# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class SelectorVariableInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'selector_type': 'str',
        'sub_type': 'str',
        'var_code_order': 'str',
        'number_of_codes': 'int',
        'code_length': 'int',
        'minimum_var_code_count': 'int',
        'maximum_var_code_count': 'int',
        'minimum_date': 'datetime',
        'maximum_date': 'datetime',
        'combined_from_variable_name': 'str'
    }

    attribute_map = {
        'selector_type': 'selectorType',
        'sub_type': 'subType',
        'var_code_order': 'varCodeOrder',
        'number_of_codes': 'numberOfCodes',
        'code_length': 'codeLength',
        'minimum_var_code_count': 'minimumVarCodeCount',
        'maximum_var_code_count': 'maximumVarCodeCount',
        'minimum_date': 'minimumDate',
        'maximum_date': 'maximumDate',
        'combined_from_variable_name': 'combinedFromVariableName'
    }

    def __init__(self, selector_type=None, sub_type=None, var_code_order=None, number_of_codes=None, code_length=None, minimum_var_code_count=None, maximum_var_code_count=None, minimum_date=None, maximum_date=None, combined_from_variable_name=None):  # noqa: E501
        """SelectorVariableInfo - a model defined in OpenAPI"""  # noqa: E501

        self._selector_type = None
        self._sub_type = None
        self._var_code_order = None
        self._number_of_codes = None
        self._code_length = None
        self._minimum_var_code_count = None
        self._maximum_var_code_count = None
        self._minimum_date = None
        self._maximum_date = None
        self._combined_from_variable_name = None
        self.discriminator = None

        if selector_type is not None:
            self.selector_type = selector_type
        if sub_type is not None:
            self.sub_type = sub_type
        if var_code_order is not None:
            self.var_code_order = var_code_order
        if number_of_codes is not None:
            self.number_of_codes = number_of_codes
        if code_length is not None:
            self.code_length = code_length
        if minimum_var_code_count is not None:
            self.minimum_var_code_count = minimum_var_code_count
        if maximum_var_code_count is not None:
            self.maximum_var_code_count = maximum_var_code_count
        if minimum_date is not None:
            self.minimum_date = minimum_date
        if maximum_date is not None:
            self.maximum_date = maximum_date
        if combined_from_variable_name is not None:
            self.combined_from_variable_name = combined_from_variable_name

    @property
    def selector_type(self):
        """Gets the selector_type of this SelectorVariableInfo.  # noqa: E501

        The type of selector that this variable is  # noqa: E501

        :return: The selector_type of this SelectorVariableInfo.  # noqa: E501
        :rtype: str
        """
        return self._selector_type

    @selector_type.setter
    def selector_type(self, selector_type):
        """Sets the selector_type of this SelectorVariableInfo.

        The type of selector that this variable is  # noqa: E501

        :param selector_type: The selector_type of this SelectorVariableInfo.  # noqa: E501
        :type: str
        """
        allowed_values = ["SingleValue", "OrArray", "AndArray", "OrBitArray", "AndBitArray"]  # noqa: E501
        if selector_type not in allowed_values:
            raise ValueError(
                "Invalid value for `selector_type` ({0}), must be one of {1}"  # noqa: E501
                .format(selector_type, allowed_values)
            )

        self._selector_type = selector_type

    @property
    def sub_type(self):
        """Gets the sub_type of this SelectorVariableInfo.  # noqa: E501

        Further type information (such as whether the selector variable is a date or datetime) for this variable  # noqa: E501

        :return: The sub_type of this SelectorVariableInfo.  # noqa: E501
        :rtype: str
        """
        return self._sub_type

    @sub_type.setter
    def sub_type(self, sub_type):
        """Sets the sub_type of this SelectorVariableInfo.

        Further type information (such as whether the selector variable is a date or datetime) for this variable  # noqa: E501

        :param sub_type: The sub_type of this SelectorVariableInfo.  # noqa: E501
        :type: str
        """
        allowed_values = ["Categorical", "Date", "DateTime"]  # noqa: E501
        if sub_type not in allowed_values:
            raise ValueError(
                "Invalid value for `sub_type` ({0}), must be one of {1}"  # noqa: E501
                .format(sub_type, allowed_values)
            )

        self._sub_type = sub_type

    @property
    def var_code_order(self):
        """Gets the var_code_order of this SelectorVariableInfo.  # noqa: E501

        How the categories are ordered within this variable  # noqa: E501

        :return: The var_code_order of this SelectorVariableInfo.  # noqa: E501
        :rtype: str
        """
        return self._var_code_order

    @var_code_order.setter
    def var_code_order(self, var_code_order):
        """Sets the var_code_order of this SelectorVariableInfo.

        How the categories are ordered within this variable  # noqa: E501

        :param var_code_order: The var_code_order of this SelectorVariableInfo.  # noqa: E501
        :type: str
        """
        allowed_values = ["Nominal", "Ascending", "Descending"]  # noqa: E501
        if var_code_order not in allowed_values:
            raise ValueError(
                "Invalid value for `var_code_order` ({0}), must be one of {1}"  # noqa: E501
                .format(var_code_order, allowed_values)
            )

        self._var_code_order = var_code_order

    @property
    def number_of_codes(self):
        """Gets the number_of_codes of this SelectorVariableInfo.  # noqa: E501

        The number of different categories (var codes) that this variable has  # noqa: E501

        :return: The number_of_codes of this SelectorVariableInfo.  # noqa: E501
        :rtype: int
        """
        return self._number_of_codes

    @number_of_codes.setter
    def number_of_codes(self, number_of_codes):
        """Sets the number_of_codes of this SelectorVariableInfo.

        The number of different categories (var codes) that this variable has  # noqa: E501

        :param number_of_codes: The number_of_codes of this SelectorVariableInfo.  # noqa: E501
        :type: int
        """

        self._number_of_codes = number_of_codes

    @property
    def code_length(self):
        """Gets the code_length of this SelectorVariableInfo.  # noqa: E501

        The length of the code for each category (in bytes) for this variable  # noqa: E501

        :return: The code_length of this SelectorVariableInfo.  # noqa: E501
        :rtype: int
        """
        return self._code_length

    @code_length.setter
    def code_length(self, code_length):
        """Sets the code_length of this SelectorVariableInfo.

        The length of the code for each category (in bytes) for this variable  # noqa: E501

        :param code_length: The code_length of this SelectorVariableInfo.  # noqa: E501
        :type: int
        """

        self._code_length = code_length

    @property
    def minimum_var_code_count(self):
        """Gets the minimum_var_code_count of this SelectorVariableInfo.  # noqa: E501

        The minimum count value in the variable's set of categories (var codes)  # noqa: E501

        :return: The minimum_var_code_count of this SelectorVariableInfo.  # noqa: E501
        :rtype: int
        """
        return self._minimum_var_code_count

    @minimum_var_code_count.setter
    def minimum_var_code_count(self, minimum_var_code_count):
        """Sets the minimum_var_code_count of this SelectorVariableInfo.

        The minimum count value in the variable's set of categories (var codes)  # noqa: E501

        :param minimum_var_code_count: The minimum_var_code_count of this SelectorVariableInfo.  # noqa: E501
        :type: int
        """

        self._minimum_var_code_count = minimum_var_code_count

    @property
    def maximum_var_code_count(self):
        """Gets the maximum_var_code_count of this SelectorVariableInfo.  # noqa: E501

        The maximum count value in the variable's set of categories (var codes)  # noqa: E501

        :return: The maximum_var_code_count of this SelectorVariableInfo.  # noqa: E501
        :rtype: int
        """
        return self._maximum_var_code_count

    @maximum_var_code_count.setter
    def maximum_var_code_count(self, maximum_var_code_count):
        """Sets the maximum_var_code_count of this SelectorVariableInfo.

        The maximum count value in the variable's set of categories (var codes)  # noqa: E501

        :param maximum_var_code_count: The maximum_var_code_count of this SelectorVariableInfo.  # noqa: E501
        :type: int
        """

        self._maximum_var_code_count = maximum_var_code_count

    @property
    def minimum_date(self):
        """Gets the minimum_date of this SelectorVariableInfo.  # noqa: E501

        If this variable is a date variable, The earliest date represented by this variable  # noqa: E501

        :return: The minimum_date of this SelectorVariableInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._minimum_date

    @minimum_date.setter
    def minimum_date(self, minimum_date):
        """Sets the minimum_date of this SelectorVariableInfo.

        If this variable is a date variable, The earliest date represented by this variable  # noqa: E501

        :param minimum_date: The minimum_date of this SelectorVariableInfo.  # noqa: E501
        :type: datetime
        """

        self._minimum_date = minimum_date

    @property
    def maximum_date(self):
        """Gets the maximum_date of this SelectorVariableInfo.  # noqa: E501

        If this variable is a date variable, The latest date represented by this variable  # noqa: E501

        :return: The maximum_date of this SelectorVariableInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._maximum_date

    @maximum_date.setter
    def maximum_date(self, maximum_date):
        """Sets the maximum_date of this SelectorVariableInfo.

        If this variable is a date variable, The latest date represented by this variable  # noqa: E501

        :param maximum_date: The maximum_date of this SelectorVariableInfo.  # noqa: E501
        :type: datetime
        """

        self._maximum_date = maximum_date

    @property
    def combined_from_variable_name(self):
        """Gets the combined_from_variable_name of this SelectorVariableInfo.  # noqa: E501

        If this variable is a summary/combined categories variable, then this is the name of the parent variable that this summarises  # noqa: E501

        :return: The combined_from_variable_name of this SelectorVariableInfo.  # noqa: E501
        :rtype: str
        """
        return self._combined_from_variable_name

    @combined_from_variable_name.setter
    def combined_from_variable_name(self, combined_from_variable_name):
        """Sets the combined_from_variable_name of this SelectorVariableInfo.

        If this variable is a summary/combined categories variable, then this is the name of the parent variable that this summarises  # noqa: E501

        :param combined_from_variable_name: The combined_from_variable_name of this SelectorVariableInfo.  # noqa: E501
        :type: str
        """

        self._combined_from_variable_name = combined_from_variable_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SelectorVariableInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
