# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class PurchaseInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'number_of_records_licensed': 'int',
        'credit_remaining': 'float',
        'grand_total_cost': 'float',
        'query_id': 'str',
        'urn_file_path': 'str'
    }

    attribute_map = {
        'number_of_records_licensed': 'numberOfRecordsLicensed',
        'credit_remaining': 'creditRemaining',
        'grand_total_cost': 'grandTotalCost',
        'query_id': 'queryId',
        'urn_file_path': 'urnFilePath'
    }

    def __init__(self, number_of_records_licensed=None, credit_remaining=None, grand_total_cost=None, query_id=None, urn_file_path=None):  # noqa: E501
        """PurchaseInfo - a model defined in OpenAPI"""  # noqa: E501

        self._number_of_records_licensed = None
        self._credit_remaining = None
        self._grand_total_cost = None
        self._query_id = None
        self._urn_file_path = None
        self.discriminator = None

        self.number_of_records_licensed = number_of_records_licensed
        self.credit_remaining = credit_remaining
        self.grand_total_cost = grand_total_cost
        self.query_id = query_id
        self.urn_file_path = urn_file_path

    @property
    def number_of_records_licensed(self):
        """Gets the number_of_records_licensed of this PurchaseInfo.  # noqa: E501

        The number of records from the given query that have not yet been licensed  # noqa: E501

        :return: The number_of_records_licensed of this PurchaseInfo.  # noqa: E501
        :rtype: int
        """
        return self._number_of_records_licensed

    @number_of_records_licensed.setter
    def number_of_records_licensed(self, number_of_records_licensed):
        """Sets the number_of_records_licensed of this PurchaseInfo.

        The number of records from the given query that have not yet been licensed  # noqa: E501

        :param number_of_records_licensed: The number_of_records_licensed of this PurchaseInfo.  # noqa: E501
        :type: int
        """
        if number_of_records_licensed is None:
            raise ValueError("Invalid value for `number_of_records_licensed`, must not be `None`")  # noqa: E501

        self._number_of_records_licensed = number_of_records_licensed

    @property
    def credit_remaining(self):
        """Gets the credit_remaining of this PurchaseInfo.  # noqa: E501

        The remaining money available to license records  # noqa: E501

        :return: The credit_remaining of this PurchaseInfo.  # noqa: E501
        :rtype: float
        """
        return self._credit_remaining

    @credit_remaining.setter
    def credit_remaining(self, credit_remaining):
        """Sets the credit_remaining of this PurchaseInfo.

        The remaining money available to license records  # noqa: E501

        :param credit_remaining: The credit_remaining of this PurchaseInfo.  # noqa: E501
        :type: float
        """
        if credit_remaining is None:
            raise ValueError("Invalid value for `credit_remaining`, must not be `None`")  # noqa: E501

        self._credit_remaining = credit_remaining

    @property
    def grand_total_cost(self):
        """Gets the grand_total_cost of this PurchaseInfo.  # noqa: E501

        The total cost of records licensed  # noqa: E501

        :return: The grand_total_cost of this PurchaseInfo.  # noqa: E501
        :rtype: float
        """
        return self._grand_total_cost

    @grand_total_cost.setter
    def grand_total_cost(self, grand_total_cost):
        """Sets the grand_total_cost of this PurchaseInfo.

        The total cost of records licensed  # noqa: E501

        :param grand_total_cost: The grand_total_cost of this PurchaseInfo.  # noqa: E501
        :type: float
        """
        if grand_total_cost is None:
            raise ValueError("Invalid value for `grand_total_cost`, must not be `None`")  # noqa: E501

        self._grand_total_cost = grand_total_cost

    @property
    def query_id(self):
        """Gets the query_id of this PurchaseInfo.  # noqa: E501

        The unique id of an audience data licensing query  # noqa: E501

        :return: The query_id of this PurchaseInfo.  # noqa: E501
        :rtype: str
        """
        return self._query_id

    @query_id.setter
    def query_id(self, query_id):
        """Sets the query_id of this PurchaseInfo.

        The unique id of an audience data licensing query  # noqa: E501

        :param query_id: The query_id of this PurchaseInfo.  # noqa: E501
        :type: str
        """
        if query_id is None:
            raise ValueError("Invalid value for `query_id`, must not be `None`")  # noqa: E501

        self._query_id = query_id

    @property
    def urn_file_path(self):
        """Gets the urn_file_path of this PurchaseInfo.  # noqa: E501

        The location of the Urn file for the purchased records  # noqa: E501

        :return: The urn_file_path of this PurchaseInfo.  # noqa: E501
        :rtype: str
        """
        return self._urn_file_path

    @urn_file_path.setter
    def urn_file_path(self, urn_file_path):
        """Sets the urn_file_path of this PurchaseInfo.

        The location of the Urn file for the purchased records  # noqa: E501

        :param urn_file_path: The urn_file_path of this PurchaseInfo.  # noqa: E501
        :type: str
        """
        if urn_file_path is None:
            raise ValueError("Invalid value for `urn_file_path`, must not be `None`")  # noqa: E501

        self._urn_file_path = urn_file_path

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PurchaseInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
