# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Measure(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'resolve_table_name': 'str',
        'function': 'str',
        'variable_name': 'str',
        'query': 'Query',
        'filter_query': 'Query',
        'expression': 'Expression',
        'sort': 'str'
    }

    attribute_map = {
        'id': 'id',
        'resolve_table_name': 'resolveTableName',
        'function': 'function',
        'variable_name': 'variableName',
        'query': 'query',
        'filter_query': 'filterQuery',
        'expression': 'expression',
        'sort': 'sort'
    }

    def __init__(self, id=None, resolve_table_name=None, function=None, variable_name=None, query=None, filter_query=None, expression=None, sort=None):  # noqa: E501
        """Measure - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._resolve_table_name = None
        self._function = None
        self._variable_name = None
        self._query = None
        self._filter_query = None
        self._expression = None
        self._sort = None
        self.discriminator = None

        self.id = id
        self.resolve_table_name = resolve_table_name
        self.function = function
        if variable_name is not None:
            self.variable_name = variable_name
        if query is not None:
            self.query = query
        if filter_query is not None:
            self.filter_query = filter_query
        if expression is not None:
            self.expression = expression
        if sort is not None:
            self.sort = sort

    @property
    def id(self):
        """Gets the id of this Measure.  # noqa: E501

        The id of the measure  # noqa: E501

        :return: The id of this Measure.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Measure.

        The id of the measure  # noqa: E501

        :param id: The id of this Measure.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def resolve_table_name(self):
        """Gets the resolve_table_name of this Measure.  # noqa: E501

        The name of the table to resolve this measure to.  I.e. all the counts in this measure will be counts of entities from this table  # noqa: E501

        :return: The resolve_table_name of this Measure.  # noqa: E501
        :rtype: str
        """
        return self._resolve_table_name

    @resolve_table_name.setter
    def resolve_table_name(self, resolve_table_name):
        """Sets the resolve_table_name of this Measure.

        The name of the table to resolve this measure to.  I.e. all the counts in this measure will be counts of entities from this table  # noqa: E501

        :param resolve_table_name: The resolve_table_name of this Measure.  # noqa: E501
        :type: str
        """
        if resolve_table_name is None:
            raise ValueError("Invalid value for `resolve_table_name`, must not be `None`")  # noqa: E501

        self._resolve_table_name = resolve_table_name

    @property
    def function(self):
        """Gets the function of this Measure.  # noqa: E501

        The function to use to aggregate up the data per cell within this measure  # noqa: E501

        :return: The function of this Measure.  # noqa: E501
        :rtype: str
        """
        return self._function

    @function.setter
    def function(self, function):
        """Sets the function of this Measure.

        The function to use to aggregate up the data per cell within this measure  # noqa: E501

        :param function: The function of this Measure.  # noqa: E501
        :type: str
        """
        if function is None:
            raise ValueError("Invalid value for `function`, must not be `None`")  # noqa: E501
        allowed_values = ["Count", "Sum", "Mean", "VariableCount", "Minimum", "Maximum", "Median", "Mode", "Variance", "StandardDeviation", "LowerQuartile", "UpperQuartile", "InterQuartileRange", "Derived", "CramersV", "UCR", "Phi", "ChiSq", "ChiSqProb", "ContCoef", "ZeroCells", "LowCells", "QueryCount", "Percentile", "CountDistinct", "MaxDistinctCount"]  # noqa: E501
        if function not in allowed_values:
            raise ValueError(
                "Invalid value for `function` ({0}), must be one of {1}"  # noqa: E501
                .format(function, allowed_values)
            )

        self._function = function

    @property
    def variable_name(self):
        """Gets the variable_name of this Measure.  # noqa: E501

        If the measure is based on a variable then the name of the variable to use  # noqa: E501

        :return: The variable_name of this Measure.  # noqa: E501
        :rtype: str
        """
        return self._variable_name

    @variable_name.setter
    def variable_name(self, variable_name):
        """Sets the variable_name of this Measure.

        If the measure is based on a variable then the name of the variable to use  # noqa: E501

        :param variable_name: The variable_name of this Measure.  # noqa: E501
        :type: str
        """

        self._variable_name = variable_name

    @property
    def query(self):
        """Gets the query of this Measure.  # noqa: E501


        :return: The query of this Measure.  # noqa: E501
        :rtype: Query
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this Measure.


        :param query: The query of this Measure.  # noqa: E501
        :type: Query
        """

        self._query = query

    @property
    def filter_query(self):
        """Gets the filter_query of this Measure.  # noqa: E501


        :return: The filter_query of this Measure.  # noqa: E501
        :rtype: Query
        """
        return self._filter_query

    @filter_query.setter
    def filter_query(self, filter_query):
        """Sets the filter_query of this Measure.


        :param filter_query: The filter_query of this Measure.  # noqa: E501
        :type: Query
        """

        self._filter_query = filter_query

    @property
    def expression(self):
        """Gets the expression of this Measure.  # noqa: E501


        :return: The expression of this Measure.  # noqa: E501
        :rtype: Expression
        """
        return self._expression

    @expression.setter
    def expression(self, expression):
        """Sets the expression of this Measure.


        :param expression: The expression of this Measure.  # noqa: E501
        :type: Expression
        """

        self._expression = expression

    @property
    def sort(self):
        """Gets the sort of this Measure.  # noqa: E501

        How the cells are sorted in this measure  # noqa: E501

        :return: The sort of this Measure.  # noqa: E501
        :rtype: str
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """Sets the sort of this Measure.

        How the cells are sorted in this measure  # noqa: E501

        :param sort: The sort of this Measure.  # noqa: E501
        :type: str
        """
        allowed_values = ["None", "Ascending", "Descending"]  # noqa: E501
        if sort not in allowed_values:
            raise ValueError(
                "Invalid value for `sort` ({0}), must be one of {1}"  # noqa: E501
                .format(sort, allowed_values)
            )

        self._sort = sort

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Measure):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
