# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class JobSummary(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'priority': 'int',
        'state': 'str',
        'cancel_requested': 'bool',
        'time_added': 'datetime',
        'time_sent': 'datetime',
        'time_finished': 'datetime',
        'server': 'str',
        'system_name': 'str',
        'thread_number': 'int',
        'username': 'str',
        'job_type': 'str'
    }

    attribute_map = {
        'id': 'id',
        'priority': 'priority',
        'state': 'state',
        'cancel_requested': 'cancelRequested',
        'time_added': 'timeAdded',
        'time_sent': 'timeSent',
        'time_finished': 'timeFinished',
        'server': 'server',
        'system_name': 'systemName',
        'thread_number': 'threadNumber',
        'username': 'username',
        'job_type': 'jobType'
    }

    def __init__(self, id=None, priority=None, state=None, cancel_requested=None, time_added=None, time_sent=None, time_finished=None, server=None, system_name=None, thread_number=None, username=None, job_type=None):  # noqa: E501
        """JobSummary - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._priority = None
        self._state = None
        self._cancel_requested = None
        self._time_added = None
        self._time_sent = None
        self._time_finished = None
        self._server = None
        self._system_name = None
        self._thread_number = None
        self._username = None
        self._job_type = None
        self.discriminator = None

        self.id = id
        self.priority = priority
        self.state = state
        self.cancel_requested = cancel_requested
        if time_added is not None:
            self.time_added = time_added
        if time_sent is not None:
            self.time_sent = time_sent
        if time_finished is not None:
            self.time_finished = time_finished
        self.server = server
        self.system_name = system_name
        self.thread_number = thread_number
        self.username = username
        self.job_type = job_type

    @property
    def id(self):
        """Gets the id of this JobSummary.  # noqa: E501

        The id of the job  # noqa: E501

        :return: The id of this JobSummary.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this JobSummary.

        The id of the job  # noqa: E501

        :param id: The id of this JobSummary.  # noqa: E501
        :type: int
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def priority(self):
        """Gets the priority of this JobSummary.  # noqa: E501

        The priority of the job.  The lower the number the more important the job  # noqa: E501

        :return: The priority of this JobSummary.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this JobSummary.

        The priority of the job.  The lower the number the more important the job  # noqa: E501

        :param priority: The priority of this JobSummary.  # noqa: E501
        :type: int
        """
        if priority is None:
            raise ValueError("Invalid value for `priority`, must not be `None`")  # noqa: E501

        self._priority = priority

    @property
    def state(self):
        """Gets the state of this JobSummary.  # noqa: E501

        The state of the job.  Valid values can include 'cancel', 'done', 'incomplete', 'inserting' and 'unassigned'  # noqa: E501

        :return: The state of this JobSummary.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this JobSummary.

        The state of the job.  Valid values can include 'cancel', 'done', 'incomplete', 'inserting' and 'unassigned'  # noqa: E501

        :param state: The state of this JobSummary.  # noqa: E501
        :type: str
        """
        if state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def cancel_requested(self):
        """Gets the cancel_requested of this JobSummary.  # noqa: E501

        Whether this job has been asked to cancel.  If it has then acted on this request and been cancelled then the state will be set to 'cancel'  # noqa: E501

        :return: The cancel_requested of this JobSummary.  # noqa: E501
        :rtype: bool
        """
        return self._cancel_requested

    @cancel_requested.setter
    def cancel_requested(self, cancel_requested):
        """Sets the cancel_requested of this JobSummary.

        Whether this job has been asked to cancel.  If it has then acted on this request and been cancelled then the state will be set to 'cancel'  # noqa: E501

        :param cancel_requested: The cancel_requested of this JobSummary.  # noqa: E501
        :type: bool
        """
        if cancel_requested is None:
            raise ValueError("Invalid value for `cancel_requested`, must not be `None`")  # noqa: E501

        self._cancel_requested = cancel_requested

    @property
    def time_added(self):
        """Gets the time_added of this JobSummary.  # noqa: E501

        The date and time that the job was added to the job queue  # noqa: E501

        :return: The time_added of this JobSummary.  # noqa: E501
        :rtype: datetime
        """
        return self._time_added

    @time_added.setter
    def time_added(self, time_added):
        """Sets the time_added of this JobSummary.

        The date and time that the job was added to the job queue  # noqa: E501

        :param time_added: The time_added of this JobSummary.  # noqa: E501
        :type: datetime
        """

        self._time_added = time_added

    @property
    def time_sent(self):
        """Gets the time_sent of this JobSummary.  # noqa: E501

        The date and time that the job was sent from the queue to be processed  # noqa: E501

        :return: The time_sent of this JobSummary.  # noqa: E501
        :rtype: datetime
        """
        return self._time_sent

    @time_sent.setter
    def time_sent(self, time_sent):
        """Sets the time_sent of this JobSummary.

        The date and time that the job was sent from the queue to be processed  # noqa: E501

        :param time_sent: The time_sent of this JobSummary.  # noqa: E501
        :type: datetime
        """

        self._time_sent = time_sent

    @property
    def time_finished(self):
        """Gets the time_finished of this JobSummary.  # noqa: E501

        The date and time that the job finished processing  # noqa: E501

        :return: The time_finished of this JobSummary.  # noqa: E501
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """Sets the time_finished of this JobSummary.

        The date and time that the job finished processing  # noqa: E501

        :param time_finished: The time_finished of this JobSummary.  # noqa: E501
        :type: datetime
        """

        self._time_finished = time_finished

    @property
    def server(self):
        """Gets the server of this JobSummary.  # noqa: E501

        The hostname of the server that is processing/processed this job  # noqa: E501

        :return: The server of this JobSummary.  # noqa: E501
        :rtype: str
        """
        return self._server

    @server.setter
    def server(self, server):
        """Sets the server of this JobSummary.

        The hostname of the server that is processing/processed this job  # noqa: E501

        :param server: The server of this JobSummary.  # noqa: E501
        :type: str
        """
        if server is None:
            raise ValueError("Invalid value for `server`, must not be `None`")  # noqa: E501

        self._server = server

    @property
    def system_name(self):
        """Gets the system_name of this JobSummary.  # noqa: E501

        The name of the FastStats system that this job is running against  # noqa: E501

        :return: The system_name of this JobSummary.  # noqa: E501
        :rtype: str
        """
        return self._system_name

    @system_name.setter
    def system_name(self, system_name):
        """Sets the system_name of this JobSummary.

        The name of the FastStats system that this job is running against  # noqa: E501

        :param system_name: The system_name of this JobSummary.  # noqa: E501
        :type: str
        """
        if system_name is None:
            raise ValueError("Invalid value for `system_name`, must not be `None`")  # noqa: E501

        self._system_name = system_name

    @property
    def thread_number(self):
        """Gets the thread_number of this JobSummary.  # noqa: E501

        The number of the thread within the FastStats Service that is running this job  # noqa: E501

        :return: The thread_number of this JobSummary.  # noqa: E501
        :rtype: int
        """
        return self._thread_number

    @thread_number.setter
    def thread_number(self, thread_number):
        """Sets the thread_number of this JobSummary.

        The number of the thread within the FastStats Service that is running this job  # noqa: E501

        :param thread_number: The thread_number of this JobSummary.  # noqa: E501
        :type: int
        """
        if thread_number is None:
            raise ValueError("Invalid value for `thread_number`, must not be `None`")  # noqa: E501

        self._thread_number = thread_number

    @property
    def username(self):
        """Gets the username of this JobSummary.  # noqa: E501

        The name of the user that submitted this job  # noqa: E501

        :return: The username of this JobSummary.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this JobSummary.

        The name of the user that submitted this job  # noqa: E501

        :param username: The username of this JobSummary.  # noqa: E501
        :type: str
        """
        if username is None:
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501

        self._username = username

    @property
    def job_type(self):
        """Gets the job_type of this JobSummary.  # noqa: E501

        The type of the job  # noqa: E501

        :return: The job_type of this JobSummary.  # noqa: E501
        :rtype: str
        """
        return self._job_type

    @job_type.setter
    def job_type(self, job_type):
        """Sets the job_type of this JobSummary.

        The type of the job  # noqa: E501

        :param job_type: The job_type of this JobSummary.  # noqa: E501
        :type: str
        """
        if job_type is None:
            raise ValueError("Invalid value for `job_type`, must not be `None`")  # noqa: E501

        self._job_type = job_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobSummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
