# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ExportResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'title': 'str',
        'notes': 'str',
        'ran_successfully': 'bool',
        'system_name': 'str',
        'system_load_date': 'datetime',
        'user_name': 'str',
        'run_date': 'datetime',
        'query_description': 'str',
        'rows': 'list[Row]',
        'export': 'Export',
        'counts': 'list[Count]'
    }

    attribute_map = {
        'title': 'title',
        'notes': 'notes',
        'ran_successfully': 'ranSuccessfully',
        'system_name': 'systemName',
        'system_load_date': 'systemLoadDate',
        'user_name': 'userName',
        'run_date': 'runDate',
        'query_description': 'queryDescription',
        'rows': 'rows',
        'export': 'export',
        'counts': 'counts'
    }

    def __init__(self, title=None, notes=None, ran_successfully=None, system_name=None, system_load_date=None, user_name=None, run_date=None, query_description=None, rows=None, export=None, counts=None):  # noqa: E501
        """ExportResult - a model defined in OpenAPI"""  # noqa: E501

        self._title = None
        self._notes = None
        self._ran_successfully = None
        self._system_name = None
        self._system_load_date = None
        self._user_name = None
        self._run_date = None
        self._query_description = None
        self._rows = None
        self._export = None
        self._counts = None
        self.discriminator = None

        if title is not None:
            self.title = title
        if notes is not None:
            self.notes = notes
        if ran_successfully is not None:
            self.ran_successfully = ran_successfully
        if system_name is not None:
            self.system_name = system_name
        if system_load_date is not None:
            self.system_load_date = system_load_date
        if user_name is not None:
            self.user_name = user_name
        if run_date is not None:
            self.run_date = run_date
        if query_description is not None:
            self.query_description = query_description
        if rows is not None:
            self.rows = rows
        if export is not None:
            self.export = export
        if counts is not None:
            self.counts = counts

    @property
    def title(self):
        """Gets the title of this ExportResult.  # noqa: E501

        The title of the query that has been counted  # noqa: E501

        :return: The title of this ExportResult.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ExportResult.

        The title of the query that has been counted  # noqa: E501

        :param title: The title of this ExportResult.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def notes(self):
        """Gets the notes of this ExportResult.  # noqa: E501

        Any notes associated with the query that has been counted  # noqa: E501

        :return: The notes of this ExportResult.  # noqa: E501
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this ExportResult.

        Any notes associated with the query that has been counted  # noqa: E501

        :param notes: The notes of this ExportResult.  # noqa: E501
        :type: str
        """

        self._notes = notes

    @property
    def ran_successfully(self):
        """Gets the ran_successfully of this ExportResult.  # noqa: E501

        Whether the query was counted successfully or not  # noqa: E501

        :return: The ran_successfully of this ExportResult.  # noqa: E501
        :rtype: bool
        """
        return self._ran_successfully

    @ran_successfully.setter
    def ran_successfully(self, ran_successfully):
        """Sets the ran_successfully of this ExportResult.

        Whether the query was counted successfully or not  # noqa: E501

        :param ran_successfully: The ran_successfully of this ExportResult.  # noqa: E501
        :type: bool
        """

        self._ran_successfully = ran_successfully

    @property
    def system_name(self):
        """Gets the system_name of this ExportResult.  # noqa: E501

        The name of the FastStats system that this count has been produced by  # noqa: E501

        :return: The system_name of this ExportResult.  # noqa: E501
        :rtype: str
        """
        return self._system_name

    @system_name.setter
    def system_name(self, system_name):
        """Sets the system_name of this ExportResult.

        The name of the FastStats system that this count has been produced by  # noqa: E501

        :param system_name: The system_name of this ExportResult.  # noqa: E501
        :type: str
        """

        self._system_name = system_name

    @property
    def system_load_date(self):
        """Gets the system_load_date of this ExportResult.  # noqa: E501

        The date and time that the FastStats system from which this count has come was last built  # noqa: E501

        :return: The system_load_date of this ExportResult.  # noqa: E501
        :rtype: datetime
        """
        return self._system_load_date

    @system_load_date.setter
    def system_load_date(self, system_load_date):
        """Sets the system_load_date of this ExportResult.

        The date and time that the FastStats system from which this count has come was last built  # noqa: E501

        :param system_load_date: The system_load_date of this ExportResult.  # noqa: E501
        :type: datetime
        """

        self._system_load_date = system_load_date

    @property
    def user_name(self):
        """Gets the user_name of this ExportResult.  # noqa: E501

        The name of the user that requested this count  # noqa: E501

        :return: The user_name of this ExportResult.  # noqa: E501
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """Sets the user_name of this ExportResult.

        The name of the user that requested this count  # noqa: E501

        :param user_name: The user_name of this ExportResult.  # noqa: E501
        :type: str
        """

        self._user_name = user_name

    @property
    def run_date(self):
        """Gets the run_date of this ExportResult.  # noqa: E501

        The date and time that this count was run on  # noqa: E501

        :return: The run_date of this ExportResult.  # noqa: E501
        :rtype: datetime
        """
        return self._run_date

    @run_date.setter
    def run_date(self, run_date):
        """Sets the run_date of this ExportResult.

        The date and time that this count was run on  # noqa: E501

        :param run_date: The run_date of this ExportResult.  # noqa: E501
        :type: datetime
        """

        self._run_date = run_date

    @property
    def query_description(self):
        """Gets the query_description of this ExportResult.  # noqa: E501

        A textual description of the query that was counted  # noqa: E501

        :return: The query_description of this ExportResult.  # noqa: E501
        :rtype: str
        """
        return self._query_description

    @query_description.setter
    def query_description(self, query_description):
        """Sets the query_description of this ExportResult.

        A textual description of the query that was counted  # noqa: E501

        :param query_description: The query_description of this ExportResult.  # noqa: E501
        :type: str
        """

        self._query_description = query_description

    @property
    def rows(self):
        """Gets the rows of this ExportResult.  # noqa: E501

        The rows of browse data for this export request.  # noqa: E501

        :return: The rows of this ExportResult.  # noqa: E501
        :rtype: list[Row]
        """
        return self._rows

    @rows.setter
    def rows(self, rows):
        """Sets the rows of this ExportResult.

        The rows of browse data for this export request.  # noqa: E501

        :param rows: The rows of this ExportResult.  # noqa: E501
        :type: list[Row]
        """

        self._rows = rows

    @property
    def export(self):
        """Gets the export of this ExportResult.  # noqa: E501


        :return: The export of this ExportResult.  # noqa: E501
        :rtype: Export
        """
        return self._export

    @export.setter
    def export(self, export):
        """Sets the export of this ExportResult.


        :param export: The export of this ExportResult.  # noqa: E501
        :type: Export
        """

        self._export = export

    @property
    def counts(self):
        """Gets the counts of this ExportResult.  # noqa: E501

        A list of counts for each affected table in the FastStats system.  The first count in the list is the main one.  # noqa: E501

        :return: The counts of this ExportResult.  # noqa: E501
        :rtype: list[Count]
        """
        return self._counts

    @counts.setter
    def counts(self, counts):
        """Sets the counts of this ExportResult.

        A list of counts for each affected table in the FastStats system.  The first count in the list is the main one.  # noqa: E501

        :param counts: The counts of this ExportResult.  # noqa: E501
        :type: list[Count]
        """

        self._counts = counts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExportResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
