# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class EndpointDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'group_name': 'str',
        'method': 'str',
        'url_template': 'str',
        'allows_anonymous_access': 'bool',
        'is_experimental': 'bool',
        'is_under_development': 'bool',
        'requires_licence_flags': 'list[str]',
        'optionally_requires_licence_flags': 'list[str]',
        'requires_roles': 'list[str]'
    }

    attribute_map = {
        'name': 'name',
        'group_name': 'groupName',
        'method': 'method',
        'url_template': 'urlTemplate',
        'allows_anonymous_access': 'allowsAnonymousAccess',
        'is_experimental': 'isExperimental',
        'is_under_development': 'isUnderDevelopment',
        'requires_licence_flags': 'requiresLicenceFlags',
        'optionally_requires_licence_flags': 'optionallyRequiresLicenceFlags',
        'requires_roles': 'requiresRoles'
    }

    def __init__(self, name=None, group_name=None, method=None, url_template=None, allows_anonymous_access=None, is_experimental=None, is_under_development=None, requires_licence_flags=None, optionally_requires_licence_flags=None, requires_roles=None):  # noqa: E501
        """EndpointDetails - a model defined in OpenAPI"""  # noqa: E501

        self._name = None
        self._group_name = None
        self._method = None
        self._url_template = None
        self._allows_anonymous_access = None
        self._is_experimental = None
        self._is_under_development = None
        self._requires_licence_flags = None
        self._optionally_requires_licence_flags = None
        self._requires_roles = None
        self.discriminator = None

        self.name = name
        self.group_name = group_name
        self.method = method
        self.url_template = url_template
        self.allows_anonymous_access = allows_anonymous_access
        self.is_experimental = is_experimental
        self.is_under_development = is_under_development
        self.requires_licence_flags = requires_licence_flags
        self.optionally_requires_licence_flags = optionally_requires_licence_flags
        self.requires_roles = requires_roles

    @property
    def name(self):
        """Gets the name of this EndpointDetails.  # noqa: E501

        The name of the endpoint  # noqa: E501

        :return: The name of this EndpointDetails.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EndpointDetails.

        The name of the endpoint  # noqa: E501

        :param name: The name of this EndpointDetails.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def group_name(self):
        """Gets the group_name of this EndpointDetails.  # noqa: E501

        The name of the group this endpoint belongs to  # noqa: E501

        :return: The group_name of this EndpointDetails.  # noqa: E501
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """Sets the group_name of this EndpointDetails.

        The name of the group this endpoint belongs to  # noqa: E501

        :param group_name: The group_name of this EndpointDetails.  # noqa: E501
        :type: str
        """
        if group_name is None:
            raise ValueError("Invalid value for `group_name`, must not be `None`")  # noqa: E501

        self._group_name = group_name

    @property
    def method(self):
        """Gets the method of this EndpointDetails.  # noqa: E501

        The HTTP method used for calling this endpoint  # noqa: E501

        :return: The method of this EndpointDetails.  # noqa: E501
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this EndpointDetails.

        The HTTP method used for calling this endpoint  # noqa: E501

        :param method: The method of this EndpointDetails.  # noqa: E501
        :type: str
        """
        if method is None:
            raise ValueError("Invalid value for `method`, must not be `None`")  # noqa: E501

        self._method = method

    @property
    def url_template(self):
        """Gets the url_template of this EndpointDetails.  # noqa: E501

        The URL template of this endpoint  # noqa: E501

        :return: The url_template of this EndpointDetails.  # noqa: E501
        :rtype: str
        """
        return self._url_template

    @url_template.setter
    def url_template(self, url_template):
        """Sets the url_template of this EndpointDetails.

        The URL template of this endpoint  # noqa: E501

        :param url_template: The url_template of this EndpointDetails.  # noqa: E501
        :type: str
        """
        if url_template is None:
            raise ValueError("Invalid value for `url_template`, must not be `None`")  # noqa: E501

        self._url_template = url_template

    @property
    def allows_anonymous_access(self):
        """Gets the allows_anonymous_access of this EndpointDetails.  # noqa: E501

        Whether this endpoint can be accessed without authentication details  # noqa: E501

        :return: The allows_anonymous_access of this EndpointDetails.  # noqa: E501
        :rtype: bool
        """
        return self._allows_anonymous_access

    @allows_anonymous_access.setter
    def allows_anonymous_access(self, allows_anonymous_access):
        """Sets the allows_anonymous_access of this EndpointDetails.

        Whether this endpoint can be accessed without authentication details  # noqa: E501

        :param allows_anonymous_access: The allows_anonymous_access of this EndpointDetails.  # noqa: E501
        :type: bool
        """
        if allows_anonymous_access is None:
            raise ValueError("Invalid value for `allows_anonymous_access`, must not be `None`")  # noqa: E501

        self._allows_anonymous_access = allows_anonymous_access

    @property
    def is_experimental(self):
        """Gets the is_experimental of this EndpointDetails.  # noqa: E501

        Whether this endpoint has been marked as experimental  # noqa: E501

        :return: The is_experimental of this EndpointDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_experimental

    @is_experimental.setter
    def is_experimental(self, is_experimental):
        """Sets the is_experimental of this EndpointDetails.

        Whether this endpoint has been marked as experimental  # noqa: E501

        :param is_experimental: The is_experimental of this EndpointDetails.  # noqa: E501
        :type: bool
        """
        if is_experimental is None:
            raise ValueError("Invalid value for `is_experimental`, must not be `None`")  # noqa: E501

        self._is_experimental = is_experimental

    @property
    def is_under_development(self):
        """Gets the is_under_development of this EndpointDetails.  # noqa: E501

        Whether this endpoint has been marked as under development  # noqa: E501

        :return: The is_under_development of this EndpointDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_under_development

    @is_under_development.setter
    def is_under_development(self, is_under_development):
        """Sets the is_under_development of this EndpointDetails.

        Whether this endpoint has been marked as under development  # noqa: E501

        :param is_under_development: The is_under_development of this EndpointDetails.  # noqa: E501
        :type: bool
        """
        if is_under_development is None:
            raise ValueError("Invalid value for `is_under_development`, must not be `None`")  # noqa: E501

        self._is_under_development = is_under_development

    @property
    def requires_licence_flags(self):
        """Gets the requires_licence_flags of this EndpointDetails.  # noqa: E501

        The set of licence flags that the user must have in order to be able to call the endpoint  # noqa: E501

        :return: The requires_licence_flags of this EndpointDetails.  # noqa: E501
        :rtype: list[str]
        """
        return self._requires_licence_flags

    @requires_licence_flags.setter
    def requires_licence_flags(self, requires_licence_flags):
        """Sets the requires_licence_flags of this EndpointDetails.

        The set of licence flags that the user must have in order to be able to call the endpoint  # noqa: E501

        :param requires_licence_flags: The requires_licence_flags of this EndpointDetails.  # noqa: E501
        :type: list[str]
        """
        if requires_licence_flags is None:
            raise ValueError("Invalid value for `requires_licence_flags`, must not be `None`")  # noqa: E501
        allowed_values = ["AudienceSelection", "AudiencePreview", "Export", "AdvancedQuery", "Cube", "Profile"]  # noqa: E501
        if not set(requires_licence_flags).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `requires_licence_flags` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(requires_licence_flags) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._requires_licence_flags = requires_licence_flags

    @property
    def optionally_requires_licence_flags(self):
        """Gets the optionally_requires_licence_flags of this EndpointDetails.  # noqa: E501

        The set of licence flags that the user might need to have in order to be able to call the endpoint, depending on the type of request sent to the endpoint  # noqa: E501

        :return: The optionally_requires_licence_flags of this EndpointDetails.  # noqa: E501
        :rtype: list[str]
        """
        return self._optionally_requires_licence_flags

    @optionally_requires_licence_flags.setter
    def optionally_requires_licence_flags(self, optionally_requires_licence_flags):
        """Sets the optionally_requires_licence_flags of this EndpointDetails.

        The set of licence flags that the user might need to have in order to be able to call the endpoint, depending on the type of request sent to the endpoint  # noqa: E501

        :param optionally_requires_licence_flags: The optionally_requires_licence_flags of this EndpointDetails.  # noqa: E501
        :type: list[str]
        """
        if optionally_requires_licence_flags is None:
            raise ValueError("Invalid value for `optionally_requires_licence_flags`, must not be `None`")  # noqa: E501
        allowed_values = ["AudienceSelection", "AudiencePreview", "Export", "AdvancedQuery", "Cube", "Profile"]  # noqa: E501
        if not set(optionally_requires_licence_flags).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `optionally_requires_licence_flags` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(optionally_requires_licence_flags) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._optionally_requires_licence_flags = optionally_requires_licence_flags

    @property
    def requires_roles(self):
        """Gets the requires_roles of this EndpointDetails.  # noqa: E501

        Any roles that the user must have to access this endpoint  # noqa: E501

        :return: The requires_roles of this EndpointDetails.  # noqa: E501
        :rtype: list[str]
        """
        return self._requires_roles

    @requires_roles.setter
    def requires_roles(self, requires_roles):
        """Sets the requires_roles of this EndpointDetails.

        Any roles that the user must have to access this endpoint  # noqa: E501

        :param requires_roles: The requires_roles of this EndpointDetails.  # noqa: E501
        :type: list[str]
        """
        if requires_roles is None:
            raise ValueError("Invalid value for `requires_roles`, must not be `None`")  # noqa: E501

        self._requires_roles = requires_roles

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EndpointDetails):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
