# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Dimension(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'type': 'str',
        'query': 'Query',
        'variable_name': 'str',
        'banding': 'DimensionBanding',
        'function': 'str',
        'none_cell': 'bool',
        'omit_unclassified': 'bool',
        'filter_query': 'Query'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'query': 'query',
        'variable_name': 'variableName',
        'banding': 'banding',
        'function': 'function',
        'none_cell': 'noneCell',
        'omit_unclassified': 'omitUnclassified',
        'filter_query': 'filterQuery'
    }

    def __init__(self, id=None, type=None, query=None, variable_name=None, banding=None, function=None, none_cell=None, omit_unclassified=None, filter_query=None):  # noqa: E501
        """Dimension - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._type = None
        self._query = None
        self._variable_name = None
        self._banding = None
        self._function = None
        self._none_cell = None
        self._omit_unclassified = None
        self._filter_query = None
        self.discriminator = None

        self.id = id
        self.type = type
        if query is not None:
            self.query = query
        if variable_name is not None:
            self.variable_name = variable_name
        if banding is not None:
            self.banding = banding
        if function is not None:
            self.function = function
        if none_cell is not None:
            self.none_cell = none_cell
        if omit_unclassified is not None:
            self.omit_unclassified = omit_unclassified
        if filter_query is not None:
            self.filter_query = filter_query

    @property
    def id(self):
        """Gets the id of this Dimension.  # noqa: E501

        The id of the dimension  # noqa: E501

        :return: The id of this Dimension.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Dimension.

        The id of the dimension  # noqa: E501

        :param id: The id of this Dimension.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def type(self):
        """Gets the type of this Dimension.  # noqa: E501

        The type of the dimension  # noqa: E501

        :return: The type of this Dimension.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Dimension.

        The type of the dimension  # noqa: E501

        :param type: The type of this Dimension.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["Selector", "NumericBand", "DateBand", "Text", "Query"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def query(self):
        """Gets the query of this Dimension.  # noqa: E501


        :return: The query of this Dimension.  # noqa: E501
        :rtype: Query
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this Dimension.


        :param query: The query of this Dimension.  # noqa: E501
        :type: Query
        """

        self._query = query

    @property
    def variable_name(self):
        """Gets the variable_name of this Dimension.  # noqa: E501

        If the dimension is a selector, numeric, date or text dimension then the name of the variable to use  # noqa: E501

        :return: The variable_name of this Dimension.  # noqa: E501
        :rtype: str
        """
        return self._variable_name

    @variable_name.setter
    def variable_name(self, variable_name):
        """Sets the variable_name of this Dimension.

        If the dimension is a selector, numeric, date or text dimension then the name of the variable to use  # noqa: E501

        :param variable_name: The variable_name of this Dimension.  # noqa: E501
        :type: str
        """

        self._variable_name = variable_name

    @property
    def banding(self):
        """Gets the banding of this Dimension.  # noqa: E501


        :return: The banding of this Dimension.  # noqa: E501
        :rtype: DimensionBanding
        """
        return self._banding

    @banding.setter
    def banding(self, banding):
        """Sets the banding of this Dimension.


        :param banding: The banding of this Dimension.  # noqa: E501
        :type: DimensionBanding
        """

        self._banding = banding

    @property
    def function(self):
        """Gets the function of this Dimension.  # noqa: E501

        Details of the function to use for this dimension  # noqa: E501

        :return: The function of this Dimension.  # noqa: E501
        :rtype: str
        """
        return self._function

    @function.setter
    def function(self, function):
        """Sets the function of this Dimension.

        Details of the function to use for this dimension  # noqa: E501

        :param function: The function of this Dimension.  # noqa: E501
        :type: str
        """
        allowed_values = ["None", "Sum", "Mean", "Min", "Max", "Median", "Mode", "Distinct", "Frequency", "Recency", "RankCoefficient"]  # noqa: E501
        if function not in allowed_values:
            raise ValueError(
                "Invalid value for `function` ({0}), must be one of {1}"  # noqa: E501
                .format(function, allowed_values)
            )

        self._function = function

    @property
    def none_cell(self):
        """Gets the none_cell of this Dimension.  # noqa: E501

        If this dimension represents something for a table lower down the hierarchy to the cube's resolve table,  whether to include a cell for where there a no records on the lower table.  I.e. for where a person has no orders  # noqa: E501

        :return: The none_cell of this Dimension.  # noqa: E501
        :rtype: bool
        """
        return self._none_cell

    @none_cell.setter
    def none_cell(self, none_cell):
        """Sets the none_cell of this Dimension.

        If this dimension represents something for a table lower down the hierarchy to the cube's resolve table,  whether to include a cell for where there a no records on the lower table.  I.e. for where a person has no orders  # noqa: E501

        :param none_cell: The none_cell of this Dimension.  # noqa: E501
        :type: bool
        """

        self._none_cell = none_cell

    @property
    def omit_unclassified(self):
        """Gets the omit_unclassified of this Dimension.  # noqa: E501

        If this dimension represents a selector with an unclassified code, whether to omit this from the cube  # noqa: E501

        :return: The omit_unclassified of this Dimension.  # noqa: E501
        :rtype: bool
        """
        return self._omit_unclassified

    @omit_unclassified.setter
    def omit_unclassified(self, omit_unclassified):
        """Sets the omit_unclassified of this Dimension.

        If this dimension represents a selector with an unclassified code, whether to omit this from the cube  # noqa: E501

        :param omit_unclassified: The omit_unclassified of this Dimension.  # noqa: E501
        :type: bool
        """

        self._omit_unclassified = omit_unclassified

    @property
    def filter_query(self):
        """Gets the filter_query of this Dimension.  # noqa: E501


        :return: The filter_query of this Dimension.  # noqa: E501
        :rtype: Query
        """
        return self._filter_query

    @filter_query.setter
    def filter_query(self, filter_query):
        """Sets the filter_query of this Dimension.


        :param filter_query: The filter_query of this Dimension.  # noqa: E501
        :type: Query
        """

        self._filter_query = filter_query

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Dimension):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
