# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class CreateShareDetail(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'shareable_type': 'str',
        'shareable_id': 'int',
        'email_addresses_to_add': 'list[str]',
        'notify_added_users': 'bool',
        'added_user_notification_message': 'str',
        'notes': 'str',
        'view_shareable_url': 'str'
    }

    attribute_map = {
        'shareable_type': 'shareableType',
        'shareable_id': 'shareableId',
        'email_addresses_to_add': 'emailAddressesToAdd',
        'notify_added_users': 'notifyAddedUsers',
        'added_user_notification_message': 'addedUserNotificationMessage',
        'notes': 'notes',
        'view_shareable_url': 'viewShareableUrl'
    }

    def __init__(self, shareable_type=None, shareable_id=None, email_addresses_to_add=None, notify_added_users=None, added_user_notification_message=None, notes=None, view_shareable_url=None):  # noqa: E501
        """CreateShareDetail - a model defined in OpenAPI"""  # noqa: E501

        self._shareable_type = None
        self._shareable_id = None
        self._email_addresses_to_add = None
        self._notify_added_users = None
        self._added_user_notification_message = None
        self._notes = None
        self._view_shareable_url = None
        self.discriminator = None

        self.shareable_type = shareable_type
        self.shareable_id = shareable_id
        self.email_addresses_to_add = email_addresses_to_add
        self.notify_added_users = notify_added_users
        if added_user_notification_message is not None:
            self.added_user_notification_message = added_user_notification_message
        if notes is not None:
            self.notes = notes
        if view_shareable_url is not None:
            self.view_shareable_url = view_shareable_url

    @property
    def shareable_type(self):
        """Gets the shareable_type of this CreateShareDetail.  # noqa: E501

        The type of the shareable item (collection, audience, etc.) being shared  # noqa: E501

        :return: The shareable_type of this CreateShareDetail.  # noqa: E501
        :rtype: str
        """
        return self._shareable_type

    @shareable_type.setter
    def shareable_type(self, shareable_type):
        """Sets the shareable_type of this CreateShareDetail.

        The type of the shareable item (collection, audience, etc.) being shared  # noqa: E501

        :param shareable_type: The shareable_type of this CreateShareDetail.  # noqa: E501
        :type: str
        """
        if shareable_type is None:
            raise ValueError("Invalid value for `shareable_type`, must not be `None`")  # noqa: E501
        allowed_values = ["Collection", "Audience"]  # noqa: E501
        if shareable_type not in allowed_values:
            raise ValueError(
                "Invalid value for `shareable_type` ({0}), must be one of {1}"  # noqa: E501
                .format(shareable_type, allowed_values)
            )

        self._shareable_type = shareable_type

    @property
    def shareable_id(self):
        """Gets the shareable_id of this CreateShareDetail.  # noqa: E501

        The id of the shareable item being shared  # noqa: E501

        :return: The shareable_id of this CreateShareDetail.  # noqa: E501
        :rtype: int
        """
        return self._shareable_id

    @shareable_id.setter
    def shareable_id(self, shareable_id):
        """Sets the shareable_id of this CreateShareDetail.

        The id of the shareable item being shared  # noqa: E501

        :param shareable_id: The shareable_id of this CreateShareDetail.  # noqa: E501
        :type: int
        """
        if shareable_id is None:
            raise ValueError("Invalid value for `shareable_id`, must not be `None`")  # noqa: E501

        self._shareable_id = shareable_id

    @property
    def email_addresses_to_add(self):
        """Gets the email_addresses_to_add of this CreateShareDetail.  # noqa: E501

        The list of email addresses to share this shareable item with  # noqa: E501

        :return: The email_addresses_to_add of this CreateShareDetail.  # noqa: E501
        :rtype: list[str]
        """
        return self._email_addresses_to_add

    @email_addresses_to_add.setter
    def email_addresses_to_add(self, email_addresses_to_add):
        """Sets the email_addresses_to_add of this CreateShareDetail.

        The list of email addresses to share this shareable item with  # noqa: E501

        :param email_addresses_to_add: The email_addresses_to_add of this CreateShareDetail.  # noqa: E501
        :type: list[str]
        """
        if email_addresses_to_add is None:
            raise ValueError("Invalid value for `email_addresses_to_add`, must not be `None`")  # noqa: E501

        self._email_addresses_to_add = email_addresses_to_add

    @property
    def notify_added_users(self):
        """Gets the notify_added_users of this CreateShareDetail.  # noqa: E501

        Whether to notify the users added in this share that the shareable item has now been shared with them  # noqa: E501

        :return: The notify_added_users of this CreateShareDetail.  # noqa: E501
        :rtype: bool
        """
        return self._notify_added_users

    @notify_added_users.setter
    def notify_added_users(self, notify_added_users):
        """Sets the notify_added_users of this CreateShareDetail.

        Whether to notify the users added in this share that the shareable item has now been shared with them  # noqa: E501

        :param notify_added_users: The notify_added_users of this CreateShareDetail.  # noqa: E501
        :type: bool
        """
        if notify_added_users is None:
            raise ValueError("Invalid value for `notify_added_users`, must not be `None`")  # noqa: E501

        self._notify_added_users = notify_added_users

    @property
    def added_user_notification_message(self):
        """Gets the added_user_notification_message of this CreateShareDetail.  # noqa: E501

        If added users are to be notified, this is the message to be sent to them.  The URL of the view of the shareable item (specified when the shareable item was created)  will be added to the notification after this message.  # noqa: E501

        :return: The added_user_notification_message of this CreateShareDetail.  # noqa: E501
        :rtype: str
        """
        return self._added_user_notification_message

    @added_user_notification_message.setter
    def added_user_notification_message(self, added_user_notification_message):
        """Sets the added_user_notification_message of this CreateShareDetail.

        If added users are to be notified, this is the message to be sent to them.  The URL of the view of the shareable item (specified when the shareable item was created)  will be added to the notification after this message.  # noqa: E501

        :param added_user_notification_message: The added_user_notification_message of this CreateShareDetail.  # noqa: E501
        :type: str
        """

        self._added_user_notification_message = added_user_notification_message

    @property
    def notes(self):
        """Gets the notes of this CreateShareDetail.  # noqa: E501

        The notes associated with this share update  # noqa: E501

        :return: The notes of this CreateShareDetail.  # noqa: E501
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this CreateShareDetail.

        The notes associated with this share update  # noqa: E501

        :param notes: The notes of this CreateShareDetail.  # noqa: E501
        :type: str
        """

        self._notes = notes

    @property
    def view_shareable_url(self):
        """Gets the view_shareable_url of this CreateShareDetail.  # noqa: E501

        A URL of a page to view the shareable item.  If specified this will be used in notification  messages to show added or removed users where to view the shareable item    If the URL is specified, it can use {shareableId} and {emailAddress} parameters    http://www.example.com/collections/{shareableId}?email={emailAddress}    If present, these parameters will be replaced with the id of the shareable item and the email address of the user being added/removed  # noqa: E501

        :return: The view_shareable_url of this CreateShareDetail.  # noqa: E501
        :rtype: str
        """
        return self._view_shareable_url

    @view_shareable_url.setter
    def view_shareable_url(self, view_shareable_url):
        """Sets the view_shareable_url of this CreateShareDetail.

        A URL of a page to view the shareable item.  If specified this will be used in notification  messages to show added or removed users where to view the shareable item    If the URL is specified, it can use {shareableId} and {emailAddress} parameters    http://www.example.com/collections/{shareableId}?email={emailAddress}    If present, these parameters will be replaced with the id of the shareable item and the email address of the user being added/removed  # noqa: E501

        :param view_shareable_url: The view_shareable_url of this CreateShareDetail.  # noqa: E501
        :type: str
        """

        self._view_shareable_url = view_shareable_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateShareDetail):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
