# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class CreateSessionParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'login_salt': 'str',
        'salt_password': 'bool',
        'user_salt': 'str',
        'use_password_hashes': 'bool',
        'hash_algorithm': 'str'
    }

    attribute_map = {
        'login_salt': 'loginSalt',
        'salt_password': 'saltPassword',
        'user_salt': 'userSalt',
        'use_password_hashes': 'usePasswordHashes',
        'hash_algorithm': 'hashAlgorithm'
    }

    def __init__(self, login_salt=None, salt_password=None, user_salt=None, use_password_hashes=None, hash_algorithm=None):  # noqa: E501
        """CreateSessionParameters - a model defined in OpenAPI"""  # noqa: E501

        self._login_salt = None
        self._salt_password = None
        self._user_salt = None
        self._use_password_hashes = None
        self._hash_algorithm = None
        self.discriminator = None

        self.login_salt = login_salt
        self.salt_password = salt_password
        self.user_salt = user_salt
        self.use_password_hashes = use_password_hashes
        self.hash_algorithm = hash_algorithm

    @property
    def login_salt(self):
        """Gets the login_salt of this CreateSessionParameters.  # noqa: E501

        The salt to use when creating a session  # noqa: E501

        :return: The login_salt of this CreateSessionParameters.  # noqa: E501
        :rtype: str
        """
        return self._login_salt

    @login_salt.setter
    def login_salt(self, login_salt):
        """Sets the login_salt of this CreateSessionParameters.

        The salt to use when creating a session  # noqa: E501

        :param login_salt: The login_salt of this CreateSessionParameters.  # noqa: E501
        :type: str
        """
        if login_salt is None:
            raise ValueError("Invalid value for `login_salt`, must not be `None`")  # noqa: E501

        self._login_salt = login_salt

    @property
    def salt_password(self):
        """Gets the salt_password of this CreateSessionParameters.  # noqa: E501

        Whether you have to use the UserSalt to create the password hash when logging in via the SaltedLogin method  # noqa: E501

        :return: The salt_password of this CreateSessionParameters.  # noqa: E501
        :rtype: bool
        """
        return self._salt_password

    @salt_password.setter
    def salt_password(self, salt_password):
        """Sets the salt_password of this CreateSessionParameters.

        Whether you have to use the UserSalt to create the password hash when logging in via the SaltedLogin method  # noqa: E501

        :param salt_password: The salt_password of this CreateSessionParameters.  # noqa: E501
        :type: bool
        """
        if salt_password is None:
            raise ValueError("Invalid value for `salt_password`, must not be `None`")  # noqa: E501

        self._salt_password = salt_password

    @property
    def user_salt(self):
        """Gets the user_salt of this CreateSessionParameters.  # noqa: E501

        The password salt for the particular user  # noqa: E501

        :return: The user_salt of this CreateSessionParameters.  # noqa: E501
        :rtype: str
        """
        return self._user_salt

    @user_salt.setter
    def user_salt(self, user_salt):
        """Sets the user_salt of this CreateSessionParameters.

        The password salt for the particular user  # noqa: E501

        :param user_salt: The user_salt of this CreateSessionParameters.  # noqa: E501
        :type: str
        """
        if user_salt is None:
            raise ValueError("Invalid value for `user_salt`, must not be `None`")  # noqa: E501

        self._user_salt = user_salt

    @property
    def use_password_hashes(self):
        """Gets the use_password_hashes of this CreateSessionParameters.  # noqa: E501

        Whether you have to hash the password with the given algorithm before it is combined with the login salt or not  # noqa: E501

        :return: The use_password_hashes of this CreateSessionParameters.  # noqa: E501
        :rtype: bool
        """
        return self._use_password_hashes

    @use_password_hashes.setter
    def use_password_hashes(self, use_password_hashes):
        """Sets the use_password_hashes of this CreateSessionParameters.

        Whether you have to hash the password with the given algorithm before it is combined with the login salt or not  # noqa: E501

        :param use_password_hashes: The use_password_hashes of this CreateSessionParameters.  # noqa: E501
        :type: bool
        """
        if use_password_hashes is None:
            raise ValueError("Invalid value for `use_password_hashes`, must not be `None`")  # noqa: E501

        self._use_password_hashes = use_password_hashes

    @property
    def hash_algorithm(self):
        """Gets the hash_algorithm of this CreateSessionParameters.  # noqa: E501

        The hash algorithm to use when generating the password hash  # noqa: E501

        :return: The hash_algorithm of this CreateSessionParameters.  # noqa: E501
        :rtype: str
        """
        return self._hash_algorithm

    @hash_algorithm.setter
    def hash_algorithm(self, hash_algorithm):
        """Sets the hash_algorithm of this CreateSessionParameters.

        The hash algorithm to use when generating the password hash  # noqa: E501

        :param hash_algorithm: The hash_algorithm of this CreateSessionParameters.  # noqa: E501
        :type: str
        """
        if hash_algorithm is None:
            raise ValueError("Invalid value for `hash_algorithm`, must not be `None`")  # noqa: E501
        allowed_values = ["BasicCipher", "MD5", "SHA1", "SHA256", "SHA384", "SHA512"]  # noqa: E501
        if hash_algorithm not in allowed_values:
            raise ValueError(
                "Invalid value for `hash_algorithm` ({0}), must be one of {1}"  # noqa: E501
                .format(hash_algorithm, allowed_values)
            )

        self._hash_algorithm = hash_algorithm

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateSessionParameters):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
