# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class CommunicationStatistics(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'days': 'list[str]',
        'communications_counts': 'list[int]',
        'total_communications_count': 'int',
        'deliveries_counts': 'list[int]',
        'total_deliveries_count': 'int',
        'messages_counts': 'list[int]',
        'total_messages_count': 'int',
        'campaigns_counts': 'list[int]',
        'total_campaigns_count': 'int',
        'people_counts': 'list[int]',
        'communication_statistics_timestamp': 'datetime',
        'campaign_statistics_timestamp': 'datetime',
        'people_statistics_timestamp': 'datetime'
    }

    attribute_map = {
        'days': 'days',
        'communications_counts': 'communicationsCounts',
        'total_communications_count': 'totalCommunicationsCount',
        'deliveries_counts': 'deliveriesCounts',
        'total_deliveries_count': 'totalDeliveriesCount',
        'messages_counts': 'messagesCounts',
        'total_messages_count': 'totalMessagesCount',
        'campaigns_counts': 'campaignsCounts',
        'total_campaigns_count': 'totalCampaignsCount',
        'people_counts': 'peopleCounts',
        'communication_statistics_timestamp': 'communicationStatisticsTimestamp',
        'campaign_statistics_timestamp': 'campaignStatisticsTimestamp',
        'people_statistics_timestamp': 'peopleStatisticsTimestamp'
    }

    def __init__(self, days=None, communications_counts=None, total_communications_count=None, deliveries_counts=None, total_deliveries_count=None, messages_counts=None, total_messages_count=None, campaigns_counts=None, total_campaigns_count=None, people_counts=None, communication_statistics_timestamp=None, campaign_statistics_timestamp=None, people_statistics_timestamp=None):  # noqa: E501
        """CommunicationStatistics - a model defined in OpenAPI"""  # noqa: E501

        self._days = None
        self._communications_counts = None
        self._total_communications_count = None
        self._deliveries_counts = None
        self._total_deliveries_count = None
        self._messages_counts = None
        self._total_messages_count = None
        self._campaigns_counts = None
        self._total_campaigns_count = None
        self._people_counts = None
        self._communication_statistics_timestamp = None
        self._campaign_statistics_timestamp = None
        self._people_statistics_timestamp = None
        self.discriminator = None

        self.days = days
        self.communications_counts = communications_counts
        self.total_communications_count = total_communications_count
        self.deliveries_counts = deliveries_counts
        self.total_deliveries_count = total_deliveries_count
        self.messages_counts = messages_counts
        self.total_messages_count = total_messages_count
        self.campaigns_counts = campaigns_counts
        self.total_campaigns_count = total_campaigns_count
        self.people_counts = people_counts
        if communication_statistics_timestamp is not None:
            self.communication_statistics_timestamp = communication_statistics_timestamp
        if campaign_statistics_timestamp is not None:
            self.campaign_statistics_timestamp = campaign_statistics_timestamp
        if people_statistics_timestamp is not None:
            self.people_statistics_timestamp = people_statistics_timestamp

    @property
    def days(self):
        """Gets the days of this CommunicationStatistics.  # noqa: E501

        The set of days where communication information is available  # noqa: E501

        :return: The days of this CommunicationStatistics.  # noqa: E501
        :rtype: list[str]
        """
        return self._days

    @days.setter
    def days(self, days):
        """Sets the days of this CommunicationStatistics.

        The set of days where communication information is available  # noqa: E501

        :param days: The days of this CommunicationStatistics.  # noqa: E501
        :type: list[str]
        """
        if days is None:
            raise ValueError("Invalid value for `days`, must not be `None`")  # noqa: E501

        self._days = days

    @property
    def communications_counts(self):
        """Gets the communications_counts of this CommunicationStatistics.  # noqa: E501

        The set of counts representing the number of communications on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :return: The communications_counts of this CommunicationStatistics.  # noqa: E501
        :rtype: list[int]
        """
        return self._communications_counts

    @communications_counts.setter
    def communications_counts(self, communications_counts):
        """Sets the communications_counts of this CommunicationStatistics.

        The set of counts representing the number of communications on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :param communications_counts: The communications_counts of this CommunicationStatistics.  # noqa: E501
        :type: list[int]
        """
        if communications_counts is None:
            raise ValueError("Invalid value for `communications_counts`, must not be `None`")  # noqa: E501

        self._communications_counts = communications_counts

    @property
    def total_communications_count(self):
        """Gets the total_communications_count of this CommunicationStatistics.  # noqa: E501

        The total number of communications across all days  # noqa: E501

        :return: The total_communications_count of this CommunicationStatistics.  # noqa: E501
        :rtype: int
        """
        return self._total_communications_count

    @total_communications_count.setter
    def total_communications_count(self, total_communications_count):
        """Sets the total_communications_count of this CommunicationStatistics.

        The total number of communications across all days  # noqa: E501

        :param total_communications_count: The total_communications_count of this CommunicationStatistics.  # noqa: E501
        :type: int
        """
        if total_communications_count is None:
            raise ValueError("Invalid value for `total_communications_count`, must not be `None`")  # noqa: E501

        self._total_communications_count = total_communications_count

    @property
    def deliveries_counts(self):
        """Gets the deliveries_counts of this CommunicationStatistics.  # noqa: E501

        The set of counts representing the number of deliveries that have run on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :return: The deliveries_counts of this CommunicationStatistics.  # noqa: E501
        :rtype: list[int]
        """
        return self._deliveries_counts

    @deliveries_counts.setter
    def deliveries_counts(self, deliveries_counts):
        """Sets the deliveries_counts of this CommunicationStatistics.

        The set of counts representing the number of deliveries that have run on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :param deliveries_counts: The deliveries_counts of this CommunicationStatistics.  # noqa: E501
        :type: list[int]
        """
        if deliveries_counts is None:
            raise ValueError("Invalid value for `deliveries_counts`, must not be `None`")  # noqa: E501

        self._deliveries_counts = deliveries_counts

    @property
    def total_deliveries_count(self):
        """Gets the total_deliveries_count of this CommunicationStatistics.  # noqa: E501

        The total number of deliveries that have run across all days  # noqa: E501

        :return: The total_deliveries_count of this CommunicationStatistics.  # noqa: E501
        :rtype: int
        """
        return self._total_deliveries_count

    @total_deliveries_count.setter
    def total_deliveries_count(self, total_deliveries_count):
        """Sets the total_deliveries_count of this CommunicationStatistics.

        The total number of deliveries that have run across all days  # noqa: E501

        :param total_deliveries_count: The total_deliveries_count of this CommunicationStatistics.  # noqa: E501
        :type: int
        """
        if total_deliveries_count is None:
            raise ValueError("Invalid value for `total_deliveries_count`, must not be `None`")  # noqa: E501

        self._total_deliveries_count = total_deliveries_count

    @property
    def messages_counts(self):
        """Gets the messages_counts of this CommunicationStatistics.  # noqa: E501

        The set of counts representing the number of messages that have had at least one delivery run on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :return: The messages_counts of this CommunicationStatistics.  # noqa: E501
        :rtype: list[int]
        """
        return self._messages_counts

    @messages_counts.setter
    def messages_counts(self, messages_counts):
        """Sets the messages_counts of this CommunicationStatistics.

        The set of counts representing the number of messages that have had at least one delivery run on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :param messages_counts: The messages_counts of this CommunicationStatistics.  # noqa: E501
        :type: list[int]
        """
        if messages_counts is None:
            raise ValueError("Invalid value for `messages_counts`, must not be `None`")  # noqa: E501

        self._messages_counts = messages_counts

    @property
    def total_messages_count(self):
        """Gets the total_messages_count of this CommunicationStatistics.  # noqa: E501

        The total number of messages that have had at least one delivery run across all days  # noqa: E501

        :return: The total_messages_count of this CommunicationStatistics.  # noqa: E501
        :rtype: int
        """
        return self._total_messages_count

    @total_messages_count.setter
    def total_messages_count(self, total_messages_count):
        """Sets the total_messages_count of this CommunicationStatistics.

        The total number of messages that have had at least one delivery run across all days  # noqa: E501

        :param total_messages_count: The total_messages_count of this CommunicationStatistics.  # noqa: E501
        :type: int
        """
        if total_messages_count is None:
            raise ValueError("Invalid value for `total_messages_count`, must not be `None`")  # noqa: E501

        self._total_messages_count = total_messages_count

    @property
    def campaigns_counts(self):
        """Gets the campaigns_counts of this CommunicationStatistics.  # noqa: E501

        The set of counts representing the number of campaigns that have had at least one delivery run on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :return: The campaigns_counts of this CommunicationStatistics.  # noqa: E501
        :rtype: list[int]
        """
        return self._campaigns_counts

    @campaigns_counts.setter
    def campaigns_counts(self, campaigns_counts):
        """Sets the campaigns_counts of this CommunicationStatistics.

        The set of counts representing the number of campaigns that have had at least one delivery run on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :param campaigns_counts: The campaigns_counts of this CommunicationStatistics.  # noqa: E501
        :type: list[int]
        """
        if campaigns_counts is None:
            raise ValueError("Invalid value for `campaigns_counts`, must not be `None`")  # noqa: E501

        self._campaigns_counts = campaigns_counts

    @property
    def total_campaigns_count(self):
        """Gets the total_campaigns_count of this CommunicationStatistics.  # noqa: E501

        The total number of campaigns that have had at least one delivery run across all days  # noqa: E501

        :return: The total_campaigns_count of this CommunicationStatistics.  # noqa: E501
        :rtype: int
        """
        return self._total_campaigns_count

    @total_campaigns_count.setter
    def total_campaigns_count(self, total_campaigns_count):
        """Sets the total_campaigns_count of this CommunicationStatistics.

        The total number of campaigns that have had at least one delivery run across all days  # noqa: E501

        :param total_campaigns_count: The total_campaigns_count of this CommunicationStatistics.  # noqa: E501
        :type: int
        """
        if total_campaigns_count is None:
            raise ValueError("Invalid value for `total_campaigns_count`, must not be `None`")  # noqa: E501

        self._total_campaigns_count = total_campaigns_count

    @property
    def people_counts(self):
        """Gets the people_counts of this CommunicationStatistics.  # noqa: E501

        The set of counts representing the number of unique people processed on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :return: The people_counts of this CommunicationStatistics.  # noqa: E501
        :rtype: list[int]
        """
        return self._people_counts

    @people_counts.setter
    def people_counts(self, people_counts):
        """Sets the people_counts of this CommunicationStatistics.

        The set of counts representing the number of unique people processed on the corresponding day.  The first figure is data for the first day in the Days list, and so on.  # noqa: E501

        :param people_counts: The people_counts of this CommunicationStatistics.  # noqa: E501
        :type: list[int]
        """
        if people_counts is None:
            raise ValueError("Invalid value for `people_counts`, must not be `None`")  # noqa: E501

        self._people_counts = people_counts

    @property
    def communication_statistics_timestamp(self):
        """Gets the communication_statistics_timestamp of this CommunicationStatistics.  # noqa: E501

        The date and time that the communication statistics were calculated  # noqa: E501

        :return: The communication_statistics_timestamp of this CommunicationStatistics.  # noqa: E501
        :rtype: datetime
        """
        return self._communication_statistics_timestamp

    @communication_statistics_timestamp.setter
    def communication_statistics_timestamp(self, communication_statistics_timestamp):
        """Sets the communication_statistics_timestamp of this CommunicationStatistics.

        The date and time that the communication statistics were calculated  # noqa: E501

        :param communication_statistics_timestamp: The communication_statistics_timestamp of this CommunicationStatistics.  # noqa: E501
        :type: datetime
        """

        self._communication_statistics_timestamp = communication_statistics_timestamp

    @property
    def campaign_statistics_timestamp(self):
        """Gets the campaign_statistics_timestamp of this CommunicationStatistics.  # noqa: E501

        The date and time that the delivery, message and campaign statistics were calculated  # noqa: E501

        :return: The campaign_statistics_timestamp of this CommunicationStatistics.  # noqa: E501
        :rtype: datetime
        """
        return self._campaign_statistics_timestamp

    @campaign_statistics_timestamp.setter
    def campaign_statistics_timestamp(self, campaign_statistics_timestamp):
        """Sets the campaign_statistics_timestamp of this CommunicationStatistics.

        The date and time that the delivery, message and campaign statistics were calculated  # noqa: E501

        :param campaign_statistics_timestamp: The campaign_statistics_timestamp of this CommunicationStatistics.  # noqa: E501
        :type: datetime
        """

        self._campaign_statistics_timestamp = campaign_statistics_timestamp

    @property
    def people_statistics_timestamp(self):
        """Gets the people_statistics_timestamp of this CommunicationStatistics.  # noqa: E501

        The date and time that the people statistics were calculated  # noqa: E501

        :return: The people_statistics_timestamp of this CommunicationStatistics.  # noqa: E501
        :rtype: datetime
        """
        return self._people_statistics_timestamp

    @people_statistics_timestamp.setter
    def people_statistics_timestamp(self, people_statistics_timestamp):
        """Sets the people_statistics_timestamp of this CommunicationStatistics.

        The date and time that the people statistics were calculated  # noqa: E501

        :param people_statistics_timestamp: The people_statistics_timestamp of this CommunicationStatistics.  # noqa: E501
        :type: datetime
        """

        self._people_statistics_timestamp = people_statistics_timestamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CommunicationStatistics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
