# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ChannelStatistics(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'days': 'list[str]',
        'per_channel_stats': 'dict(str, PerChannelStatistics)',
        'total_communications_count': 'int',
        'total_cost': 'float',
        'statistics_timestamp': 'datetime'
    }

    attribute_map = {
        'days': 'days',
        'per_channel_stats': 'perChannelStats',
        'total_communications_count': 'totalCommunicationsCount',
        'total_cost': 'totalCost',
        'statistics_timestamp': 'statisticsTimestamp'
    }

    def __init__(self, days=None, per_channel_stats=None, total_communications_count=None, total_cost=None, statistics_timestamp=None):  # noqa: E501
        """ChannelStatistics - a model defined in OpenAPI"""  # noqa: E501

        self._days = None
        self._per_channel_stats = None
        self._total_communications_count = None
        self._total_cost = None
        self._statistics_timestamp = None
        self.discriminator = None

        self.days = days
        self.per_channel_stats = per_channel_stats
        self.total_communications_count = total_communications_count
        self.total_cost = total_cost
        if statistics_timestamp is not None:
            self.statistics_timestamp = statistics_timestamp

    @property
    def days(self):
        """Gets the days of this ChannelStatistics.  # noqa: E501

        The set of days where channel information is available  # noqa: E501

        :return: The days of this ChannelStatistics.  # noqa: E501
        :rtype: list[str]
        """
        return self._days

    @days.setter
    def days(self, days):
        """Sets the days of this ChannelStatistics.

        The set of days where channel information is available  # noqa: E501

        :param days: The days of this ChannelStatistics.  # noqa: E501
        :type: list[str]
        """
        if days is None:
            raise ValueError("Invalid value for `days`, must not be `None`")  # noqa: E501

        self._days = days

    @property
    def per_channel_stats(self):
        """Gets the per_channel_stats of this ChannelStatistics.  # noqa: E501

        A map between a channel's id and its statistics data  # noqa: E501

        :return: The per_channel_stats of this ChannelStatistics.  # noqa: E501
        :rtype: dict(str, PerChannelStatistics)
        """
        return self._per_channel_stats

    @per_channel_stats.setter
    def per_channel_stats(self, per_channel_stats):
        """Sets the per_channel_stats of this ChannelStatistics.

        A map between a channel's id and its statistics data  # noqa: E501

        :param per_channel_stats: The per_channel_stats of this ChannelStatistics.  # noqa: E501
        :type: dict(str, PerChannelStatistics)
        """
        if per_channel_stats is None:
            raise ValueError("Invalid value for `per_channel_stats`, must not be `None`")  # noqa: E501

        self._per_channel_stats = per_channel_stats

    @property
    def total_communications_count(self):
        """Gets the total_communications_count of this ChannelStatistics.  # noqa: E501

        The total number of communications across all channels  # noqa: E501

        :return: The total_communications_count of this ChannelStatistics.  # noqa: E501
        :rtype: int
        """
        return self._total_communications_count

    @total_communications_count.setter
    def total_communications_count(self, total_communications_count):
        """Sets the total_communications_count of this ChannelStatistics.

        The total number of communications across all channels  # noqa: E501

        :param total_communications_count: The total_communications_count of this ChannelStatistics.  # noqa: E501
        :type: int
        """
        if total_communications_count is None:
            raise ValueError("Invalid value for `total_communications_count`, must not be `None`")  # noqa: E501

        self._total_communications_count = total_communications_count

    @property
    def total_cost(self):
        """Gets the total_cost of this ChannelStatistics.  # noqa: E501

        The total cost across all channels  # noqa: E501

        :return: The total_cost of this ChannelStatistics.  # noqa: E501
        :rtype: float
        """
        return self._total_cost

    @total_cost.setter
    def total_cost(self, total_cost):
        """Sets the total_cost of this ChannelStatistics.

        The total cost across all channels  # noqa: E501

        :param total_cost: The total_cost of this ChannelStatistics.  # noqa: E501
        :type: float
        """
        if total_cost is None:
            raise ValueError("Invalid value for `total_cost`, must not be `None`")  # noqa: E501

        self._total_cost = total_cost

    @property
    def statistics_timestamp(self):
        """Gets the statistics_timestamp of this ChannelStatistics.  # noqa: E501

        The date and time that the channel statistics were calculated  # noqa: E501

        :return: The statistics_timestamp of this ChannelStatistics.  # noqa: E501
        :rtype: datetime
        """
        return self._statistics_timestamp

    @statistics_timestamp.setter
    def statistics_timestamp(self, statistics_timestamp):
        """Sets the statistics_timestamp of this ChannelStatistics.

        The date and time that the channel statistics were calculated  # noqa: E501

        :param statistics_timestamp: The statistics_timestamp of this ChannelStatistics.  # noqa: E501
        :type: datetime
        """

        self._statistics_timestamp = statistics_timestamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChannelStatistics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
