# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class AudienceExportDetail(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'audience_update_id': 'int',
        'timestamp': 'datetime',
        'fast_stats_build_date': 'datetime',
        'user': 'UserDisplayDetails',
        'nett_counts': 'list[Count]',
        'urn_file_path': 'str',
        'maximum_number_of_rows_to_browse': 'int',
        'return_browse_rows': 'bool',
        'file_path': 'str',
        'output': 'Output',
        'columns': 'list[Column]',
        'rows': 'list[Row]'
    }

    attribute_map = {
        'audience_update_id': 'audienceUpdateId',
        'timestamp': 'timestamp',
        'fast_stats_build_date': 'fastStatsBuildDate',
        'user': 'user',
        'nett_counts': 'nettCounts',
        'urn_file_path': 'urnFilePath',
        'maximum_number_of_rows_to_browse': 'maximumNumberOfRowsToBrowse',
        'return_browse_rows': 'returnBrowseRows',
        'file_path': 'filePath',
        'output': 'output',
        'columns': 'columns',
        'rows': 'rows'
    }

    def __init__(self, audience_update_id=None, timestamp=None, fast_stats_build_date=None, user=None, nett_counts=None, urn_file_path=None, maximum_number_of_rows_to_browse=None, return_browse_rows=None, file_path=None, output=None, columns=None, rows=None):  # noqa: E501
        """AudienceExportDetail - a model defined in OpenAPI"""  # noqa: E501

        self._audience_update_id = None
        self._timestamp = None
        self._fast_stats_build_date = None
        self._user = None
        self._nett_counts = None
        self._urn_file_path = None
        self._maximum_number_of_rows_to_browse = None
        self._return_browse_rows = None
        self._file_path = None
        self._output = None
        self._columns = None
        self._rows = None
        self.discriminator = None

        self.audience_update_id = audience_update_id
        self.timestamp = timestamp
        self.fast_stats_build_date = fast_stats_build_date
        self.user = user
        self.nett_counts = nett_counts
        self.urn_file_path = urn_file_path
        self.maximum_number_of_rows_to_browse = maximum_number_of_rows_to_browse
        self.return_browse_rows = return_browse_rows
        if file_path is not None:
            self.file_path = file_path
        if output is not None:
            self.output = output
        self.columns = columns
        if rows is not None:
            self.rows = rows

    @property
    def audience_update_id(self):
        """Gets the audience_update_id of this AudienceExportDetail.  # noqa: E501

        The id of the update (audience version) that the export was created from  # noqa: E501

        :return: The audience_update_id of this AudienceExportDetail.  # noqa: E501
        :rtype: int
        """
        return self._audience_update_id

    @audience_update_id.setter
    def audience_update_id(self, audience_update_id):
        """Sets the audience_update_id of this AudienceExportDetail.

        The id of the update (audience version) that the export was created from  # noqa: E501

        :param audience_update_id: The audience_update_id of this AudienceExportDetail.  # noqa: E501
        :type: int
        """
        if audience_update_id is None:
            raise ValueError("Invalid value for `audience_update_id`, must not be `None`")  # noqa: E501

        self._audience_update_id = audience_update_id

    @property
    def timestamp(self):
        """Gets the timestamp of this AudienceExportDetail.  # noqa: E501

        The date and time that the export was produced  # noqa: E501

        :return: The timestamp of this AudienceExportDetail.  # noqa: E501
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this AudienceExportDetail.

        The date and time that the export was produced  # noqa: E501

        :param timestamp: The timestamp of this AudienceExportDetail.  # noqa: E501
        :type: datetime
        """
        if timestamp is None:
            raise ValueError("Invalid value for `timestamp`, must not be `None`")  # noqa: E501

        self._timestamp = timestamp

    @property
    def fast_stats_build_date(self):
        """Gets the fast_stats_build_date of this AudienceExportDetail.  # noqa: E501

        The date and time that the FastStats system used to create this export was built  # noqa: E501

        :return: The fast_stats_build_date of this AudienceExportDetail.  # noqa: E501
        :rtype: datetime
        """
        return self._fast_stats_build_date

    @fast_stats_build_date.setter
    def fast_stats_build_date(self, fast_stats_build_date):
        """Sets the fast_stats_build_date of this AudienceExportDetail.

        The date and time that the FastStats system used to create this export was built  # noqa: E501

        :param fast_stats_build_date: The fast_stats_build_date of this AudienceExportDetail.  # noqa: E501
        :type: datetime
        """
        if fast_stats_build_date is None:
            raise ValueError("Invalid value for `fast_stats_build_date`, must not be `None`")  # noqa: E501

        self._fast_stats_build_date = fast_stats_build_date

    @property
    def user(self):
        """Gets the user of this AudienceExportDetail.  # noqa: E501


        :return: The user of this AudienceExportDetail.  # noqa: E501
        :rtype: UserDisplayDetails
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this AudienceExportDetail.


        :param user: The user of this AudienceExportDetail.  # noqa: E501
        :type: UserDisplayDetails
        """
        if user is None:
            raise ValueError("Invalid value for `user`, must not be `None`")  # noqa: E501

        self._user = user

    @property
    def nett_counts(self):
        """Gets the nett_counts of this AudienceExportDetail.  # noqa: E501

        The set of overall counts for the audience behind this export  # noqa: E501

        :return: The nett_counts of this AudienceExportDetail.  # noqa: E501
        :rtype: list[Count]
        """
        return self._nett_counts

    @nett_counts.setter
    def nett_counts(self, nett_counts):
        """Sets the nett_counts of this AudienceExportDetail.

        The set of overall counts for the audience behind this export  # noqa: E501

        :param nett_counts: The nett_counts of this AudienceExportDetail.  # noqa: E501
        :type: list[Count]
        """
        if nett_counts is None:
            raise ValueError("Invalid value for `nett_counts`, must not be `None`")  # noqa: E501

        self._nett_counts = nett_counts

    @property
    def urn_file_path(self):
        """Gets the urn_file_path of this AudienceExportDetail.  # noqa: E501

        If a URN file was generated as part of this export then this will be its path within the FastStats system  # noqa: E501

        :return: The urn_file_path of this AudienceExportDetail.  # noqa: E501
        :rtype: str
        """
        return self._urn_file_path

    @urn_file_path.setter
    def urn_file_path(self, urn_file_path):
        """Sets the urn_file_path of this AudienceExportDetail.

        If a URN file was generated as part of this export then this will be its path within the FastStats system  # noqa: E501

        :param urn_file_path: The urn_file_path of this AudienceExportDetail.  # noqa: E501
        :type: str
        """
        if urn_file_path is None:
            raise ValueError("Invalid value for `urn_file_path`, must not be `None`")  # noqa: E501

        self._urn_file_path = urn_file_path

    @property
    def maximum_number_of_rows_to_browse(self):
        """Gets the maximum_number_of_rows_to_browse of this AudienceExportDetail.  # noqa: E501

        The requested maximum number of rows to return when browsing the data  # noqa: E501

        :return: The maximum_number_of_rows_to_browse of this AudienceExportDetail.  # noqa: E501
        :rtype: int
        """
        return self._maximum_number_of_rows_to_browse

    @maximum_number_of_rows_to_browse.setter
    def maximum_number_of_rows_to_browse(self, maximum_number_of_rows_to_browse):
        """Sets the maximum_number_of_rows_to_browse of this AudienceExportDetail.

        The requested maximum number of rows to return when browsing the data  # noqa: E501

        :param maximum_number_of_rows_to_browse: The maximum_number_of_rows_to_browse of this AudienceExportDetail.  # noqa: E501
        :type: int
        """
        if maximum_number_of_rows_to_browse is None:
            raise ValueError("Invalid value for `maximum_number_of_rows_to_browse`, must not be `None`")  # noqa: E501

        self._maximum_number_of_rows_to_browse = maximum_number_of_rows_to_browse

    @property
    def return_browse_rows(self):
        """Gets the return_browse_rows of this AudienceExportDetail.  # noqa: E501

        Whether data rows were requested to be returned or whether the data was exported directly to the specified file  # noqa: E501

        :return: The return_browse_rows of this AudienceExportDetail.  # noqa: E501
        :rtype: bool
        """
        return self._return_browse_rows

    @return_browse_rows.setter
    def return_browse_rows(self, return_browse_rows):
        """Sets the return_browse_rows of this AudienceExportDetail.

        Whether data rows were requested to be returned or whether the data was exported directly to the specified file  # noqa: E501

        :param return_browse_rows: The return_browse_rows of this AudienceExportDetail.  # noqa: E501
        :type: bool
        """
        if return_browse_rows is None:
            raise ValueError("Invalid value for `return_browse_rows`, must not be `None`")  # noqa: E501

        self._return_browse_rows = return_browse_rows

    @property
    def file_path(self):
        """Gets the file_path of this AudienceExportDetail.  # noqa: E501

        If specified, the path of a file that the data was exported to  # noqa: E501

        :return: The file_path of this AudienceExportDetail.  # noqa: E501
        :rtype: str
        """
        return self._file_path

    @file_path.setter
    def file_path(self, file_path):
        """Sets the file_path of this AudienceExportDetail.

        If specified, the path of a file that the data was exported to  # noqa: E501

        :param file_path: The file_path of this AudienceExportDetail.  # noqa: E501
        :type: str
        """

        self._file_path = file_path

    @property
    def output(self):
        """Gets the output of this AudienceExportDetail.  # noqa: E501


        :return: The output of this AudienceExportDetail.  # noqa: E501
        :rtype: Output
        """
        return self._output

    @output.setter
    def output(self, output):
        """Sets the output of this AudienceExportDetail.


        :param output: The output of this AudienceExportDetail.  # noqa: E501
        :type: Output
        """

        self._output = output

    @property
    def columns(self):
        """Gets the columns of this AudienceExportDetail.  # noqa: E501

        The list of columns that have been included in this export  # noqa: E501

        :return: The columns of this AudienceExportDetail.  # noqa: E501
        :rtype: list[Column]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """Sets the columns of this AudienceExportDetail.

        The list of columns that have been included in this export  # noqa: E501

        :param columns: The columns of this AudienceExportDetail.  # noqa: E501
        :type: list[Column]
        """
        if columns is None:
            raise ValueError("Invalid value for `columns`, must not be `None`")  # noqa: E501

        self._columns = columns

    @property
    def rows(self):
        """Gets the rows of this AudienceExportDetail.  # noqa: E501

        If data rows were requested to be returned then the set of rows containing data for the given columns selected by the audience queries  # noqa: E501

        :return: The rows of this AudienceExportDetail.  # noqa: E501
        :rtype: list[Row]
        """
        return self._rows

    @rows.setter
    def rows(self, rows):
        """Sets the rows of this AudienceExportDetail.

        If data rows were requested to be returned then the set of rows containing data for the given columns selected by the audience queries  # noqa: E501

        :param rows: The rows of this AudienceExportDetail.  # noqa: E501
        :type: list[Row]
        """

        self._rows = rows

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AudienceExportDetail):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
