# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from apteco_api.api_client import ApiClient
from apteco_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class VisualisationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def visualisations_cancel_visualisation_render_data_refresh_job(self, data_view_name, visualisation_id, refresh_request_id, **kwargs):  # noqa: E501
        """Cancel a job refreshing the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_cancel_visualisation_render_data_refresh_job(data_view_name, visualisation_id, refresh_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation that the job is refreshing (required)
        :param int refresh_request_id: The id of the refresh job to cancel (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.visualisations_cancel_visualisation_render_data_refresh_job_with_http_info(data_view_name, visualisation_id, refresh_request_id, **kwargs)  # noqa: E501

    def visualisations_cancel_visualisation_render_data_refresh_job_with_http_info(self, data_view_name, visualisation_id, refresh_request_id, **kwargs):  # noqa: E501
        """Cancel a job refreshing the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_cancel_visualisation_render_data_refresh_job_with_http_info(data_view_name, visualisation_id, refresh_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation that the job is refreshing (required)
        :param int refresh_request_id: The id of the refresh job to cancel (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'visualisation_id', 'refresh_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method visualisations_cancel_visualisation_render_data_refresh_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `visualisations_cancel_visualisation_render_data_refresh_job`")  # noqa: E501
        # verify the required parameter 'visualisation_id' is set
        if ('visualisation_id' not in local_var_params or
                local_var_params['visualisation_id'] is None):
            raise ApiValueError("Missing the required parameter `visualisation_id` when calling `visualisations_cancel_visualisation_render_data_refresh_job`")  # noqa: E501
        # verify the required parameter 'refresh_request_id' is set
        if ('refresh_request_id' not in local_var_params or
                local_var_params['refresh_request_id'] is None):
            raise ApiValueError("Missing the required parameter `refresh_request_id` when calling `visualisations_cancel_visualisation_render_data_refresh_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'visualisation_id' in local_var_params:
            path_params['visualisationId'] = local_var_params['visualisation_id']  # noqa: E501
        if 'refresh_request_id' in local_var_params:
            path_params['refreshRequestId'] = local_var_params['refresh_request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/Visualisations/{visualisationId}/RenderData/RefreshJobs/{refreshRequestId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def visualisations_create_visualisation_render_data_refresh_job(self, data_view_name, visualisation_id, **kwargs):  # noqa: E501
        """Creates a job to refresh the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_create_visualisation_render_data_refresh_job(data_view_name, visualisation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation that the job is to refresh (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RenderDataRefreshJobDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.visualisations_create_visualisation_render_data_refresh_job_with_http_info(data_view_name, visualisation_id, **kwargs)  # noqa: E501

    def visualisations_create_visualisation_render_data_refresh_job_with_http_info(self, data_view_name, visualisation_id, **kwargs):  # noqa: E501
        """Creates a job to refresh the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_create_visualisation_render_data_refresh_job_with_http_info(data_view_name, visualisation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation that the job is to refresh (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RenderDataRefreshJobDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'visualisation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method visualisations_create_visualisation_render_data_refresh_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `visualisations_create_visualisation_render_data_refresh_job`")  # noqa: E501
        # verify the required parameter 'visualisation_id' is set
        if ('visualisation_id' not in local_var_params or
                local_var_params['visualisation_id'] is None):
            raise ApiValueError("Missing the required parameter `visualisation_id` when calling `visualisations_create_visualisation_render_data_refresh_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'visualisation_id' in local_var_params:
            path_params['visualisationId'] = local_var_params['visualisation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/Visualisations/{visualisationId}/RenderData/RefreshJobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RenderDataRefreshJobDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def visualisations_get_visualisation(self, data_view_name, visualisation_id, **kwargs):  # noqa: E501
        """Returns the details of a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_get_visualisation(data_view_name, visualisation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation to view (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VisualisationDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.visualisations_get_visualisation_with_http_info(data_view_name, visualisation_id, **kwargs)  # noqa: E501

    def visualisations_get_visualisation_with_http_info(self, data_view_name, visualisation_id, **kwargs):  # noqa: E501
        """Returns the details of a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_get_visualisation_with_http_info(data_view_name, visualisation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation to view (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VisualisationDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'visualisation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method visualisations_get_visualisation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `visualisations_get_visualisation`")  # noqa: E501
        # verify the required parameter 'visualisation_id' is set
        if ('visualisation_id' not in local_var_params or
                local_var_params['visualisation_id'] is None):
            raise ApiValueError("Missing the required parameter `visualisation_id` when calling `visualisations_get_visualisation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'visualisation_id' in local_var_params:
            path_params['visualisationId'] = local_var_params['visualisation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/Visualisations/{visualisationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VisualisationDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def visualisations_get_visualisation_render_data(self, data_view_name, visualisation_id, **kwargs):  # noqa: E501
        """Returns the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_get_visualisation_render_data(data_view_name, visualisation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation to generate the render data for (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AbstractRenderSpec
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.visualisations_get_visualisation_render_data_with_http_info(data_view_name, visualisation_id, **kwargs)  # noqa: E501

    def visualisations_get_visualisation_render_data_with_http_info(self, data_view_name, visualisation_id, **kwargs):  # noqa: E501
        """Returns the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_get_visualisation_render_data_with_http_info(data_view_name, visualisation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation to generate the render data for (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AbstractRenderSpec, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'visualisation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method visualisations_get_visualisation_render_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `visualisations_get_visualisation_render_data`")  # noqa: E501
        # verify the required parameter 'visualisation_id' is set
        if ('visualisation_id' not in local_var_params or
                local_var_params['visualisation_id'] is None):
            raise ApiValueError("Missing the required parameter `visualisation_id` when calling `visualisations_get_visualisation_render_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'visualisation_id' in local_var_params:
            path_params['visualisationId'] = local_var_params['visualisation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/Visualisations/{visualisationId}/RenderData', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AbstractRenderSpec',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def visualisations_get_visualisation_render_data_refresh_job(self, data_view_name, visualisation_id, refresh_request_id, **kwargs):  # noqa: E501
        """Returns the details of a job to refresh the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_get_visualisation_render_data_refresh_job(data_view_name, visualisation_id, refresh_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation that the job is refreshing (required)
        :param int refresh_request_id: The id of the refresh job to view (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RenderDataRefreshJobDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.visualisations_get_visualisation_render_data_refresh_job_with_http_info(data_view_name, visualisation_id, refresh_request_id, **kwargs)  # noqa: E501

    def visualisations_get_visualisation_render_data_refresh_job_with_http_info(self, data_view_name, visualisation_id, refresh_request_id, **kwargs):  # noqa: E501
        """Returns the details of a job to refresh the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_get_visualisation_render_data_refresh_job_with_http_info(data_view_name, visualisation_id, refresh_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation that the job is refreshing (required)
        :param int refresh_request_id: The id of the refresh job to view (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RenderDataRefreshJobDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'visualisation_id', 'refresh_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method visualisations_get_visualisation_render_data_refresh_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `visualisations_get_visualisation_render_data_refresh_job`")  # noqa: E501
        # verify the required parameter 'visualisation_id' is set
        if ('visualisation_id' not in local_var_params or
                local_var_params['visualisation_id'] is None):
            raise ApiValueError("Missing the required parameter `visualisation_id` when calling `visualisations_get_visualisation_render_data_refresh_job`")  # noqa: E501
        # verify the required parameter 'refresh_request_id' is set
        if ('refresh_request_id' not in local_var_params or
                local_var_params['refresh_request_id'] is None):
            raise ApiValueError("Missing the required parameter `refresh_request_id` when calling `visualisations_get_visualisation_render_data_refresh_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'visualisation_id' in local_var_params:
            path_params['visualisationId'] = local_var_params['visualisation_id']  # noqa: E501
        if 'refresh_request_id' in local_var_params:
            path_params['refreshRequestId'] = local_var_params['refresh_request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/Visualisations/{visualisationId}/RenderData/RefreshJobs/{refreshRequestId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RenderDataRefreshJobDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def visualisations_perform_visualisation_render_data_refresh_synchronously(self, data_view_name, visualisation_id, **kwargs):  # noqa: E501
        """Performs a synchronous refresh of the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_perform_visualisation_render_data_refresh_synchronously(data_view_name, visualisation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation to generate the render data for (required)
        :param int timeout_in_seconds: The number of seconds before the request will time out.  Leave unspecified to use the default value given in the visualisation service's configuration
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AbstractRenderSpec
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.visualisations_perform_visualisation_render_data_refresh_synchronously_with_http_info(data_view_name, visualisation_id, **kwargs)  # noqa: E501

    def visualisations_perform_visualisation_render_data_refresh_synchronously_with_http_info(self, data_view_name, visualisation_id, **kwargs):  # noqa: E501
        """Performs a synchronous refresh of the render data for a particular visualisation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.visualisations_perform_visualisation_render_data_refresh_synchronously_with_http_info(data_view_name, visualisation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str visualisation_id: The id of the visualisation to generate the render data for (required)
        :param int timeout_in_seconds: The number of seconds before the request will time out.  Leave unspecified to use the default value given in the visualisation service's configuration
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AbstractRenderSpec, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'visualisation_id', 'timeout_in_seconds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method visualisations_perform_visualisation_render_data_refresh_synchronously" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `visualisations_perform_visualisation_render_data_refresh_synchronously`")  # noqa: E501
        # verify the required parameter 'visualisation_id' is set
        if ('visualisation_id' not in local_var_params or
                local_var_params['visualisation_id'] is None):
            raise ApiValueError("Missing the required parameter `visualisation_id` when calling `visualisations_perform_visualisation_render_data_refresh_synchronously`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'visualisation_id' in local_var_params:
            path_params['visualisationId'] = local_var_params['visualisation_id']  # noqa: E501

        query_params = []
        if 'timeout_in_seconds' in local_var_params:
            query_params.append(('timeoutInSeconds', local_var_params['timeout_in_seconds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/Visualisations/{visualisationId}/RenderData/RefreshSync', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AbstractRenderSpec',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
