# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from apteco_api.api_client import ApiClient
from apteco_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class FastStatsSystemsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def fast_stats_systems_get_all_fast_stats_system_items(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Gets all FastStats systems items - variables, var codes, tables and folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_all_fast_stats_system_items(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Key, Type, TableName, VariableType
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Key, Type, TableName, VariableType
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResultsFastStatsSystemItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_all_fast_stats_system_items_with_http_info(data_view_name, system_name, **kwargs)  # noqa: E501

    def fast_stats_systems_get_all_fast_stats_system_items_with_http_info(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Gets all FastStats systems items - variables, var codes, tables and folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_all_fast_stats_system_items_with_http_info(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Key, Type, TableName, VariableType
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Key, Type, TableName, VariableType
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResultsFastStatsSystemItem, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name', 'filter', 'order_by', 'offset', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_all_fast_stats_system_items" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_all_fast_stats_system_items`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_get_all_fast_stats_system_items`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `fast_stats_systems_get_all_fast_stats_system_items`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `fast_stats_systems_get_all_fast_stats_system_items`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501

        query_params = []
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'order_by' in local_var_params:
            query_params.append(('orderBy', local_var_params['order_by']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}/All', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsFastStatsSystemItem',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_get_fast_stats_folder(self, data_view_name, system_name, path, **kwargs):  # noqa: E501
        """Gets the folder structure for the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_folder(data_view_name, system_name, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str path: The path to the folder that should be retrieved (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, Description, Type, TableName, VariableType
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, Description, Type, TableName, VariableType
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_fast_stats_folder_with_http_info(data_view_name, system_name, path, **kwargs)  # noqa: E501

    def fast_stats_systems_get_fast_stats_folder_with_http_info(self, data_view_name, system_name, path, **kwargs):  # noqa: E501
        """Gets the folder structure for the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_folder_with_http_info(data_view_name, system_name, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str path: The path to the folder that should be retrieved (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, Description, Type, TableName, VariableType
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, Description, Type, TableName, VariableType
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Folder, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name', 'path', 'filter', 'order_by', 'offset', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_fast_stats_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_fast_stats_folder`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_get_fast_stats_folder`")  # noqa: E501
        # verify the required parameter 'path' is set
        if ('path' not in local_var_params or
                local_var_params['path'] is None):
            raise ApiValueError("Missing the required parameter `path` when calling `fast_stats_systems_get_fast_stats_folder`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `fast_stats_systems_get_fast_stats_folder`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `fast_stats_systems_get_fast_stats_folder`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'order_by' in local_var_params:
            query_params.append(('orderBy', local_var_params['order_by']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}/Folders/{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Folder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_get_fast_stats_root_folder(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Gets the items in the root of the FastStats system folder structure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_root_folder(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, Description, Type, TableName, VariableType
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, Description, Type, TableName, VariableType
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResultsFolderStructureNode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_fast_stats_root_folder_with_http_info(data_view_name, system_name, **kwargs)  # noqa: E501

    def fast_stats_systems_get_fast_stats_root_folder_with_http_info(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Gets the items in the root of the FastStats system folder structure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_root_folder_with_http_info(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, Description, Type, TableName, VariableType
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, Description, Type, TableName, VariableType
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResultsFolderStructureNode, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name', 'filter', 'order_by', 'offset', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_fast_stats_root_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_fast_stats_root_folder`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_get_fast_stats_root_folder`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `fast_stats_systems_get_fast_stats_root_folder`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `fast_stats_systems_get_fast_stats_root_folder`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501

        query_params = []
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'order_by' in local_var_params:
            query_params.append(('orderBy', local_var_params['order_by']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}/Folders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsFolderStructureNode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_get_fast_stats_system(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Returns some top-level details for the specified FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_system(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to return details for (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FastStatsSystemDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_fast_stats_system_with_http_info(data_view_name, system_name, **kwargs)  # noqa: E501

    def fast_stats_systems_get_fast_stats_system_with_http_info(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Returns some top-level details for the specified FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_system_with_http_info(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to return details for (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FastStatsSystemDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_fast_stats_system" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_fast_stats_system`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_get_fast_stats_system`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FastStatsSystemDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_get_fast_stats_systems(self, data_view_name, **kwargs):  # noqa: E501
        """Returns the list of FastStats systems available  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_systems(data_view_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, Description, FastStatsBuildDate
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, Description, FastStatsBuildDate
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResultsFastStatsSystemSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_fast_stats_systems_with_http_info(data_view_name, **kwargs)  # noqa: E501

    def fast_stats_systems_get_fast_stats_systems_with_http_info(self, data_view_name, **kwargs):  # noqa: E501
        """Returns the list of FastStats systems available  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_systems_with_http_info(data_view_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, Description, FastStatsBuildDate
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, Description, FastStatsBuildDate
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResultsFastStatsSystemSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'filter', 'order_by', 'offset', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_fast_stats_systems" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_fast_stats_systems`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `fast_stats_systems_get_fast_stats_systems`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `fast_stats_systems_get_fast_stats_systems`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501

        query_params = []
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'order_by' in local_var_params:
            query_params.append(('orderBy', local_var_params['order_by']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsFastStatsSystemSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_get_fast_stats_table(self, data_view_name, system_name, table_name, **kwargs):  # noqa: E501
        """Gets the details for a particular table in the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_table(data_view_name, system_name, table_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str table_name: The name of the table to get the details for (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Table
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_fast_stats_table_with_http_info(data_view_name, system_name, table_name, **kwargs)  # noqa: E501

    def fast_stats_systems_get_fast_stats_table_with_http_info(self, data_view_name, system_name, table_name, **kwargs):  # noqa: E501
        """Gets the details for a particular table in the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_table_with_http_info(data_view_name, system_name, table_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str table_name: The name of the table to get the details for (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Table, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name', 'table_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_fast_stats_table" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_fast_stats_table`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_get_fast_stats_table`")  # noqa: E501
        # verify the required parameter 'table_name' is set
        if ('table_name' not in local_var_params or
                local_var_params['table_name'] is None):
            raise ApiValueError("Missing the required parameter `table_name` when calling `fast_stats_systems_get_fast_stats_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501
        if 'table_name' in local_var_params:
            path_params['tableName'] = local_var_params['table_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}/Tables/{tableName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Table',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_get_fast_stats_tables(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Gets all the tables present in the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_tables(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, SingularDisplayName, PluralDisplayName, TotalRecords
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, SingularDisplayName, PluralDisplayName, TotalRecords
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResultsTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_fast_stats_tables_with_http_info(data_view_name, system_name, **kwargs)  # noqa: E501

    def fast_stats_systems_get_fast_stats_tables_with_http_info(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Gets all the tables present in the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_tables_with_http_info(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, SingularDisplayName, PluralDisplayName, TotalRecords
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, SingularDisplayName, PluralDisplayName, TotalRecords
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResultsTable, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name', 'filter', 'order_by', 'offset', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_fast_stats_tables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_fast_stats_tables`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_get_fast_stats_tables`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `fast_stats_systems_get_fast_stats_tables`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `fast_stats_systems_get_fast_stats_tables`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501

        query_params = []
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'order_by' in local_var_params:
            query_params.append(('orderBy', local_var_params['order_by']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}/Tables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_get_fast_stats_variable(self, data_view_name, system_name, variable_name, **kwargs):  # noqa: E501
        """Gets the details for a particular variable in the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_variable(data_view_name, system_name, variable_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str variable_name: The name of the variable to get the details for (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_fast_stats_variable_with_http_info(data_view_name, system_name, variable_name, **kwargs)  # noqa: E501

    def fast_stats_systems_get_fast_stats_variable_with_http_info(self, data_view_name, system_name, variable_name, **kwargs):  # noqa: E501
        """Gets the details for a particular variable in the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_variable_with_http_info(data_view_name, system_name, variable_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str variable_name: The name of the variable to get the details for (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Variable, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name', 'variable_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_fast_stats_variable" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_fast_stats_variable`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_get_fast_stats_variable`")  # noqa: E501
        # verify the required parameter 'variable_name' is set
        if ('variable_name' not in local_var_params or
                local_var_params['variable_name'] is None):
            raise ApiValueError("Missing the required parameter `variable_name` when calling `fast_stats_systems_get_fast_stats_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501
        if 'variable_name' in local_var_params:
            path_params['variableName'] = local_var_params['variable_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}/Variables/{variableName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Variable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_get_fast_stats_variable_codes(self, data_view_name, system_name, variable_name, **kwargs):  # noqa: E501
        """Gets all the categories (var codes) for the specified variable in the FastStats system if it is a selector variable  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_variable_codes(data_view_name, system_name, variable_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str variable_name: The name of the variable to get the var codes for (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Code, Description, Count
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Code, Description, Count
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResultsVarCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_fast_stats_variable_codes_with_http_info(data_view_name, system_name, variable_name, **kwargs)  # noqa: E501

    def fast_stats_systems_get_fast_stats_variable_codes_with_http_info(self, data_view_name, system_name, variable_name, **kwargs):  # noqa: E501
        """Gets all the categories (var codes) for the specified variable in the FastStats system if it is a selector variable  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_variable_codes_with_http_info(data_view_name, system_name, variable_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str variable_name: The name of the variable to get the var codes for (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Code, Description, Count
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Code, Description, Count
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResultsVarCode, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name', 'variable_name', 'filter', 'order_by', 'offset', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_fast_stats_variable_codes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_fast_stats_variable_codes`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_get_fast_stats_variable_codes`")  # noqa: E501
        # verify the required parameter 'variable_name' is set
        if ('variable_name' not in local_var_params or
                local_var_params['variable_name'] is None):
            raise ApiValueError("Missing the required parameter `variable_name` when calling `fast_stats_systems_get_fast_stats_variable_codes`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `fast_stats_systems_get_fast_stats_variable_codes`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `fast_stats_systems_get_fast_stats_variable_codes`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501
        if 'variable_name' in local_var_params:
            path_params['variableName'] = local_var_params['variable_name']  # noqa: E501

        query_params = []
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'order_by' in local_var_params:
            query_params.append(('orderBy', local_var_params['order_by']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}/Variables/{variableName}/Codes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsVarCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_get_fast_stats_variables(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Gets all the variables present in the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_variables(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, Description, Type, SelectorType, TableName, NumberOfCodes, FolderName
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, Description, Type, SelectorType, TableName, NumberOfCodes, FolderName
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResultsVariable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_get_fast_stats_variables_with_http_info(data_view_name, system_name, **kwargs)  # noqa: E501

    def fast_stats_systems_get_fast_stats_variables_with_http_info(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Gets all the variables present in the FastStats system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_get_fast_stats_variables_with_http_info(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param str filter: Filter the list of items using a simple expression language.  The available list of fields are Name, Description, Type, SelectorType, TableName, NumberOfCodes, FolderName
        :param str order_by: Order the items by a given field (in ascending order unless the field is preceeded by a \"-\" character).  The available list of fields are Name, Description, Type, SelectorType, TableName, NumberOfCodes, FolderName
        :param int offset: The number of items to skip in the (potentially filtered) result set before returning subsequent items.
        :param int count: The maximum number of items to show from the (potentially filtered) result set.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResultsVariable, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name', 'filter', 'order_by', 'offset', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_get_fast_stats_variables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_get_fast_stats_variables`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_get_fast_stats_variables`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `fast_stats_systems_get_fast_stats_variables`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `fast_stats_systems_get_fast_stats_variables`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501

        query_params = []
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'order_by' in local_var_params:
            query_params.append(('orderBy', local_var_params['order_by']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'count' in local_var_params:
            query_params.append(('count', local_var_params['count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}/Variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsVariable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fast_stats_systems_refresh_system_information_sync(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Requires OrbitAdmin: An endpoint to request the API refresh any information it holds on the given FastStats system.  This endpoint will wait until the refresh has completed before returning.  # noqa: E501

        This endpoint is only available for users with the OrbitAdmin role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_refresh_system_information_sync(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_stats_systems_refresh_system_information_sync_with_http_info(data_view_name, system_name, **kwargs)  # noqa: E501

    def fast_stats_systems_refresh_system_information_sync_with_http_info(self, data_view_name, system_name, **kwargs):  # noqa: E501
        """Requires OrbitAdmin: An endpoint to request the API refresh any information it holds on the given FastStats system.  This endpoint will wait until the refresh has completed before returning.  # noqa: E501

        This endpoint is only available for users with the OrbitAdmin role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fast_stats_systems_refresh_system_information_sync_with_http_info(data_view_name, system_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_view_name: The name of the DataView to act on (required)
        :param str system_name: The name of the FastStats system to act on (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data_view_name', 'system_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fast_stats_systems_refresh_system_information_sync" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_view_name' is set
        if ('data_view_name' not in local_var_params or
                local_var_params['data_view_name'] is None):
            raise ApiValueError("Missing the required parameter `data_view_name` when calling `fast_stats_systems_refresh_system_information_sync`")  # noqa: E501
        # verify the required parameter 'system_name' is set
        if ('system_name' not in local_var_params or
                local_var_params['system_name'] is None):
            raise ApiValueError("Missing the required parameter `system_name` when calling `fast_stats_systems_refresh_system_information_sync`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_view_name' in local_var_params:
            path_params['dataViewName'] = local_var_params['data_view_name']  # noqa: E501
        if 'system_name' in local_var_params:
            path_params['systemName'] = local_var_params['system_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['faststats_auth']  # noqa: E501

        return self.api_client.call_api(
            '/{dataViewName}/FastStatsSystems/{systemName}/RefreshInformationSync', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
