"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const widget_1 = require("./widget");
/**
 * Display query results from Logs Insights
 */
class LogQueryWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
        if (props.logGroupNames.length === 0) {
            throw new Error('Specify at least one log group name.');
        }
        if (!!props.queryString === !!props.queryLines) {
            throw new Error('Specify exactly one of \'queryString\' and \'queryLines\'');
        }
    }
    toJson() {
        const sources = this.props.logGroupNames.map(l => `SOURCE '${l}'`).join(' | ');
        const query = this.props.queryLines
            ? this.props.queryLines.join('\n| ')
            : this.props.queryString;
        return [{
                type: 'log',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: 'table',
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.REGION,
                    query: `${sources} | ${query}`,
                },
            }];
    }
}
exports.LogQueryWidget = LogQueryWidget;
//# sourceMappingURL=data:application/json;base64,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