"""
Test the TkZero.Button module
"""

import base64
import unittest

from PIL.ImageTk import PhotoImage

from TkZero import Style
from TkZero.Button import Button, DisplayModes
from TkZero.MainWindow import MainWindow


class ButtonTest(unittest.TestCase):
    def test_no_params(self):
        root = MainWindow()
        root.update()
        with self.assertRaises(TypeError):
            Button()
        root.update()
        root.close()

    def test_good_params(self):
        root = MainWindow()
        root.update()
        image_data = base64.b64decode("""Qk02MAAAAAAAADYAAAAoAAAAQAAAAEAAAAABABgAAAAAAAAwAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AA//////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////r6+vMDAwAAAAAAAAAAAAGBgYaGhov7+///
        //////////////////////////////////////////////////////////////////////AAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
        //////////////////9/f3YGBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5+f//////////////////////////////////
        //////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
        //////////////////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5
        +f////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAA////////////////////////////////////////////////9/f3YGBgAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgcHBw5+fn////////z8/PcH
        BwICAgAAAAAAAAAAAAAAAAAAAAAAAASEhI9/f3//////////////////////////////////////
        //AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
        //////9/f3SEhIAAAAAAAAAAAAAAAAAAAAf39///////////////////////////////////////
        //////////////////////////////////////7+/vf39/EBAQAAAAAAAAAAAASEhI9/f3//////
        //////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
        //////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAICAgl5eX//////////////
        //////////////////////////////////////////////////////////////////////////7+
        /vcHBwAAAAAAAAAAAASEhI9/f3////////////////////////////////AAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAA////////////////////////////////////9/f3SEhIAAAAAAAAAAAAf3
        9///////////////////////////////////////////////////////////////////////////
        //////////////////////////////////f39/AAAAAAAAAAAASEhI9/f3//////////////////
        //////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
        //////YGBgAAAAAAAAAAAAf39///////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////f39/AAAAAA
        AAAAAASEhI9/f3////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
        //////////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////f39/AAAAAAAAAAAAWFhY////////////////////////AAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////////9/f3QEBAAAAAAAAAUFBQ//
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////f39/AAAAAAAAAAAA//////
        //////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
        //////YGBgAAAAAAAAAAAAz8/P//////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////GBgYAAAAAAAAr6+v////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAA////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////cHBwAAAAAAAAMDAw////////////////////AA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////WFhYAAAAAAAAUFBQ//
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////5+fnAAAAAA
        AAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
        //////9/f3CAgIAAAAAAAAz8/P//////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////AAAAAAAAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAA////////////////////aGhoAAAAAAAACAgI//////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////AAAAAAAAAAAA//////////////
        //////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////7+/vCAgIAAAAAAAAh4
        eH//////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //GBgYAAAAAAAAr6+v////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
        //////////n5+fAAAAAAAAQEBA//////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////cHBwAAAAAAAAMDAw////////////////AAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAA////////////9/f3ODg4AAAAAAAAl5eX//////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////5+fnAAAAAAAAAAAA//
        //////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////cHBwAAAAAAAAAA
        AA5+fn//////////////////////////////////////////////////////////////////////
        //////////////////h4eHAAAAaGho//////////////////////////////////////////////
        //////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AA////////////CAgIAAAAAAAAh4eH////////////////////h4eHAAAAaGho//////////////
        //////////////////////////////////////////////CAgIAAAAAAAA//////////////////
        //////////////////////////////////////////AAAAAAAAAAAA////////////////AAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////////////
        //CAgIAAAAAAAAaGho////////////////////////////////////////////////////////AA
        AAAAAAAAAAaGho////////////////////////////////////////////////////////AAAAAA
        AAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAA
        AAAAAA////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////
        //////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////////
        //////////////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////t7e3AAAAAAAAAAAA//
        //////////////////////////////////////////////////////t7e3AAAAAAAAAAAA//////
        //////////////////////////////////////////////////GBgYAAAACAgI//////////////
        //AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////
        //////////////AAAAAAAAAAAA//////////////////////////////////////////////////
        //////////GBgYAAAAAAAAr6+v//////////////////////////////////////////////////
        //t7e3QEBAn5+f////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
        //AAAAAAAAAAAA////////////////////////////AAAAAAAAAAAA//////////////////////
        //////////////////////////////////////cHBwAAAAAAAAMDAw//////////////////////
        //////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////////AAAAAA
        AAAAAA////////////////////////////////////////////////////////////5+fnAAAAAA
        AAAAAA//////////////////////////////////////////////////////////////////////
        //////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////GBgYAAAACAgI//////
        //////////////////////AAAAAAAAAAAA//////////////////////////////////////////
        //////////////////////AAAAAAAAAAAA//////////////////////////////////////////
        //////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
        //////////t7e3QEBAn5+f////////////////////////////AAAAAAAAAAAA//////////////
        //////////////////////////////////////////////////AAAAAAAAAAAA//////////////
        //////////////////////////////////////////////////////////////////AAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
        //AAAAAAAAAAAA//////////////////////////////////////////////////////////////
        //AAAAAAAAAAAA//////////////////////////////////////////////////////////////
        //////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
        //////////////////////////////AAAAAAAAAAAA//////////////////////////////////
        //////////////////////////////AAAAAAAAAAAA//////////////////////////////////
        //////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAA////////////////////////////////////////////////////AAAAAAAAAAAA//////
        //////////////////////////////////////////////////////////AAAAAAAAAAAA//////
        //////////////////////////////////////////////////////////////////////////AA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
        //////////AAAAAAAAAAAA//////////////////////////////////////////////////////
        //////////AAAAAAAAAAAA//////////////////////////////////////////////////////
        //////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
        //////////////////////////////////////GBgYAAAAAAAAr6+v//////////////////////
        //////////////////////////////////////AAAAAAAAAAAA//////////////////////////
        //////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAA////////////////////////////////////////////////////cHBwAAAAAA
        AAMDAw////////////////////////////////////////////////////////////AAAAAAAAAA
        AA//////////////////////////////////////////////////////////////////////////
        //////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////
        //////////////////5+fnAAAAAAAAAAAA//////////////////////////////////////////
        //////////////////AAAAAAAAAAAA//////////////////////////////////////////////
        //////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
        //////////////////////////////////////////////////AAAAAAAAAAAA//////////////
        //////////////////////////////////////////////AAAAAAAAAAAA//////////////////
        //////////////////////////////////////////////////////////////AAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
        //AAAAAAAAAAAA////////////////////////////////////////////////////////////AA
        AAAAAAAAAA//////////////////////////////////////////////////////////////////
        //////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
        //////////////////////////////AAAAAAAAAAAA//////////////////////////////////
        //////////////////////////AAAAAAAAAAAA//////////////////////////////////////
        //////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AA////////////////////////////////////////////////////////AAAAAAAAAAAA//////
        //////////////////////////////////////////////////////AAAAAAAAAAAA//////////
        //////////////////////////////////////////////////////////////////////AAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
        //////////AAAAAAAAAAAA//////////////////////////////////////////////////////
        //////AAAAAAAAAAAA//////////////////////////////////////////////////////////
        //////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
        //////////////////////////////////////AAAAAAAAAAAA//////////////////////////
        //////////////////////////////////AAAAAAAAAAAA//////////////////////////////
        //////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAA////////////////////////////////////////////////////////AAAAAAAAAA
        AA////////////////////////////////////////////////////////////AAAAAAAAAAAA//
        ////////////////////////////////////////////////////////////////////////////
        //AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
        //////////////////AAAAAAAAAAAA//////////////////////////////////////////////
        //////////////AAAAAAAAAAAA//////////////////////////////////////////////////
        //////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
        //////////////////////////////////////////////AAAAAAAAAAAA//////////////////
        //////////////////////////////////////z8/PAAAAAAAAAAAA//////////////////////
        //////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAA////////////////////////////////////////////////////////AA
        AAAAAAAAAA////////////////////////////////////////////////////////WFhYAAAAAA
        AAUFBQ//////////////////////////////////////////////////////////////////////
        //////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
        //////////////////////////AAAAAAAAAAAA//////////////////////////////////////
        //////////////////CAgIAAAAAAAAz8/P//////////////////////////////////////////
        //////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
        //////////////////////////////////////////////////////AAAAAAAAAAAA//////////
        //////////////////////////////////////////////AAAAAAAAAAAA//////////////////
        //////////////////////////////////////////////////////////////////AAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
        //////AAAAAAAAAAAA////////////////////////////////////////////////////////AA
        AAAAAAAAAA//////////////////////////////////////////////////////////////////
        //////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
        //////////////////////////////////GBgYAAAACAgI//////////////////////////////
        //////////////////////////AAAAAAAAAAAA//////////////////////////////////////
        //////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAA////////////////////////////////////////////////////////t7e3QEBAn5+f//
        //////////////////////////////////////////////////////GBgYAAAACAgI//////////
        //////////////////////////////////////////////////////////////////////////AA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////t7e3QEBAn5+f//////////////////////////////////////////////////////////
        //////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
        ////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAA//////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA""")
        Button(root, text="hi", image=PhotoImage(data=image_data)).grid(row=0, column=0)
        root.update()
        root.close()

    def test_text(self):
        root = MainWindow()
        root.update()
        b = Button(root, text="Foobar")
        b.grid(row=0, column=0)
        b.text = "Test"
        root.update()
        self.assertEqual(b.text, "Test")
        root.close()

    def test_image(self):
        root = MainWindow()
        root.update()
        b = Button(root)
        b.grid(row=0, column=0)
        self.assertTrue(b.image is None)
        image_data = base64.b64decode("""Qk02MAAAAAAAADYAAAAoAAAAQAAAAEAAAAABABgAAAAAAAAwAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////r6+vMDAwAAAAAAAAAAAAGBgYaGhov7+///
//////////////////////////////////////////////////////////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
//////////////////9/f3YGBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5+f//////////////////////////////////
//////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
//////////////////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5
+f////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////////////////////////////////////////9/f3YGBgAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgcHBw5+fn////////z8/PcH
BwICAgAAAAAAAAAAAAAAAAAAAAAAAASEhI9/f3//////////////////////////////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
//////9/f3SEhIAAAAAAAAAAAAAAAAAAAAf39///////////////////////////////////////
//////////////////////////////////////7+/vf39/EBAQAAAAAAAAAAAASEhI9/f3//////
//////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAICAgl5eX//////////////
//////////////////////////////////////////////////////////////////////////7+
/vcHBwAAAAAAAAAAAASEhI9/f3////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////////////////////////////9/f3SEhIAAAAAAAAAAAAf3
9///////////////////////////////////////////////////////////////////////////
//////////////////////////////////f39/AAAAAAAAAAAASEhI9/f3//////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
//////YGBgAAAAAAAAAAAAf39///////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////f39/AAAAAA
AAAAAASEhI9/f3////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////f39/AAAAAAAAAAAAWFhY////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////////9/f3QEBAAAAAAAAAUFBQ//
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////f39/AAAAAAAAAAAA//////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////YGBgAAAAAAAAAAAAz8/P//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////GBgYAAAAAAAAr6+v////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////cHBwAAAAAAAAMDAw////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////WFhYAAAAAAAAUFBQ//
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////5+fnAAAAAA
AAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
//////9/f3CAgIAAAAAAAAz8/P//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////AAAAAAAAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA////////////////////aGhoAAAAAAAACAgI//////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////7+/vCAgIAAAAAAAAh4
eH//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//GBgYAAAAAAAAr6+v////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
//////////n5+fAAAAAAAAQEBA//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////cHBwAAAAAAAAMDAw////////////////AAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA////////////9/f3ODg4AAAAAAAAl5eX//////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////5+fnAAAAAAAAAAAA//
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////cHBwAAAAAAAAAA
AA5+fn//////////////////////////////////////////////////////////////////////
//////////////////h4eHAAAAaGho//////////////////////////////////////////////
//////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA////////////CAgIAAAAAAAAh4eH////////////////////h4eHAAAAaGho//////////////
//////////////////////////////////////////////CAgIAAAAAAAA//////////////////
//////////////////////////////////////////AAAAAAAAAAAA////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////////////
//CAgIAAAAAAAAaGho////////////////////////////////////////////////////////AA
AAAAAAAAAAaGho////////////////////////////////////////////////////////AAAAAA
AAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAA
AAAAAA////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////
//////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////////
//////////////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////t7e3AAAAAAAAAAAA//
//////////////////////////////////////////////////////t7e3AAAAAAAAAAAA//////
//////////////////////////////////////////////////GBgYAAAACAgI//////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////
//////////////AAAAAAAAAAAA//////////////////////////////////////////////////
//////////GBgYAAAAAAAAr6+v//////////////////////////////////////////////////
//t7e3QEBAn5+f////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//AAAAAAAAAAAA////////////////////////////AAAAAAAAAAAA//////////////////////
//////////////////////////////////////cHBwAAAAAAAAMDAw//////////////////////
//////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////////AAAAAA
AAAAAA////////////////////////////////////////////////////////////5+fnAAAAAA
AAAAAA//////////////////////////////////////////////////////////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////GBgYAAAACAgI//////
//////////////////////AAAAAAAAAAAA//////////////////////////////////////////
//////////////////////AAAAAAAAAAAA//////////////////////////////////////////
//////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////t7e3QEBAn5+f////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
//AAAAAAAAAAAA//////////////////////////////////////////////////////////////
//AAAAAAAAAAAA//////////////////////////////////////////////////////////////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
//////////////////////////////////////GBgYAAAAAAAAr6+v//////////////////////
//////////////////////////////////////AAAAAAAAAAAA//////////////////////////
//////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA////////////////////////////////////////////////////cHBwAAAAAA
AAMDAw////////////////////////////////////////////////////////////AAAAAAAAAA
AA//////////////////////////////////////////////////////////////////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////
//////////////////5+fnAAAAAAAAAAAA//////////////////////////////////////////
//////////////////AAAAAAAAAAAA//////////////////////////////////////////////
//////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////////////////////////////AAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
//AAAAAAAAAAAA////////////////////////////////////////////////////////////AA
AAAAAAAAAA//////////////////////////////////////////////////////////////////
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA////////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////AAAAAAAAAAAA//////////
//////////////////////////////////////////////////////////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////AAAAAAAAAAAA//////////////////////////////////////////////////////////
//////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
//////////////////////////////////////AAAAAAAAAAAA//////////////////////////
//////////////////////////////////AAAAAAAAAAAA//////////////////////////////
//////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////////////////////////////////////////////////AAAAAAAAAA
AA////////////////////////////////////////////////////////////AAAAAAAAAAAA//
////////////////////////////////////////////////////////////////////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
//////////////////AAAAAAAAAAAA//////////////////////////////////////////////
//////////////AAAAAAAAAAAA//////////////////////////////////////////////////
//////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////z8/PAAAAAAAAAAAA//////////////////////
//////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////////////////////////////////////////////////AA
AAAAAAAAAA////////////////////////////////////////////////////////WFhYAAAAAA
AAUFBQ//////////////////////////////////////////////////////////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////CAgIAAAAAAAAz8/P//////////////////////////////////////////
//////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////////////////////////////////////////////////AAAAAAAAAAAA//////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////////////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
//////AAAAAAAAAAAA////////////////////////////////////////////////////////AA
AAAAAAAAAA//////////////////////////////////////////////////////////////////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////////////////////////////////GBgYAAAACAgI//////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////////////////////////////////////t7e3QEBAn5+f//
//////////////////////////////////////////////////////GBgYAAAACAgI//////////
//////////////////////////////////////////////////////////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////t7e3QEBAn5+f//////////////////////////////////////////////////////////
//////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA//////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA""")
        b.image = PhotoImage(data=image_data)
        root.update()
        self.assertTrue(b.image is not None)
        root.close()

    def test_text_and_image(self):
        root = MainWindow()
        root.update()
        b = Button(root, text="Click for smiles!")
        b.grid(row=0, column=0)
        root.update()
        self.assertEqual(b.text, "Click for smiles!")
        self.assertTrue(b.image is None)
        image_data = base64.b64decode("""Qk02MAAAAAAAADYAAAAoAAAAQAAAAEAAAAABABgAAAAAAAAwAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////r6+vMDAwAAAAAAAAAAAAGBgYaGhov7+///
//////////////////////////////////////////////////////////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
//////////////////9/f3YGBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5+f//////////////////////////////////
//////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
//////////////////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5
+f////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////////////////////////////////////////9/f3YGBgAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgcHBw5+fn////////z8/PcH
BwICAgAAAAAAAAAAAAAAAAAAAAAAAASEhI9/f3//////////////////////////////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
//////9/f3SEhIAAAAAAAAAAAAAAAAAAAAf39///////////////////////////////////////
//////////////////////////////////////7+/vf39/EBAQAAAAAAAAAAAASEhI9/f3//////
//////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAICAgl5eX//////////////
//////////////////////////////////////////////////////////////////////////7+
/vcHBwAAAAAAAAAAAASEhI9/f3////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////////////////////////////9/f3SEhIAAAAAAAAAAAAf3
9///////////////////////////////////////////////////////////////////////////
//////////////////////////////////f39/AAAAAAAAAAAASEhI9/f3//////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
//////YGBgAAAAAAAAAAAAf39///////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////f39/AAAAAA
AAAAAASEhI9/f3////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////f39/AAAAAAAAAAAAWFhY////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////////9/f3QEBAAAAAAAAAUFBQ//
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////f39/AAAAAAAAAAAA//////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////YGBgAAAAAAAAAAAAz8/P//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////GBgYAAAAAAAAr6+v////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////cHBwAAAAAAAAMDAw////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////WFhYAAAAAAAAUFBQ//
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////5+fnAAAAAA
AAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
//////9/f3CAgIAAAAAAAAz8/P//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////AAAAAAAAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA////////////////////aGhoAAAAAAAACAgI//////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////7+/vCAgIAAAAAAAAh4
eH//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//GBgYAAAAAAAAr6+v////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
//////////n5+fAAAAAAAAQEBA//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////cHBwAAAAAAAAMDAw////////////////AAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA////////////9/f3ODg4AAAAAAAAl5eX//////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////5+fnAAAAAAAAAAAA//
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////cHBwAAAAAAAAAA
AA5+fn//////////////////////////////////////////////////////////////////////
//////////////////h4eHAAAAaGho//////////////////////////////////////////////
//////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA////////////CAgIAAAAAAAAh4eH////////////////////h4eHAAAAaGho//////////////
//////////////////////////////////////////////CAgIAAAAAAAA//////////////////
//////////////////////////////////////////AAAAAAAAAAAA////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////////////
//CAgIAAAAAAAAaGho////////////////////////////////////////////////////////AA
AAAAAAAAAAaGho////////////////////////////////////////////////////////AAAAAA
AAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAA
AAAAAA////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////
//////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////////
//////////////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////t7e3AAAAAAAAAAAA//
//////////////////////////////////////////////////////t7e3AAAAAAAAAAAA//////
//////////////////////////////////////////////////GBgYAAAACAgI//////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////
//////////////AAAAAAAAAAAA//////////////////////////////////////////////////
//////////GBgYAAAAAAAAr6+v//////////////////////////////////////////////////
//t7e3QEBAn5+f////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//AAAAAAAAAAAA////////////////////////////AAAAAAAAAAAA//////////////////////
//////////////////////////////////////cHBwAAAAAAAAMDAw//////////////////////
//////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////////AAAAAA
AAAAAA////////////////////////////////////////////////////////////5+fnAAAAAA
AAAAAA//////////////////////////////////////////////////////////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////GBgYAAAACAgI//////
//////////////////////AAAAAAAAAAAA//////////////////////////////////////////
//////////////////////AAAAAAAAAAAA//////////////////////////////////////////
//////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////t7e3QEBAn5+f////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
//AAAAAAAAAAAA//////////////////////////////////////////////////////////////
//AAAAAAAAAAAA//////////////////////////////////////////////////////////////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
//////////////////////////////////////GBgYAAAAAAAAr6+v//////////////////////
//////////////////////////////////////AAAAAAAAAAAA//////////////////////////
//////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA////////////////////////////////////////////////////cHBwAAAAAA
AAMDAw////////////////////////////////////////////////////////////AAAAAAAAAA
AA//////////////////////////////////////////////////////////////////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////
//////////////////5+fnAAAAAAAAAAAA//////////////////////////////////////////
//////////////////AAAAAAAAAAAA//////////////////////////////////////////////
//////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////////////////////////////AAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
//AAAAAAAAAAAA////////////////////////////////////////////////////////////AA
AAAAAAAAAA//////////////////////////////////////////////////////////////////
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA////////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////AAAAAAAAAAAA//////////
//////////////////////////////////////////////////////////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////AAAAAAAAAAAA//////////////////////////////////////////////////////////
//////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
//////////////////////////////////////AAAAAAAAAAAA//////////////////////////
//////////////////////////////////AAAAAAAAAAAA//////////////////////////////
//////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////////////////////////////////////////////////AAAAAAAAAA
AA////////////////////////////////////////////////////////////AAAAAAAAAAAA//
////////////////////////////////////////////////////////////////////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
//////////////////AAAAAAAAAAAA//////////////////////////////////////////////
//////////////AAAAAAAAAAAA//////////////////////////////////////////////////
//////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////z8/PAAAAAAAAAAAA//////////////////////
//////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////////////////////////////////////////////////AA
AAAAAAAAAA////////////////////////////////////////////////////////WFhYAAAAAA
AAUFBQ//////////////////////////////////////////////////////////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////CAgIAAAAAAAAz8/P//////////////////////////////////////////
//////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////////////////////////////////////////////////AAAAAAAAAAAA//////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////////////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
//////AAAAAAAAAAAA////////////////////////////////////////////////////////AA
AAAAAAAAAA//////////////////////////////////////////////////////////////////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////////////////////////////////GBgYAAAACAgI//////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////////////////////////////////////t7e3QEBAn5+f//
//////////////////////////////////////////////////////GBgYAAAACAgI//////////
//////////////////////////////////////////////////////////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////t7e3QEBAn5+f//////////////////////////////////////////////////////////
//////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA//////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA""")
        b.image = PhotoImage(data=image_data)
        root.update()
        self.assertTrue(b.image is not None)
        root.update()
        self.assertEqual(b.display_mode, DisplayModes.Original)
        b.display_mode = DisplayModes.ImageTopText
        root.update()
        self.assertEqual(b.display_mode, DisplayModes.ImageTopText)
        root.close()

    def test_enabled(self):
        root = MainWindow()
        root.update()
        b = Button(root)
        b.grid(row=0, column=0)
        root.update()
        self.assertTrue(b.enabled)
        b.enabled = False
        self.assertFalse(b.enabled)
        root.close()

    def test_execution(self):
        root = MainWindow()
        root.update()
        b = Button(root, command=lambda: None)
        b.grid(row=0, column=0)
        root.update()
        root.close()

    def test_style(self):
        root = MainWindow()
        root.update()
        b = Button(root)
        b.grid(row=0, column=0)
        Style.define_style(Style.WidgetStyleRoots.Button, "Test", background="red")
        b.apply_style("Test")
        self.assertEqual(b.cget("style"), "Test.TButton")
        root.update()
        root.close()


if __name__ == '__main__':
    unittest.main()
