# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/12_utils_code.ipynb (unless otherwise specified).

__all__ = ['screen_size', 'product_dicts']

# Cell
import csv
import requests
import xml.etree.ElementTree as ET
import urllib3
from tqdm import tqdm
import glob
import pandas as pd
import pandas as pd
import math

# Cell
def screen_size(aspect_ration, inch):
    if aspect_ration != '':
        size_cm = float(inch)*2.54
        x = int(str(aspect_ration).split('x')[0])
        y = int(str(aspect_ration).split('x')[1])
        value = math.sqrt((size_cm*size_cm)/ (x*x + y*y))
        screen_height = x*value*10
        screen_width = y*value*10
        return round(screen_height), round(screen_width)

# Cell
product_dicts = []

for i in tqdm(glob.glob("/Users/sachinchandra/Documents/work/notebooks/tv_xmls/*")):

    try:
        product_dict = {"file_name": "NA",
                "Brand" : "NA",
                "Sub Brand" : "NA",
                "Picture" : "NA",
                "Release Date": "NA",
                "Screen Size": "NA",
                "Screen Size Text" : "NA",
                "Width" : "NA",
                "Width Text" : "NA",
                "Height" : "NA",
                "Height Text": "NA",
                "Depth" : "NA",
                "Depth Text" :"NA",
                "isSmartTV": "NA",
                "Display Technology": "NA",
                "HD Type": "NA",
                "HDMI Ports": "NA",
                "USB2.0 Ports": "NA",
                "Resolution" : "NA",
                "Has-Wifi" : "NA"
               }
        product_dict["file_name"] = i
        with open(i) as f:
            tv = ET.parse(f)
        root = tv.getroot()
        found_feature_list = []
        for child in root.getchildren():
            product_dict["Brand"] = child.attrib["Title"].split(' ')[0]
            product_dict["Sub Brand"]= child.attrib["Title"]
            product_dict["Picture"] = child.attrib["HighPic"]
            product_dict["Release Date"] = child.attrib["ReleaseDate"]

        for item in root.findall('./Product/ProductFeature'):
            if item.attrib["CategoryFeature_ID"] == "34548":
                product_dict["Screen Size"] = item.attrib["Value"]
                product_dict["Screen Size Text"] = item.attrib["Presentation_Value"]


            if item.attrib["CategoryFeature_ID"] == "34573":
                product_dict["Width"] = item.attrib["Value"]
                product_dict["Width Text"] = item.attrib["Presentation_Value"]


            if item.attrib["CategoryFeature_ID"] == "34575":
                product_dict["Height"] = item.attrib["Value"]
                product_dict["Height Text"] = item.attrib["Presentation_Value"]


            if item.attrib["CategoryFeature_ID"] == "34574":
                product_dict["Depth"] = item.attrib["Value"]
                product_dict["Depth Text"] = item.attrib["Presentation_Value"]


            if item.attrib["CategoryFeature_ID"] == "172209":
                product_dict["Display Technology"] = item.attrib["Value"]


            if item.attrib["CategoryFeature_ID"] == "54033":
                product_dict["isSmartTV"] = item.attrib["Value"]

            if item.attrib["CategoryFeature_ID"] == "46195":
                product_dict["Has-Wifi"] = item.attrib["Value"]

            if item.attrib["CategoryFeature_ID"] == "34560":
                product_dict["USB2.0 Ports"] = item.attrib["Value"]

            if item.attrib["CategoryFeature_ID"] == "34559":
                product_dict["HDMI Ports"] = item.attrib["Value"]

            if item.attrib["CategoryFeature_ID"] == "74100":
                product_dict["HD Type"] = item.attrib["Value"]

            if item.attrib["CategoryFeature_ID"] == "34551":
                product_dict["Resolution"] = item.attrib["Value"]

        product_dicts.append(product_dict)
    except:
        pass


# Cell
import pandas as pd
import requests
import shutil
import gdown


# Cell
for i,row in df.iterrows():
    if pd.notna(row[3]):
        print(row[3])
        file_name = '{}/{}_{}_{}_{}_{}.jpg'.format("/Users/sachinchandra/Downloads/collected_sticky_note_set11", i+300, "left", size, note_dim, model_num)

        # for gdown to download, the url needs to have url component open as uc. Check the urls to see this. Open refers to view image
        url = row[3].replace("open", "uc")
        gdown.download(url, file_name, quiet=False)