import os
from setuptools import setup, find_packages
import subprocess

__author__ = 'Josue Kouka'
__email__ = 'josuebrunel@gmail.com'

version_py = os.path.join(os.path.dirname(__file__), 'version.py')

try:
    version_git = subprocess.check_output(["git", "describe"]).rstrip().decode()
except Exception:
    with open(version_py, 'r') as fh:
        version_git = open(version_py).read().strip().split('=')[-1].replace('"', '')

version_msg = "# Do not edit this file, pipeline versioning is governed by git tags"

with open(version_py, 'w') as fh:
    fh.write('{} {} __version__={}'.format(version_msg, os.linesep, version_git))


def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()


requirements = read('requirements.txt').splitlines()

setup(
    name="pysxm",
    version=version_git,
    description="Simple and extensible xml python marshaller",
    long_description=read("README.rst"),
    author=__author__,
    author_email=__email__,
    url="https://github.com/josuebrunel/pysxm",
    download_url="https://github.com/josuebrunel/pysxm/archive/{0}.tar.gz".format(version_git),
    keywords=['xml', 'data binding', 'data', 'binding', 'data-binging', 'marshaller'],
    packages=find_packages(),
    classifiers=[
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.5',
        'Development Status :: 5 - Production/Stable',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License'
    ],
    platforms=['Any'],
    license='MIT',
    install_requires=requirements
)
