/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.router;

import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.arq.querybuilder.WhereBuilder;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import uk.ac.cam.cares.jps.base.cache.LRUCache;
import uk.ac.cam.cares.jps.base.config.KeyValueMap;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;
import uk.ac.cam.cares.jps.base.router.AbstractCachedRouter;

public class AgentRouter
extends AbstractCachedRouter<String, String> {
    private static final Logger LOGGER = LogManager.getLogger(AgentRouter.class);
    private static final int CACHE_SIZE = Integer.parseInt(KeyValueMap.getInstance().get("agentrouter.cache.size"));
    private String agentRouterEndpoint = KeyValueMap.getInstance().get("url.agentrouter.endpoint");
    static final Var VAR_S = Var.alloc("s");
    static final String STR_O = "o";
    static final Var VAR_O = Var.alloc("o");
    static final String MSM_HAS_HTTP_URL = "<http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#hasHttpUrl>";
    static final String MSM_OPERATION = "<http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#Operation>";
    static final String RDF_TYPE = "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>";
    private static AgentRouter instance = null;

    private AgentRouter() {
        super(new LRUCache(CACHE_SIZE));
        LOGGER.info("Agent router instantiated with router endpoint: " + this.agentRouterEndpoint);
    }

    public static synchronized AgentRouter getInstance() {
        if (instance == null) {
            instance = new AgentRouter();
        }
        return instance;
    }

    public void setRouterEndpoint(String endpoint) {
        this.agentRouterEndpoint = endpoint;
        LOGGER.info("Agent router endpoint set to: " + this.agentRouterEndpoint);
    }

    public void resetRouterEndpoint() {
        this.setRouterEndpoint(KeyValueMap.getInstance().get("url.agentrouter.endpoint"));
    }

    @Override
    public String get(String agentID) {
        String url = (String)super.get(agentID);
        if (url == null) {
            throw new JPSRuntimeException("AgentRouter: url not found for " + agentID);
        }
        return url;
    }

    @Override
    public String getFromStore(String agentID, StoreClientInterface storeClient) {
        LOGGER.debug("Get URL from triple store. AgentID=" + agentID);
        String query = this.getQuery(agentID);
        try {
            JSONArray result = storeClient.executeQuery(query);
            if (!result.isEmpty()) {
                String firstURL = result.getJSONObject(0).getString(STR_O);
                LOGGER.debug("URL=" + firstURL);
                return firstURL;
            }
            LOGGER.info("URL not found for AgentID=" + agentID);
            return null;
        }
        catch (Exception e) {
            throw new JPSRuntimeException("AgentRouter: failed to query store.", e);
        }
    }

    @Override
    public StoreClientInterface getStoreClient() {
        return new RemoteStoreClient(this.agentRouterEndpoint);
    }

    private String getQuery(String agentName) {
        ExprFactory exprFactory = new ExprFactory();
        ExprVar exprS = new ExprVar(VAR_S);
        Expr exprMatch = exprFactory.asExpr(agentName);
        E_StrContains SContains = exprFactory.contains(exprFactory.str(exprS), exprMatch);
        WhereBuilder where = new WhereBuilder().addWhere(VAR_S, RDF_TYPE, MSM_OPERATION).addWhere(VAR_S, MSM_HAS_HTTP_URL, VAR_O).addFilter(SContains);
        SelectBuilder select = (SelectBuilder)new SelectBuilder().addVar(VAR_O).addWhere(where);
        return select.buildString();
    }
}

