/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.router;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.interfaces.CacheInterface;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public abstract class AbstractCachedRouter<K, V> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractCachedRouter.class);
    private CacheInterface<K, V> cache;

    public AbstractCachedRouter(CacheInterface<K, V> cache) {
        this.cache = cache;
    }

    public synchronized V get(K key) {
        V value;
        if (!this.cache.contains(key)) {
            LOGGER.info("Key= " + key.toString() + " not in cache. Get from store.");
            StoreClientInterface storeClient = this.getStoreClient();
            value = this.getFromStore(key, storeClient);
            if (this.validate(value)) {
                this.cache.put(key, value);
            }
        } else {
            LOGGER.info("Key= " + key.toString() + " found in cache.");
            value = this.cache.get(key);
        }
        LOGGER.info("Key= " + key.toString() + ", Value=" + String.valueOf(value));
        return value;
    }

    protected boolean validate(V value) {
        if (value == null) {
            LOGGER.debug("Invalid value");
            return false;
        }
        return true;
    }

    public abstract StoreClientInterface getStoreClient();

    public abstract V getFromStore(K var1, StoreClientInterface var2);
}

