/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.config.KeyValueMap;
import uk.ac.cam.cares.jps.base.discovery.MediaType;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.scenario.JPSContext;

public class AccessAgentCaller {
    private static final Logger LOGGER = LogManager.getLogger(AccessAgentCaller.class);

    public static String put(String datasetUrl, String targetUrl, String content, String contentType) {
        LOGGER.info("put for datasetUrl=" + datasetUrl + ", targetUrl=" + targetUrl + ", scenarioUrl=" + JPSContext.getScenarioUrl());
        Object[] a = AccessAgentCaller.createRequestUrl(datasetUrl, targetUrl);
        if (contentType == null) {
            contentType = MediaType.APPLICATION_RDF_XML.type;
        }
        String requestUrl = (String)a[0];
        JSONObject joparams = (JSONObject)a[1];
        return Http.execute(Http.put(requestUrl, content, contentType, null, joparams));
    }

    public static String get(String datasetUrl, String targetUrl, String accept) {
        LOGGER.info("get for datasetUrl=" + datasetUrl + ", targetUrl=" + targetUrl + ", scenarioUrl=" + JPSContext.getScenarioUrl());
        Object[] a = AccessAgentCaller.createRequestUrl(datasetUrl, targetUrl);
        String requestUrl = (String)a[0];
        JSONObject joparams = (JSONObject)a[1];
        return Http.execute(Http.get(requestUrl, accept, joparams));
    }

    public static JSONArray queryStore(String targetResourceID, String sparqlQuery) {
        return new JSONArray(new JSONObject(AccessAgentCaller.query(null, targetResourceID, sparqlQuery)).getString("result"));
    }

    @Deprecated
    public static String query(String targetResourceID, String sparqlQuery) {
        return AccessAgentCaller.query(null, targetResourceID, sparqlQuery);
    }

    public static String query(String datasetUrl, String targetUrl, String sparqlQuery) {
        LOGGER.info("query for datasetUrl=" + datasetUrl + ", targetUrl=" + targetUrl + ", scenarioUrl=" + JPSContext.getScenarioUrl());
        Object[] a = AccessAgentCaller.createRequestUrl(datasetUrl, targetUrl);
        String requestUrl = (String)a[0];
        JSONObject joparams = (JSONObject)a[1];
        JSONObject jobody = new JSONObject();
        jobody.put("sparqlquery", sparqlQuery);
        String contentType = MediaType.APPLICATION_JSON.type;
        return Http.execute(Http.post(requestUrl, jobody.toString(), contentType, null, joparams));
    }

    public static void updateStore(String targetResourceID, String sparqlUpdate) {
        AccessAgentCaller.update(null, targetResourceID, sparqlUpdate);
    }

    @Deprecated
    public static void update(String targetResourceID, String sparqlUpdate) {
        AccessAgentCaller.update(null, targetResourceID, sparqlUpdate);
    }

    public static void update(String datasetUrl, String targetUrl, String sparqlUpdate) {
        LOGGER.info("update for datasetUrl=" + datasetUrl + ", targetUrl=" + targetUrl + ", scenarioUrl=" + JPSContext.getScenarioUrl());
        Object[] a = AccessAgentCaller.createRequestUrl(datasetUrl, targetUrl);
        String requestUrl = (String)a[0];
        JSONObject joparams = (JSONObject)a[1];
        JSONObject jobody = new JSONObject();
        jobody.put("sparqlupdate", sparqlUpdate);
        String contentType = MediaType.APPLICATION_JSON.type;
        Http.execute(Http.post(requestUrl, jobody.toString(), contentType, null, joparams));
    }

    public static Object[] createRequestUrl(String datasetUrl, String targetUrl) {
        String scenarioUrl = JPSContext.getScenarioUrl();
        String requestUrl = null;
        if (datasetUrl != null && datasetUrl.isEmpty()) {
            datasetUrl = null;
        }
        JSONObject joparams = null;
        if (scenarioUrl != null) {
            requestUrl = scenarioUrl;
            joparams = new JSONObject();
            String resource = AccessAgentCaller.cutHashFragment(targetUrl);
            joparams.put("scenarioresource", resource);
            if (datasetUrl != null) {
                if (targetUrl == null) {
                    joparams.put("scenarioresource", datasetUrl);
                } else {
                    joparams.put("dataset", datasetUrl);
                }
            }
        } else if (datasetUrl != null) {
            requestUrl = AccessAgentCaller.getBaseWorldUrl(datasetUrl);
            joparams = new JSONObject();
            joparams.put("targetresourceiri", AccessAgentCaller.cutHashFragment(datasetUrl));
            joparams.put("targetgraph", AccessAgentCaller.cutHashFragment(targetUrl));
        } else {
            requestUrl = AccessAgentCaller.getBaseWorldUrl(targetUrl);
            joparams = new JSONObject();
            joparams.put("targetresourceiri", AccessAgentCaller.cutHashFragment(targetUrl));
        }
        Object[] a = new Object[]{requestUrl, joparams};
        return a;
    }

    public static String cutHashFragment(String url) {
        if (url == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(URLDecoder.decode(url, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new JPSRuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new JPSRuntimeException(e);
        }
        if (uri.getScheme() != null) {
            return uri.getScheme() + ":" + uri.getSchemeSpecificPart();
        }
        return uri.getSchemeSpecificPart();
    }

    public static String getBaseWorldUrl(String url) {
        URI requestUrl = null;
        try {
            URI uri = new URI(URLDecoder.decode(url, "UTF-8"));
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            if (scheme == null) {
                scheme = "http";
            }
            if (authority == null) {
                authority = KeyValueMap.getInstance().get("url.accessagent.host");
            }
            requestUrl = new URI(scheme, authority, "/access-agent/access", null, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new JPSRuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new JPSRuntimeException(e);
        }
        return requestUrl.toString();
    }
}

