/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expressions;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Operand;
import org.eclipse.rdf4j.sparqlbuilder.core.Prefix;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.core.PropertyPaths;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.core.query.ModifyQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Queries;
import org.eclipse.rdf4j.sparqlbuilder.core.query.SelectQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatternNotTriples;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatterns;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.SubSelect;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.derivation.Derivation;
import uk.ac.cam.cares.jps.base.derivation.Entity;
import uk.ac.cam.cares.jps.base.derivation.StatusType;
import uk.ac.cam.cares.jps.base.derivation.ValuesPattern;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;

public class DerivationSparql {
    private StoreClientInterface storeClient;
    private String derivationInstanceBaseURL;
    public static String derivednamespace = "https://raw.githubusercontent.com/cambridge-cares/TheWorldAvatar/main/JPS_Ontology/ontology/ontoderivation/OntoDerivation.owl#";
    private static final String PLACEHOLDER = "http://This_is_a_placeholder_string";
    private static final Iri PLACEHOLDER_IRI = Rdf.iri("http://This_is_a_placeholder_string");
    private static String REQUESTED = "Requested";
    private static String INPROGRESS = "InProgress";
    private static String FINISHED = "Finished";
    public static String DERIVATION = "Derivation";
    public static String DERIVATIONWITHTIMESERIES = "DerivationWithTimeSeries";
    public static String DERIVATIONASYN = "DerivationAsyn";
    public static String ONTODERIVATION_DERIVATION = derivednamespace + DERIVATION;
    public static String ONTODERIVATION_DERIVATIONASYN = derivednamespace + DERIVATIONASYN;
    public static String ONTODERIVATION_DERIVATIONWITHTIMESERIES = derivednamespace + DERIVATIONWITHTIMESERIES;
    private static Prefix p_agent = SparqlBuilder.prefix("agent", Rdf.iri("http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#"));
    private static Prefix p_derived = SparqlBuilder.prefix("derived", Rdf.iri(derivednamespace));
    private static Prefix p_time = SparqlBuilder.prefix("time", Rdf.iri("http://www.w3.org/2006/time#"));
    private static Iri Service = p_agent.iri("Service");
    private static Iri Operation = p_agent.iri("Operation");
    private static Iri TimePosition = p_time.iri("TimePosition");
    private static Iri Derivation = p_derived.iri(DERIVATION);
    private static Iri DerivationWithTimeSeries = p_derived.iri(DERIVATIONWITHTIMESERIES);
    private static Iri DerivationAsyn = p_derived.iri(DERIVATIONASYN);
    private static Iri Status = p_derived.iri("Status");
    private static Iri Requested = p_derived.iri(REQUESTED);
    private static Iri InProgress = p_derived.iri(INPROGRESS);
    private static Iri Finished = p_derived.iri(FINISHED);
    private static Iri InstantClass = p_time.iri("Instant");
    private static Iri hasHttpUrl = p_agent.iri("hasHttpUrl");
    private static Iri hasOperation = p_agent.iri("hasOperation");
    private static Iri hasInput = p_agent.iri("hasInput");
    private static Iri hasMandatoryPart = p_agent.iri("hasMandatoryPart");
    private static Iri hasType = p_agent.iri("hasType");
    private static Iri hasName = p_agent.iri("hasName");
    private static Iri isDerivedFrom = p_derived.iri("isDerivedFrom");
    private static Iri isDerivedUsing = p_derived.iri("isDerivedUsing");
    private static Iri belongsTo = p_derived.iri("belongsTo");
    private static Iri hasStatus = p_derived.iri("hasStatus");
    private static Iri hasNewDerivedIRI = p_derived.iri("hasNewDerivedIRI");
    private static Iri hasTime = p_time.iri("hasTime");
    private static Iri numericPosition = p_time.iri("numericPosition");
    private static Iri hasTRS = p_time.iri("hasTRS");
    private static Iri inTimePosition = p_time.iri("inTimePosition");
    private static Iri retrievedInputsAt = p_derived.iri("retrievedInputsAt");
    private static List<Iri> classesToIgnore = Arrays.asList(Rdf.iri(OWL.THING), Rdf.iri(OWL.NAMEDINDIVIDUAL));
    private static final Map<String, StatusType> statusToType;
    private static final Map<String, Iri> derivationToIri;
    public static final List<String> derivationTypes;
    public static final List<String> statusType;
    private static final Logger LOGGER;

    @Deprecated
    public DerivationSparql(StoreClientInterface storeClient) {
        this.storeClient = storeClient;
        this.derivationInstanceBaseURL = derivednamespace;
    }

    public DerivationSparql(StoreClientInterface storeClient, String derivationInstanceBaseURL) {
        this.storeClient = storeClient;
        this.derivationInstanceBaseURL = derivationInstanceBaseURL;
    }

    List<String> unifiedBulkCreateDerivations(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList, List<Iri> derivationTypeList, List<Boolean> forAsyncUpdateFlagList) {
        ModifyQuery modify = Queries.MODIFY();
        if (entitiesList.size() != agentIRIList.size()) {
            String errmsg = "Size of entities list is different from agent IRI list";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        if (entitiesList.size() != agentURLList.size()) {
            String errmsg = "Size of entities list is different from agent URL list";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        if (entitiesList.size() != inputsList.size()) {
            String errmsg = "Size of entities list is different from inputs list";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        if (entitiesList.size() != derivationTypeList.size()) {
            String errmsg = "Size of entities list is different from derivationType list";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        if (entitiesList.size() != forAsyncUpdateFlagList.size()) {
            String errmsg = "Size of entities list is different from forAsyncUpdateFlag list";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        ArrayList<String> derivations = new ArrayList<String>();
        for (int i = 0; i < entitiesList.size(); ++i) {
            List<String> entities = entitiesList.get(i);
            List<String> inputs = inputsList.get(i);
            String agentIRI = agentIRIList.get(i);
            String agentURL = agentURLList.get(i);
            Boolean forUpdateFlag = forAsyncUpdateFlagList.get(i);
            Iri derivationType = derivationTypeList.get(i);
            String derivedQuantity = this.derivationInstanceBaseURL + "derived_" + UUID.randomUUID().toString();
            derivations.add(derivedQuantity);
            Iri derived_iri = Rdf.iri(derivedQuantity);
            modify.insert(derived_iri.isA(derivationType));
            for (String entity : entities) {
                modify.insert(Rdf.iri(entity).has((RdfPredicate)belongsTo, derived_iri));
            }
            for (String input : inputs) {
                modify.insert(derived_iri.has((RdfPredicate)isDerivedFrom, Rdf.iri(input)));
            }
            if (forUpdateFlag.booleanValue()) {
                Iri status_iri = Rdf.iri(this.derivationInstanceBaseURL + "status_" + UUID.randomUUID().toString());
                modify.insert(derived_iri.has((RdfPredicate)hasStatus, status_iri));
                modify.insert(status_iri.isA(Requested));
            }
            modify.insert(derived_iri.has((RdfPredicate)isDerivedUsing, Rdf.iri(agentIRI)));
            if (agentURL.contentEquals(PLACEHOLDER)) continue;
            String operation_iri = this.derivationInstanceBaseURL + UUID.randomUUID().toString();
            modify.insert(Rdf.iri(agentIRI).isA(Service).andHas((RdfPredicate)hasOperation, Rdf.iri(operation_iri)));
            modify.insert(Rdf.iri(operation_iri).isA(Operation).andHas((RdfPredicate)hasHttpUrl, Rdf.iri(agentURL)));
        }
        modify.prefix(p_derived, p_agent);
        this.storeClient.executeUpdate(modify.getQueryString());
        return derivations;
    }

    String createDerivation(List<String> entities, String agentIRI, String agentURL, List<String> inputs) {
        ModifyQuery modify = Queries.MODIFY();
        String derivedQuantity = this.derivationInstanceBaseURL + "derived_" + UUID.randomUUID().toString();
        Iri derived_iri = Rdf.iri(derivedQuantity);
        modify.insert(derived_iri.isA(Derivation));
        for (String entity : entities) {
            if (!this.hasBelongsTo(entity)) {
                modify.insert(Rdf.iri(entity).has((RdfPredicate)belongsTo, derived_iri));
                continue;
            }
            String errmsg = "<" + entity + "> is already part of another derivation";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        modify.insert(derived_iri.has((RdfPredicate)isDerivedUsing, Rdf.iri(agentIRI)));
        String operation_iri = this.derivationInstanceBaseURL + UUID.randomUUID().toString();
        modify.insert(Rdf.iri(agentIRI).isA(Service).andHas((RdfPredicate)hasOperation, Rdf.iri(operation_iri)));
        modify.insert(Rdf.iri(operation_iri).isA(Operation).andHas((RdfPredicate)hasHttpUrl, Rdf.iri(agentURL)));
        for (String input : inputs) {
            modify.insert(derived_iri.has((RdfPredicate)isDerivedFrom, Rdf.iri(input)));
        }
        this.storeClient.setQuery(((ModifyQuery)modify.prefix(p_time, p_derived, p_agent)).getQueryString());
        this.storeClient.executeUpdate();
        return derivedQuantity;
    }

    String createDerivation(List<String> entities, String agentIRI, List<String> inputs) {
        ModifyQuery modify = Queries.MODIFY();
        String derivedQuantity = this.derivationInstanceBaseURL + "derived_" + UUID.randomUUID().toString();
        Iri derived_iri = Rdf.iri(derivedQuantity);
        modify.insert(derived_iri.isA(Derivation));
        for (String entity : entities) {
            if (!this.hasBelongsTo(entity)) {
                modify.insert(Rdf.iri(entity).has((RdfPredicate)belongsTo, derived_iri));
                continue;
            }
            String errmsg = "<" + entity + "> is already part of another derivation";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        modify.insert(derived_iri.has((RdfPredicate)isDerivedUsing, Rdf.iri(agentIRI)));
        for (String input : inputs) {
            modify.insert(derived_iri.has((RdfPredicate)isDerivedFrom, Rdf.iri(input)));
        }
        modify.prefix(p_time, p_derived, p_agent);
        this.storeClient.setQuery(((ModifyQuery)modify.prefix(p_time, p_derived, p_agent)).getQueryString());
        this.storeClient.executeUpdate();
        return derivedQuantity;
    }

    String createDerivationIRI() {
        String derivedQuantity = this.derivationInstanceBaseURL + "derived_" + UUID.randomUUID().toString();
        return derivedQuantity;
    }

    String getAgentUrlGivenAgentIRI(String agentIRI) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        String queryKey = "url";
        Variable url = SparqlBuilder.var(queryKey);
        Iri agentIri = Rdf.iri(agentIRI);
        TriplePattern queryPattern = agentIri.has(PropertyPaths.path(hasOperation, hasHttpUrl), url);
        ((SelectQuery)query.select(url).where(queryPattern)).prefix(p_agent);
        this.storeClient.setQuery(query.getQueryString());
        String queryResult = this.storeClient.executeQuery().getJSONObject(0).getString(queryKey);
        return queryResult;
    }

    void writeSyncDerivationNewInfo(List<TriplePattern> outputTriples, List<String> entities, String agentIRI, List<String> inputsIRI, String derivationIRI, String derivationType, Long retrievedInputsAt) {
        ModifyQuery modify = Queries.MODIFY();
        modify.insert(Rdf.iri(derivationIRI).isA(Rdf.iri(derivationType)));
        outputTriples.forEach(t -> modify.insert((TriplePattern)t));
        for (String entity : entities) {
            if (!this.hasBelongsTo(entity)) {
                modify.insert(Rdf.iri(entity).has((RdfPredicate)belongsTo, Rdf.iri(derivationIRI)));
                continue;
            }
            String errmsg = "<" + entity + "> is already part of another derivation";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        inputsIRI.forEach(input -> modify.insert(Rdf.iri(derivationIRI).has((RdfPredicate)isDerivedFrom, Rdf.iri(input))));
        modify.insert(Rdf.iri(derivationIRI).has((RdfPredicate)isDerivedUsing, Rdf.iri(agentIRI)));
        String time_instant = this.derivationInstanceBaseURL + "time" + UUID.randomUUID().toString();
        String time_unix = this.derivationInstanceBaseURL + "time" + UUID.randomUUID().toString();
        Iri time_instant_iri = Rdf.iri(time_instant);
        Iri time_unix_iri = Rdf.iri(time_unix);
        modify.insert(Rdf.iri(derivationIRI).has((RdfPredicate)hasTime, time_instant_iri));
        modify.insert(time_instant_iri.isA(InstantClass).andHas((RdfPredicate)inTimePosition, time_unix_iri));
        modify.insert(time_unix_iri.isA(TimePosition).andHas((RdfPredicate)numericPosition, retrievedInputsAt).andHas((RdfPredicate)hasTRS, Rdf.iri("http://dbpedia.org/resource/Unix_time")));
        this.storeClient.setQuery(((ModifyQuery)modify.prefix(p_time, p_derived, p_agent)).getQueryString());
        this.storeClient.executeUpdate();
    }

    List<String> bulkCreateDerivations(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList) {
        List<Iri> derivationTypeList = IntStream.range(0, entitiesList.size()).mapToObj(i -> Derivation).collect(Collectors.toList());
        List<Boolean> forAsyncUpdateFlagList = IntStream.range(0, entitiesList.size()).mapToObj(i -> false).collect(Collectors.toList());
        return this.unifiedBulkCreateDerivations(entitiesList, agentIRIList, agentURLList, inputsList, derivationTypeList, forAsyncUpdateFlagList);
    }

    String createDerivationWithTimeSeries(List<String> entities, String agentIRI, String agentURL, List<String> inputs) {
        ModifyQuery modify = Queries.MODIFY();
        String derivedQuantity = this.derivationInstanceBaseURL + "derived_" + UUID.randomUUID().toString();
        Iri derived_iri = Rdf.iri(derivedQuantity);
        modify.insert(derived_iri.isA(DerivationWithTimeSeries));
        for (String entity : entities) {
            if (!this.hasBelongsTo(entity)) {
                modify.insert(Rdf.iri(entity).has((RdfPredicate)belongsTo, derived_iri));
                continue;
            }
            String errmsg = "<" + entity + "> is already part of another derivation";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        modify.insert(derived_iri.has((RdfPredicate)isDerivedUsing, Rdf.iri(agentIRI)));
        String operation_iri = this.derivationInstanceBaseURL + UUID.randomUUID().toString();
        modify.insert(Rdf.iri(agentIRI).isA(Service).andHas((RdfPredicate)hasOperation, Rdf.iri(operation_iri)));
        modify.insert(Rdf.iri(operation_iri).isA(Operation).andHas((RdfPredicate)hasHttpUrl, Rdf.iri(agentURL)));
        for (String input : inputs) {
            modify.insert(derived_iri.has((RdfPredicate)isDerivedFrom, Rdf.iri(input)));
        }
        modify.prefix(p_time, p_derived, p_agent);
        this.storeClient.setQuery(((ModifyQuery)modify.prefix(p_time, p_derived, p_agent)).getQueryString());
        this.storeClient.executeUpdate();
        return derivedQuantity;
    }

    List<String> bulkCreateDerivationsWithTimeSeries(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList) {
        List<Iri> derivationTypeList = IntStream.range(0, entitiesList.size()).mapToObj(i -> DerivationWithTimeSeries).collect(Collectors.toList());
        List<Boolean> forAsyncUpdateFlagList = IntStream.range(0, entitiesList.size()).mapToObj(i -> false).collect(Collectors.toList());
        return this.unifiedBulkCreateDerivations(entitiesList, agentIRIList, agentURLList, inputsList, derivationTypeList, forAsyncUpdateFlagList);
    }

    String createDerivationAsync(List<String> entities, String agentIRI, List<String> inputs, boolean forUpdate) {
        ModifyQuery modify = Queries.MODIFY();
        String derivedQuantity = this.derivationInstanceBaseURL + "derivedAsyn_" + UUID.randomUUID().toString();
        Iri derived_iri = Rdf.iri(derivedQuantity);
        modify.insert(derived_iri.isA(DerivationAsyn));
        for (String entity : entities) {
            if (!this.hasBelongsTo(entity)) {
                modify.insert(Rdf.iri(entity).has((RdfPredicate)belongsTo, derived_iri));
                continue;
            }
            String errmsg = "<" + entity + "> is already part of another derivation";
            LOGGER.fatal(errmsg);
            throw new JPSRuntimeException(errmsg);
        }
        modify.insert(derived_iri.has((RdfPredicate)isDerivedUsing, Rdf.iri(agentIRI)));
        for (String input : inputs) {
            modify.insert(derived_iri.has((RdfPredicate)isDerivedFrom, Rdf.iri(input)));
        }
        if (forUpdate) {
            String statusIRI = this.derivationInstanceBaseURL + "status_" + UUID.randomUUID().toString();
            TriplePattern insert_tp = derived_iri.has((RdfPredicate)hasStatus, Rdf.iri(statusIRI));
            TriplePattern insert_tp_rdf_type = Rdf.iri(statusIRI).isA(Requested);
            modify.insert(insert_tp);
            modify.insert(insert_tp_rdf_type);
        }
        modify.prefix(p_time, p_derived, p_agent);
        this.storeClient.setQuery(((ModifyQuery)modify.prefix(p_time, p_derived, p_agent)).getQueryString());
        this.storeClient.executeUpdate();
        return derivedQuantity;
    }

    List<String> bulkCreateDerivationsAsync(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList, List<Boolean> forAsyncUpdateFlagList) {
        List<Iri> derivationTypeList = IntStream.range(0, entitiesList.size()).mapToObj(i -> DerivationAsyn).collect(Collectors.toList());
        return this.unifiedBulkCreateDerivations(entitiesList, agentIRIList, agentURLList, inputsList, derivationTypeList, forAsyncUpdateFlagList);
    }

    List<String> bulkCreateDerivationsAsync(List<List<String>> entitiesList, List<String> agentIRIList, List<List<String>> inputsList, List<Boolean> forAsyncUpdateFlagList) {
        List<String> agentURLList = IntStream.range(0, entitiesList.size()).mapToObj(i -> PLACEHOLDER).collect(Collectors.toList());
        List<Iri> derivationTypeList = IntStream.range(0, entitiesList.size()).mapToObj(i -> DerivationAsyn).collect(Collectors.toList());
        return this.unifiedBulkCreateDerivations(entitiesList, agentIRIList, agentURLList, inputsList, derivationTypeList, forAsyncUpdateFlagList);
    }

    List<String> bulkCreateMixedDerivations(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList, List<String> derivationRdfTypeList, List<Boolean> forAsyncUpdateFlagList) {
        List<Iri> derivationTypeList = derivationRdfTypeList.stream().map(iri -> derivationToIri.get(iri)).collect(Collectors.toList());
        return this.unifiedBulkCreateDerivations(entitiesList, agentIRIList, agentURLList, inputsList, derivationTypeList, forAsyncUpdateFlagList);
    }

    List<String> bulkCreateMixedDerivations(List<List<String>> entitiesList, List<String> agentIRIList, List<List<String>> inputsList, List<String> derivationRdfTypeList, List<Boolean> forAsyncUpdateFlagList) {
        List<String> agentURLList = IntStream.range(0, entitiesList.size()).mapToObj(i -> PLACEHOLDER).collect(Collectors.toList());
        List<Iri> derivationTypeList = derivationRdfTypeList.stream().map(iri -> derivationToIri.get(iri)).collect(Collectors.toList());
        return this.unifiedBulkCreateDerivations(entitiesList, agentIRIList, agentURLList, inputsList, derivationTypeList, forAsyncUpdateFlagList);
    }

    boolean hasBelongsTo(String entity) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        TriplePattern queryPattern = Rdf.iri(entity).has((RdfPredicate)belongsTo, query.var());
        ((SelectQuery)query.prefix(p_derived)).where(queryPattern);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        return !queryResult.isEmpty();
    }

    @Deprecated
    String markAsRequested(String derivation) {
        this.deleteStatus(derivation);
        ModifyQuery modify = Queries.MODIFY();
        String statusIRI = this.getNameSpace(derivation) + "status_" + UUID.randomUUID().toString();
        TriplePattern insert_tp = Rdf.iri(derivation).has((RdfPredicate)hasStatus, Rdf.iri(statusIRI));
        TriplePattern insert_tp_rdf_type = Rdf.iri(statusIRI).isA(Requested);
        ((ModifyQuery)modify.prefix(p_derived)).insert(insert_tp);
        ((ModifyQuery)modify.prefix(p_derived)).insert(insert_tp_rdf_type);
        this.storeClient.executeUpdate(modify.getQueryString());
        return statusIRI;
    }

    void updateStatusBeforeSetupJob(String derivation) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        ModifyQuery modify = Queries.MODIFY();
        Variable status = query.var();
        Variable statusType = query.var();
        Variable existingTimestamp = query.var();
        GraphPatternNotTriples query_gp = GraphPatterns.and(Rdf.iri(derivation).has((RdfPredicate)hasStatus, status), status.isA(statusType));
        TriplePattern delete_tp = status.isA(statusType);
        TriplePattern insert_tp_rdf_type = status.isA(InProgress);
        long retrievedInputsAtTimestamp = Instant.now().getEpochSecond();
        TriplePattern insert_tp_retrieved_inputs_at = Rdf.iri(derivation).has((RdfPredicate)retrievedInputsAt, retrievedInputsAtTimestamp);
        TriplePattern existingRetrievedInputsAtPattern = Rdf.iri(derivation).has((RdfPredicate)retrievedInputsAt, existingTimestamp);
        modify.delete(delete_tp).insert(insert_tp_rdf_type, insert_tp_retrieved_inputs_at).where(GraphPatterns.and(query_gp.filterNotExists(existingRetrievedInputsAtPattern))).prefix(p_derived);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    void updateStatusAtJobCompletion(String derivation, List<String> newDerivedIRI, List<TriplePattern> newTriples) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        ModifyQuery modify = Queries.MODIFY();
        Variable status = query.var();
        Variable statusType = query.var();
        GraphPatternNotTriples query_gp = GraphPatterns.and(Rdf.iri(derivation).has((RdfPredicate)hasStatus, status), status.isA(statusType));
        TriplePattern delete_tp = status.isA(statusType);
        TriplePattern insert_tp_rdf_type = status.isA(Finished);
        modify.delete(delete_tp).where(query_gp).prefix(p_derived);
        modify.insert(insert_tp_rdf_type);
        newTriples.stream().forEach(t -> modify.insert((TriplePattern)t));
        for (String newIRI : newDerivedIRI) {
            modify.insert(status.has((RdfPredicate)hasNewDerivedIRI, Rdf.iri(newIRI)));
        }
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    StatusType getStatusType(String derivation) {
        String statusQueryKey = "status";
        String statusTypeQueryKey = "statusType";
        Variable status = SparqlBuilder.var(statusQueryKey);
        Variable statusType = SparqlBuilder.var(statusTypeQueryKey);
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Operand[] entityFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            entityFilters[j] = Expressions.notEquals(statusType, classesToIgnore.get(j));
        }
        TriplePattern queryPattern = Rdf.iri(derivation).has((RdfPredicate)hasStatus, status);
        GraphPattern queryPattern2 = status.isA(statusType).filter(Expressions.and(entityFilters));
        ((SelectQuery)((SelectQuery)query.prefix(p_derived)).where(queryPattern, queryPattern2)).select(status, statusType);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        if (queryResult.isEmpty()) {
            return StatusType.NOSTATUS;
        }
        return statusToType.get(queryResult.getJSONObject(0).getString(statusTypeQueryKey));
    }

    @Deprecated
    boolean hasStatus(String derivation) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        TriplePattern queryPattern = Rdf.iri(derivation).has((RdfPredicate)hasStatus, query.var());
        ((SelectQuery)query.prefix(p_derived)).where(queryPattern);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        return !queryResult.isEmpty();
    }

    List<String> getNewDerivedIRI(String derivation) {
        if (this.getStatusType(derivation) == StatusType.FINISHED) {
            String derivedQueryKey = "newDerivedIRI";
            SelectQuery query = Queries.SELECT(new Projectable[0]);
            Variable newDerivedIRI = SparqlBuilder.var(derivedQueryKey);
            TriplePattern derivedPattern = Rdf.iri(derivation).has(PropertyPaths.path(hasStatus, hasNewDerivedIRI), newDerivedIRI);
            ((SelectQuery)((SelectQuery)query.prefix(p_derived)).where(derivedPattern)).select(newDerivedIRI);
            JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
            ArrayList<String> newDerived = new ArrayList<String>();
            for (int i = 0; i < queryResult.length(); ++i) {
                newDerived.add(queryResult.getJSONObject(i).getString(derivedQueryKey));
            }
            return newDerived;
        }
        throw new JPSRuntimeException("Unable to retrieve the new derived IRI as derivation <" + derivation + "> is not finished.");
    }

    @Deprecated
    private boolean checkInstanceExists(String instance) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        GraphPatternNotTriples queryPattern = GraphPatterns.and(Rdf.iri(instance).has((RdfPredicate)query.var(), query.var()).optional(), query.var().has((RdfPredicate)query.var(), Rdf.iri(instance)).optional());
        query.where(queryPattern);
        JSONArray queryresult = this.storeClient.executeQuery(query.getQueryString());
        return !queryresult.getJSONObject(0).isEmpty();
    }

    void addTimeInstance(String entity) {
        ModifyQuery modify = Queries.MODIFY();
        String time_instant = this.derivationInstanceBaseURL + "time" + UUID.randomUUID().toString();
        String time_unix = this.derivationInstanceBaseURL + "time" + UUID.randomUUID().toString();
        long timestamp = 0L;
        Iri time_instant_iri = Rdf.iri(time_instant);
        Iri time_unix_iri = Rdf.iri(time_unix);
        modify.insert(Rdf.iri(entity).has((RdfPredicate)hasTime, time_instant_iri));
        modify.insert(time_instant_iri.isA(InstantClass).andHas((RdfPredicate)inTimePosition, time_unix_iri));
        modify.insert(time_unix_iri.isA(TimePosition).andHas((RdfPredicate)numericPosition, timestamp).andHas((RdfPredicate)hasTRS, Rdf.iri("http://dbpedia.org/resource/Unix_time")));
        this.storeClient.setQuery(((ModifyQuery)modify.prefix(p_time)).getQueryString());
        this.storeClient.executeUpdate();
    }

    void addTimeInstance(List<String> entities) {
        ModifyQuery modify = Queries.MODIFY();
        for (String entity : entities) {
            String time_instant = this.derivationInstanceBaseURL + "time" + UUID.randomUUID().toString();
            String time_unix = this.derivationInstanceBaseURL + "time" + UUID.randomUUID().toString();
            long timestamp = 0L;
            Iri time_instant_iri = Rdf.iri(time_instant);
            Iri time_unix_iri = Rdf.iri(time_unix);
            modify.insert(Rdf.iri(entity).has((RdfPredicate)hasTime, time_instant_iri));
            modify.insert(time_instant_iri.isA(InstantClass).andHas((RdfPredicate)inTimePosition, time_unix_iri));
            modify.insert(time_unix_iri.isA(TimePosition).andHas((RdfPredicate)numericPosition, timestamp).andHas((RdfPredicate)hasTRS, Rdf.iri("http://dbpedia.org/resource/Unix_time")));
        }
        this.storeClient.executeUpdate(((ModifyQuery)modify.prefix(p_time)).getQueryString());
    }

    String getAgentUrl(String derivedQuantity) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        String queryKey = "url";
        Variable url = SparqlBuilder.var(queryKey);
        Iri derivedQuantityIRI = Rdf.iri(derivedQuantity);
        TriplePattern queryPattern = derivedQuantityIRI.has(PropertyPaths.path(isDerivedUsing, hasOperation, hasHttpUrl), url);
        ((SelectQuery)query.select(url).where(queryPattern)).prefix(p_agent, p_derived);
        this.storeClient.setQuery(query.getQueryString());
        String queryResult = this.storeClient.executeQuery().getJSONObject(0).getString(queryKey);
        return queryResult;
    }

    List<String> getInputs(String derivedQuantity) {
        String queryKey = "input";
        Variable input = SparqlBuilder.var(queryKey);
        TriplePattern queryPattern = Rdf.iri(derivedQuantity).has((RdfPredicate)isDerivedFrom, input);
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        ((SelectQuery)((SelectQuery)query.prefix(p_derived)).where(queryPattern)).select(input);
        this.storeClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.storeClient.executeQuery();
        ArrayList<String> inputs = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            inputs.add(queryResult.getJSONObject(i).getString(queryKey));
        }
        return inputs;
    }

    JSONObject getInputsMapToAgent(String derivedQuantity, String agentIRI) {
        String typeKey = "type";
        String inputKey = "input";
        Variable type = SparqlBuilder.var(typeKey);
        Variable input = SparqlBuilder.var(inputKey);
        TriplePattern agentTypePattern = Rdf.iri(agentIRI).has(PropertyPaths.path(hasOperation, hasInput, hasMandatoryPart, hasType), type);
        TriplePattern derivationInputPattern = Rdf.iri(derivedQuantity).has((RdfPredicate)isDerivedFrom, input);
        TriplePattern mappingPattern = input.has(PropertyPaths.path(PropertyPaths.zeroOrMore(RdfPredicate.a), PropertyPaths.zeroOrMore(Rdf.iri(RDFS.SUBCLASSOF.toString()))), type);
        SelectQuery query = Queries.SELECT(new Projectable[0]).distinct();
        ((SelectQuery)((SelectQuery)query.prefix(p_derived, p_agent)).where(agentTypePattern, derivationInputPattern, mappingPattern)).select(input, type);
        this.storeClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.storeClient.executeQuery();
        JSONObject agentInputs = new JSONObject();
        for (int i = 0; i < queryResult.length(); ++i) {
            if (agentInputs.has(queryResult.getJSONObject(i).getString(typeKey))) {
                if (agentInputs.get(queryResult.getJSONObject(i).getString(typeKey)) instanceof JSONArray) {
                    agentInputs.getJSONArray(queryResult.getJSONObject(i).getString(typeKey)).put(queryResult.getJSONObject(i).getString(inputKey));
                    continue;
                }
                agentInputs.put(queryResult.getJSONObject(i).getString(typeKey), new JSONArray().put(agentInputs.get(queryResult.getJSONObject(i).getString(typeKey))));
                agentInputs.getJSONArray(queryResult.getJSONObject(i).getString(typeKey)).put(queryResult.getJSONObject(i).getString(inputKey));
                continue;
            }
            agentInputs.put(queryResult.getJSONObject(i).getString(typeKey), new JSONArray().put(queryResult.getJSONObject(i).getString(inputKey)));
        }
        return agentInputs;
    }

    JSONObject mapInstancesToAgentInputs(List<String> inputs, String agentIRI) {
        String typeKey = "type";
        String inputKey = "input";
        Variable type = SparqlBuilder.var(typeKey);
        Variable input = SparqlBuilder.var(inputKey);
        TriplePattern agentTypePattern = Rdf.iri(agentIRI).has(PropertyPaths.path(hasOperation, hasInput, hasMandatoryPart, hasType), type);
        ValuesPattern inputValuesPattern = new ValuesPattern(input, inputs.stream().map(i -> Rdf.iri(i)).collect(Collectors.toList()));
        TriplePattern mappingPattern = input.has(PropertyPaths.path(PropertyPaths.zeroOrMore(RdfPredicate.a), PropertyPaths.zeroOrMore(Rdf.iri(RDFS.SUBCLASSOF.toString()))), type);
        SelectQuery query = Queries.SELECT(new Projectable[0]).distinct();
        ((SelectQuery)((SelectQuery)query.prefix(p_derived, p_agent)).where(agentTypePattern, inputValuesPattern, mappingPattern)).select(input, type);
        this.storeClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.storeClient.executeQuery();
        JSONObject agentInputs = new JSONObject();
        for (int i2 = 0; i2 < queryResult.length(); ++i2) {
            if (agentInputs.has(queryResult.getJSONObject(i2).getString(typeKey))) {
                if (agentInputs.get(queryResult.getJSONObject(i2).getString(typeKey)) instanceof JSONArray) {
                    agentInputs.getJSONArray(queryResult.getJSONObject(i2).getString(typeKey)).put(queryResult.getJSONObject(i2).getString(inputKey));
                    continue;
                }
                agentInputs.put(queryResult.getJSONObject(i2).getString(typeKey), new JSONArray().put(agentInputs.get(queryResult.getJSONObject(i2).getString(typeKey))));
                agentInputs.getJSONArray(queryResult.getJSONObject(i2).getString(typeKey)).put(queryResult.getJSONObject(i2).getString(inputKey));
                continue;
            }
            agentInputs.put(queryResult.getJSONObject(i2).getString(typeKey), new JSONArray().put(queryResult.getJSONObject(i2).getString(inputKey)));
        }
        return agentInputs;
    }

    List<String> retrieveMatchingInstances(String upstreamDerivation, String agentIRI) {
        String typeKey = "type";
        String outputKey = "output";
        Variable type = SparqlBuilder.var(typeKey);
        Variable output = SparqlBuilder.var(outputKey);
        TriplePattern agentTypePattern = Rdf.iri(agentIRI).has(PropertyPaths.path(hasOperation, hasInput, hasMandatoryPart, hasType), type);
        TriplePattern derivationOutputPattern = output.has((RdfPredicate)belongsTo, Rdf.iri(upstreamDerivation));
        TriplePattern mappingPattern = output.has(PropertyPaths.path(PropertyPaths.zeroOrMore(RdfPredicate.a), PropertyPaths.zeroOrMore(Rdf.iri(RDFS.SUBCLASSOF.toString()))), type);
        SelectQuery query = Queries.SELECT(new Projectable[0]).distinct();
        ((SelectQuery)((SelectQuery)query.prefix(p_derived, p_agent)).where(agentTypePattern, derivationOutputPattern, mappingPattern)).select(output, type);
        this.storeClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.storeClient.executeQuery();
        ArrayList<String> matchingInstances = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            matchingInstances.add(queryResult.getJSONObject(i).getString(outputKey));
        }
        return matchingInstances;
    }

    Map<String, List<String>> matchNewDerivedIriToDownsFroNewInfo(List<String> instances, List<String> downstreamDerivationsForNewInfo) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        SelectQuery query = Queries.SELECT(new Projectable[0]).distinct();
        Variable derivation = query.var();
        Variable type = query.var();
        Variable instance = query.var();
        GraphPatternNotTriples matchingPattern = GraphPatterns.and(new ValuesPattern(derivation, downstreamDerivationsForNewInfo.stream().map(i -> Rdf.iri(i)).collect(Collectors.toList())), derivation.has(PropertyPaths.path(isDerivedUsing, hasOperation, hasInput, hasMandatoryPart, hasType), type), new ValuesPattern(instance, instances.stream().map(i -> Rdf.iri(i)).collect(Collectors.toList())), instance.has(PropertyPaths.path(PropertyPaths.zeroOrMore(RdfPredicate.a), PropertyPaths.zeroOrMore(Rdf.iri(RDFS.SUBCLASSOF.toString()))), type));
        ((SelectQuery)((SelectQuery)query.prefix(p_derived, p_agent)).where(matchingPattern)).select(instance, derivation);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        for (int i2 = 0; i2 < queryResult.length(); ++i2) {
            String inst = queryResult.getJSONObject(i2).getString(instance.getQueryString().substring(1));
            String deriv = queryResult.getJSONObject(i2).getString(derivation.getQueryString().substring(1));
            if (map.containsKey(inst)) {
                ((List)map.get(inst)).add(deriv);
                continue;
            }
            map.put(inst, new ArrayList<String>(Arrays.asList(deriv)));
        }
        return map;
    }

    List<String> getDerivations(String agentIRI) {
        String queryKey = "derivation";
        Variable derivation = SparqlBuilder.var(queryKey);
        TriplePattern queryPattern = derivation.has((RdfPredicate)isDerivedUsing, Rdf.iri(agentIRI));
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        ((SelectQuery)query.prefix(p_derived, p_agent)).select(derivation).where(queryPattern);
        this.storeClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.storeClient.executeQuery();
        ArrayList<String> derivations = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            derivations.add(queryResult.getJSONObject(i).getString(queryKey));
        }
        return derivations;
    }

    Map<String, StatusType> getDerivationsAndStatusType(String agentIRI) {
        String queryKey = "derivation";
        String statusQueryKey = "status";
        String statusTypeQueryKey = "statusType";
        Variable derivation = SparqlBuilder.var(queryKey);
        Variable status = SparqlBuilder.var(statusQueryKey);
        Variable statusType = SparqlBuilder.var(statusTypeQueryKey);
        Operand[] entityFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            entityFilters[j] = Expressions.notEquals(statusType, classesToIgnore.get(j));
        }
        TriplePattern queryPattern = derivation.has((RdfPredicate)isDerivedUsing, Rdf.iri(agentIRI)).andIsA(DerivationAsyn);
        GraphPatternNotTriples optionalPattern = GraphPatterns.optional(GraphPatterns.and(derivation.has((RdfPredicate)hasStatus, status), status.isA(statusType).filter(Expressions.and(entityFilters))));
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        ((SelectQuery)query.prefix(p_derived, p_agent)).select(derivation, statusType).where(queryPattern, optionalPattern);
        this.storeClient.setQuery(query.getQueryString());
        JSONArray queryResult = this.storeClient.executeQuery();
        HashMap<String, StatusType> derivationsAndStatusType = new HashMap<String, StatusType>();
        for (int i = 0; i < queryResult.length(); ++i) {
            if (queryResult.getJSONObject(i).has(statusTypeQueryKey)) {
                derivationsAndStatusType.put(queryResult.getJSONObject(i).getString(queryKey), statusToType.get(queryResult.getJSONObject(i).getString(statusTypeQueryKey)));
                continue;
            }
            derivationsAndStatusType.put(queryResult.getJSONObject(i).getString(queryKey), StatusType.NOSTATUS);
        }
        return derivationsAndStatusType;
    }

    Map<String, List<String>> getUpstreamDerivationsNeedUpdate(String derivation) {
        String upsDevQueryKey = "upstreamDerivation";
        String upsDevTypeQueryKey = "upstreamDerivationType";
        String upsDevTimeQueryKey = "upstreamDerivationTimestamp";
        String statusQueryKey = "status";
        String statusTypeQueryKey = "statusType";
        String pureInputTimeQueryKey = "pureInputTimestamp";
        String inputsBelongingToDevTimeQueryKey = "inputsBelongingToDerivationTimestamp";
        SelectQuery query = Queries.SELECT(new Projectable[0]).distinct();
        Variable upstreamDerivation = SparqlBuilder.var(upsDevQueryKey);
        Variable upstreamDerivationType = SparqlBuilder.var(upsDevTypeQueryKey);
        Variable upstreamDerivationTimestamp = SparqlBuilder.var(upsDevTimeQueryKey);
        Variable status = SparqlBuilder.var(statusQueryKey);
        Variable statusType = SparqlBuilder.var(statusTypeQueryKey);
        Variable pureInputTimestamp = SparqlBuilder.var(pureInputTimeQueryKey);
        Variable inputsBelongingToDerivationTimestamp = SparqlBuilder.var(inputsBelongingToDevTimeQueryKey);
        Operand[] entityFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            entityFilters[j] = Expressions.notEquals(statusType, classesToIgnore.get(j));
        }
        Expression<?> upstreamDerivationFilter = Expressions.or(Expressions.lt((Operand)upstreamDerivationTimestamp, (Operand)pureInputTimestamp), Expressions.lt((Operand)upstreamDerivationTimestamp, (Operand)inputsBelongingToDerivationTimestamp), Expressions.equals(statusType, Requested), Expressions.equals(statusType, InProgress), Expressions.equals(statusType, Finished));
        GraphPatternNotTriples upstreamDerivationPattern = GraphPatterns.and(Rdf.iri(derivation).has(PropertyPaths.path(isDerivedFrom, this.zeroOrOne(belongsTo)), upstreamDerivation), upstreamDerivation.isA(upstreamDerivationType), new ValuesPattern(upstreamDerivationType, derivationTypes.stream().map(i -> derivationToIri.get(i)).collect(Collectors.toList())));
        TriplePattern upDevTimePattern = upstreamDerivation.has(PropertyPaths.path(hasTime, inTimePosition, numericPosition), upstreamDerivationTimestamp);
        GraphPatternNotTriples upDevStatusTypePattern = GraphPatterns.optional(GraphPatterns.and(upstreamDerivation.has((RdfPredicate)hasStatus, status), status.isA(statusType).filter(Expressions.and(entityFilters))));
        GraphPattern upDevPureInputTimePattern = upstreamDerivation.has(PropertyPaths.path(isDerivedFrom, hasTime, inTimePosition, numericPosition), pureInputTimestamp).optional();
        GraphPattern inputsBelongsToDevTimePattern = upstreamDerivation.has(PropertyPaths.path(isDerivedFrom, belongsTo, hasTime, inTimePosition, numericPosition), inputsBelongingToDerivationTimestamp).optional();
        ((SelectQuery)query.prefix(p_derived, p_time)).select(upstreamDerivation, upstreamDerivationType).where(GraphPatterns.and(upstreamDerivationPattern, upDevTimePattern, upDevStatusTypePattern, upDevPureInputTimePattern, inputsBelongsToDevTimePattern).filter((Expression)upstreamDerivationFilter));
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        HashMap<String, List<String>> upstreamDerivationMap = new HashMap<String, List<String>>();
        for (int i2 = 0; i2 < queryResult.length(); ++i2) {
            String derivedIRI = queryResult.getJSONObject(i2).getString(upsDevQueryKey);
            String derivationType = queryResult.getJSONObject(i2).getString(upsDevTypeQueryKey);
            if (!upstreamDerivationMap.containsKey(derivationType)) {
                upstreamDerivationMap.put(derivationType, new ArrayList<String>(Arrays.asList(derivedIRI)));
                continue;
            }
            ((List)upstreamDerivationMap.get(derivationType)).add(derivedIRI);
        }
        return upstreamDerivationMap;
    }

    void markAsRequestedIfOutdated(String derivationIRI) {
        SubSelect sub = GraphPatterns.select(new Projectable[0]);
        ModifyQuery modify = Queries.MODIFY();
        Variable d = SparqlBuilder.var("derivation");
        Variable dTs = SparqlBuilder.var("derivationTimestamp");
        Variable dStatus = SparqlBuilder.var("derivationStatus");
        Variable upstream = SparqlBuilder.var("upstream");
        Variable upsTs = SparqlBuilder.var("upstreamTimestamp");
        Variable upsStatusType = SparqlBuilder.var("upsStatusType");
        Expression<?> upstreamFilter = Expressions.or(Expressions.lt((Operand)dTs, (Operand)upsTs), Expressions.equals(upsStatusType, Requested), Expressions.equals(upsStatusType, InProgress), Expressions.equals(upsStatusType, Finished));
        ValuesPattern derivationIRIPattern = new ValuesPattern(d, Arrays.asList(Rdf.iri(derivationIRI)));
        TriplePattern derivationTimePattern = d.has(PropertyPaths.path(hasTime, inTimePosition, numericPosition), dTs);
        TriplePattern upstreamPattern = d.has(PropertyPaths.path(isDerivedFrom, this.zeroOrOne(belongsTo)), upstream);
        TriplePattern upstreamTimePattern = upstream.has(PropertyPaths.path(hasTime, inTimePosition, numericPosition), upsTs);
        GraphPatternNotTriples upstreamStatusTypePattern = GraphPatterns.and(upstream.has(PropertyPaths.path(hasStatus, RdfPredicate.a), upsStatusType)).optional();
        TriplePattern derivationStatusPattern = d.has((RdfPredicate)hasStatus, dStatus);
        sub.select(d).where(GraphPatterns.and(derivationIRIPattern, derivationTimePattern, upstreamPattern, upstreamTimePattern, upstreamStatusTypePattern).filter((Expression)upstreamFilter).filterNotExists(derivationStatusPattern));
        String statusIRI = this.getNameSpace(derivationIRI) + "status_" + UUID.randomUUID().toString();
        TriplePattern insert_status = d.has((RdfPredicate)hasStatus, Rdf.iri(statusIRI));
        TriplePattern insert_status_rdf_type = Rdf.iri(statusIRI).isA(Requested);
        ((ModifyQuery)modify.prefix(p_time, p_derived)).insert(insert_status, insert_status_rdf_type).where(sub);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    List<String> getInputsAndDerived(String derived) {
        String inputQueryKey = "input";
        String derivedQueryKey = "derived";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable input = SparqlBuilder.var(inputQueryKey);
        Variable derivedOfInput = SparqlBuilder.var(derivedQueryKey);
        GraphPatternNotTriples inputPattern = GraphPatterns.and(Rdf.iri(derived).has((RdfPredicate)isDerivedFrom, input));
        GraphPattern derivedPattern = input.has((RdfPredicate)belongsTo, derivedOfInput).optional();
        ((SelectQuery)((SelectQuery)query.prefix(p_derived)).where(inputPattern, derivedPattern)).select(input, derivedOfInput);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        ArrayList<String> inputsAndDerived = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            String derivedIRI = queryResult.getJSONObject(i).optString(derivedQueryKey);
            if (derivedIRI.length() > 0) {
                inputsAndDerived.add(derivedIRI);
                continue;
            }
            inputsAndDerived.add(queryResult.getJSONObject(i).getString(inputQueryKey));
        }
        return inputsAndDerived;
    }

    @Deprecated
    List<String> getDerivedEntities(String derivedIRI) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        String queryKey = "entity";
        Variable entity = SparqlBuilder.var(queryKey);
        TriplePattern queryPattern = entity.has((RdfPredicate)belongsTo, Rdf.iri(derivedIRI));
        ((SelectQuery)query.prefix(p_derived)).select(entity).where(queryPattern);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        ArrayList<String> entities = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            entities.add(queryResult.getJSONObject(i).getString(queryKey));
        }
        return entities;
    }

    @Deprecated
    List<Entity> getDerivedEntitiesAndDownstreamDerivation(String derivation) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        String entityQueryKey = "entity";
        String rdfTypeQueryKey = "class";
        String downstreamDevQueryKey = "downstreamDerivation";
        String downsDevRdfTypeQueryKey = "downsDevClass";
        Variable entity = SparqlBuilder.var(entityQueryKey);
        Variable rdfType = SparqlBuilder.var(rdfTypeQueryKey);
        Variable downstreamDerivation = SparqlBuilder.var(downstreamDevQueryKey);
        Variable downsDevRdfType = SparqlBuilder.var(downsDevRdfTypeQueryKey);
        Operand[] entityFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            entityFilters[j] = Expressions.notEquals(rdfType, classesToIgnore.get(j));
        }
        Operand[] downsDevFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            downsDevFilters[j] = Expressions.notEquals(downsDevRdfType, classesToIgnore.get(j));
        }
        GraphPattern queryPattern = entity.has((RdfPredicate)belongsTo, Rdf.iri(derivation)).andIsA(rdfType).filter(Expressions.and(entityFilters));
        GraphPattern downstreamDevPattern = downstreamDerivation.has((RdfPredicate)isDerivedFrom, entity).andIsA(downsDevRdfType).filter(Expressions.and(downsDevFilters));
        ((SelectQuery)query.prefix(p_derived)).select(entity, rdfType, downstreamDerivation, downsDevRdfType).where(queryPattern, downstreamDevPattern);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        HashMap<String, Entity> entityMap = new HashMap<String, Entity>();
        for (int i = 0; i < queryResult.length(); ++i) {
            String eiri = queryResult.getJSONObject(i).getString(entityQueryKey);
            if (!entityMap.containsKey(eiri)) {
                Entity e = new Entity(eiri);
                e.setRdfType(queryResult.getJSONObject(i).getString(rdfTypeQueryKey));
                e.setAsInput(new Derivation(queryResult.getJSONObject(i).getString(downstreamDevQueryKey), queryResult.getJSONObject(i).getString(downsDevRdfTypeQueryKey)));
                entityMap.put(eiri, e);
                continue;
            }
            ((Entity)entityMap.get(eiri)).setAsInput(new Derivation(queryResult.getJSONObject(i).getString(downstreamDevQueryKey), queryResult.getJSONObject(i).getString(downsDevRdfTypeQueryKey)));
        }
        return new ArrayList<Entity>(entityMap.values());
    }

    Map<String, String> getDownstreamDerivationForNewInfo(String derivation) {
        SelectQuery query = Queries.SELECT(new Projectable[0]).distinct();
        Variable downstream = query.var();
        Variable downstreamType = query.var();
        Variable agentIRI = query.var();
        GraphPatternNotTriples queryPattern = GraphPatterns.and(downstream.has((RdfPredicate)isDerivedFrom, Rdf.iri(derivation)).andHas(RdfPredicate.a, downstreamType).andHas((RdfPredicate)isDerivedUsing, agentIRI), new ValuesPattern(downstreamType, Arrays.asList(DerivationAsyn)));
        ((SelectQuery)query.prefix(p_derived, p_agent)).select(downstream, agentIRI).where(queryPattern);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        HashMap<String, String> downstreamDerivations = new HashMap<String, String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            downstreamDerivations.put(queryResult.getJSONObject(i).getString(downstream.getQueryString().substring(1)), queryResult.getJSONObject(i).getString(agentIRI.getQueryString().substring(1)));
        }
        return downstreamDerivations;
    }

    @Deprecated
    List<List<String>> getIsDerivedFromEntities(List<String> entities) {
        String derivedkey = "derived";
        String typeKey = "type";
        Variable derived = SparqlBuilder.var(derivedkey);
        Variable entityType = SparqlBuilder.var(typeKey);
        Operand[] filters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            filters[j] = Expressions.notEquals(entityType, classesToIgnore.get(j));
        }
        ArrayList<List<String>> derivedAndEntityType = new ArrayList<List<String>>();
        ArrayList<String> derivediri = new ArrayList<String>();
        ArrayList<String> typeiri = new ArrayList<String>();
        for (String entity : entities) {
            SelectQuery query = Queries.SELECT(new Projectable[0]);
            GraphPatternNotTriples queryPattern = ((GraphPatternNotTriples)GraphPatterns.and(derived.has((RdfPredicate)isDerivedFrom, Rdf.iri(entity)), Rdf.iri(entity).isA(entityType)).filter((Expression)Expressions.and(filters))).optional();
            ((SelectQuery)query.select(derived, entityType).where(queryPattern)).prefix(p_derived);
            JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
            if (queryResult.getJSONObject(0).isEmpty()) continue;
            for (int j = 0; j < queryResult.length(); ++j) {
                derivediri.add(queryResult.getJSONObject(j).getString(derivedkey));
                typeiri.add(queryResult.getJSONObject(j).getString(typeKey));
            }
        }
        derivedAndEntityType.add(derivediri);
        derivedAndEntityType.add(typeiri);
        return derivedAndEntityType;
    }

    @Deprecated
    void deleteInstances(List<String> entities) {
        for (String entity : entities) {
            SubSelect sub = GraphPatterns.select(new Projectable[0]);
            Variable subject = sub.var();
            Variable pred1 = sub.var();
            Variable pred2 = sub.var();
            Variable object = sub.var();
            TriplePattern[] delete_tp = new TriplePattern[2];
            GraphPattern[] queryPattern = new GraphPattern[2];
            delete_tp[0] = subject.has((RdfPredicate)pred1, Rdf.iri(entity));
            queryPattern[0] = delete_tp[0].optional();
            delete_tp[1] = Rdf.iri(entity).has((RdfPredicate)pred2, object);
            queryPattern[1] = delete_tp[1].optional();
            sub.select(subject, pred1, pred2, object).where(queryPattern);
            ModifyQuery modify = Queries.MODIFY();
            modify.delete(delete_tp).where(sub);
            this.storeClient.executeUpdate(modify.getQueryString());
        }
    }

    @Deprecated
    void deleteStatus(String derivation) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable status = query.var();
        Variable type = query.var();
        Variable newDerivedIRI = query.var();
        TriplePattern tp1 = Rdf.iri(derivation).has((RdfPredicate)hasStatus, status);
        TriplePattern tp2 = status.isA(type);
        TriplePattern tp3 = status.has((RdfPredicate)hasNewDerivedIRI, newDerivedIRI);
        GraphPattern gp = status.has((RdfPredicate)hasNewDerivedIRI, newDerivedIRI).optional();
        ModifyQuery modify = Queries.MODIFY();
        modify.delete(tp1, tp2, tp3).where(tp1, tp2, gp).prefix(p_derived);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    long getTimestamp(String instance) {
        String queryKey = "timestamp";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable time = SparqlBuilder.var(queryKey);
        Iri instanceIRI = Rdf.iri(instance);
        RdfPredicate[] predicates = new Iri[]{hasTime, inTimePosition, numericPosition};
        GraphPattern queryPattern = instanceIRI.has(PropertyPaths.path(predicates), time).optional();
        RdfPredicate[] predicates2 = new Iri[]{belongsTo, hasTime, inTimePosition, numericPosition};
        GraphPattern queryPattern2 = instanceIRI.has(PropertyPaths.path(predicates2), time).optional();
        ((SelectQuery)((SelectQuery)query.prefix(p_time, p_derived)).where(queryPattern, queryPattern2)).select(time);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        if (queryResult.length() > 1) {
            throw new JPSRuntimeException("DerivedQuantitySparql: More than 1 time instance associated with <" + instance + ">");
        }
        try {
            long timestamp = queryResult.getJSONObject(0).getLong(queryKey);
            return timestamp;
        }
        catch (JSONException e) {
            throw new JPSRuntimeException("No timestamp for <" + instance + ">. This is probably an input and you should consider adding a timestamp using DerivationClient.addTimeInstance or create a derived instance using this instance");
        }
    }

    long updateTimeStamp(String instance) {
        long timestamp = Instant.now().getEpochSecond();
        SubSelect sub = GraphPatterns.select(new Projectable[0]);
        Variable timeIRI = sub.var();
        Variable unixtimeIRI = SparqlBuilder.var("timeIRI");
        Variable oldvalue = SparqlBuilder.var("oldvalue");
        GraphPatternNotTriples queryPattern = GraphPatterns.and(Rdf.iri(instance).has((RdfPredicate)hasTime, timeIRI), timeIRI.has((RdfPredicate)inTimePosition, unixtimeIRI), unixtimeIRI.has((RdfPredicate)numericPosition, oldvalue));
        TriplePattern delete_tp = unixtimeIRI.has((RdfPredicate)numericPosition, oldvalue);
        TriplePattern insert_tp = unixtimeIRI.has((RdfPredicate)numericPosition, timestamp);
        sub.select(unixtimeIRI, oldvalue).where(queryPattern);
        ModifyQuery modify = Queries.MODIFY();
        ((ModifyQuery)modify.prefix(p_time)).delete(delete_tp).insert(insert_tp).where(sub);
        this.storeClient.setQuery(modify.getQueryString());
        this.storeClient.executeUpdate();
        return timestamp;
    }

    @Deprecated
    List<String> getInstanceClass(List<String> instances) {
        String queryKey = "class";
        ArrayList<String> classOfInstances = new ArrayList<String>(instances.size());
        for (int i = 0; i < instances.size(); ++i) {
            SelectQuery query = Queries.SELECT(new Projectable[0]);
            Variable type = SparqlBuilder.var(queryKey);
            Operand[] filters = new Expression[classesToIgnore.size()];
            for (int j = 0; j < classesToIgnore.size(); ++j) {
                filters[j] = Expressions.notEquals(type, classesToIgnore.get(j));
            }
            GraphPattern queryPattern = Rdf.iri(instances.get(i)).isA(type).filter(Expressions.and(filters));
            query.select(type).where(queryPattern);
            this.storeClient.setQuery(query.getQueryString());
            JSONArray queryResult = this.storeClient.executeQuery();
            if (queryResult.length() > 1) {
                throw new JPSRuntimeException("DerivedQuantitySparql.getInstanceClass: more than 1 rdf:type for " + instances.get(i));
            }
            if (queryResult.length() == 1) {
                classOfInstances.add(i, queryResult.getJSONObject(0).getString(queryKey));
                continue;
            }
            classOfInstances.add(i, "");
        }
        return classOfInstances;
    }

    @Deprecated
    List<Entity> initialiseNewEntities(String derivationIRI) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable type = query.var();
        Variable instance = query.var();
        Operand[] filters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            filters[j] = Expressions.notEquals(type, classesToIgnore.get(j));
        }
        GraphPatternNotTriples instancePattern = GraphPatterns.and(instance.has((RdfPredicate)belongsTo, Rdf.iri(derivationIRI)), instance.isA(type).filter(Expressions.and(filters)));
        ((SelectQuery)query.prefix(p_derived)).select(type, instance).where(instancePattern);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        ArrayList<Entity> newEntities = new ArrayList<Entity>();
        for (int i = 0; i < queryResult.length(); ++i) {
            String iri = queryResult.getJSONObject(i).getString(instance.getQueryString().substring(1));
            if (newEntities.stream().anyMatch(e -> e.getIri().equals(iri))) {
                throw new JPSRuntimeException("DerivedQuantitySparql.getInstanceClass: more than 1 rdf:type for " + iri);
            }
            Entity entity = new Entity(iri);
            if (queryResult.getJSONObject(i).has(type.getQueryString().substring(1))) {
                entity.setRdfType(queryResult.getJSONObject(i).getString(type.getQueryString().substring(1)));
            }
            newEntities.add(entity);
        }
        return newEntities;
    }

    @Deprecated
    void reconnectInputToDerived(String input, String derived) {
        ModifyQuery modify = Queries.MODIFY();
        TriplePattern insert_tp = Rdf.iri(derived).has((RdfPredicate)isDerivedFrom, Rdf.iri(input));
        ((ModifyQuery)modify.prefix(p_derived)).insert(insert_tp);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    @Deprecated
    void reconnectInputToDerived(List<String> inputs, List<String> derivations) {
        if (inputs.size() != derivations.size()) {
            throw new JPSRuntimeException("reconnectInputToDerived has incorrect inputs");
        }
        ModifyQuery modify = Queries.MODIFY();
        for (int i = 0; i < inputs.size(); ++i) {
            modify.insert(Rdf.iri(derivations.get(i)).has((RdfPredicate)isDerivedFrom, Rdf.iri(inputs.get(i))));
        }
        modify.prefix(p_derived);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    void updateTimestampDeleteStatus(String derivation, Long timestamp) {
        ModifyQuery modify = Queries.MODIFY();
        SubSelect sub = GraphPatterns.select(new Projectable[0]);
        Variable timeIRI = sub.var();
        Variable unixtimeIRI = SparqlBuilder.var("timeIRI");
        Variable oldvalue = SparqlBuilder.var("oldvalue");
        Variable status = SparqlBuilder.var("status");
        Variable type = SparqlBuilder.var("statusType");
        Variable newDerivedIRI = SparqlBuilder.var("newDerivedIRI");
        GraphPatternNotTriples tsQueryPattern = GraphPatterns.and(Rdf.iri(derivation).has((RdfPredicate)hasTime, timeIRI), timeIRI.has((RdfPredicate)inTimePosition, unixtimeIRI), unixtimeIRI.has((RdfPredicate)numericPosition, oldvalue));
        TriplePattern tp1 = Rdf.iri(derivation).has((RdfPredicate)hasStatus, status);
        TriplePattern tp2 = status.isA(type);
        TriplePattern tp3 = status.has((RdfPredicate)hasNewDerivedIRI, newDerivedIRI);
        GraphPatternNotTriples statusQueryPattern = GraphPatterns.and(tp1, tp2, tp3.optional());
        TriplePattern delete_tp = unixtimeIRI.has((RdfPredicate)numericPosition, oldvalue);
        TriplePattern insert_tp = unixtimeIRI.has((RdfPredicate)numericPosition, timestamp);
        sub.select(unixtimeIRI, oldvalue, status, type, newDerivedIRI).where(tsQueryPattern, statusQueryPattern.optional());
        ((ModifyQuery)modify.prefix(p_time, p_derived)).delete(delete_tp, tp1, tp2, tp3).insert(insert_tp).where(sub);
        this.storeClient.setQuery(modify.getQueryString());
        this.storeClient.executeUpdate();
    }

    @Deprecated
    void deleteDirectConnectionBetweenDerivations(Map<String, String> derivationPairMap) {
        ModifyQuery modify = Queries.MODIFY();
        derivationPairMap.forEach((downstream, upstream) -> modify.delete(Rdf.iri(downstream).has((RdfPredicate)isDerivedFrom, Rdf.iri(upstream))));
        modify.prefix(p_derived);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    boolean isDerivedAsynchronous(String derived_iri) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable type = query.var();
        TriplePattern tp = Rdf.iri(derived_iri).isA(type);
        Expression<?> constraint = Expressions.equals(type, DerivationAsyn);
        GraphPattern queryPattern = tp.filter(constraint);
        ((SelectQuery)query.prefix(p_derived)).select(type).where(queryPattern);
        return this.storeClient.executeQuery(query.getQueryString()).length() == 1;
    }

    @Deprecated
    void addNewEntitiesToDerived(String instance, List<String> newEntities) {
        ModifyQuery modify = Queries.MODIFY();
        for (String newEntity : newEntities) {
            modify.insert(Rdf.iri(newEntity).has((RdfPredicate)belongsTo, Rdf.iri(instance)));
        }
        this.storeClient.executeUpdate(((ModifyQuery)modify.prefix(p_derived)).getQueryString());
    }

    List<Derivation> getDerivations(String rootDerivationIRI, List<String> targetDerivationTypeList, RdfPredicate upstreamPath) {
        List<Iri> targetDerivationTypeIriList = targetDerivationTypeList.stream().map(iri -> derivationToIri.get(iri)).collect(Collectors.toList());
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable derivation = query.var();
        Variable input = query.var();
        Variable inputType = query.var();
        Variable entity = query.var();
        Variable entityType = query.var();
        Variable agentURL = query.var();
        Variable derivationTimestamp = query.var();
        Variable inputTimestamp = query.var();
        Variable derivationType = query.var();
        Variable status = query.var();
        Variable statusType = query.var();
        Variable newDerivedIRI = query.var();
        Variable newDerivedIRIRdfType = query.var();
        Operand[] entityTypeFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            entityTypeFilters[j] = Expressions.notEquals(entityType, classesToIgnore.get(j));
        }
        Operand[] inputTypeFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            inputTypeFilters[j] = Expressions.notEquals(inputType, classesToIgnore.get(j));
        }
        Operand[] newDerivedIRITypeFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            newDerivedIRITypeFilters[j] = Expressions.notEquals(newDerivedIRIRdfType, classesToIgnore.get(j));
        }
        GraphPatternNotTriples derivationPattern = GraphPatterns.and(new ValuesPattern(derivationType, targetDerivationTypeIriList), derivation.has((RdfPredicate)isDerivedFrom, input).andHas(PropertyPaths.path(isDerivedUsing, hasOperation, hasHttpUrl), agentURL).andHas(PropertyPaths.path(hasTime, inTimePosition, numericPosition), derivationTimestamp).andIsA(derivationType));
        GraphPatternNotTriples statusPattern = GraphPatterns.and(new ValuesPattern(statusType, DerivationSparql.statusType.stream().map(i -> Rdf.iri(i)).collect(Collectors.toList())), derivation.has((RdfPredicate)hasStatus, status), status.isA(statusType), ((GraphPatternNotTriples)GraphPatterns.and(status.has((RdfPredicate)hasNewDerivedIRI, newDerivedIRI), newDerivedIRI.isA(newDerivedIRIRdfType)).optional().filter((Expression)Expressions.and(newDerivedIRITypeFilters))).optional()).optional();
        GraphPatternNotTriples entityPattern = GraphPatterns.and(entity.has((RdfPredicate)belongsTo, derivation), entity.isA(entityType).optional().filter(Expressions.and(entityTypeFilters))).optional();
        GraphPattern inputTimestampPattern = input.has(PropertyPaths.path(hasTime, inTimePosition, numericPosition), inputTimestamp).optional();
        GraphPattern inputTypePattern = input.isA(inputType).filter(Expressions.and(inputTypeFilters));
        if (!rootDerivationIRI.equals(PLACEHOLDER)) {
            GraphPattern rootDerivationPattern;
            if (!upstreamPath.equals(PLACEHOLDER_IRI)) {
                rootDerivationPattern = Rdf.iri(rootDerivationIRI).has(upstreamPath, derivation);
                query.where(rootDerivationPattern);
            } else {
                rootDerivationPattern = new ValuesPattern(derivation, Arrays.asList(Rdf.iri(rootDerivationIRI)));
                query.where(rootDerivationPattern);
            }
        }
        ((SelectQuery)query.select(derivation, input, entity, agentURL, derivationTimestamp, status, newDerivedIRI, inputTimestamp, derivationType, inputType, entityType, statusType, newDerivedIRIRdfType).where(derivationPattern, statusPattern, entityPattern, inputTimestampPattern, inputTypePattern)).prefix(p_derived, p_time, p_agent);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        LOGGER.debug(query.getQueryString());
        LOGGER.debug(queryResult);
        HashMap<String, Derivation> derivationsMap = new HashMap<String, Derivation>();
        ArrayList<Derivation> derivationList = new ArrayList<Derivation>();
        HashMap<String, Entity> entitiesMap = new HashMap<String, Entity>();
        HashMap<String, Entity> newDerivedIRIMap = new HashMap<String, Entity>();
        for (int i2 = 0; i2 < queryResult.length(); ++i2) {
            Derivation derived;
            String derivationIRI = queryResult.getJSONObject(i2).getString(derivation.getQueryString().substring(1));
            String inputIRI = queryResult.getJSONObject(i2).getString(input.getQueryString().substring(1));
            String urlString = queryResult.getJSONObject(i2).getString(agentURL.getQueryString().substring(1));
            String derivedType = queryResult.getJSONObject(i2).getString(derivationType.getQueryString().substring(1));
            String input_rdf_type = queryResult.getJSONObject(i2).getString(inputType.getQueryString().substring(1));
            long derivedTimestamp = queryResult.getJSONObject(i2).getLong(derivationTimestamp.getQueryString().substring(1));
            if (derivationsMap.containsKey(derivationIRI)) {
                derived = (Derivation)derivationsMap.get(derivationIRI);
            } else {
                derived = new Derivation(derivationIRI, derivedType);
                derivationsMap.put(derivationIRI, derived);
                derivationList.add(derived);
            }
            if (derivationTypes.contains(input_rdf_type)) {
                Derivation directUpstream;
                if (derivationsMap.containsKey(inputIRI)) {
                    directUpstream = (Derivation)derivationsMap.get(inputIRI);
                } else {
                    directUpstream = new Derivation(inputIRI, input_rdf_type);
                    derivationsMap.put(inputIRI, directUpstream);
                    derivationList.add(directUpstream);
                }
                derived.setDirectedUpstreams(directUpstream);
            } else {
                Entity input_entity;
                if (entitiesMap.containsKey(inputIRI)) {
                    input_entity = (Entity)entitiesMap.get(inputIRI);
                } else {
                    input_entity = new Entity(inputIRI);
                    entitiesMap.put(inputIRI, input_entity);
                }
                input_entity.setRdfType(input_rdf_type);
                if (queryResult.getJSONObject(i2).has(inputTimestamp.getQueryString().substring(1))) {
                    long input_timestamp = queryResult.getJSONObject(i2).getLong(inputTimestamp.getQueryString().substring(1));
                    input_entity.setTimestamp(input_timestamp);
                }
                derived.addInput(input_entity);
            }
            if (queryResult.getJSONObject(i2).has(entity.getQueryString().substring(1))) {
                Entity entity_entity;
                String entityIRI = queryResult.getJSONObject(i2).getString(entity.getQueryString().substring(1));
                if (entitiesMap.containsKey(entityIRI)) {
                    entity_entity = (Entity)entitiesMap.get(entityIRI);
                } else {
                    entity_entity = new Entity(entityIRI);
                    entitiesMap.put(entityIRI, entity_entity);
                }
                if (queryResult.getJSONObject(i2).has(entityType.getQueryString().substring(1))) {
                    entity_entity.setRdfType(queryResult.getJSONObject(i2).getString(entityType.getQueryString().substring(1)));
                }
                derived.addEntity(entity_entity);
            }
            if (queryResult.getJSONObject(i2).has(status.getQueryString().substring(1))) {
                String statusIRI = queryResult.getJSONObject(i2).getString(status.getQueryString().substring(1));
                String statusTypeIRI = queryResult.getJSONObject(i2).getString(statusType.getQueryString().substring(1));
                if (derived.getStatus() == null) {
                    derived.setStatus(statusIRI, statusTypeIRI);
                } else if (!derived.getStatus().getStatusIri().equals(statusIRI) || !derived.getStatus().getStatusRdfType().equals(statusTypeIRI)) {
                    throw new JPSRuntimeException("Multiple instances of OntoDerivation:Status were added to derivation <" + derived.getIri() + ">: " + Arrays.asList(derived.getStatus().getStatusIri(), statusIRI).toString());
                }
                if (queryResult.getJSONObject(i2).has(newDerivedIRI.getQueryString().substring(1))) {
                    Entity new_entity;
                    String newIRI = queryResult.getJSONObject(i2).getString(newDerivedIRI.getQueryString().substring(1));
                    if (newDerivedIRIMap.containsKey(newIRI)) {
                        new_entity = (Entity)newDerivedIRIMap.get(newIRI);
                    } else {
                        new_entity = new Entity(newIRI);
                        newDerivedIRIMap.put(newIRI, new_entity);
                    }
                    if (queryResult.getJSONObject(i2).has(newDerivedIRIRdfType.getQueryString().substring(1))) {
                        new_entity.setRdfType(queryResult.getJSONObject(i2).getString(newDerivedIRIRdfType.getQueryString().substring(1)));
                    }
                    derived.getStatus().addNewDerivedIRI(new_entity);
                }
            }
            derived.setAgentURL(urlString);
            derived.setTimestamp(derivedTimestamp);
        }
        return derivationList;
    }

    List<Derivation> getRootAndAllTargetUpstreamDerivations(String rootDerivationIRI, List<String> targetDerivationTypeList) {
        return this.getDerivations(rootDerivationIRI, targetDerivationTypeList, PropertyPaths.zeroOrMore(this.groupPropertyPath(PropertyPaths.path(isDerivedFrom, belongsTo))));
    }

    List<Derivation> getAllImmediateUpstreamDerivations(String rootDerivationIRI) {
        return this.getDerivations(rootDerivationIRI, derivationTypes, this.groupPropertyPath(PropertyPaths.path(isDerivedFrom, belongsTo)));
    }

    Derivation getDerivation(String rootDerivationIRI) {
        List<Derivation> derivations = this.getDerivations(rootDerivationIRI, derivationTypes, PLACEHOLDER_IRI);
        Derivation derivation = derivations.stream().filter(d -> d.getIri().contentEquals(rootDerivationIRI)).findFirst().get();
        return derivation;
    }

    List<Derivation> getAllDerivationsInKG() {
        return this.getRootAndAllTargetUpstreamDerivations(PLACEHOLDER, derivationTypes);
    }

    Derivation getDerivationWithImmediateDownstream(String targetDerivationIRI) {
        List<Derivation> derivations = this.getDerivations(targetDerivationIRI, derivationTypes, this.zeroOrOne(this.inversePath(this.groupPropertyPath(PropertyPaths.path(isDerivedFrom, this.zeroOrOne(belongsTo))))));
        Derivation derivation = derivations.stream().filter(d -> d.getIri().contentEquals(targetDerivationIRI)).findFirst().get();
        return derivation;
    }

    @Deprecated
    List<Derivation> getDerivations() {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable derivation = query.var();
        Variable input = query.var();
        Variable inputType = query.var();
        Variable entity = query.var();
        Variable entityType = query.var();
        Variable agentURL = query.var();
        Variable derivationTimestamp = query.var();
        Variable inputTimestamp = query.var();
        Variable derivationType = query.var();
        Operand[] entityTypeFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            entityTypeFilters[j] = Expressions.notEquals(entityType, classesToIgnore.get(j));
        }
        Operand[] inputTypeFilters = new Expression[classesToIgnore.size()];
        for (int j = 0; j < classesToIgnore.size(); ++j) {
            inputTypeFilters[j] = Expressions.notEquals(inputType, classesToIgnore.get(j));
        }
        TriplePattern derivationPattern = derivation.has((RdfPredicate)isDerivedFrom, input).andHas(PropertyPaths.path(isDerivedUsing, hasOperation, hasHttpUrl), agentURL).andHas(PropertyPaths.path(hasTime, inTimePosition, numericPosition), derivationTimestamp).andIsA(derivationType);
        TriplePattern entityPattern = entity.has((RdfPredicate)belongsTo, derivation);
        GraphPattern inputTimestampPattern = input.has(PropertyPaths.path(hasTime, inTimePosition, numericPosition), inputTimestamp).optional();
        GraphPattern inputTypePattern = input.isA(inputType).optional().filter(Expressions.and(inputTypeFilters));
        GraphPattern entityTypePattern = entity.isA(entityType).optional().filter(Expressions.and(entityTypeFilters));
        ((SelectQuery)query.select(derivation, input, entity, agentURL, derivationTimestamp, inputTimestamp, derivationType, inputType, entityType).where(derivationPattern, entityPattern, inputTimestampPattern, inputTypePattern, entityTypePattern)).prefix(p_derived, p_time, p_agent);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        HashMap<String, Derivation> derivationsMap = new HashMap<String, Derivation>();
        ArrayList<Derivation> derivationList = new ArrayList<Derivation>();
        HashMap<String, Entity> entitiesMap = new HashMap<String, Entity>();
        for (int i = 0; i < queryResult.length(); ++i) {
            Entity entity_entity;
            Entity input_entity;
            Derivation derived;
            String derivationIRI = queryResult.getJSONObject(i).getString(derivation.getQueryString().substring(1));
            String inputIRI = queryResult.getJSONObject(i).getString(input.getQueryString().substring(1));
            String entityIRI = queryResult.getJSONObject(i).getString(entity.getQueryString().substring(1));
            String urlString = queryResult.getJSONObject(i).getString(agentURL.getQueryString().substring(1));
            String derivedType = queryResult.getJSONObject(i).getString(derivationType.getQueryString().substring(1));
            long derivedTimestamp = queryResult.getJSONObject(i).getLong(derivationTimestamp.getQueryString().substring(1));
            if (derivationsMap.containsKey(derivationIRI)) {
                derived = (Derivation)derivationsMap.get(derivationIRI);
            } else {
                derived = new Derivation(derivationIRI, derivedType);
                derivationsMap.put(derivationIRI, derived);
                derivationList.add(derived);
            }
            if (entitiesMap.containsKey(inputIRI)) {
                input_entity = (Entity)entitiesMap.get(inputIRI);
            } else {
                input_entity = new Entity(inputIRI);
                entitiesMap.put(inputIRI, input_entity);
            }
            if (queryResult.getJSONObject(i).has(inputType.getQueryString().substring(1))) {
                input_entity.setRdfType(queryResult.getJSONObject(i).getString(inputType.getQueryString().substring(1)));
            }
            if (queryResult.getJSONObject(i).has(inputTimestamp.getQueryString().substring(1))) {
                long input_timestamp = queryResult.getJSONObject(i).getLong(inputTimestamp.getQueryString().substring(1));
                input_entity.setTimestamp(input_timestamp);
            }
            if (entitiesMap.containsKey(entityIRI)) {
                entity_entity = (Entity)entitiesMap.get(entityIRI);
            } else {
                entity_entity = new Entity(entityIRI);
                entitiesMap.put(entityIRI, entity_entity);
            }
            if (queryResult.getJSONObject(i).has(entityType.getQueryString().substring(1))) {
                entity_entity.setRdfType(queryResult.getJSONObject(i).getString(entityType.getQueryString().substring(1)));
            }
            derived.addEntity(entity_entity);
            derived.addInput(input_entity);
            derived.setAgentURL(urlString);
            derived.setTimestamp(derivedTimestamp);
        }
        return derivationList;
    }

    boolean validatePureInputs() {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable input = query.var();
        Variable derivation = query.var();
        Variable inputTimestamp = query.var();
        TriplePattern queryPattern = input.has((RdfPredicate)belongsTo, derivation).andHas(PropertyPaths.path(hasTime, inTimePosition, numericPosition), inputTimestamp);
        ((SelectQuery)query.prefix(p_time, p_derived)).where(queryPattern);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        return queryResult.length() <= 0;
    }

    @Deprecated
    void deleteBelongsTo(String derivation) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable entity = query.var();
        Variable predicate1 = query.var();
        Variable predicate2 = query.var();
        Variable subject = query.var();
        Variable object = query.var();
        TriplePattern delete_tp1 = entity.has((RdfPredicate)predicate1, object);
        TriplePattern delete_tp2 = subject.has((RdfPredicate)predicate2, entity);
        ModifyQuery modify = Queries.MODIFY();
        modify.delete(delete_tp1, delete_tp2).where(entity.has((RdfPredicate)belongsTo, Rdf.iri(derivation)), delete_tp1, subject.has((RdfPredicate)predicate2, entity).optional()).prefix(p_derived);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    boolean reconnectNewDerivedIRIs(List<TriplePattern> outputTriples, Map<String, List<String>> newIriDownstreamDerivationMap, String derivation, Long retrievedInputsAt) {
        ModifyQuery modify = Queries.MODIFY();
        SubSelect sub = GraphPatterns.select(new Projectable[0]);
        outputTriples.forEach(t -> modify.insert((TriplePattern)t));
        newIriDownstreamDerivationMap.forEach((newIRI, downstreamDerivations) -> {
            modify.insert(Rdf.iri(newIRI).has((RdfPredicate)belongsTo, Rdf.iri(derivation)));
            if (!downstreamDerivations.isEmpty()) {
                downstreamDerivations.stream().forEach(dd -> modify.insert(Rdf.iri(dd).has((RdfPredicate)isDerivedFrom, Rdf.iri(newIRI))));
            }
        });
        Variable d = SparqlBuilder.var("d");
        Variable ups = SparqlBuilder.var("ups");
        Variable e = SparqlBuilder.var("e");
        Variable p1 = SparqlBuilder.var("p1");
        Variable o = SparqlBuilder.var("o");
        Variable s = SparqlBuilder.var("s");
        Variable p2 = SparqlBuilder.var("p2");
        Variable unixtimeIRI = SparqlBuilder.var("timeIRI");
        Variable dTs = SparqlBuilder.var("dTs");
        Variable upsTs = SparqlBuilder.var("upsTs");
        Variable status = SparqlBuilder.var("status");
        Variable statusType = SparqlBuilder.var("statusType");
        Expression<?> tsFilter = Expressions.lt((Operand)dTs, (Operand)upsTs);
        GraphPattern derivationPattern = GraphPatterns.and(new ValuesPattern(d, Arrays.asList(Rdf.iri(derivation))), d.has(PropertyPaths.path(hasTime, inTimePosition), unixtimeIRI), unixtimeIRI.has((RdfPredicate)numericPosition, dTs), d.has(PropertyPaths.path(isDerivedFrom, this.zeroOrOne(belongsTo)), ups), ups.has(PropertyPaths.path(hasTime, inTimePosition, numericPosition), upsTs)).filter((Expression)tsFilter);
        GraphPatternNotTriples entityPattern = GraphPatterns.and(e.has((RdfPredicate)belongsTo, d), e.has((RdfPredicate)p1, o), s.has((RdfPredicate)p2, e).optional());
        TriplePattern tp1 = d.has((RdfPredicate)hasStatus, status);
        TriplePattern tp2 = status.isA(statusType);
        GraphPatternNotTriples statusQueryPattern = GraphPatterns.and(tp1, tp2).optional();
        sub.select(d, unixtimeIRI, dTs, status, statusType, e, p1, o, s, p2).where(derivationPattern, entityPattern, statusQueryPattern);
        TriplePattern deleteEntityAsSubject = e.has((RdfPredicate)p1, o);
        TriplePattern deleteEntityAsObject = s.has((RdfPredicate)p2, e);
        TriplePattern deleteOldTimestamp = unixtimeIRI.has((RdfPredicate)numericPosition, dTs);
        TriplePattern insertNewTimestamp = unixtimeIRI.has((RdfPredicate)numericPosition, retrievedInputsAt);
        ((ModifyQuery)modify.prefix(p_time, p_derived)).delete(deleteEntityAsSubject, deleteEntityAsObject, tp1, tp2, deleteOldTimestamp).insert(insertNewTimestamp).where(sub);
        try {
            if (this.storeClient.getClass() == RemoteStoreClient.class) {
                if (((RemoteStoreClient)this.storeClient).isUpdateEndpointBlazegraphBackended()) {
                    HttpResponse httpResponse = ((RemoteStoreClient)this.storeClient).executeUpdateByPost(modify.getQueryString());
                    if (httpResponse.getStatusLine().getStatusCode() != 204 && httpResponse.getEntity() != null) {
                        String html = EntityUtils.toString(httpResponse.getEntity());
                        Pattern pattern = Pattern.compile("mutationCount=(.*)</p");
                        Matcher matcher = pattern.matcher(html);
                        if (matcher.find() && Integer.parseInt(matcher.group(1)) > 0) {
                            LOGGER.debug("SPARQL update (" + modify.getQueryString() + ") executed with mutationCount=" + matcher.group(1));
                            return true;
                        }
                        LOGGER.debug("SPARQL update (" + modify.getQueryString() + ") executed with mutationCount=" + matcher.group(1));
                    }
                } else {
                    this.storeClient.executeUpdate(modify.getQueryString());
                }
            } else {
                this.storeClient.executeUpdate(modify.getQueryString());
            }
        }
        catch (IOException | ParseException exception) {
            throw new JPSRuntimeException(exception);
        }
        return false;
    }

    boolean updateFinishedAsyncDerivation(String derivation, Map<String, List<String>> newIriDownstreamDerivationMap) {
        ModifyQuery modify = Queries.MODIFY();
        SubSelect sub = GraphPatterns.select(new Projectable[0]);
        newIriDownstreamDerivationMap.forEach((newIRI, downstreamDerivations) -> {
            modify.insert(Rdf.iri(newIRI).has((RdfPredicate)belongsTo, Rdf.iri(derivation)));
            if (!downstreamDerivations.isEmpty()) {
                downstreamDerivations.stream().forEach(dd -> modify.insert(Rdf.iri(dd).has((RdfPredicate)isDerivedFrom, Rdf.iri(newIRI))));
            }
        });
        Variable d = SparqlBuilder.var("d");
        Variable ups = SparqlBuilder.var("ups");
        Variable downd = SparqlBuilder.var("dd");
        Variable e = SparqlBuilder.var("e");
        Variable p1 = SparqlBuilder.var("p1");
        Variable o = SparqlBuilder.var("o");
        Variable s = SparqlBuilder.var("s");
        Variable p2 = SparqlBuilder.var("p2");
        Variable unixtimeIRI = SparqlBuilder.var("timeIRI");
        Variable dTs = SparqlBuilder.var("dTs");
        Variable upsTs = SparqlBuilder.var("upsTs");
        Variable retrievedInputsAtTs = SparqlBuilder.var("retrievedInputsAt");
        Variable status = SparqlBuilder.var("status");
        Variable statusType = SparqlBuilder.var("statusType");
        Variable sndIRI = SparqlBuilder.var("sndIRI");
        Expression<?> tsFilter = Expressions.lt((Operand)dTs, (Operand)upsTs);
        GraphPattern derivationTsPattern = GraphPatterns.and(new ValuesPattern(d, Arrays.asList(Rdf.iri(derivation))), d.has(PropertyPaths.path(hasTime, inTimePosition), unixtimeIRI), unixtimeIRI.has((RdfPredicate)numericPosition, dTs), d.has(PropertyPaths.path(isDerivedFrom, this.zeroOrOne(belongsTo)), ups), ups.has(PropertyPaths.path(hasTime, inTimePosition, numericPosition), upsTs)).filter((Expression)tsFilter);
        TriplePattern retrievedInputsAtPattern = d.has((RdfPredicate)retrievedInputsAt, retrievedInputsAtTs);
        TriplePattern tp1 = d.has((RdfPredicate)hasStatus, status);
        TriplePattern tp2 = status.isA(statusType);
        TriplePattern tp3 = status.has((RdfPredicate)hasNewDerivedIRI, sndIRI);
        GraphPatternNotTriples statusQueryPattern = GraphPatterns.and(tp1, tp2, tp3);
        GraphPattern directedDownstreamPattern = downd.has((RdfPredicate)isDerivedFrom, d).optional();
        GraphPatternNotTriples entityPattern = GraphPatterns.and(e.has((RdfPredicate)belongsTo, d), e.has((RdfPredicate)p1, o), s.has((RdfPredicate)p2, e).optional()).optional();
        sub.select(d, unixtimeIRI, dTs, retrievedInputsAtTs, status, statusType, sndIRI, downd, e, p1, o, s, p2).where(derivationTsPattern, retrievedInputsAtPattern, statusQueryPattern, directedDownstreamPattern, entityPattern);
        TriplePattern deleteEntityAsSubject = e.has((RdfPredicate)p1, o);
        TriplePattern deleteEntityAsObject = s.has((RdfPredicate)p2, e);
        TriplePattern deleteDirectedDownstream = downd.has((RdfPredicate)isDerivedFrom, d);
        TriplePattern deleteOldTimestamp = unixtimeIRI.has((RdfPredicate)numericPosition, dTs);
        TriplePattern deleteRetrievedInputsAt = d.has((RdfPredicate)retrievedInputsAt, retrievedInputsAtTs);
        TriplePattern insertNewTimestamp = unixtimeIRI.has((RdfPredicate)numericPosition, retrievedInputsAtTs);
        ((ModifyQuery)modify.prefix(p_time, p_derived)).delete(deleteEntityAsSubject, deleteEntityAsObject, tp1, tp2, tp3, deleteDirectedDownstream, deleteOldTimestamp, deleteRetrievedInputsAt).insert(insertNewTimestamp).where(sub);
        try {
            if (this.storeClient.getClass() == RemoteStoreClient.class) {
                if (((RemoteStoreClient)this.storeClient).isUpdateEndpointBlazegraphBackended()) {
                    HttpResponse httpResponse = ((RemoteStoreClient)this.storeClient).executeUpdateByPost(modify.getQueryString());
                    if (httpResponse.getStatusLine().getStatusCode() != 204 && httpResponse.getEntity() != null) {
                        String html = EntityUtils.toString(httpResponse.getEntity());
                        Pattern pattern = Pattern.compile("mutationCount=(.*)</p");
                        Matcher matcher = pattern.matcher(html);
                        if (matcher.find() && Integer.parseInt(matcher.group(1)) > 0) {
                            LOGGER.debug("SPARQL update (" + modify.getQueryString() + ") executed with mutationCount=" + matcher.group(1));
                            return true;
                        }
                        LOGGER.debug("SPARQL update (" + modify.getQueryString() + ") executed with mutationCount=" + matcher.group(1));
                    }
                } else {
                    this.storeClient.executeUpdate(modify.getQueryString());
                }
            } else {
                this.storeClient.executeUpdate(modify.getQueryString());
            }
        }
        catch (IOException | ParseException exception) {
            throw new JPSRuntimeException(exception);
        }
        return false;
    }

    void dropAllDerivations() {
        List<Iri> derivationTypes = Arrays.asList(Derivation, DerivationWithTimeSeries, DerivationAsyn);
        ModifyQuery modify = Queries.MODIFY();
        SubSelect query = GraphPatterns.select(new Projectable[0]);
        Variable inputs = query.var();
        Variable entities = query.var();
        Variable derivation = query.var();
        Variable time = query.var();
        Variable time_unix_iri = query.var();
        Variable timestamp = query.var();
        Variable trs = query.var();
        Variable agent = query.var();
        Variable operation = query.var();
        Variable url = query.var();
        Variable derivationType = query.var();
        TriplePattern belongsToTp = entities.has((RdfPredicate)belongsTo, derivation);
        TriplePattern isDerivedFromTp = derivation.has((RdfPredicate)isDerivedFrom, inputs);
        TriplePattern derivationTypeTp = derivation.isA(derivationType);
        TriplePattern timestampTp1 = derivation.has((RdfPredicate)hasTime, time);
        TriplePattern timeTpAll1 = time.isA(InstantClass).andHas((RdfPredicate)inTimePosition, time_unix_iri);
        TriplePattern timeTpAll2 = time_unix_iri.isA(TimePosition).andHas((RdfPredicate)numericPosition, timestamp).andHas((RdfPredicate)hasTRS, trs);
        TriplePattern agentTp1 = derivation.has((RdfPredicate)isDerivedUsing, agent);
        TriplePattern agentTp2 = agent.isA(Service).andHas((RdfPredicate)hasOperation, operation);
        TriplePattern agentTp3 = operation.isA(Operation).andHas((RdfPredicate)hasHttpUrl, url);
        Variable status = query.var();
        Variable statusType = query.var();
        Variable newDerivedIRI = query.var();
        TriplePattern tp1 = derivation.has((RdfPredicate)hasStatus, status);
        TriplePattern tp2 = status.isA(statusType);
        TriplePattern tp3 = status.has((RdfPredicate)hasNewDerivedIRI, newDerivedIRI);
        GraphPattern gp = status.has((RdfPredicate)hasNewDerivedIRI, newDerivedIRI).optional();
        GraphPatternNotTriples asyncStatusGP = GraphPatterns.and(tp1, tp2, gp).optional();
        GraphPatternNotTriples queryPattern = GraphPatterns.and(new ValuesPattern(derivationType, derivationTypes), isDerivedFromTp, timestampTp1, timeTpAll1, timeTpAll2, agentTp1, derivationTypeTp, agentTp2.optional(), agentTp3.optional(), belongsToTp.optional(), asyncStatusGP);
        modify.delete(belongsToTp, isDerivedFromTp, timestampTp1, timeTpAll1, timeTpAll2, agentTp1, agentTp2, agentTp3, derivationTypeTp, tp1, tp2, tp3).where(queryPattern).prefix(p_time, p_derived, p_agent);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    void dropAllDerivationsNotOntoAgent() {
        List<Iri> derivationTypes = Arrays.asList(Derivation, DerivationWithTimeSeries, DerivationAsyn);
        ModifyQuery modify = Queries.MODIFY();
        SubSelect query = GraphPatterns.select(new Projectable[0]);
        Variable inputs = query.var();
        Variable entities = query.var();
        Variable derivation = query.var();
        Variable time = query.var();
        Variable time_unix_iri = query.var();
        Variable timestamp = query.var();
        Variable trs = query.var();
        Variable agent = query.var();
        Variable derivationType = query.var();
        TriplePattern belongsToTp = entities.has((RdfPredicate)belongsTo, derivation);
        TriplePattern isDerivedFromTp = derivation.has((RdfPredicate)isDerivedFrom, inputs);
        TriplePattern derivationTypeTp = derivation.isA(derivationType);
        TriplePattern timestampTp1 = derivation.has((RdfPredicate)hasTime, time);
        TriplePattern timeTpAll1 = time.isA(InstantClass).andHas((RdfPredicate)inTimePosition, time_unix_iri);
        TriplePattern timeTpAll2 = time_unix_iri.isA(TimePosition).andHas((RdfPredicate)numericPosition, timestamp).andHas((RdfPredicate)hasTRS, trs);
        TriplePattern agentTp1 = derivation.has((RdfPredicate)isDerivedUsing, agent);
        Variable status = query.var();
        Variable statusType = query.var();
        Variable newDerivedIRI = query.var();
        TriplePattern tp1 = derivation.has((RdfPredicate)hasStatus, status);
        TriplePattern tp2 = status.isA(statusType);
        TriplePattern tp3 = status.has((RdfPredicate)hasNewDerivedIRI, newDerivedIRI);
        GraphPattern gp = status.has((RdfPredicate)hasNewDerivedIRI, newDerivedIRI).optional();
        GraphPatternNotTriples asyncStatusGP = GraphPatterns.and(tp1, tp2, gp).optional();
        GraphPatternNotTriples queryPattern = GraphPatterns.and(new ValuesPattern(derivationType, derivationTypes), isDerivedFromTp, timestampTp1, timeTpAll1, timeTpAll2, agentTp1, derivationTypeTp, belongsToTp.optional(), asyncStatusGP);
        modify.delete(belongsToTp, isDerivedFromTp, timestampTp1, timeTpAll1, timeTpAll2, agentTp1, derivationTypeTp, tp1, tp2, tp3).where(queryPattern).prefix(p_time, p_derived, p_agent);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    void dropAllTimestamps() {
        ModifyQuery modify = Queries.MODIFY();
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable entity = query.var();
        Variable time = query.var();
        Variable time_unix_iri = query.var();
        Variable timestamp = query.var();
        Variable trs = query.var();
        TriplePattern tp1 = entity.has((RdfPredicate)hasTime, time);
        TriplePattern tp2 = time.isA(InstantClass).andHas((RdfPredicate)inTimePosition, time_unix_iri);
        TriplePattern tp3 = time_unix_iri.isA(TimePosition).andHas((RdfPredicate)numericPosition, timestamp).andHas((RdfPredicate)hasTRS, trs);
        modify.delete(tp1, tp2, tp3).where(tp1, tp2, tp3).prefix(p_time);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    void updateTimestamps(Map<String, Long> instanceTimestamp_map) {
        ArrayList<String> instances = new ArrayList<String>(instanceTimestamp_map.keySet());
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable inst = query.var();
        ValuesPattern instValuesPattern = new ValuesPattern(inst, instances.stream().map(i -> Rdf.iri(i)).collect(Collectors.toList()));
        Variable time_unix = query.var();
        TriplePattern gp1 = inst.has(PropertyPaths.path(hasTime, inTimePosition), time_unix);
        ((SelectQuery)query.select(inst, time_unix).where(gp1, instValuesPattern)).prefix(p_time);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        HashMap<String, String> instance_timeiri_map = new HashMap<String, String>();
        for (int i2 = 0; i2 < queryResult.length(); ++i2) {
            instance_timeiri_map.put(queryResult.getJSONObject(i2).getString(inst.getQueryString().substring(1)), queryResult.getJSONObject(i2).getString(time_unix.getQueryString().substring(1)));
        }
        instances = new ArrayList(instance_timeiri_map.keySet());
        ModifyQuery modify = Queries.MODIFY();
        Variable timestamp = query.var();
        TriplePattern[] insert_tp = new TriplePattern[instances.size()];
        ArrayList<Iri> timeIRIList = new ArrayList<Iri>();
        for (int i3 = 0; i3 < instances.size(); ++i3) {
            String instance = (String)instances.get(i3);
            Iri timeIRI = Rdf.iri((String)instance_timeiri_map.get(instance));
            insert_tp[i3] = timeIRI.has((RdfPredicate)numericPosition, instanceTimestamp_map.get(instance));
            timeIRIList.add(timeIRI);
        }
        TriplePattern delete_tp = time_unix.has((RdfPredicate)numericPosition, timestamp);
        ValuesPattern timeValuesPattern = new ValuesPattern(time_unix, timeIRIList);
        modify.delete(delete_tp).where(timeValuesPattern, delete_tp).insert(insert_tp).prefix(p_time);
        this.storeClient.executeUpdate(modify.getQueryString());
    }

    Map<String, String> getDerivationsOf(List<String> entities) {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable entity = query.var();
        Variable derivation = query.var();
        TriplePattern queryPattern = entity.has((RdfPredicate)belongsTo, derivation);
        ValuesPattern valuesPattern = new ValuesPattern(entity, entities.stream().map(e -> Rdf.iri(e)).collect(Collectors.toList()));
        ((SelectQuery)query.select(entity, derivation).where(queryPattern, valuesPattern)).prefix(p_derived);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        HashMap<String, String> entityDerivationMap = new HashMap<String, String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            entityDerivationMap.put(queryResult.getJSONObject(i).getString(entity.getQueryString().substring(1)), queryResult.getJSONObject(i).getString(derivation.getQueryString().substring(1)));
        }
        return entityDerivationMap;
    }

    @Deprecated
    Map<String, Long> retrieveInputReadTimestamp(String derivation) {
        HashMap<String, Long> derivationTime_map = new HashMap<String, Long>();
        String queryKey = "timestamp";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable time = SparqlBuilder.var(queryKey);
        TriplePattern queryPattern = Rdf.iri(derivation).has((RdfPredicate)retrievedInputsAt, time);
        ((SelectQuery)query.prefix(p_derived)).select(time).where(queryPattern);
        JSONArray queryResult = this.storeClient.executeQuery(query.getQueryString());
        if (queryResult.length() > 1) {
            throw new JPSRuntimeException("DerivedQuantitySparql: More than 1 time instance recorded for reading derivation inputs of <" + derivation + ">");
        }
        try {
            long inputReadTimestamp = queryResult.getJSONObject(0).getLong(queryKey);
            derivationTime_map.put(derivation, inputReadTimestamp);
            ModifyQuery modify = Queries.MODIFY();
            TriplePattern delete_timeRecord = Rdf.iri(derivation).has((RdfPredicate)retrievedInputsAt, inputReadTimestamp);
            ((ModifyQuery)modify.prefix(p_derived)).delete(delete_timeRecord);
            this.storeClient.executeUpdate(modify.getQueryString());
            return derivationTime_map;
        }
        catch (JSONException e) {
            throw new JPSRuntimeException("No timestamp recorded for reading derivation inputs of <" + derivation + ">. The derivation is probably not setup correctly.");
        }
    }

    private String getNameSpace(String iri) {
        if ((iri = this.trimIRI(iri)).contains("#")) {
            iri = iri.substring(0, iri.lastIndexOf("#") + 1);
        } else if (iri.contains("/")) {
            iri = iri.substring(0, iri.lastIndexOf("/") + 1);
        }
        return iri;
    }

    private String trimIRI(String iri) {
        if (iri.startsWith("<")) {
            iri = iri.substring(1);
        }
        if (iri.endsWith(">")) {
            iri = iri.substring(0, iri.length() - 1);
        }
        return iri;
    }

    private RdfPredicate groupPropertyPath(RdfPredicate aElement) {
        return () -> "(" + aElement.getQueryString() + ")";
    }

    private RdfPredicate zeroOrOne(RdfPredicate aElement) {
        return () -> aElement.getQueryString() + "?";
    }

    private RdfPredicate inversePath(RdfPredicate aElement) {
        return () -> "^" + aElement.getQueryString();
    }

    static {
        HashMap<String, StatusType> statusMap = new HashMap<String, StatusType>();
        statusMap.put(derivednamespace.concat(REQUESTED), StatusType.REQUESTED);
        statusMap.put(derivednamespace.concat(INPROGRESS), StatusType.INPROGRESS);
        statusMap.put(derivednamespace.concat(FINISHED), StatusType.FINISHED);
        statusToType = statusMap;
        HashMap<String, Iri> derivationTypeMap = new HashMap<String, Iri>();
        derivationTypeMap.put(derivednamespace.concat(DERIVATION), Derivation);
        derivationTypeMap.put(derivednamespace.concat(DERIVATIONWITHTIMESERIES), DerivationWithTimeSeries);
        derivationTypeMap.put(derivednamespace.concat(DERIVATIONASYN), DerivationAsyn);
        derivationToIri = derivationTypeMap;
        derivationTypes = derivationToIri.keySet().stream().collect(Collectors.toList());
        statusType = statusToType.keySet().stream().collect(Collectors.toList());
        LOGGER = LogManager.getLogger(DerivationSparql.class);
    }
}

