/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class DerivationOutputs {
    public static final String RETRIEVED_INPUTS_TIMESTAMP_KEY = "retrievedInputsAt";
    private Map<String, String> oldEntitiesMap = new HashMap<String, String>();
    private Map<String, List<String>> oldEntitiesDownstreamDerivationMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> newEntitiesMap = new HashMap<String, List<String>>();
    private List<TriplePattern> outputTriples = new ArrayList<TriplePattern>();
    private String thisDerivation = new String();
    private long retrievedInputsAt = 0L;
    public static final String OLD_ENTITIES_MAP_ERROR = "Serialise the given JSONObject to oldEntitiesMap Map<String, String> is not supported: ";
    public static final String OLD_ENTITIES_DOWNSTREAM_DERIVATION_MAP_ERROR = "Serialise the given JSONObject to oldEntitiesDownstreamDerivationMap Map<String, List<String>> is not supported: ";
    public static final String OLD_NEW_ENTITIES_MATCHING_ERROR = "When the agent writes new instances, make sure that there is 1 instance with matching rdf:type over the old set, old set: ";
    public static final String INVALID_IRI_ERROR = "Invalid IRI received when validating IRIs: ";
    public static final String INVALID_IRI_FOR_GET_CLASS_NAME_ERROR = "The provided rdf:type to getClassName should NOT end with '#' or '/', received IRI: ";

    public void setThisDerivation(String derivation) {
        this.thisDerivation = derivation;
    }

    public void setRetrievedInputsAt(long retrievedInputsAt) {
        this.retrievedInputsAt = retrievedInputsAt;
    }

    public void setOldEntitiesMap(JSONObject oldEntitiesRdfType) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> keys = oldEntitiesRdfType.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object val = oldEntitiesRdfType.get(key);
            if (val instanceof String) {
                map.put(key, (String)val);
                continue;
            }
            throw new JPSRuntimeException(OLD_ENTITIES_MAP_ERROR + oldEntitiesRdfType.toString());
        }
        this.oldEntitiesMap = map;
    }

    public void setOldEntitiesMap(Map<String, String> oldEntitiesRdfTypeMap) {
        this.oldEntitiesMap = oldEntitiesRdfTypeMap;
    }

    public void setOldEntitiesDownstreamDerivationMap(JSONObject oldEntitiesDownstreamDerivation) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Iterator<String> keys = oldEntitiesDownstreamDerivation.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object val = oldEntitiesDownstreamDerivation.get(key);
            if (val instanceof JSONArray) {
                map.put(key, ((JSONArray)val).toList().stream().map(iri -> (String)iri).collect(Collectors.toList()));
                continue;
            }
            if (val instanceof String) {
                map.put(key, new ArrayList<String>(Arrays.asList((String)val)));
                continue;
            }
            throw new JPSRuntimeException(OLD_ENTITIES_DOWNSTREAM_DERIVATION_MAP_ERROR + oldEntitiesDownstreamDerivation.toString());
        }
        this.oldEntitiesDownstreamDerivationMap = map;
    }

    public void setOldEntitiesDownstreamDerivationMap(Map<String, List<String>> oldEntitiesDownstreamDerivationMap) {
        this.oldEntitiesDownstreamDerivationMap = oldEntitiesDownstreamDerivationMap;
    }

    public void createNewEntity(String iri, String rdfType) {
        iri = this.trimIRI(iri);
        if (this.newEntitiesMap.containsKey(rdfType = this.trimIRI(rdfType))) {
            if (!this.newEntitiesMap.get(rdfType).contains(iri)) {
                this.newEntitiesMap.get(rdfType).add(iri);
                this.addTriple(iri, RDF.TYPE.toString(), rdfType);
            }
        } else {
            this.newEntitiesMap.put(rdfType, new ArrayList<String>(Arrays.asList(iri)));
            this.addTriple(iri, RDF.TYPE.toString(), rdfType);
        }
    }

    public String createNewEntityWithBaseUrl(String baseUrl, String rdfType) {
        baseUrl = this.trimIRI(baseUrl);
        rdfType = this.trimIRI(rdfType);
        String clz = this.getClassName(rdfType);
        if (!baseUrl.endsWith("/") && !baseUrl.endsWith("#")) {
            baseUrl = baseUrl + "/";
        }
        String iri = baseUrl + clz + "_" + UUID.randomUUID().toString();
        this.createNewEntity(iri, rdfType);
        return iri;
    }

    public void addTriple(TriplePattern triple) {
        this.addTriple(Arrays.asList(triple));
    }

    public void addTriple(List<TriplePattern> triples) {
        this.outputTriples.addAll(triples);
    }

    public void addTriple(String s, String p, String o) {
        s = this.trimIRI(s);
        p = this.trimIRI(p);
        o = this.trimIRI(o);
        try {
            if (new URI(o).isAbsolute()) {
                this.outputTriples.add(Rdf.iri(s).has((RdfPredicate)Rdf.iri(p), Rdf.iri(o)));
            } else {
                this.outputTriples.add(Rdf.iri(s).has((RdfPredicate)Rdf.iri(p), Rdf.literalOf(o)));
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void addTriple(String s, String p, Number o) {
        s = this.trimIRI(s);
        p = this.trimIRI(p);
        this.checkIfValidIri(Arrays.asList(s, p));
        this.outputTriples.add(Rdf.iri(s).has((RdfPredicate)Rdf.iri(p), Rdf.literalOf(o)));
    }

    public void addTriple(String s, String p, Boolean o) {
        s = this.trimIRI(s);
        p = this.trimIRI(p);
        this.checkIfValidIri(Arrays.asList(s, p));
        this.outputTriples.add(Rdf.iri(s).has((RdfPredicate)Rdf.iri(p), Rdf.literalOf(o)));
    }

    public void addTriple(String s, String p, String o, String dataType) {
        s = this.trimIRI(s);
        p = this.trimIRI(p);
        this.checkIfValidIri(Arrays.asList(s, p, dataType));
        this.outputTriples.add(Rdf.iri(s).has((RdfPredicate)Rdf.iri(p), Rdf.literalOfType(o, Rdf.iri(dataType))));
    }

    public List<TriplePattern> getOutputTriples() {
        return this.outputTriples;
    }

    public Map<String, List<String>> getNewEntitiesDownstreamDerivationMap() {
        HashMap<String, List<String>> newEntitiesDownstreamDerivationMap = new HashMap<String, List<String>>();
        this.newEntitiesMap.values().stream().flatMap(i -> i.stream()).forEach(iri -> newEntitiesDownstreamDerivationMap.put((String)iri, new ArrayList()));
        this.oldEntitiesDownstreamDerivationMap.forEach((iri, derivations) -> {
            List<String> matchingEntity = this.newEntitiesMap.get(this.oldEntitiesMap.get(iri));
            if (matchingEntity.size() != 1) {
                throw new JPSRuntimeException(OLD_NEW_ENTITIES_MATCHING_ERROR + this.oldEntitiesMap.toString() + ", new entities" + this.newEntitiesMap.toString());
            }
            ((List)newEntitiesDownstreamDerivationMap.get(matchingEntity.get(0))).addAll(derivations);
        });
        return newEntitiesDownstreamDerivationMap;
    }

    public JSONObject getNewEntitiesJsonMap() {
        JSONObject newEntitiesJson = new JSONObject();
        this.newEntitiesMap.forEach((rdfType, iris) -> iris.stream().forEach(iri -> newEntitiesJson.put((String)iri, rdfType)));
        return newEntitiesJson;
    }

    public long getRetrievedInputsAt() {
        return this.retrievedInputsAt;
    }

    public String getThisDerivation() {
        return this.thisDerivation;
    }

    public List<String> getNewDerivedIRI() {
        return this.newEntitiesMap.values().stream().flatMap(i -> i.stream()).collect(Collectors.toList());
    }

    void checkIfValidIri(List<String> strs) {
        strs.stream().forEach(s -> {
            try {
                new URI(this.trimIRI((String)s)).toURL();
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                e.printStackTrace();
                throw new JPSRuntimeException(INVALID_IRI_ERROR + s);
            }
        });
    }

    String trimIRI(String iri) {
        if (iri.startsWith("<")) {
            iri = iri.substring(1);
        }
        if (iri.endsWith(">")) {
            iri = iri.substring(0, iri.length() - 1);
        }
        return iri;
    }

    String getClassName(String rdfType) {
        if ((rdfType = this.trimIRI(rdfType)).endsWith("#") || rdfType.endsWith("/")) {
            throw new JPSRuntimeException(INVALID_IRI_FOR_GET_CLASS_NAME_ERROR + rdfType);
        }
        if (rdfType.contains("#")) {
            String temp = rdfType.substring(rdfType.lastIndexOf("#") + 1);
            if (!temp.contains("/")) {
                return temp;
            }
            return temp.substring(temp.lastIndexOf("/") + 1);
        }
        return rdfType.substring(rdfType.lastIndexOf("/") + 1);
    }
}

