/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.derivation.Derivation;
import uk.ac.cam.cares.jps.base.derivation.DerivationSparql;
import uk.ac.cam.cares.jps.base.derivation.Entity;
import uk.ac.cam.cares.jps.base.derivation.StatusType;
import uk.ac.cam.cares.jps.base.discovery.AgentCaller;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class DerivationClient {
    public static final String AGENT_INPUT_KEY = "agent_input";
    public static final String AGENT_OUTPUT_KEY = "agent_output";
    public static final String BELONGSTO_KEY = "belongsTo";
    public static final String DERIVATION_KEY = "derivation";
    public static final String DERIVATION_TYPE_KEY = "derivation_rdftype";
    public static final String DOWNSTREAMDERIVATION_KEY = "downstream_derivation";
    public static final String SYNC_NEW_INFO_FLAG = "sync_new_info";
    public static final String AGENT_IRI_KEY = "agent_service_iri";
    public static final String GET_AGENT_INPUT_PARAMS_KEY_JPSHTTPSERVLET = "?query=";
    StoreClientInterface kbClient;
    DerivationSparql sparqlClient;
    boolean upstreamDerivationRequested;
    private static final Logger LOGGER = LogManager.getLogger(DerivationClient.class);

    @Deprecated
    public DerivationClient(StoreClientInterface kbClient) {
        this.kbClient = kbClient;
        this.sparqlClient = new DerivationSparql(kbClient);
    }

    public DerivationClient(StoreClientInterface kbClient, String derivationInstanceBaseURL) {
        this.kbClient = kbClient;
        this.sparqlClient = new DerivationSparql(kbClient, derivationInstanceBaseURL);
    }

    public String createDerivation(List<String> entities, String agentIRI, String agentURL, List<String> inputsIRI) {
        String createdDerivation = this.sparqlClient.createDerivation(entities, agentIRI, agentURL, inputsIRI);
        this.sparqlClient.addTimeInstance(createdDerivation);
        LOGGER.info("Instantiated derivation <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + "> located at " + agentURL);
        return createdDerivation;
    }

    public List<String> bulkCreateDerivations(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList) {
        List<String> derivations = this.sparqlClient.bulkCreateDerivations(entitiesList, agentIRIList, agentURLList, inputsList);
        LOGGER.info("Instantiated derivations " + derivations);
        this.sparqlClient.addTimeInstance(derivations);
        return derivations;
    }

    public String createDerivation(List<String> entities, String agentIRI, List<String> inputsIRI) {
        String createdDerivation = this.sparqlClient.createDerivation(entities, agentIRI, inputsIRI);
        this.sparqlClient.addTimeInstance(createdDerivation);
        LOGGER.info("Instantiated derivation <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + ">");
        return createdDerivation;
    }

    public String createDerivationWithTimeSeries(List<String> entities, String agentIRI, String agentURL, List<String> inputsIRI) {
        String createdDerivation = this.sparqlClient.createDerivationWithTimeSeries(entities, agentIRI, agentURL, inputsIRI);
        this.sparqlClient.addTimeInstance(createdDerivation);
        LOGGER.info("Instantiated derivation with time series <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + "> located at " + agentURL);
        return createdDerivation;
    }

    public List<String> bulkCreateDerivationsWithTimeSeries(List<List<String>> entitiesList, List<String> agentIRIList, List<String> agentURLList, List<List<String>> inputsList) {
        List<String> derivations = this.sparqlClient.bulkCreateDerivationsWithTimeSeries(entitiesList, agentIRIList, agentURLList, inputsList);
        LOGGER.info("Instantiated derivations with time series " + derivations);
        this.sparqlClient.addTimeInstance(derivations);
        return derivations;
    }

    public Derivation createSyncDerivationForNewInfo(String agentIRI, List<String> inputsIRI, String derivationType) throws ClientProtocolException, IOException {
        String agentURL = this.sparqlClient.getAgentUrlGivenAgentIRI(agentIRI);
        return this.createSyncDerivationForNewInfo(agentIRI, agentURL, inputsIRI, derivationType);
    }

    public Derivation createSyncDerivationForNewInfo(String agentIRI, String agentURL, List<String> inputsIRI, String derivationType) throws ClientProtocolException, IOException {
        String derivationIRI = this.sparqlClient.createDerivationIRI();
        Derivation createdDerivation = new Derivation(derivationIRI, derivationType);
        JSONObject mappedInputs = this.sparqlClient.mapInstancesToAgentInputs(inputsIRI, agentIRI);
        Iterator<String> inputTypes = mappedInputs.keys();
        while (inputTypes.hasNext()) {
            String rdfType = inputTypes.next();
            mappedInputs.getJSONArray(rdfType).toList().stream().forEach(iri -> {
                Entity inp = new Entity((String)iri);
                inp.setRdfType(rdfType);
                createdDerivation.addInput(inp);
            });
        }
        JSONObject requestParams = new JSONObject();
        requestParams.put(AGENT_INPUT_KEY, mappedInputs);
        requestParams.put(DERIVATION_KEY, derivationIRI);
        requestParams.put(DERIVATION_TYPE_KEY, derivationType);
        requestParams.put(SYNC_NEW_INFO_FLAG, true);
        requestParams.put(AGENT_IRI_KEY, agentIRI);
        LOGGER.debug("Creating <" + derivationIRI + "> using agent at <" + agentURL + "> with http request " + requestParams);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String originalRequest = agentURL + GET_AGENT_INPUT_PARAMS_KEY_JPSHTTPSERVLET + requestParams.toString();
        HttpGet httpGet = new HttpGet(agentURL + GET_AGENT_INPUT_PARAMS_KEY_JPSHTTPSERVLET + URLEncoder.encode(requestParams.toString(), StandardCharsets.UTF_8.toString()));
        CloseableHttpResponse httpResponse = httpClient.execute(httpGet);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            String msg = "Failed to update derivation <" + derivationIRI + "> with original request: " + originalRequest;
            String body = EntityUtils.toString(httpResponse.getEntity());
            LOGGER.error(msg);
            throw new JPSRuntimeException(msg + " Error body: " + body);
        }
        String response = EntityUtils.toString(httpResponse.getEntity());
        LOGGER.debug("Obtained http response from agent: " + response);
        JSONObject agentResponse = new JSONObject(response);
        Iterator<String> keys = agentResponse.getJSONObject(AGENT_OUTPUT_KEY).keys();
        while (keys.hasNext()) {
            String iri2 = keys.next();
            Entity ne = new Entity(iri2);
            ne.setRdfType(agentResponse.getJSONObject(AGENT_OUTPUT_KEY).getString(iri2));
            createdDerivation.addEntity(ne);
        }
        LOGGER.info("Instantiated derivation <" + createdDerivation.getIri() + "> with derivation type <" + createdDerivation.getRdfType() + ">");
        LOGGER.debug("<" + createdDerivation.getEntitiesIri() + "> belongsTo <" + createdDerivation.getIri() + ">");
        LOGGER.debug("<" + createdDerivation.getIri() + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation.getIri() + "> isDerivedUsing <" + agentIRI + ">");
        return createdDerivation;
    }

    public void writeSyncDerivationNewInfo(List<TriplePattern> outputTriples, List<String> entities, String agentIRI, List<String> inputsIRI, String derivationIRI, String derivationType, Long retrievedInputsAt) {
        this.sparqlClient.writeSyncDerivationNewInfo(outputTriples, entities, agentIRI, inputsIRI, derivationIRI, derivationType, retrievedInputsAt);
    }

    public String createAsyncDerivation(List<String> entities, String agentIRI, List<String> inputsIRI, boolean forUpdate) {
        String createdDerivation = this.sparqlClient.createDerivationAsync(entities, agentIRI, inputsIRI, forUpdate);
        this.sparqlClient.addTimeInstance(createdDerivation);
        if (!forUpdate) {
            this.sparqlClient.updateTimeStamp(createdDerivation);
        }
        LOGGER.info("Instantiated asynchronous derivation <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + ">");
        return createdDerivation;
    }

    public String createAsyncDerivation(List<String> entities, String agentIRI, String derivation, boolean forUpdate) {
        List<String> inputsIRI = this.sparqlClient.retrieveMatchingInstances(derivation, agentIRI);
        return this.createAsyncDerivation(entities, agentIRI, inputsIRI, forUpdate);
    }

    public String createAsyncDerivationForNewInfo(String agentIRI, List<String> inputsAndDerivations) {
        return this.createAsyncDerivation(new ArrayList<String>(), agentIRI, inputsAndDerivations, true);
    }

    public List<String> bulkCreateAsyncDerivations(List<List<String>> entitiesList, List<String> agentIRIList, List<List<String>> inputsList, List<Boolean> forUpdateFlagList) {
        List<String> derivations = this.sparqlClient.bulkCreateDerivationsAsync(entitiesList, agentIRIList, inputsList, forUpdateFlagList);
        LOGGER.info("Instantiated asynchronous derivations " + derivations);
        this.sparqlClient.addTimeInstance(derivations);
        for (int i = 0; i < derivations.size(); ++i) {
            if (forUpdateFlagList.get(i).booleanValue()) continue;
            this.sparqlClient.updateTimeStamp(derivations.get(i));
        }
        return derivations;
    }

    public List<String> bulkCreateAsyncDerivationsForNewInfo(List<String> agentIRIList, List<List<String>> inputsAndDerivationsList) {
        List<List<String>> entitiesList = IntStream.range(0, agentIRIList.size()).mapToObj(i -> new ArrayList()).collect(Collectors.toList());
        List<Boolean> forAsyncUpdateFlagList = IntStream.range(0, entitiesList.size()).mapToObj(i -> true).collect(Collectors.toList());
        List<String> derivations = this.sparqlClient.bulkCreateDerivationsAsync(entitiesList, agentIRIList, inputsAndDerivationsList, forAsyncUpdateFlagList);
        LOGGER.info("Instantiated asynchronous derivations " + derivations);
        this.sparqlClient.addTimeInstance(derivations);
        return derivations;
    }

    public void addTimeInstance(String entity) {
        this.sparqlClient.addTimeInstance(entity);
        LOGGER.info("Added timestamp to <" + entity + ">");
    }

    public void addTimeInstance(List<String> entities) {
        this.sparqlClient.addTimeInstance(entities);
        LOGGER.info("Added timestamps to <" + entities + ">");
    }

    public void updateTimestamps(List<String> entities) {
        Map<String, String> entityDerivationMap = this.sparqlClient.getDerivationsOf(entities);
        HashMap<String, Long> timestamp_map = new HashMap<String, Long>();
        long currentTime = Instant.now().getEpochSecond();
        for (String entity : entities) {
            if (entityDerivationMap.containsKey(entity)) {
                timestamp_map.put(entityDerivationMap.get(entity), currentTime);
                continue;
            }
            timestamp_map.put(entity, currentTime);
        }
        this.sparqlClient.updateTimestamps(timestamp_map);
    }

    public void updateTimestamp(String entity) {
        this.updateTimestamps(Arrays.asList(entity));
    }

    @Deprecated
    public void updateDerivationAsyn(String derivationIRI) {
        DirectedAcyclicGraph<String, DefaultEdge> graph = new DirectedAcyclicGraph<String, DefaultEdge>(DefaultEdge.class);
        try {
            this.upstreamDerivationRequested = false;
            this.updateDerivationAsyn(derivationIRI, graph);
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    public void updateMixedAsyncDerivation(String derivationIRI) {
        DirectedAcyclicGraph<String, DefaultEdge> graph = new DirectedAcyclicGraph<String, DefaultEdge>(DefaultEdge.class);
        Derivation derivation = this.sparqlClient.getDerivation(derivationIRI);
        try {
            this.updateMixedAsyncDerivation(derivation, graph);
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    public void updatePureSyncDerivation(String derivationIRI) {
        this.updatePureSyncDerivations(Arrays.asList(derivationIRI));
    }

    public void updatePureSyncDerivations(List<String> derivationIRIs) {
        DirectedAcyclicGraph<String, DefaultEdge> graph = new DirectedAcyclicGraph<String, DefaultEdge>(DefaultEdge.class);
        List<Derivation> derivations = this.sparqlClient.getAllDerivationsInKG();
        try {
            for (String derivationIRI : derivationIRIs) {
                Derivation derivation = derivations.stream().filter(d -> d.getIri().equals(derivationIRI)).findFirst().get();
                this.updatePureSyncDerivation(derivation, graph);
            }
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    public void updateAllSyncDerivations() {
        List<Derivation> derivations = this.sparqlClient.getAllDerivationsInKG();
        ArrayList<Derivation> topNodes = new ArrayList<Derivation>();
        for (Derivation derivation : derivations) {
            if (!derivation.getEntities().stream().allMatch(e -> !e.isInputToDerivation())) continue;
            topNodes.add(derivation);
        }
        DirectedAcyclicGraph<String, DefaultEdge> graph = new DirectedAcyclicGraph<String, DefaultEdge>(DefaultEdge.class);
        try {
            for (Derivation derivation : topNodes) {
                this.updatePureSyncDerivation(derivation, graph);
            }
        }
        catch (Exception exception) {
            LOGGER.fatal(exception.getMessage());
            throw new JPSRuntimeException(exception);
        }
    }

    public void unifiedUpdateDerivation(String derivationIRI) {
        try {
            if (this.isDerivedAsynchronous(derivationIRI)) {
                this.updateMixedAsyncDerivation(derivationIRI);
            } else {
                this.updatePureSyncDerivations(Arrays.asList(derivationIRI));
            }
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    @Deprecated
    public void updateDerivations(List<String> derivedIRIs) {
        DirectedAcyclicGraph<String, DefaultEdge> graph = new DirectedAcyclicGraph<String, DefaultEdge>(DefaultEdge.class);
        List<Derivation> derivations = this.sparqlClient.getDerivations();
        try {
            for (String derivedIRI : derivedIRIs) {
                Derivation derivation = derivations.stream().filter(d -> d.getIri().equals(derivedIRI)).findFirst().get();
                this.updateDerivation(derivation, graph);
            }
            HashMap<String, Long> derivationTime_map = new HashMap<String, Long>();
            for (Derivation derivation : derivations) {
                if (!derivation.getUpdateStatus()) continue;
                derivationTime_map.put(derivation.getIri(), derivation.getTimestamp());
            }
            this.sparqlClient.updateTimestamps(derivationTime_map);
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    @Deprecated
    public void updateDerivations() {
        List<Derivation> derivations = this.sparqlClient.getDerivations();
        ArrayList<Derivation> topNodes = new ArrayList<Derivation>();
        for (Derivation derivation : derivations) {
            if (!derivation.getEntities().stream().allMatch(e -> !e.isInputToDerivation())) continue;
            topNodes.add(derivation);
        }
        DirectedAcyclicGraph<String, DefaultEdge> graph = new DirectedAcyclicGraph<String, DefaultEdge>(DefaultEdge.class);
        try {
            for (Derivation derivation : topNodes) {
                this.updateDerivation(derivation, graph);
            }
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (Derivation derivation : derivations) {
                if (!derivation.getUpdateStatus()) continue;
                hashMap.put(derivation.getIri(), derivation.getTimestamp());
            }
            this.sparqlClient.updateTimestamps(hashMap);
        }
        catch (Exception exception) {
            LOGGER.fatal(exception.getMessage());
            throw new JPSRuntimeException(exception);
        }
    }

    public boolean validateDerivations() {
        if (!this.sparqlClient.validatePureInputs()) {
            throw new JPSRuntimeException("Entities belonging to a derivation should not have timestamps attached");
        }
        List<Derivation> derivations = this.sparqlClient.getAllDerivationsInKG();
        ArrayList<Derivation> topNodes = new ArrayList<Derivation>();
        for (Derivation derivation : derivations) {
            if (!derivation.getEntities().isEmpty()) {
                if (!derivation.getEntities().stream().allMatch(e -> !e.isInputToDerivation())) continue;
                topNodes.add(derivation);
                continue;
            }
            if (!derivation.getDirectedDownstreams().isEmpty()) continue;
            topNodes.add(derivation);
        }
        DirectedAcyclicGraph<String, DefaultEdge> graph = new DirectedAcyclicGraph<String, DefaultEdge>(DefaultEdge.class);
        try {
            for (Derivation derivation : topNodes) {
                this.validateDerivation(derivation, graph);
            }
        }
        catch (Exception exception) {
            LOGGER.fatal(exception.getMessage());
            throw new JPSRuntimeException(exception);
        }
        return true;
    }

    public JSONObject retrieveAgentInputIRIs(String derivation, String agentIRI) {
        JSONObject agentInputs = new JSONObject();
        agentInputs.put(AGENT_INPUT_KEY, this.sparqlClient.getInputsMapToAgent(derivation, agentIRI));
        this.sparqlClient.updateStatusBeforeSetupJob(derivation);
        return agentInputs;
    }

    public void dropAllDerivationsAndTimestamps() {
        this.dropAllDerivations();
        this.dropAllTimestamps();
    }

    public void dropAllDerivationsAndTimestampsNotOntoAgent() {
        this.dropAllDerivationsNotOntoAgent();
        this.dropAllTimestamps();
    }

    public void dropAllDerivations() {
        this.sparqlClient.dropAllDerivations();
        LOGGER.info("Dropped all derivations");
    }

    public void dropAllDerivationsNotOntoAgent() {
        this.sparqlClient.dropAllDerivationsNotOntoAgent();
        LOGGER.info("Dropped all derivations but not OntoAgent triples");
    }

    public void dropAllTimestamps() {
        this.sparqlClient.dropAllTimestamps();
        LOGGER.info("Dropped all timestamps");
    }

    public void updateStatusAtJobCompletion(String derivation, List<String> newDerivedIRI, List<TriplePattern> newTriples) {
        this.sparqlClient.updateStatusAtJobCompletion(derivation, newDerivedIRI, newTriples);
    }

    public Map<String, List<String>> checkImmediateUpstreamDerivation(String derivation) {
        Map<String, List<String>> upstreamDerivationsNeedUpdate = this.sparqlClient.getUpstreamDerivationsNeedUpdate(derivation);
        return upstreamDerivationsNeedUpdate;
    }

    public List<String> groupSyncDerivationsToUpdate(Map<String, List<String>> derivationsToUpdate) {
        ArrayList<String> syncDerivations = new ArrayList<String>();
        if (!derivationsToUpdate.isEmpty()) {
            for (String rdfType : Arrays.asList(DerivationSparql.ONTODERIVATION_DERIVATION, DerivationSparql.ONTODERIVATION_DERIVATIONWITHTIMESERIES)) {
                if (!derivationsToUpdate.containsKey(rdfType)) continue;
                syncDerivations.addAll((Collection<String>)derivationsToUpdate.get(rdfType));
            }
        }
        return syncDerivations;
    }

    public void cleanUpFinishedDerivationUpdate(String derivation) {
        List<Derivation> directedDownstream;
        Derivation finishedDerivation = this.sparqlClient.getDerivationWithImmediateDownstream(derivation);
        List oldEntitiesAsInput = finishedDerivation.getEntities().stream().filter(e -> e.isInputToDerivation()).collect(Collectors.toList());
        List<Entity> newEntities = finishedDerivation.getStatus().getNewDerivedIRI();
        HashMap<String, List<String>> newIriDownstreamDerivationMap = new HashMap<String, List<String>>();
        newEntities.stream().forEach(e -> newIriDownstreamDerivationMap.put(e.getIri(), new ArrayList()));
        if (oldEntitiesAsInput.size() > 0) {
            LOGGER.debug("This derivation contains at least one entity which is an input to another derivation");
            LOGGER.debug("Relinking new instance(s) to the derivation by matching their rdf:type");
            for (Entity oldInput : oldEntitiesAsInput) {
                List matchingEntity = newEntities.stream().filter(e -> e.getRdfType().equals(oldInput.getRdfType())).collect(Collectors.toList());
                if (matchingEntity.size() != 1) {
                    String errmsg = "When the agent writes new instances, make sure that there is 1 instance with matching rdf:type over the old set";
                    LOGGER.error(errmsg);
                    LOGGER.error("Number of matching entities = " + matchingEntity.size());
                    throw new JPSRuntimeException(errmsg);
                }
                ((List)newIriDownstreamDerivationMap.get(((Entity)matchingEntity.get(0)).getIri())).addAll(oldInput.getInputOf().stream().map(d -> d.getIri()).collect(Collectors.toList()));
            }
        }
        if (!(directedDownstream = finishedDerivation.getDirectedDownstreams()).isEmpty()) {
            Map<String, List<String>> map = this.sparqlClient.matchNewDerivedIriToDownsFroNewInfo(newEntities.stream().map(e -> e.getIri()).collect(Collectors.toList()), directedDownstream.stream().map(d -> d.getIri()).collect(Collectors.toList()));
            map.forEach((inst, derivs) -> {
                if (newIriDownstreamDerivationMap.containsKey(inst)) {
                    ((List)newIriDownstreamDerivationMap.get(inst)).addAll(derivs);
                } else {
                    newIriDownstreamDerivationMap.put((String)inst, (List<String>)derivs);
                }
            });
        }
        this.sparqlClient.updateFinishedAsyncDerivation(derivation, newIriDownstreamDerivationMap);
    }

    public boolean isDerivedAsynchronous(String derivation) {
        return this.sparqlClient.isDerivedAsynchronous(derivation);
    }

    public StatusType getStatusType(String derivation) {
        return this.sparqlClient.getStatusType(derivation);
    }

    public List<String> getNewDerivedIRI(String derivation) {
        return this.sparqlClient.getNewDerivedIRI(derivation);
    }

    public String getAgentUrl(String derivedQuantity) {
        return this.sparqlClient.getAgentUrl(derivedQuantity);
    }

    public List<String> getDerivations(String agentIRI) {
        return this.sparqlClient.getDerivations(agentIRI);
    }

    public Map<String, StatusType> getDerivationsAndStatusType(String agentIRI) {
        return this.sparqlClient.getDerivationsAndStatusType(agentIRI);
    }

    public Map<String, String> getDerivationsOf(List<String> entities) {
        return this.sparqlClient.getDerivationsOf(entities);
    }

    public boolean reconnectNewDerivedIRIs(List<TriplePattern> outputTriples, Map<String, List<String>> newIriDownstreamDerivationMap, String derivation, Long retrievedInputsAt) {
        return this.sparqlClient.reconnectNewDerivedIRIs(outputTriples, newIriDownstreamDerivationMap, derivation, retrievedInputsAt);
    }

    public Derivation getDerivation(String derivationIRI) {
        return this.sparqlClient.getDerivation(derivationIRI);
    }

    @Deprecated
    private void updateDerivationAsyn(String instance, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<String> inputsAndDerived = this.sparqlClient.getInputsAndDerived(instance);
        if (!graph.containsVertex(instance)) {
            graph.addVertex(instance);
        }
        for (String input : inputsAndDerived) {
            if (!graph.addVertex(input) || null == graph.addEdge(instance, input)) continue;
            this.updateDerivationAsyn(input, graph);
        }
        List<String> inputs = this.sparqlClient.getInputs(instance);
        if (inputs.size() > 0 && this.isDerivedAsynchronous(instance)) {
            if (this.isOutOfDate(instance, inputs)) {
                if (!this.sparqlClient.hasStatus(instance)) {
                    this.sparqlClient.markAsRequested(instance);
                }
                this.upstreamDerivationRequested = true;
            } else if (this.upstreamDerivationRequested && !this.sparqlClient.hasStatus(instance)) {
                this.sparqlClient.markAsRequested(instance);
            }
        }
    }

    private void updateMixedAsyncDerivation(Derivation derivation, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<Derivation> immediateUpstreamDerivations = this.sparqlClient.getAllImmediateUpstreamDerivations(derivation.getIri());
        if (!graph.containsVertex(derivation.getIri())) {
            graph.addVertex(derivation.getIri());
        }
        for (Derivation upstream : immediateUpstreamDerivations) {
            if (!(graph.addVertex(upstream.getIri()) & null != graph.addEdge(derivation.getIri(), upstream.getIri()))) continue;
            this.updateMixedAsyncDerivation(upstream, graph);
        }
        this.sparqlClient.markAsRequestedIfOutdated(derivation.getIri());
    }

    private void updatePureSyncDerivation(Derivation derivation, DirectedAcyclicGraph<String, DefaultEdge> graph) throws ClientProtocolException, IOException {
        List<Derivation> upstreamDerivations = derivation.getInputsWithBelongsTo();
        if (!graph.containsVertex(derivation.getIri())) {
            graph.addVertex(derivation.getIri());
        }
        for (Derivation upstream : upstreamDerivations) {
            if (!(graph.addVertex(upstream.getIri()) & null != graph.addEdge(derivation.getIri(), upstream.getIri()))) continue;
            this.updatePureSyncDerivation(upstream, graph);
        }
        List<String> inputs = derivation.getAgentInputs();
        if (inputs.size() > 0 && derivation.isOutOfDate()) {
            LOGGER.info("Updating <" + derivation.getIri() + ">");
            String agentURL = derivation.getAgentURL();
            JSONObject requestParams = new JSONObject();
            requestParams.put(AGENT_INPUT_KEY, derivation.getAgentInputsMap());
            requestParams.put(BELONGSTO_KEY, derivation.getBelongsToMap());
            requestParams.put(DERIVATION_KEY, derivation.getIri());
            requestParams.put(DERIVATION_TYPE_KEY, derivation.getRdfType());
            requestParams.put(DOWNSTREAMDERIVATION_KEY, derivation.getDownstreamDerivationMap());
            requestParams.put(SYNC_NEW_INFO_FLAG, false);
            LOGGER.debug("Updating <" + derivation.getIri() + "> using agent at <" + agentURL + "> with http request " + requestParams);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String originalRequest = agentURL + GET_AGENT_INPUT_PARAMS_KEY_JPSHTTPSERVLET + requestParams.toString();
            HttpGet httpGet = new HttpGet(agentURL + GET_AGENT_INPUT_PARAMS_KEY_JPSHTTPSERVLET + URLEncoder.encode(requestParams.toString(), StandardCharsets.UTF_8.toString()));
            CloseableHttpResponse httpResponse = httpClient.execute(httpGet);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String msg = "Failed to update derivation <" + derivation.getIri() + "> with original request: " + originalRequest;
                String body = EntityUtils.toString(httpResponse.getEntity());
                LOGGER.error(msg);
                throw new JPSRuntimeException(msg + " Error body: " + body);
            }
            String response = EntityUtils.toString(httpResponse.getEntity());
            LOGGER.debug("Obtained http response from agent: " + response);
            JSONObject agentResponse = new JSONObject(response);
            derivation.setTimestamp(agentResponse.getLong("retrievedInputsAt"));
            if (!derivation.isDerivationWithTimeSeries()) {
                List inputToAnotherDerivation = derivation.getEntities().stream().filter(e -> e.isInputToDerivation()).collect(Collectors.toList());
                ArrayList<Entity> newEntities = new ArrayList<Entity>();
                Iterator<String> keys = agentResponse.getJSONObject(AGENT_OUTPUT_KEY).keys();
                while (keys.hasNext()) {
                    String iri = keys.next();
                    Entity ne = new Entity(iri);
                    ne.setRdfType(agentResponse.getJSONObject(AGENT_OUTPUT_KEY).getString(iri));
                    newEntities.add(ne);
                }
                if (inputToAnotherDerivation.size() > 0) {
                    LOGGER.debug("This derivation contains at least one entity which is an input to another derivation");
                    LOGGER.debug("Relinking new instance(s) to the derivation by matching their rdf:type");
                    for (Entity oldInput : inputToAnotherDerivation) {
                        List matchingEntity = newEntities.stream().filter(e -> e.getRdfType().equals(oldInput.getRdfType())).collect(Collectors.toList());
                        if (matchingEntity.size() != 1) {
                            String errmsg = "When the agent writes new instances, make sure that there is 1 instance with matching rdf:type over the old set";
                            LOGGER.error(errmsg);
                            LOGGER.error("Number of matching entities = " + matchingEntity.size());
                            throw new JPSRuntimeException(errmsg);
                        }
                        oldInput.getInputOf().forEach(d -> {
                            Derivation derivationToReconnect = d;
                            derivationToReconnect.addInput((Entity)matchingEntity.get(0));
                            derivationToReconnect.removeInput(oldInput);
                        });
                    }
                }
                if (!newEntities.isEmpty()) {
                    derivation.replaceEntities(newEntities);
                }
            } else {
                this.sparqlClient.updateTimestampDeleteStatus(derivation.getIri(), derivation.getTimestamp());
            }
        }
    }

    @Deprecated
    private void updateDerivation(Derivation derivation, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<Derivation> inputsWithBelongsTo = derivation.getInputsWithBelongsTo();
        if (!graph.containsVertex(derivation.getIri())) {
            graph.addVertex(derivation.getIri());
        }
        for (Derivation input : inputsWithBelongsTo) {
            if (!graph.containsVertex(input.getIri())) {
                graph.addVertex(input.getIri());
            }
            if (null == graph.addEdge(derivation.getIri(), input.getIri())) continue;
            this.updateDerivation(input, graph);
        }
        List<String> inputs = derivation.getAgentInputs();
        if (inputs.size() > 0 && derivation.isOutOfDate()) {
            LOGGER.info("Updating <" + derivation.getIri() + ">");
            String agentURL = derivation.getAgentURL();
            JSONObject requestParams = new JSONObject();
            JSONArray iris = new JSONArray(inputs);
            requestParams.put(AGENT_INPUT_KEY, iris);
            requestParams.put(BELONGSTO_KEY, derivation.getEntitiesIri());
            LOGGER.debug("Updating <" + derivation.getIri() + "> using agent at <" + agentURL + "> with http request " + requestParams);
            long newTimestamp = Instant.now().getEpochSecond();
            String response = AgentCaller.executeGetWithURLAndJSON(agentURL, requestParams.toString());
            LOGGER.debug("Obtained http response from agent: " + response);
            if (!derivation.isDerivationWithTimeSeries()) {
                List<String> newEntitiesString = new JSONObject(response).getJSONArray(AGENT_OUTPUT_KEY).toList().stream().map(iri -> (String)iri).collect(Collectors.toList());
                this.sparqlClient.deleteBelongsTo(derivation.getIri());
                LOGGER.debug("Deleted old instances of: " + derivation.getIri());
                this.sparqlClient.addNewEntitiesToDerived(derivation.getIri(), newEntitiesString);
                LOGGER.debug("Added new instances <" + newEntitiesString + "> to the derivation <" + derivation.getIri() + ">");
                List inputToAnotherDerivation = derivation.getEntities().stream().filter(e -> e.isInputToDerivation()).collect(Collectors.toList());
                List<Entity> newEntities = this.sparqlClient.initialiseNewEntities(derivation.getIri());
                if (inputToAnotherDerivation.size() > 0) {
                    LOGGER.debug("This derivation contains at least one entity which is an input to another derivation");
                    LOGGER.debug("Relinking new instance(s) to the derivation by matching their rdf:type");
                    ArrayList<String> newInputs = new ArrayList<String>();
                    ArrayList<String> derivationsToReconnect = new ArrayList<String>();
                    for (Entity oldInput : inputToAnotherDerivation) {
                        List matchingEntity = newEntities.stream().filter(e -> e.getRdfType().equals(oldInput.getRdfType())).collect(Collectors.toList());
                        if (matchingEntity.size() != 1) {
                            String errmsg = "When the agent writes new instances, make sure that there is 1 instance with matching rdf:type over the old set";
                            LOGGER.error(errmsg);
                            LOGGER.error("Number of matching entities = " + matchingEntity.size());
                            throw new JPSRuntimeException(errmsg);
                        }
                        oldInput.getInputOf().forEach(d -> {
                            Derivation derivationToReconnect = d;
                            derivationToReconnect.addInput((Entity)matchingEntity.get(0));
                            derivationToReconnect.removeInput(oldInput);
                            newInputs.add(((Entity)matchingEntity.get(0)).getIri());
                            derivationsToReconnect.add(derivationToReconnect.getIri());
                        });
                    }
                    this.sparqlClient.reconnectInputToDerived(newInputs, derivationsToReconnect);
                    derivation.replaceEntities(newEntities);
                }
            }
            derivation.setTimestamp(newTimestamp);
            derivation.setUpdateStatus(true);
        }
    }

    private void validateDerivation(Derivation derivation, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List allUpstreamDerivations = Stream.concat(derivation.getInputsWithBelongsTo().stream(), derivation.getDirectedUpstreams().stream()).distinct().collect(Collectors.toList());
        if (!graph.containsVertex(derivation.getIri())) {
            graph.addVertex(derivation.getIri());
        }
        for (Derivation upstream : allUpstreamDerivations) {
            if (!derivation.isDerivationAsyn() && upstream.isDerivationAsyn()) {
                throw new JPSRuntimeException("Synchronous derivation <" + derivation.getIri() + "> depends on asynchronous derivation <" + upstream.getIri() + ">.");
            }
            if (!(graph.addVertex(upstream.getIri()) & null != graph.addEdge(derivation.getIri(), upstream.getIri()))) continue;
            this.validateDerivation(upstream, graph);
        }
        List<Entity> inputs = derivation.getInputs();
        for (Entity input : inputs) {
            if (input.hasBelongsTo() || input.getTimestamp() != null) continue;
            throw new JPSRuntimeException(input.getIri() + " does not have a timestamp");
        }
    }

    @Deprecated
    private boolean isOutOfDate(String instance, List<String> inputs) {
        boolean outOfDate = false;
        long instanceTimestamp = this.sparqlClient.getTimestamp(instance);
        for (String input : inputs) {
            long inputTimestamp = this.sparqlClient.getTimestamp(input);
            if (inputTimestamp <= instanceTimestamp) continue;
            outOfDate = true;
            return outOfDate;
        }
        return outOfDate;
    }
}

