"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fairlearnDashboard_1 = require("./fairlearnDashboard");
const base_1 = require("@jupyter-widgets/base");
const EXTENSION_ID = 'interpret-ml-widget:plugin';
const fairlearnDashboardPlugin = {
    id: EXTENSION_ID,
    requires: [base_1.IJupyterWidgetRegistry],
    activate: activateWidgetExtension,
    autoStart: true
};
exports.default = fairlearnDashboardPlugin;
const data = require('../package.json');
/**
 * Activate the widget extension.
 */
function activateWidgetExtension(app, registry) {
    registry.registerWidget({
        name: 'interpret-ml-widget',
        version: data.version,
        exports: {
            FairlearnModel: fairlearnDashboard_1.FairlearnModel,
            FairlearnView: fairlearnDashboard_1.FairlearnView
        }
    });
}
//# sourceMappingURL=labplugin.js.map