# -*- coding: utf-8 -*-
#
# Auxiliar class: Simple stoppable HTTPServer extracted from
#
# http://code.activestate.com/recipes/425210-simple-stoppable-server-using-socket-timeout/
#
# Unless required by applicable law or agreed to in writing, this software
# is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

import http.server
import socket

class StoppableHTTPServer(http.server.HTTPServer):

    def server_bind(self):
        http.server.HTTPServer.server_bind(self)
        self.socket.settimeout(1)
        self.run = True

    def get_request(self):
        while self.run:
            try:
                sock, addr = self.socket.accept()
                sock.settimeout(None)
                return (sock, addr)
            except socket.timeout:
                pass

    def stop(self):
        self.run = False

    def serve(self):
        while self.run:
            self.handle_request()
