from io import open
from setuptools import find_packages, setup

with open("README.md", "r", encoding="utf-8") as f:
    long_description = f.read()

setup(
    name="django-rest",
    version="0.8.7",
    url="https://github.com/alaouimehdi1995/django-rest/",
    license="MIT",
    description="Tiny, lightweight, blazing fast REST library for django",
    keywords="django REST library fast light serializer",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="Mehdi Alaoui",
    author_email="alaoui.mehdi.1995@gmail.com",
    packages=find_packages(include=["django_rest*"]),
    install_requires=["django>=1.11", "six"],
    python_requires=">=2.7, !=3.0.*, !=3.1.*, !=3.2.*, <4",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Environment :: Web Environment",
        "Framework :: Django",
        "Framework :: Django :: 1.11",
        "Framework :: Django :: 1.4",
        "Framework :: Django :: 1.5",
        "Framework :: Django :: 1.6",
        "Framework :: Django :: 1.7",
        "Framework :: Django :: 1.8",
        "Framework :: Django :: 1.9",
        "Framework :: Django :: 2.0",
        "Framework :: Django :: 2.1",
        "Framework :: Django :: 2.2",
        "Framework :: Django :: 3.0",
        "Framework :: Django :: 3.1",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.3",
        "Programming Language :: Python :: 3.4",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Topic :: Internet",
        "Topic :: Internet :: WWW/HTTP",
    ],
    project_urls={"Source": "https://github.com/alaouimehdi1995/django-rest/"},
)
