import numpy as np


# {{{ mesh object thingy


class Mesh:
    dimensions = 2

    def __init__(self):
        self.vertex_coordinates = np.array(
            [
                [1.00000000e00, 1.00000000e00],
                [-1.00000000e00, 1.00000000e00],
                [-1.00000000e00, -1.00000000e00],
                [1.00000000e00, -1.00000000e00],
                [1.00000000e00, 0.00000000e00],
                [5.00000000e-01, 0.00000000e00],
                [4.04508497e-01, 2.93892626e-01],
                [1.54508497e-01, 4.75528258e-01],
                [-1.54508497e-01, 4.75528258e-01],
                [-4.04508497e-01, 2.93892626e-01],
                [-5.00000000e-01, 6.12323400e-17],
                [-4.04508497e-01, -2.93892626e-01],
                [-1.54508497e-01, -4.75528258e-01],
                [1.54508497e-01, -4.75528258e-01],
                [4.04508497e-01, -2.93892626e-01],
                [5.00000000e-01, -1.22464680e-16],
                [-1.00000000e00, 0.00000000e00],
                [0.00000000e00, -1.00000000e00],
                [0.00000000e00, 1.00000000e00],
                [7.50000000e-01, -6.12323400e-17],
                [3.76380160e-01, -6.92475869e-01],
                [2.53742158e-01, 7.19073297e-01],
                [6.28756830e-01, 4.63210153e-01],
                [-5.74443055e-01, -3.53084198e-01],
                [-6.18581756e-01, 2.31042725e-01],
                [-2.26660566e-01, -6.52489609e-01],
                [-1.38777878e-16, -7.15005157e-01],
                [-8.32667268e-17, -4.75528258e-01],
                [1.31420055e-01, -6.30214034e-01],
                [3.52012743e-01, -5.60408551e-01],
                [6.68920108e-01, -6.90243593e-01],
                [-7.72542486e-02, -5.95266707e-01],
                [3.23649069e-02, -5.81200949e-01],
                [7.72542486e-02, -5.09659838e-01],
                [-7.72542486e-02, -5.10475584e-01],
                [-3.86612967e-01, -6.49034477e-01],
                [-5.00000000e-01, -1.00000000e00],
                [-2.65876650e-01, -4.97380593e-01],
                [-2.79508497e-01, -3.84710442e-01],
                [5.00000000e-01, -1.00000000e00],
                [2.79508497e-01, -3.84710442e-01],
                [2.49036745e-01, -4.74202452e-01],
                [4.17444286e-01, -4.43129989e-01],
                [3.66059344e-01, -3.72404685e-01],
                [1.00000000e00, -5.00000000e-01],
                [-2.17008497e-01, -4.30119350e-01],
                [-4.29734374e-01, -4.60045845e-01],
                [-3.74119094e-01, -3.83497979e-01],
                [-1.00000000e00, -5.00000000e-01],
                [5.57224765e-01, -3.55834603e-01],
                [7.21409218e-01, -3.41603211e-01],
                [-4.52254249e-01, -1.46946313e-01],
                [1.85001438e-01, -8.57502578e-01],
                [6.23193603e-01, -1.62706897e-01],
                [4.52254249e-01, -1.46946313e-01],
                [5.12185038e-01, -2.47648931e-01],
                [4.28381373e-01, -2.20419470e-01],
                [5.43214916e-01, -9.52713015e-02],
                [-6.92549940e-01, -1.43793192e-01],
                [-5.15515268e-01, -2.48730988e-01],
                [-4.28381373e-01, -2.20419470e-01],
                [-5.71866870e-01, -1.04580885e-01],
                [-4.76127124e-01, -7.34731565e-02],
                [-6.89960366e-01, 5.35552226e-02],
                [-2.77500572e-01, -8.09255088e-01],
                [-7.30529084e-01, 3.04896602e-01],
                [-4.52254249e-01, 1.46946313e-01],
                [-5.72946346e-01, 1.04931629e-01],
                [-4.76127124e-01, 7.34731565e-02],
                [-4.84687225e-01, 2.38714350e-01],
                [-4.19217263e-01, 5.95504869e-01],
                [-6.41386449e-01, 5.21452559e-01],
                [-1.00000000e00, 5.00000000e-01],
                [-5.29677214e-01, 7.27277579e-01],
                [-2.79508497e-01, 3.84710442e-01],
                [-3.98323250e-01, 4.16812142e-01],
                [-3.42008497e-01, 3.39301534e-01],
                [-2.72282842e-01, 5.06197960e-01],
                [-2.17008497e-01, 4.30119350e-01],
                [-5.00000000e-01, 1.00000000e00],
                [7.72542486e-02, 7.19631585e-01],
                [2.77555756e-17, 4.75528258e-01],
                [-7.72542486e-02, 5.73039943e-01],
                [-7.72542486e-02, 4.75528258e-01],
                [7.72542486e-02, 5.85355142e-01],
                [7.72542486e-02, 4.75528258e-01],
                [4.28743328e-01, 7.41939961e-01],
                [-1.00000000e00, -2.50000000e-01],
                [2.79508497e-01, 3.84710442e-01],
                [2.50009912e-01, 5.42623972e-01],
                [5.00000000e-01, 1.00000000e00],
                [2.37711541e-01, 4.58614646e-01],
                [3.65111148e-01, 4.81894882e-01],
                [3.75966372e-01, 3.86040540e-01],
                [1.00000000e00, 5.00000000e-01],
                [-5.43296861e-01, -7.92213176e-01],
                [-7.96662390e-01, -3.40516303e-01],
                [-6.52705475e-01, -6.10334816e-01],
                [8.75000000e-01, -1.82460056e-01],
                [-2.09778923e-01, 6.41770688e-01],
                [-1.04175415e-01, 8.20467199e-01],
                [-5.56672529e-01, 3.83610683e-01],
                [-8.27449562e-01, 7.55663220e-01],
                [-2.50000000e-01, 1.00000000e00],
                [7.50000000e-01, 0.00000000e00],
                [5.04937767e-01, 5.85487598e-01],
                [7.87954754e-01, 7.48243953e-01],
                [-8.66944614e-01, 1.53933167e-01],
                [5.52449169e-01, 3.31115121e-01],
                [4.52254249e-01, 1.46946313e-01],
                [4.96110705e-01, 2.42426064e-01],
                [5.77759442e-01, 1.47110460e-01],
                [4.76127124e-01, 7.34731565e-02],
                [6.25000000e-01, 0.00000000e00],
                [8.06678337e-01, 2.72341866e-01],
                [7.26562966e-01, 1.46946320e-01],
                [7.50000000e-01, -1.00000000e00],
                [7.97833359e-01, -5.31380557e-01],
                [-3.36478386e-01, 8.08917810e-01],
                [-8.88250684e-01, -7.50000000e-01],
                [2.50000000e-01, 1.00000000e00],
            ]
        )
        self.elements = np.array(
            [
                [50, 44, 98],
                [25, 37, 35],
                [99, 8, 82],
                [25, 31, 12],
                [98, 19, 53],
                [21, 120, 80],
                [98, 53, 50],
                [60, 51, 59],
                [73, 71, 70],
                [44, 50, 117],
                [9, 75, 101],
                [69, 9, 101],
                [106, 90, 86],
                [105, 86, 92],
                [44, 117, 3],
                [49, 14, 42],
                [56, 14, 55],
                [13, 27, 33],
                [26, 52, 28],
                [118, 73, 70],
                [108, 93, 6],
                [30, 29, 20],
                [92, 93, 108],
                [23, 96, 97],
                [35, 97, 95],
                [89, 91, 92],
                [24, 67, 69],
                [14, 43, 42],
                [73, 79, 102],
                [119, 97, 48],
                [64, 17, 26],
                [26, 31, 25],
                [32, 26, 28],
                [52, 26, 17],
                [32, 34, 31],
                [28, 13, 33],
                [58, 16, 87],
                [17, 39, 52],
                [39, 20, 52],
                [49, 50, 53],
                [28, 52, 20],
                [25, 12, 37],
                [46, 35, 37],
                [34, 32, 27],
                [26, 32, 31],
                [27, 32, 33],
                [28, 33, 32],
                [27, 12, 34],
                [12, 31, 34],
                [47, 38, 11],
                [26, 25, 64],
                [38, 47, 37],
                [17, 64, 36],
                [46, 47, 23],
                [45, 38, 37],
                [58, 61, 63],
                [97, 35, 46],
                [28, 29, 41],
                [40, 41, 42],
                [3, 30, 116],
                [41, 13, 28],
                [40, 13, 41],
                [19, 98, 4],
                [29, 42, 41],
                [14, 40, 43],
                [40, 42, 43],
                [42, 29, 30],
                [49, 30, 117],
                [37, 12, 45],
                [64, 35, 95],
                [23, 47, 11],
                [37, 47, 46],
                [48, 97, 96],
                [35, 64, 25],
                [42, 30, 49],
                [28, 20, 29],
                [39, 30, 20],
                [49, 55, 14],
                [10, 61, 62],
                [23, 11, 59],
                [57, 54, 55],
                [15, 57, 19],
                [49, 53, 55],
                [19, 57, 53],
                [57, 55, 53],
                [55, 54, 56],
                [15, 54, 57],
                [36, 95, 119],
                [61, 59, 51],
                [58, 23, 59],
                [101, 24, 69],
                [59, 11, 60],
                [59, 61, 58],
                [9, 69, 66],
                [61, 51, 62],
                [63, 67, 24],
                [87, 96, 58],
                [46, 23, 97],
                [63, 10, 67],
                [68, 66, 67],
                [10, 63, 61],
                [69, 67, 66],
                [63, 24, 65],
                [102, 79, 1],
                [67, 10, 68],
                [70, 71, 101],
                [118, 70, 99],
                [70, 101, 75],
                [118, 79, 73],
                [72, 65, 71],
                [100, 82, 80],
                [99, 77, 8],
                [8, 77, 78],
                [70, 75, 77],
                [63, 107, 16],
                [76, 74, 75],
                [75, 74, 77],
                [89, 21, 84],
                [75, 9, 76],
                [103, 118, 100],
                [85, 7, 84],
                [77, 74, 78],
                [99, 70, 77],
                [80, 84, 21],
                [83, 81, 82],
                [84, 82, 81],
                [80, 18, 100],
                [103, 100, 18],
                [84, 7, 89],
                [82, 8, 83],
                [82, 84, 80],
                [89, 7, 91],
                [84, 81, 85],
                [86, 90, 120],
                [87, 48, 96],
                [109, 112, 111],
                [89, 86, 21],
                [92, 86, 89],
                [106, 105, 22],
                [105, 106, 86],
                [7, 88, 91],
                [92, 91, 88],
                [93, 92, 88],
                [18, 80, 120],
                [88, 6, 93],
                [111, 115, 108],
                [111, 108, 110],
                [95, 97, 119],
                [101, 71, 65],
                [1, 72, 102],
                [16, 58, 63],
                [58, 96, 23],
                [64, 95, 36],
                [44, 4, 98],
                [102, 71, 73],
                [63, 65, 107],
                [100, 118, 99],
                [24, 101, 65],
                [72, 71, 102],
                [82, 100, 99],
                [115, 111, 113],
                [108, 114, 22],
                [108, 105, 92],
                [22, 94, 106],
                [94, 0, 106],
                [90, 106, 0],
                [65, 72, 107],
                [72, 16, 107],
                [22, 105, 108],
                [110, 108, 6],
                [6, 109, 110],
                [109, 111, 110],
                [104, 115, 113],
                [4, 94, 114],
                [114, 115, 4],
                [112, 113, 111],
                [113, 112, 5],
                [94, 22, 114],
                [4, 115, 104],
                [108, 115, 114],
                [49, 117, 50],
                [30, 39, 116],
                [3, 117, 30],
                [79, 118, 103],
                [48, 2, 119],
                [119, 2, 36],
                [86, 120, 21],
            ]
        )

    def __len__(self):
        return len(self.elements)


# }}}


# {{{ add_to_silo_file


def add_to_silo_file(
    silo,
    mesh,
    cell_data=None,
    point_data=None,
    line_integral_rules=None,
    mesh_name="mesh",
    real_only=False,
):
    zonelist_name = mesh_name + "_zonelist"

    from pyvisfile.silo import IntVector

    nodelist = IntVector()
    nodelist.extend(int(i) for i in mesh.elements.flat)

    shapetypes = IntVector()
    from pyvisfile.silo import DB_ZONETYPE_TRIANGLE

    shapetypes.append(DB_ZONETYPE_TRIANGLE)

    shapesizes = IntVector()
    shapesizes.append(3)

    shapecounts = IntVector()
    shapecounts.append(len(mesh))

    silo.put_zonelist_2(
        zonelist_name,
        len(mesh),
        mesh.dimensions,
        nodelist,
        0,
        0,
        shapetypes,
        shapesizes,
        shapecounts,
    )

    silo.put_ucdmesh(
        mesh_name,
        [],
        np.asarray(mesh.vertex_coordinates.T, order="C"),
        len(mesh),
        zonelist_name,
        None,
    )

    from pyvisfile.silo import DB_NODECENT, DB_ZONECENT

    silo.put_ucdvar1(
        "myvar",
        mesh_name,
        np.arange(mesh.vertex_coordinates.shape[0], dtype=np.double),
        DB_NODECENT,
    )
    silo.put_ucdvar1(
        "myvar2", mesh_name, np.arange(len(mesh), dtype=np.double), DB_ZONECENT
    )


# }}}


def test_silo_unstructured():
    from pyvisfile.silo import SiloFile

    silo = SiloFile("out.silo")
    add_to_silo_file(silo, Mesh())
    silo.close()


if __name__ == "__main__":
    import sys
    if len(sys.argv) > 1:
        exec(sys.argv[1])
    else:
        from pytest import main
        main([__file__])

# vim: fdm=marker
