<!--
***
*** To avoid retyping too much info. Do a search and replace for the following:
*** well-known-handler, WellKnownHandler
-->
[![Contributors][contributors-shield]][contributors-url]
[![Forks][forks-shield]][forks-url]
[![Stargazers][stars-shield]][stars-url]
[![Issues][issues-shield]][issues-url]
[![MIT License][license-shield]][license-url]
![Build][build-shield]

<!-- PROJECT LOGO -->
<br />
<p align="center">
  <a href="https://github.com/EOEPCA/well-known-handler">
  </a>

  <h3 align="center">WellKnownHandler</h3>

  <p align="center">
    Auxiliary Python3 library that allows for simple parsing and usage of an SSO server's "well-known" endpoints
    <br />
    <a href="https://github.com/EOEPCA/well-known-handler/issues">Report Bug</a>
    ·
    <a href="https://github.com/EOEPCA/well-known-handler/issues">Request Feature</a>
  </p>
</p>

## Table of Contents

- [Table of Contents](#table-of-contents)
- [About The Project](#about-the-project)
  - [Built With](#built-with)
- [Prerequisites](#prerequisites)
- [Installation](#installation)
- [Testing](#testing)
- [Usage](#usage)
- [Roadmap](#roadmap)
- [Contributing](#contributing)
- [License](#license)
- [Contact](#contact)
- [Acknowledgements](#acknowledgements)

## About The Project

Auxiliary Python3 library that allows for simple parsing and usage of an SSO server's "well-known" endpoints.
This library is created to support EOEPCA's project, but is generic enough to be used in any other environment.

Currently supported endpoints (easily expandable!):
  - OIDC
  - SCIM

### Built With

- [Python](https://www.python.org//)
- [PyTest](https://docs.pytest.org)
- [YAML](https://yaml.org/)
- [Travis CI](https://travis-ci.com/)

### Prerequisites

This is an example of how to list things you need to use the software and how to install them.

- [Python 3](https://www.python.org//)
- [Pip](https://pip.pypa.io/en/stable/)

### Installation

Just download the library using pip

```sh
pip install WellKnownHandler
```

### Testing

```sh
pytest WellKnownHandler/tests
```

## Usage

Checkout our main.py file for some examples of usage!

## Roadmap

See the [open issues](https://github.com/EOEPCA/well-known-handler/issues) for a list of proposed features (and known issues).

## Contributing

Contributions are what make the open source community such an amazing place to be learn, inspire, and create. Any contributions you make are **greatly appreciated**.

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## License

Distributed under the Apache-2.0 License. See `LICENSE` for more information.

## Contact

[EOEPCA mailbox](eoepca.systemteam@telespazio.com)

Project Link: [https://github.com/EOEPCA/well-known-handler](https://github.com/EOEPCA/well-known-handler)

## Acknowledgements

- README.md is based on [this template](https://github.com/othneildrew/Best-README-Template) by [Othneil Drew](https://github.com/othneildrew).


[contributors-shield]: https://img.shields.io/github/contributors/EOEPCA/well-known-handler.svg?style=flat-square
[contributors-url]: https://github.com/EOEPCA/well-known-handler/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/EOEPCA/well-known-handler.svg?style=flat-square
[forks-url]: https://github.com/EOEPCA/well-known-handler/network/members
[stars-shield]: https://img.shields.io/github/stars/EOEPCA/well-known-handler.svg?style=flat-square
[stars-url]: https://github.com/EOEPCA/well-known-handler/stargazers
[issues-shield]: https://img.shields.io/github/issues/EOEPCA/well-known-handler.svg?style=flat-square
[issues-url]: https://github.com/EOEPCA/well-known-handler/issues
[license-shield]: https://img.shields.io/github/license/EOEPCA/well-known-handler.svg?style=flat-square
[license-url]: https://github.com/EOEPCA/well-known-handler/blob/master/LICENSE
[build-shield]: https://www.travis-ci.com/EOEPCA/well-known-handler.svg?branch=master
