# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['carrot_rcc']
entry_points = \
{'console_scripts': ['carrot-rcc = carrot_rcc:main']}

setup_kwargs = {
    'name': 'carrot-rcc',
    'version': '0.6.0',
    'description': 'Camunda external task Robot Framework RCC client',
    'long_description': 'Camunda external task Robot Framework RCC client\n================================================\n\n**Technology preview.**\n\n`carrot-rcc` is an opinionated [Camunda external task](https://docs.camunda.org/manual/latest/user-guide/process-engine/external-tasks/) client for executing [Robot Framework](https://robotframework.org/rpa/) [RPA framework](https://rpaframework.org/) automation tasks. It is based on Robocorp [RCC toolchain](https://robocorp.com/docs/rcc/overview) and [Camunda external task client for Node JS](https://github.com/camunda/camunda-external-task-client-js).\n\n`carrot-rcc` executes automation tasks built and wrapped into robot.zip packages as instructed by [Robocorp documentation](https://robocorp.com/docs/). Single `carrot-rcc` service can subscribe multiple topics and execute tasks from same or different robot-packages concurrently, although only locally on the same computer. `carrot-rcc` should work fine on Windows, Linux and on MacOS.\n\n```bash\nusage: carrot-rcc [<robots>...]\n                  [--base-url] [--authorization]\n                  [--worker-id] [--max-tasks] [--poll-interval] [--log-level]\n                  [--rcc-executable] [--rcc-encoding] [--rcc-telemetry]\n                  [--rcc-controller] [--rcc-fixed-spaces]\n                  [--vault-addr] [--vault-token]\n                  [-h] [--help]\n\n<robots> could also be passed as a comma separated env RCC_ROBOTS\n\noptions:\n\n  --base-url[=<url>]                       [env: CAMUNDA_API_BASE_URL] [default: http://localhost:8080/engine-rest]\n  --authorization[=<header>]               [env: CAMUNDA_API_AUTHORIZATION] [example: Basic ZGVtbzpkZW1v]\n\n  --worker-id[=<string>]                   [env: CLIENT_WORKER_ID] [default: carrot-rcc]\n  --max-tasks[=<cpus>]                     [env: CLIENT_MAX_TASKS] [default: [cpu count]]\n  --poll-interval[=<milliseconds>]         [env: CLIENT_POLL_INTERVAL] [default: 10000]\n  --log-level[=<debug|info|warn|error>]    [env: CLIENT_LOG_LEVEL] [default: info]\n\n  --rcc-executable[=<path>]                [env: RCC_EXECUTABLE] [default: rcc]\n  --rcc-controller[=<controller>]          [env: RCC_CONTROLLER] [default: carrot]\n  --rcc-encoding[=<encoding>]              [env: RCC_ENCODING] [default: utf-8]\n  --rcc-telemetry                          [env: RCC_TELEMETRY] (default: do not track)\n  --rcc-fixed-spaces                       [env: RCC_FIXED_SPACES] (default: circulate spaces)\n\n  --vault-addr[=<addr>]                    [env: VAULT_ADDR] [default: http://127.0.0.1:8200]\n  --vault-token[=<token>]                  [env: VAULT_TOKEN] [default: token]\n\n  -h, --help\n\nexamples:\n\n  $ carrot-rcc robot1.zip\n\n  $ carrot-rcc robot1.zip robot2.zip --log-level=debug\n\n  $ RCC_ROBOTS="robot1.zip,robot2.zip" LOG_LEVEL="debug" carrot-rcc\n\n  $ CAMUNDA_API_AUTHORIZATION="Bearer MY_TOKEN" carrot-rcc robot1.zip\n```\n\nDesign\n======\n\nWhen `carrot-rcc` is started, it examines every given robot-package and examines available task names from their `robot.yaml`. Currently, `carrot-rcc` can only find packages preloaded onto local filesystem.\n\nThen `carrot-rcc` subscribes every found task name as they were Camunda external task topics, and starts listening for new tasks for its topics to become available at Camunda.\n\n[![](https://mermaid.ink/img/eyJjb2RlIjoic2VxdWVuY2VEaWFncmFtXG4gICAgcGFydGljaXBhbnQgQ2FtdW5kYVxuICAgIHBhcnRpY2lwYW50IENhcnJvdFxuICAgIHBhcnRpY2lwYW50IFJDQ1xuICAgIHBhcnRpY2lwYW50IFJvYm90XG4gICAgUGFydGljaXBhbnQgV29yayBpdGVtXG5cbiAgICBDYXJyb3QtPj5DYW11bmRhOiBGZXRjaCBhbmQgbG9ja1xuICAgIGxvb3BcbiAgICBDYW11bmRhLT4-K0NhcnJvdDogVGFza1xuICAgIHBhclxuICAgIENhcnJvdC0-PitSQ0M6IFVucGFjayByb2JvdFxuICAgIFJDQy0tPj4tQ2Fycm90OiBbZXhpdCBjb2RlXVxuICAgIENhcnJvdC0-PitXb3JrIGl0ZW06IENyZWF0ZSB3b3JrIGl0ZW1cbiAgICBDYXJyb3QtPj4rUkNDOiBSdW4gcm9ib3RcbiAgICBOb3RlIG92ZXIgUkNDOiBTZXR1cCBlbnZpcm9ubWVudFxuICAgIFJDQy0-PitSb2JvdDogUnVuIHJvYm90XG4gICAgUm9ib3QtPj5Xb3JrIGl0ZW06IExvYWQgd29yayBpdGVtXG4gICAgV29yayBpdGVtLS0-PlJvYm90OiBbd29yayBpdGVtXVxuICAgIE5vdGUgb3ZlciBSb2JvdDogQXV0b21hdGlvblxuICAgIFJvYm90LT4-V29yayBpdGVtOiBTYXZlIHdvcmsgaXRlbVxuICAgIFJvYm90LS0-Pi1SQ0M6IFtleGl0IGNvZGVdXG4gICAgTm90ZSBvdmVyIFJDQzogVGVhcmRvd24gZW52aXJvbm1lbnRcbiAgICBSQ0MtLT4-LUNhcnJvdDogW2V4aXQgY29kZV1cbiAgICBhbmRcbiAgICBsb29wXG4gICAgQ2Fycm90LS0-PkNhbXVuZGE6IEV4dGVuZCBsb2NrXG4gICAgZW5kXG4gICAgZW5kXG4gICAgQ2Fycm90LT4-V29yayBpdGVtOiBMb2FkIHdvcmsgaXRlbVxuICAgIFdvcmsgaXRlbS0tPj4tQ2Fycm90OiBbd29yayBpdGVtXVxuICAgIENhcnJvdC0tPj5DYW11bmRhOiBVcGRhdGUgdmFyaWFibGVzXG4gICAgYWx0XG4gICAgQ2Fycm90LS0-PkNhbXVuZGE6IENvbXBsZXRlIHRhc2tcbiAgICBlbHNlXG4gICAgQ2Fycm90LS0-Pi1DYW11bmRhOiBIYW5kbGUgZmFpbHVyZVxuICAgIGVuZFxuICAgIGVuZFxuIiwibWVybWFpZCI6eyJ0aGVtZSI6ImRlZmF1bHQifSwidXBkYXRlRWRpdG9yIjpmYWxzZSwiYXV0b1N5bmMiOnRydWUsInVwZGF0ZURpYWdyYW0iOmZhbHNlfQ)](https://mermaid-js.github.io/mermaid-live-editor/edit##eyJjb2RlIjoic2VxdWVuY2VEaWFncmFtXG4gICAgcGFydGljaXBhbnQgQ2FtdW5kYVxuICAgIHBhcnRpY2lwYW50IENhcnJvdFxuICAgIHBhcnRpY2lwYW50IFJDQ1xuICAgIHBhcnRpY2lwYW50IFJvYm90XG4gICAgUGFydGljaXBhbnQgV29yayBpdGVtXG5cbiAgICBDYXJyb3QtPj5DYW11bmRhOiBGZXRjaCBhbmQgbG9ja1xuICAgIGxvb3BcbiAgICBDYW11bmRhLT4-K0NhcnJvdDogVGFza1xuICAgIHBhclxuICAgIENhcnJvdC0-PitSQ0M6IFVucGFjayByb2JvdFxuICAgIFJDQy0tPj4tQ2Fycm90OiBbZXhpdCBjb2RlXVxuICAgIENhcnJvdC0-PitXb3JrIGl0ZW06IENyZWF0ZSB3b3JrIGl0ZW1cbiAgICBDYXJyb3QtPj4rUkNDOiBSdW4gcm9ib3RcbiAgICBOb3RlIG92ZXIgUkNDOiBTZXR1cCBlbnZpcm9ubWVudFxuICAgIFJDQy0-PitSb2JvdDogUnVuIHJvYm90XG4gICAgUm9ib3QtPj5Xb3JrIGl0ZW06IExvYWQgd29yayBpdGVtXG4gICAgV29yayBpdGVtLS0-PlJvYm90OiBbd29yayBpdGVtXVxuICAgIE5vdGUgb3ZlciBSb2JvdDogQXV0b21hdGlvXG4gICAgUm9ib3QtPj5Xb3JrIGl0ZW06IFNhdmUgd29yayBpdGVtXG4gICAgUm9ib3QtLT4-LVJDQzogW2V4aXQgY29kZV1cbiAgICBOb3RlIG92ZXIgUkNDOiBUZWFyZG93biBlbnZpcm9ubWVudFxuICAgIFJDQy0tPj4tQ2Fycm90OiBbZXhpdCBjb2RlXVxuICAgIGFuZFxuICAgIGxvb3BcbiAgICBDYXJyb3QtLT4-Q2FtdW5kYTogRXh0ZW5kIGxvY2tcbiAgICBlbmRcbiAgICBlbmRcbiAgICBDYXJyb3QtPj5Xb3JrIGl0ZW06IExvYWQgd29yayBpdGVtXG4gICAgV29yayBpdGVtLS0-Pi1DYXJyb3Q6IFt3b3JrIGl0ZW1dXG4gICAgQ2Fycm90LS0-PkNhbXVuZGE6IFVwZGF0ZSB2YXJpYWJsZXNcbiAgICBhbHRcbiAgICBDYXJyb3QtLT4-Q2FtdW5kYTogQ29tcGxldGUgdGFza1xuICAgIGVsc2VcbiAgICBDYXJyb3QtLT4-LUNhbXVuZGE6IEhhbmRsZSBmYWlsdXJlXG4gICAgZW5kXG4gICAgZW5kXG4iLCJtZXJtYWlkIjoie1xuICBcInRoZW1lXCI6IFwiZGVmYXVsdFwiXG59IiwidXBkYXRlRWRpdG9yIjpmYWxzZSwiYXV0b1N5bmMiOnRydWUsInVwZGF0ZURpYWdyYW0iOmZhbHNlfQ)\n\nOn a new task, `carrot-rcc` remembers which topic was mapped to which task on which robot-package, and unpacks the correct robot-package into a new temporary directory. Then it creates another temporary directory with all external task variables and files as a local [robot work item](https://robocorp.com/docs/libraries/rpa-framework/rpa-robocorp-workitems).\n\nSimilarly to work item, for convenience, all `carrot-rcc` process environment variables are made available as `env` secret to keep their use out of Robot Framework logs when used with [RPA framework\'s Secrets -library](https://robocorp.com/docs/libraries/rpa-framework/rpa-robocorp-vault).\n\nNext [RCC](https://robocorp.com/docs/rcc/overview) is called to resolve robot\'s dependencies and execute the robot. Robot package may declare any available Conda or Pip package as its dependency. For example, this makes it possible to have [fully functional browser automation stack as a task dependency](https://github.com/datakurre/carrot-rcc/blob/main/xkcd-bot/conda.yaml) independently what the local machine actually has available. RCC caches the dependency environments on the machine to enable their fast re-use.\n\nFinally, `carrot-rcc` saves all the changed and added variables from the saved work item back to Camunda. In addition, it also saves full [Robot Framework execution logs](https://robotframework.org/robotframework/latest/RobotFrameworkUserGuide.html#log-file). All these are saved back into the task execution context, to leave their further use for the BPMN designer. At the end `carrot-rcc` either completes of fails the task at Camunda.\n\n[![Screencast of carrot-rcc in action](https://github.com/datakurre/carrot-rcc/raw/main/example-process.gif)](https://github.com/datakurre/carrot-rcc/raw/main/example-process.gif)\n\n\nUsage\n=====\n\n`carrot-rcc` requires only [NodeJS](https://nodejs.org/en/) 12 or later and expects [RCC](https://downloads.robocorp.com/rcc/releases/index.html) to be on the environment PATH. RCC location may also be configured manually with ``--rcc-executable`` argument.\n\nIt is also possible to bootstrap everything with just using RCC:\n\n1. Create a directory for `carrot-rcc` and download [RCC](https://downloads.robocorp.com/rcc/releases/index.html) into that directory.\n\n2. Download an example [conda.yaml](https://raw.githubusercontent.com/datakurre/carrot-rcc/main/conda.yaml) defining the requirements for `carrot-rcc`.\n\n3. Install `carrot-rcc` into RCC managed environment with\n\n   ```bash\n   $ rcc env new conda.yaml\n   ```\n   or\n   ```bash\n   $ rcc.exe env new conda.yaml\n   ```\n\n4. The hard part is to figure out from the logs where RCC did create the environment. When found, copy a few files back and forth to give you access the environment and `carrot-rcc`, and give `carrot-rcc` access to RCC:\n\n   ```bash\n   $ cp /home/user/.robocorp/live/850002f365eee60f/rcc_activate.sh .\n   $ cp rcc /home/user/.robocorp/live/850002f365eee60f/bin\n   ```\n   or\n   ```bash\n   $ copy C:\\Users\\User\\AppData\\Local\\robocorp\\live\\850002f365eee60f\\rcc_activate.cmd .\n   $ copy C:\\Users\\User\\AppData\\Local\\robocorp\\live\\850002f365eee60f\\Scripts\\carrot-rcc.exe .\n   $ copy rcc.exe C:\\Users\\User\\AppData\\Local\\robocorp\\live\\850002f365eee60f\n   ```\n\n5. Finally, activate the environment:\n\n   ```bash\n   $ source rcc_activate.sh\n   ```\n   or\n   ```bash\n   $ rcc_activate.cmd\n   ```\n\nDone. Now `carrot-rcc` should be ready to be run, for example:\n\n```bash\n$ carrot-rcc robot.zip --base-url=http://localhost:8080/engine-rest --log-level=debug\n```\nor\n```bash\n$ carrot-rcc.exe robot.zip --base-url=http://192.168.86.156:8080/engine-rest --log-level=debug\n```\n\nThe project\'s repository includes [example Camunda processes](https://github.com/datakurre/carrot-rcc/tree/main/camunda/deployment) with example RCC compatible robots ([1](https://github.com/datakurre/carrot-rcc/blob/main/xkcd-bot/robot.zip?raw=true), [2](https://github.com/datakurre/carrot-rcc/blob/main/fleamarket-bot/robot.zip?raw=true)) available.\n\n![](https://github.com/datakurre/carrot-rcc/raw/main/example-process.png)\n\nVault support\n=============\n\n`carrot-rcc` has some support for [HashiCorp Vault KV secrets engine](https://www.vaultproject.io/docs/secrets/kv). When working `VAULT_ADDR` and `VAULT_TOKEN` set, `carrot_rcc` will resolve secrets defined in each robots\' `robot.yaml` each time before a robot execution. \n\nAn example `robot.yaml` with secrets:\n\n```yaml\ntasks:\n\n  Camunda Topic:\n    robotTaskName:\n      My Robot Task\n\nvault:\n  my-secret: /secret-engine-path/data/my-secret-path\n\ncondaConfigFile:\n  conda.yaml\n\nartifactsDir:\n  output\n```\n\nNote: `carrot-rcc` does NOT manage renewal for the given `VAULT_TOKEN`.\n',
    'author': 'Asko Soukka',
    'author_email': 'asko.soukka@iki.fi',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/datakurre/carrot-rcc',
    'py_modules': modules,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
