# Copyright 2018 Rackspace
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import base64
import logging

from oslo_config import cfg

LOG = logging.getLogger(__name__)
CONF = cfg.CONF


def basic_auth(user_section='user'):
    password = CONF.get(user_section).password or CONF.user.password
    username = CONF.get(user_section).username or CONF.user.username
    encoded_creds = base64.b64encode(
        "{}:{}".format(username, password).encode())
    return "Basic %s" % encoded_creds.decode()
