# browsenextfile


[![en](https://img.shields.io/badge/lang-en-blue.svg)](README.md)


Данная программа позволяет просматривать локальные файлы на компьютере (изображения или видео) при помощи веб-браузера. Переходить к следующему или предыдущему файлу в директории можно, кликая мышью. Открывать изображения и видео всех форматов, поддерживаемых браузером.


## Требования:

- Python 3
- Веб-браузер Mozilla Firefox


## Установка:

В среде Linux, откройте командную строку и введите:
```
~> python3 -m pip install browsenextfile
```

В среде Windows, откройте командную строку или Windows PowerShell и введите:
```
~> py -m pip install browsenextfile
```


## Использование:

Запустите программу. Если программа была установлена с использованием PIP, как показано выше, тогда на рабочем столе и в меню приложений для нее был автоматически создан ярлык `NextFile`. В этом случае программу можно запустить двойным кликом мыши на этом ярлыке, или кликнув правой кнопкой мыши на файле-изображении или видео-файле, который мы хотим открыть, и в выпадающем меню выбрав программу `NextFile`.

Технически, программу `nextfile.py` можно запустить из командной строки как Python-скрипт:
```
~> python3 nextfile.py
```

Подождите, пока откроется новое окно браузера. На это может уйти до минуты.

В браузере откроется стартовая страница с информацией о программе.

В окне браузера перейдите на любой локальный файл на компьютере, для чего кликните мышью на кнопке `Открыть` в верхней части экрана. (Другой способ: В браузере Firefox нажмите клавишу `Alt`, чтобы открыть меню браузера, и выберите `Файл--Открыть файл`. В браузерах Chrome или Edge нажмите клавишу `Ctrl+O`.)

Чтобы открыть следующий файл в директории, кликните мышью на кнопке `>` в правой части экрана.

Чтобы открыть предыдущий файл в директории, кликните мышью на кнопке `<` в левой части экрана.

Чтобы увеличить изображение, кликните на кнопке `+` в нижней части экрана, или потяните изображение мышью вниз при нажатой средней кнопке мыши (колёсике).

Чтобы уменьшить изображение, кликните на кнопке `-` в нижней части экрана, или потяните изображение мышью вверх при нажатой средней кнопке мыши (колёсике).

Для прокрутки изображения пользуйтесь полосами прокрутки, или перемещайте изображение мышью при нажатой левой кнопке мыши.

Если в браузере открыты несколько закладок, только одна (обычно первая) управляется кнопками.

Кнопки присутствуют только если в браузере открыт локальный файл из этого компьютера. Если открыта страница из интернета, кнопки отсутствуют.


## Изменение опций программы:

Текстовый файл `nextfile_options.txt` содержит ряд опций, которые пользователь может менять, чтобы корректировать поведение программы. Этот файл расположен в директории редактируемых данных программы:

В среде Linux:
```
/home/<user_name>/.local/share/nextfile/nextfile_options.txt
```

В среде Windows:
```
C:\Users\<user_name>\AppData\Local\dmitrish\nextfile\nextfile_options.txt
```

Точное расположение этого и других файлов, используемых программой, можно найти на информационной странице - первой странице, которая откроется в браузере после запуска программы.

Имеющиеся опции:

*browser*: По умолчанию программа открывает браузер Firefox. Чтобы использовать другой браузер, в файле опций соответствующим образом поменяйте значение *value* опции *browser*. На данный момент программа тестировалась с браузерами Firefox, Chrome, и Edge.


## Данные браузера:

Когда данная программа открывает веб-браузер, используется пользовательский профиль отличный от профиля, используемого по умолчанию при открытии браузера обычным образом. Все данные браузера (включая пользовательские настройки, кэш браузера, историю, закладки, установленные расширения, и т.п.), используемые веб-браузерами, когда они открываются данной программой, хранятся в следующей директории. Если профиль здесь удалить, вместо него будет создан чистый профиль:

В среде Linux:
```
home/<user_name>/.local/share/nextfile/profiles/
```

В среде Windows:
```
C:\Users\<user_name>\AppData\Local\dmitrish\nextfile\profiles\
```

Точное расположение этого и других файлов, используемых программой, можно найти на информационной странице - первой странице, которая откроется в браузере после запуска программы.


## Установка веб-драйвера (опционно):

Программа поставляется с предустановленным веб-драйвером для браузера Firefox, поэтому если вы хотите использовать Firefox, он будет работать без каких-либо дополнительных действий. Однако, если вы хотите использовать другой браузер, например Chrome или Edge, вы должны установить соответствующий веб-драйвер вручную, как описано ниже. К тому же, в случае использования Chrome или Edge вы должны будете периодически обновлять веб-драйвер, чтобы его версия совпадала с текущей версией автоматически обновляемого браузера Chrome или Edge.

Установите веб-драйвер для браузера, который вы хотите использовать. Ссылки для загрузки приведены на сайте:

[Скачать веб-драйвер](https://www.selenium.dev/documentation/webdriver/getting_started/install_drivers/#quick-reference)

**Важно**: Для всех браузеров, кроме Firefox, версия файла веб-драйвера должна совпадать с текущей версией вашего браузера.

Откройте скачанный архив и извлеките файл веб-драйвера. Веб-драйвер для браузера Firefox обычно имеет имя `geckodriver`. Веб-драйвер для браузера Chrome обычно имеет имя `chromedriver`. Веб-драйвер для браузера Edge обычно имеет имя `msedgedriver.exe`.

Поместите файл веб-драйвера в соответствующую поддиректорию в директории данных программы:

В среде Linux:
```
/home/<user_name>/.local/share/nextfile/web_driver/linux64
```

В среде Windows:
```
C:\Users\<user_name>\AppData\Local\dmitrish\nextfile\web_driver\win64
```

Точное расположение этого и других файлов, используемых программой, можно найти на информационной странице - первой странице, которая откроется в браузере после запуска программы.


## Поддерживаемые платформы:

Данное ПО тестировалось на платформе Linux (Ubuntu) с браузерами Firefox и Chrome, и на платформе Windows с браузерами Firefox, Chrome, и Edge.

Программа использует следующее программное обеспечение (Если программа устанавливается с использованием PIP, все устанавливается автоматически):

Проект "Selenium" для управления браузером:

[https://www.selenium.dev/selenium/docs/api/py/api.html](https://www.selenium.dev/selenium/docs/api/py/api.html)






