# Generated by Django 3.2.12 on 2022-04-07 02:07

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import drf_operation_log.encoders
import drf_operation_log.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("contenttypes", "__first__"),
    ]

    operations = [
        migrations.CreateModel(
            name='OperationLogEntry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action_time', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='操作时间')),
                ('object_id', models.TextField(blank=True, null=True, verbose_name='对象ID')),
                ('action', models.CharField(max_length=32, verbose_name='动作')),
                ('action_name', models.CharField(max_length=32, verbose_name='动作名称')),
                ('action_flag', models.PositiveSmallIntegerField(choices=[(1, 'Addition'), (2, 'Change'), (3, 'Deletion')], verbose_name='操作类型')),
                ('change_message', models.JSONField(blank=True, default=dict, encoder=drf_operation_log.encoders.JSONEncoder, verbose_name='差异信息')),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.contenttype', verbose_name='操作对象')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='用户')),
            ],
            options={
                'verbose_name': '操作日志',
                'verbose_name_plural': '操作日志',
                'db_table': 'drf_operation_log',
                'ordering': ['-action_time'],
                'index_together': {('content_type', 'object_id')},
            },
            managers=[
                ('objects', drf_operation_log.models.OperationLogEntryManager()),
            ],
        ),
    ]
