"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const s3 = new aws_sdk_1.S3({ apiVersion: '2006-03-01' });
async function handler(event) {
    const request = event.Records[0].cf.request;
    try {
        const s3Origin = request.origin?.s3;
        if (!s3Origin) {
            throw new Error('No S3 origin');
        }
        const bucket = s3Origin.domainName.replace(new RegExp(`.s3.${s3Origin.region}.amazonaws.com$`), '');
        const key = request.uri.substring(1); // remove first slash
        const data = await s3.getObject({
            Bucket: bucket,
            Key: key,
        }).promise();
        if (!data.Body) {
            throw new Error('No body');
        }
        const redirect = JSON.parse(data.Body.toString());
        return {
            status: '301',
            statusDescription: 'Moved Permanently',
            headers: {
                location: [{
                        key: 'Location',
                        value: redirect.url,
                    }],
            },
        };
    }
    catch (err) {
        console.log(err);
        return {
            status: '404',
            statusDescription: 'Not Found',
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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