"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CleanObjectsFunction = void 0;
// ~~ Generated by projen. To modify, edit .projenrc.js and run "npx projen".
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
/**
 * An AWS Lambda function which executes src/toolkit-cleaner/clean-objects.
 */
class CleanObjectsFunction extends lambda.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            description: 'src/toolkit-cleaner/clean-objects.lambda.ts',
            ...props,
            runtime: new lambda.Runtime('nodejs16.x', lambda.RuntimeFamily.NODEJS),
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '../../assets/toolkit-cleaner/clean-objects.lambda')),
        });
        this.addEnvironment('AWS_NODEJS_CONNECTION_REUSE_ENABLED', '1', { removeInEdge: true });
    }
}
exports.CleanObjectsFunction = CleanObjectsFunction;
//# sourceMappingURL=data:application/json;base64,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