"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
const web_api_1 = require("@slack/web-api");
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const got_1 = require("got");
async function handler(event) {
    console.log('Event: %j', event);
    const slackClient = new web_api_1.WebClient(process.env.SLACK_TOKEN);
    // Get file info
    const info = await slackClient.files.info({
        file: event.file_id,
    });
    console.log('File info: %j', info);
    if (!info.file.mimetype.startsWith('image')) {
        console.log('Not an image');
        return;
    }
    // Get file
    const file = await got_1.default(info.file.url_private, {
        headers: {
            Authorization: `Bearer ${process.env.SLACK_TOKEN}`,
        },
    }).buffer();
    // Detect text with Textract
    const textract = new aws_sdk_1.Textract({ apiVersion: '2018-06-27' });
    const data = await textract.detectDocumentText({
        Document: { Bytes: file },
    }).promise();
    if (!data.Blocks) {
        console.log('No text detected');
        return;
    }
    // Add detected text in image thread
    const postMessage = await slackClient.chat.postMessage({
        channel: event.channel_id,
        text: data.Blocks.filter((b) => b.BlockType === 'LINE').map((b) => b.Text).join('\n'),
        thread_ts: info.file.shares.public[event.channel_id][0].ts,
    });
    console.log('Post message: %j', postMessage);
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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