import * as cdk from 'aws-cdk-lib';
import * as events from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
/**
 * Properties for a SlackEvents
 */
export interface SlackEventsProps {
    /**
     * The signing secret of the Slack app
     */
    readonly signingSecret: cdk.SecretValue;
    /**
     * A name for the API Gateway resource
     *
     * @default SlackEventsApi
     */
    readonly apiName?: string;
    /**
     * Whether to use a custom event bus
     *
     * @default false
     */
    readonly customEventBus?: boolean;
}
/**
 * Send Slack events to Amazon EventBridge
 */
export declare class SlackEvents extends Construct {
    /**
     * The custom event bus where Slack events are sent
     */
    readonly eventBus?: events.EventBus;
    constructor(scope: Construct, id: string, props: SlackEventsProps);
}
