"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConcreteWidget = exports.GRID_WIDTH = void 0;
/**
 * The width of the grid we're filling
 */
exports.GRID_WIDTH = 24;
/**
 * A real CloudWatch widget that has its own fixed size and remembers its position.
 *
 * This is in contrast to other widgets which exist for layout purposes.
 */
class ConcreteWidget {
    /**
     *
     */
    constructor(width, height) {
        this.width = width;
        this.height = height;
        if (this.width > exports.GRID_WIDTH) {
            throw new Error(`Widget is too wide, max ${exports.GRID_WIDTH} units allowed`);
        }
    }
    /**
     * Place the widget at a given position.
     */
    position(x, y) {
        this.x = x;
        this.y = y;
    }
}
exports.ConcreteWidget = ConcreteWidget;
//# sourceMappingURL=data:application/json;base64,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