import { IAlarm } from './alarm-base';
import { ConcreteWidget } from './widget';
/**
 * Properties for an Alarm Status Widget.
 */
export interface AlarmStatusWidgetProps {
    /**
     * CloudWatch Alarms to show in widget.
     */
    readonly alarms: IAlarm[];
    /**
     * The title of the widget.
     *
     * @default 'Alarm Status'
     */
    readonly title?: string;
    /**
     * Width of the widget, in a grid of 24 units wide.
     *
     * @default 6
     */
    readonly width?: number;
    /**
     * Height of the widget.
     *
     * @default 3
     */
    readonly height?: number;
}
/**
 * A dashboard widget that displays alarms in a grid view.
 */
export declare class AlarmStatusWidget extends ConcreteWidget {
    private readonly props;
    /**
     *
     */
    constructor(props: AlarmStatusWidgetProps);
    /**
     * Place the widget at a given position.
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     */
    toJson(): any[];
}
