import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpcComputeImageListEntryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_image_list_entry#entry DataOpcComputeImageListEntry#entry}
    */
    readonly entry?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_image_list_entry#id DataOpcComputeImageListEntry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_image_list_entry#image_list DataOpcComputeImageListEntry#image_list}
    */
    readonly imageList: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_image_list_entry#version DataOpcComputeImageListEntry#version}
    */
    readonly version: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/d/compute_image_list_entry opc_compute_image_list_entry}
*/
export declare class DataOpcComputeImageListEntry extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opc_compute_image_list_entry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/d/compute_image_list_entry opc_compute_image_list_entry} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpcComputeImageListEntryConfig
    */
    constructor(scope: Construct, id: string, config: DataOpcComputeImageListEntryConfig);
    get attributes(): string;
    private _entry?;
    get entry(): number;
    set entry(value: number);
    resetEntry(): void;
    get entryInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageList?;
    get imageList(): string;
    set imageList(value: string);
    get imageListInput(): string | undefined;
    get machineImages(): string[];
    get uri(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    get versionInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
