import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSecurityIpListConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_ip_list#description ComputeSecurityIpList#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_ip_list#id ComputeSecurityIpList#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_ip_list#ip_entries ComputeSecurityIpList#ip_entries}
    */
    readonly ipEntries: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_ip_list#name ComputeSecurityIpList#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_security_ip_list opc_compute_security_ip_list}
*/
export declare class ComputeSecurityIpList extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_security_ip_list";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_security_ip_list opc_compute_security_ip_list} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSecurityIpListConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSecurityIpListConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipEntries?;
    get ipEntries(): string[];
    set ipEntries(value: string[]);
    get ipEntriesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
