import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSecurityApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_application#description ComputeSecurityApplication#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_application#dport ComputeSecurityApplication#dport}
    */
    readonly dport?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_application#icmpcode ComputeSecurityApplication#icmpcode}
    */
    readonly icmpcode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_application#icmptype ComputeSecurityApplication#icmptype}
    */
    readonly icmptype?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_application#id ComputeSecurityApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_application#name ComputeSecurityApplication#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_application#protocol ComputeSecurityApplication#protocol}
    */
    readonly protocol: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_security_application opc_compute_security_application}
*/
export declare class ComputeSecurityApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_security_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_security_application opc_compute_security_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSecurityApplicationConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSecurityApplicationConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dport?;
    get dport(): string;
    set dport(value: string);
    resetDport(): void;
    get dportInput(): string | undefined;
    private _icmpcode?;
    get icmpcode(): string;
    set icmpcode(value: string);
    resetIcmpcode(): void;
    get icmpcodeInput(): string | undefined;
    private _icmptype?;
    get icmptype(): string;
    set icmptype(value: string);
    resetIcmptype(): void;
    get icmptypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
