import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeIpAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_ip_association#id ComputeIpAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_ip_association#name ComputeIpAssociation#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_ip_association#parent_pool ComputeIpAssociation#parent_pool}
    */
    readonly parentPool: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_ip_association#vcable ComputeIpAssociation#vcable}
    */
    readonly vcable: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_ip_association opc_compute_ip_association}
*/
export declare class ComputeIpAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_ip_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_ip_association opc_compute_ip_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeIpAssociationConfig
    */
    constructor(scope: Construct, id: string, config: ComputeIpAssociationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _parentPool?;
    get parentPool(): string;
    set parentPool(value: string);
    get parentPoolInput(): string | undefined;
    private _vcable?;
    get vcable(): string;
    set vcable(value: string);
    get vcableInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
