# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:20:58 2022
#

import datetime
import uuid
import time
import dataclasses
import typing
import mettle.io
import mettle.db

from .cfg_key import tCfgKey

@dataclasses.dataclass(slots=True)
class tCfg(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    id: str = dataclasses.field(default='', compare=True, hash=True)
    col_pk: str = dataclasses.field(default='', compare=False)
    col_ignr: str = dataclasses.field(default='', compare=False)
    par_id: str = dataclasses.field(default='', compare=False)
    par_col: str = dataclasses.field(default='', compare=False)
    last_chg: typing.Optional[datetime.datetime] = dataclasses.field(default=None, compare=False)
    audby_col: str = dataclasses.field(default='', compare=False)
    mode: str = dataclasses.field(default='', compare=False)

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = ''
        self.col_pk = ''
        self.col_ignr = ''
        self.par_id = ''
        self.par_col = ''
        self.last_chg = None
        self.audby_col = ''
        self.mode = ''

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tCfg'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_string("id", self.id)
        _w.write_string("col_pk", self.col_pk)
        _w.write_string("col_ignr", self.col_ignr)
        _w.write_string("par_id", self.par_id)
        _w.write_string("par_col", self.par_col)
        _w.write_datetime("last_chg", self.last_chg)
        _w.write_string("audby_col", self.audby_col)
        _w.write_char("mode", self.mode)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_string("id")
        self.col_pk = _r.read_string("col_pk")
        self.col_ignr = _r.read_string("col_ignr")
        self.par_id = _r.read_string("par_id")
        self.par_col = _r.read_string("par_col")
        self.last_chg = _r.read_datetime("last_chg")
        self.audby_col = _r.read_string("audby_col")
        self.mode = _r.read_char("mode")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tCfg"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.col_pk = rec.col_pk
        self.col_ignr = rec.col_ignr
        self.par_id = rec.par_id
        self.par_col = rec.par_col
        self.last_chg = rec.last_chg
        self.audby_col = rec.audby_col
        self.mode = rec.mode

    def _write_pk(self, _key: "tCfg"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tCfg"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tCfgKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tCfgKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        if key_only:
            return dvc

        dvc.add_targ("mode", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("mode", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("mode", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("mode", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['M','T']))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tCfg._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tCfgKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tCfgKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    class Mode_Couplet(dict):
        key_manual = "M"
        key_trigger = "T"

        value_manual = "Manual"
        value_trigger = "Trigger"

        def __init__(self):
            self[self.key_manual] = self.value_manual
            self[self.key_trigger] = self.value_trigger

        @staticmethod
        def get_value(key):
            if key == tCfg.Mode_Couplet.key_manual:
                return tCfg.Mode_Couplet.value_manual

            if key == tCfg.Mode_Couplet.key_trigger:
                return tCfg.Mode_Couplet.value_trigger

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return (x.id > y.id) - (x.id < y.id)

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tCfg.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tCfg()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tCfg._cache_davs(dvc, for_ins, key_only)

