# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:20:58 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_audit.db.tables.col import tCol

class dColInsert:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tCol()

    async def __aenter__(self):
        """
        With statement enter.
        """
        return self

    async def __aexit__(self, type, value, traceback):
        """
        With statement exit.
        """
        await self._destroy()

    async def _destroy(self):
        if self._dbstmnt:
            await self._dbstmnt.destroy()
            self._dbstmnt = None

    async def exec_deft(self,
                        aud_id: int,
                        name: str,
                        before: str,
                        after: str) -> "dColInsert":
        """
        Execute the query by setting all the inputs.

        :param aud_id: int
        :param name: str
        :param before: str
        :param after: str
        :return: Self for convenience.
        """
        self.irec.aud_id = aud_id
        self.irec.name = name
        self.irec.before = before
        self.irec.after = after

        return await self.exec()

    async def exec(self, irec: tCol = None) -> "dColInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        await self._destroy()

        self._dbstmnt = await self._dbcon.statement("ColInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into audit.Col (
  aud_id,
  name,
  before,
  after
) values (
  :aud_id,
  :name,
  :before,
  :after
)""")

        self._dbstmnt.bind_in("aud_id", self.irec.aud_id, int, 8)
        self._dbstmnt.bind_in("name", self.irec.name, str)
        self._dbstmnt.bind_in("before", self.irec.before, str)
        self._dbstmnt.bind_in("after", self.irec.after, str)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

