# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:20:58 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_audit.db.tables.icfg_upd_last_change import iCfgUpdLastChange

class dCfgUpdLastChange:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iCfgUpdLastChange()

    async def __aenter__(self):
        """
        With statement enter.
        """
        return self

    async def __aexit__(self, type, value, traceback):
        """
        With statement exit.
        """
        await self._destroy()

    async def _destroy(self):
        if self._dbstmnt:
            await self._dbstmnt.destroy()
            self._dbstmnt = None

    async def exec_deft(self,
                        idcrit: str) -> "dCfgUpdLastChange":
        """
        Execute the query by setting all the inputs.

        :param idcrit: str
        :return: Self for convenience.
        """
        self.irec.idcrit = idcrit

        return await self.exec()

    async def exec(self, irec: iCfgUpdLastChange = None) -> "dCfgUpdLastChange":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        await self._destroy()

        self._dbstmnt = await self._dbcon.statement("CfgUpdLastChange", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  audit.cfg c
set
  last_chg = current_timestamp
where
  c.id in ( [idcrit] )""")

        self._dbstmnt.dynamic("[idcrit]", self.irec.idcrit)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

