# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:20:58 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_audit.db.tables.tran_key import tTranKey
from bs_audit.db.tables.tran import tTran

class dTranSelectOne:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tTranKey()
        self.orec     = None

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  id: int) -> "dTranSelectOne":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :return: Self for convenience.
        """
        self.irec.id = id

        return self.exec()

    def exec(self, irec: tTranKey = None) -> "dTranSelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("TranSelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  site_id,
  who,
  src,
  tm_stamp
from
  audit.Tran
where
  id = :id""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("who", str, 128)
        self._dbstmnt.bind_out("src", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:Tran, proc:SelectOne, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = tTran()

        self.orec.id = self._dbstmnt.result[0]
        self.orec.site_id = self._dbstmnt.result[1]
        self.orec.who = self._dbstmnt.result[2]
        self.orec.src = self._dbstmnt.result[3]
        self.orec.tm_stamp = self._dbstmnt.result[4]

        return True

    def fetch_iter(self) -> tTran:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while self.fetch():
            yield self.orec

    def fetch_all(self, out_list: tTran.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while self.fetch():
            out_list.append(self.orec)

        return len(out_list)

