# pyMAISE - Michigan Artificial Intelligance Standard Environment

[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![Tests Status](https://github.com/myerspat/pyMAISE/actions/workflows/test.yml/badge.svg)](https://github.com/myerspat/pyMAISE/actions/workflows)
[![Documentation Status](https://readthedocs.org/projects/pymaise/badge/?version=latest)](https://pymaise.readthedocs.io/en/latest/?badge=latest)

pyMAISE is an artificial intelligence (AI) and machine learning (ML) benchmarking library for nuclear reactor applications. It offers to streamline the building, tuning, and comparison of various ML models for user-provided data sets. Additionally, pyMAISE offers benchmarked data sets with example Jupyter Notebooks. Current ML algorithm support includes

- linear regression,
- lasso regression,
- decision tree regression,
- support vector regression,
- random forest regression,
- k-nearest neighbors regression,
- sequential dense neural networks.

These models are built using [scikit-learn](https://scikit-learn.org/stable/index.html) and [Keras](https://keras.io). For more information such as installation, examples, and use, refer to the sections below.

## Installation and Documentation

Refer to the [installation guide](https://pymaise.readthedocs.io/en/latest/installation.html) and [documentation](https://pymaise.readthedocs.io/en/latest/index.html) for help.

## Benchmark Example Jupyter Notebooks

You can find the pyMAISE benchmarks [here](https://pymaise.readthedocs.io/en/latest/examples/index.html).
