from systemdlint.cls.limitation import Limitation
from systemdlint.cls.setting import DropinAdditive
from systemdlint.cls.setting import Setting
from systemdlint.cls.value import AbsolutePathListValue
from systemdlint.cls.value import BooleanValue
from systemdlint.cls.value import CombinedValue
from systemdlint.cls.value import DeviceNodeValue
from systemdlint.cls.value import EitherValue
from systemdlint.cls.value import EmptyValue
from systemdlint.cls.value import EnumValue
from systemdlint.cls.value import ErrorTypeValue
from systemdlint.cls.value import ExecValue
from systemdlint.cls.value import GroupsValue
from systemdlint.cls.value import HexValue
from systemdlint.cls.value import IPorUrlValue
from systemdlint.cls.value import IPValue
from systemdlint.cls.value import KeyValuePairListValue
from systemdlint.cls.value import ListOf
from systemdlint.cls.value import MacAddressValue
from systemdlint.cls.value import MountPathValue
from systemdlint.cls.value import NumericValue
from systemdlint.cls.value import OctalModeValue
from systemdlint.cls.value import PathValue
from systemdlint.cls.value import SignalValue
from systemdlint.cls.value import TextValue
from systemdlint.cls.value import TimeValue
from systemdlint.cls.value import UnitListValue
from systemdlint.cls.value import UrlListValue
from systemdlint.cls.value import UsersValue

KNOWN_SETTINGS = [
    Setting(section="Address", name="AddPrefixRoute", allowedValue=BooleanValue(), sinceRel="2.45"),
    Setting(section="Address", name="Address", allowedValue=TextValue()),
    Setting(section="Address", name="AutoJoin", allowedValue=BooleanValue()),
    Setting(section="Address", name="Broadcast", allowedValue=IPValue()),
    Setting(section="Address", name="DuplicateAddressDetection", allowedValue=BooleanValue()),
    Setting(section="Address", name="HomeAddress", allowedValue=BooleanValue()),
    Setting(section="Address", name="Label", allowedValue=TextValue()),
    Setting(section="Address", name="ManageTemporaryAddress", allowedValue=BooleanValue()),
    Setting(section="Address", name="Peer", allowedValue=IPValue()),
    Setting(section="Address", name="PreferredLifetime", allowedValue=EnumValue(["forever", "infinity", "0"])),
    Setting(section="Address", name="PrefixRoute", allowedValue=BooleanValue(), tillRel="2.45"),
    Setting(section="Address", name="Scope", allowedValue=EitherValue(args=[EnumValue(["global", "link", "host"]), NumericValue(lower=0, upper=255)])),
    Setting(section="Automount", name="DirectoryMode", allowedValue=OctalModeValue()),
    Setting(section="Automount", name="TimeoutIdleSec", allowedValue=TimeValue(), sinceRel="2.20"),
    Setting(section="Automount", name="What", allowedValue=TextValue()),
    Setting(section="Automount", name="Where", allowedValue=AbsolutePathListValue()),
    Setting(section="BFIFO", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="BFIFO", name="PacketLimit", allowedValue=NumericValue(upper=4294967294), sinceRel="2.46"),
    Setting(section="BFIFO", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="Bond", name="AdActorSystem", allowedValue=TextValue()),
    Setting(section="Bond", name="AdActorSystemPriority", allowedValue=NumericValue(lower=1, upper=65535)),
    Setting(section="Bond", name="AdSelect", allowedValue=EnumValue(["stable", "bandwidth", "count"])),
    Setting(section="Bond", name="AdUserPortKey", allowedValue=NumericValue(lower=1, upper=1023)),
    Setting(section="Bond", name="AllSlavesActive", allowedValue=BooleanValue()),
    Setting(section="Bond", name="ARPAllTargets", allowedValue=EnumValue(["any", "all"])),
    Setting(section="Bond", name="ARPIntervalSec", allowedValue=NumericValue()),
    Setting(section="Bond", name="ARPIPTargets", allowedValue=TextValue()),
    Setting(section="Bond", name="ARPValidate", allowedValue=EnumValue(["none", "active", "backup", "all"])),
    Setting(section="Bond", name="DownDelaySec", allowedValue=NumericValue()),
    Setting(section="Bond", name="DynamicTransmitLoadBalancing", allowedValue=BooleanValue()),
    Setting(section="Bond", name="FailOverMACPolicy", allowedValue=EnumValue(["none", "active", "follow"])),
    Setting(section="Bond", name="GratuitousARP", allowedValue=NumericValue(lower=0, upper=255)),
    Setting(section="Bond", name="LACPTransmitRate", allowedValue=EnumValue(["slow", "fast"])),
    Setting(section="Bond", name="LearnPacketIntervalSec", allowedValue=NumericValue(lower=1, upper=2147483647)),
    Setting(section="Bond", name="MIIMonitorSec", allowedValue=NumericValue()),
    Setting(section="Bond", name="MinLinks", allowedValue=NumericValue()),
    Setting(section="Bond", name="Mode", allowedValue=EnumValue(["balance-rr", "active-backup", "balance-xor", "broadcast", "802.3ad", "balance-tlb", "balance-alb"])),
    Setting(section="Bond", name="PacketsPerSlave", allowedValue=NumericValue(lower=0, upper=65535)),
    Setting(section="Bond", name="PrimaryReselectPolicy", allowedValue=EnumValue(["always", "better", "failure"])),
    Setting(section="Bond", name="ResendIGMP", allowedValue=NumericValue(lower=0, upper=255)),
    Setting(section="Bond", name="TransmitHashPolicy", allowedValue=EnumValue(["layer2", "layer3+4", "layer2+3", "encap2+3", "encap3+4"])),
    Setting(section="Bond", name="UpDelaySec", allowedValue=NumericValue()),
    Setting(section="Bridge", name="AllowPortToBeRoot", allowedValue=BooleanValue()),
    Setting(section="Bridge", name="Cost", allowedValue=NumericValue(lower=1, upper=65535)),
    Setting(section="Bridge", name="FastLeave", allowedValue=BooleanValue()),
    Setting(section="Bridge", name="HairPin", allowedValue=BooleanValue()),
    Setting(section="Bridge", name="Learning", allowedValue=BooleanValue()),
    Setting(section="Bridge", name="MulticastFlood", allowedValue=BooleanValue()),
    Setting(section="Bridge", name="MulticastToUnicast", allowedValue=BooleanValue()),
    Setting(section="Bridge", name="NeighborSuppression", allowedValue=BooleanValue()),
    Setting(section="Bridge", name="Priority", allowedValue=NumericValue(lower=0, upper=63)),
    Setting(section="Bridge", name="ProxyARP", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="Bridge", name="ProxyARPWiFi", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="Bridge", name="UnicastFlood", allowedValue=BooleanValue()),
    Setting(section="Bridge", name="UseBPDU", allowedValue=BooleanValue()),
    Setting(section="Bridge", name="VLANProtocol", allowedValue=EnumValue(["802.1Q", "802.1ad"]), sinceRel="2.46"),
    Setting(section="BridgeFDB", name="AssociatedWith", allowedValue=EnumValue(["use", "self", "master", "router"]), sinceRel="2.43"),
    Setting(section="BridgeFDB", name="Destination", allowedValue=IPValue(), sinceRel="2.43"),
    Setting(section="BridgeFDB", name="MACAddress", allowedValue=MacAddressValue()),
    Setting(section="BridgeFDB", name="VLANId", allowedValue=TextValue()),
    Setting(section="BridgeFDB", name="VNI", allowedValue=NumericValue(1, 16777215), sinceRel="2.43"),
    Setting(section="BridgeVLAN", name="EgressUntagged", allowedValue=TextValue(), requires=[Limitation(key="VLAN")]),
    Setting(section="BridgeVLAN", name="PVID", allowedValue=TextValue(), requires=[Limitation(key="VLAN")]),
    Setting(section="BridgeVLAN", name="VLAN", allowedValue=TextValue()),
    Setting(section="CAKE", name="Bandwidth", allowedValue=NumericValue(base=1000, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="CAKE", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="CAKE", name="OverheadBytes", allowedValue=NumericValue(lower=-64, upper=256), sinceRel="2.46"),
    Setting(section="CAKE", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="CAN", name="BitRate", allowedValue=NumericValue(lower=1, upper=4294967295, base=1000, suffixes=["K", "M"]), sinceRel="2.46"),
    Setting(section="CAN", name="Bitrate", allowedValue=NumericValue(suffixes=["K", "M"], base=1000)),
    Setting(section="CAN", name="DataBitRate", allowedValue=NumericValue(lower=1, upper=4294967295, base=1000, suffixes=["K", "M"]), sinceRel="2.46"),
    Setting(section="CAN", name="DataSamplePoint", allowedValue=TextValue(), sinceRel="2.46"), ## TODO: percentage value
    Setting(section="CAN", name="FDMode", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="CAN", name="FDNonISO", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="CAN", name="ListenOnly", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="CAN", name="RestartSec", allowedValue=TimeValue()),
    Setting(section="CAN", name="SamplePoint", allowedValue=TextValue(), sinceRel="2.46"), ## TODO: percentage value
    Setting(section="CAN", name="SamplePoint", allowedValue=TextValue()),
    Setting(section="CAN", name="Termination", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="CAN", name="TripleSampling", allowedValue=BooleanValue()),
    Setting(section="ControlledDelay", name="CEThresholdSec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="ControlledDelay", name="ECN", allowedValue=BooleanValue(), sinceRel="2.45"),
    Setting(section="ControlledDelay", name="Handle", allowedValue=EitherValue(args=[HexValue(lower=0, upper=0xfff), EmptyValue()]), sinceRel="2.45"),
    Setting(section="ControlledDelay", name="IntervalSec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="ControlledDelay", name="PacketLimit", allowedValue=NumericValue(lower=0, upper=4294967294), sinceRel="2.45"),
    Setting(section="ControlledDelay", name="Parent", allowedValue=EnumValue(value=["root", "clsact", "ingress"]), sinceRel="2.45"),
    Setting(section="ControlledDelay", name="TargetSec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="DeficitRoundRobinScheduler", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="DeficitRoundRobinScheduler", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="DeficitRoundRobinSchedulerClass", name="ClassId", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="DeficitRoundRobinSchedulerClass", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root"])]), sinceRel="2.46"),
    Setting(section="DeficitRoundRobinSchedulerClass", name="QuantumBytes", allowedValue=NumericValue(base=1024, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="DHCP", name="Anonymize", allowedValue=BooleanValue(), requires=[Limitation(key="MACAddressPolicy", value=["1", "yes", "true"], section="Link")]),
    Setting(section="DHCP", name="ClientIdentifier", allowedValue=EnumValue(["mac", "duid", "duid-only"]), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCP", name="CriticalConnection", allowedValue=BooleanValue(), tillRel="2.42"),
    Setting(section="DHCP", name="DUIDRawData", allowedValue=TextValue()),
    Setting(section="DHCP", name="DUIDType", allowedValue=TextValue()),
    Setting(section="DHCP", name="ForceDHCPv6PDOtherInformation", allowedValue=BooleanValue()),
    Setting(section="DHCP", name="Hostname", allowedValue=TextValue()),
    Setting(section="DHCP", name="IAID", allowedValue=NumericValue()),
    Setting(section="DHCP", name="KeepConfiguration", allowedValue=TextValue(), sinceRel="2.43"),
    Setting(section="DHCP", name="ListenPort", allowedValue=NumericValue(lower=1, upper=65535)),
    Setting(section="DHCP", name="RapidCommit", allowedValue=BooleanValue()),
    Setting(section="DHCP", name="RequestBroadcast", allowedValue=TextValue()),
    Setting(section="DHCP", name="RouteMetric", allowedValue=NumericValue()),
    Setting(section="DHCP", name="RouteTable", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="DHCP", name="SendHostname", allowedValue=BooleanValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCP", name="UseDNS", allowedValue=BooleanValue()),
    Setting(section="DHCP", name="UseDomains", allowedValue=EitherValue(args=[BooleanValue(), EnumValue(["route"])])),
    Setting(section="DHCP", name="UseHostname", allowedValue=BooleanValue()),
    Setting(section="DHCP", name="UseMTU", allowedValue=BooleanValue(), restricted=[Limitation(key="MTUBytes", section="Link"), Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCP", name="UseNTP", allowedValue=BooleanValue()),
    Setting(section="DHCP", name="UserClass", allowedValue=TextValue()),
    Setting(section="DHCP", name="UseRoutes", allowedValue=BooleanValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCP", name="UseTimezone", allowedValue=BooleanValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCP", name="VendorClassIdentifier", allowedValue=TextValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPServer", name="DefaultLeaseTimeSec", allowedValue=TimeValue()),
    Setting(section="DHCPServer", name="DNS", allowedValue=TextValue()),
    Setting(section="DHCPServer", name="EmitDNS", allowedValue=BooleanValue()),
    Setting(section="DHCPServer", name="EmitLPR", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="DHCPServer", name="EmitNTP", allowedValue=BooleanValue()),
    Setting(section="DHCPServer", name="EmitPOP3", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="DHCPServer", name="EmitRouter", allowedValue=BooleanValue()),
    Setting(section="DHCPServer", name="EmitSIP", allowedValue=BooleanValue(), sinceRel="2.44"),
    Setting(section="DHCPServer", name="EmitSMTP", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="DHCPServer", name="EmitTimezone", allowedValue=BooleanValue()),
    Setting(section="DHCPServer", name="LRP", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="DHCPServer", name="MaxLeaseTimeSec", allowedValue=TimeValue()),
    Setting(section="DHCPServer", name="NTP", allowedValue=TextValue()),
    Setting(section="DHCPServer", name="PoolOffset", allowedValue=NumericValue()),
    Setting(section="DHCPServer", name="PoolSize", allowedValue=NumericValue()),
    Setting(section="DHCPServer", name="POP3", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="DHCPServer", name="SendOption", allowedValue=TextValue(), sinceRel="2.44"),  # TODO: option entry parser
    Setting(section="DHCPServer", name="SendVendorOption", allowedValue=TextValue(), sinceRel="2.46"), ## TODO parser
    Setting(section="DHCPServer", name="SIP", allowedValue=TextValue(), sinceRel="2.44"),
    Setting(section="DHCPServer", name="SMTP", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="DHCPServer", name="Timezone", allowedValue=TextValue()),
    Setting(section="DHCPv4", name="DenyList", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="DHCPv4", name="FallbackLeaseLifetimeSec", allowedValue=EitherValue([NumericValue(), EnumValue(["forever", "infinity"])]), sinceRel="2.46"),
    Setting(section="DHCPv4", name="SendOption", allowedValue=TextValue(), sinceRel="2.44"), # TODO: option entry parser
    Setting(section="DHCPv4", name="SendVendorOption", allowedValue=TextValue(), sinceRel="2.46"), ## TODO parser
    Setting(section="DHCPv4", name="UseGateway", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="DHCPv4", sinceRel="2.43", name="Anonymize", allowedValue=BooleanValue(), requires=[Limitation(key="MACAddressPolicy", value=["1", "yes", "true"], section="Link")]),
    Setting(section="DHCPv4", sinceRel="2.43", name="ClientIdentifier", allowedValue=EnumValue(["mac", "duid", "duid-only"]), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv4", sinceRel="2.43", name="DUIDRawData", allowedValue=TextValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="DUIDType", allowedValue=TextValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="ForceDHCPv6PDOtherInformation", allowedValue=BooleanValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="Hostname", allowedValue=TextValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="IAID", allowedValue=NumericValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="KeepConfiguration", allowedValue=TextValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="ListenPort", allowedValue=NumericValue(lower=1, upper=65535)),
    Setting(section="DHCPv4", sinceRel="2.43", name="RapidCommit", allowedValue=BooleanValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="RequestBroadcast", allowedValue=TextValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="RouteMetric", allowedValue=NumericValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="RouteTable", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="DHCPv4", sinceRel="2.43", name="SendHostname", allowedValue=BooleanValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv4", sinceRel="2.43", name="UseDNS", allowedValue=BooleanValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="UseDomains", allowedValue=EitherValue(args=[BooleanValue(), EnumValue(["route"])])),
    Setting(section="DHCPv4", sinceRel="2.43", name="UseHostname", allowedValue=BooleanValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="UseMTU", allowedValue=BooleanValue(), restricted=[Limitation(key="MTUBytes", section="Link"), Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv4", sinceRel="2.43", name="UseNTP", allowedValue=BooleanValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="UserClass", allowedValue=TextValue()),
    Setting(section="DHCPv4", sinceRel="2.43", name="UseRoutes", allowedValue=BooleanValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv4", sinceRel="2.43", name="UseTimezone", allowedValue=BooleanValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv4", sinceRel="2.43", name="VendorClassIdentifier", allowedValue=TextValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv4", sinceRel="2.45", name="SendDecline", allowedValue=BooleanValue()),
    Setting(section="DHCPv6", name="PrefixDelegationHint", allowedValue=IPValue(), sinceRel="2.44"),
    Setting(section="DHCPv6", name="RequestOptions", allowedValue=ListOf(NumericValue()), sinceRel="2.46"),
    Setting(section="DHCPv6", name="SendOption", allowedValue=TextValue(), sinceRel="2.46"), ## TODO parser
    Setting(section="DHCPv6", name="VendorClass", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="DHCPv6", name="WithoutRA", allowedValue=EnumValue(["solicit", "information-request"]), sinceRel="2.46"),
    Setting(section="DHCPv6", sinceRel="2.43", name="Anonymize", allowedValue=BooleanValue(), requires=[Limitation(key="MACAddressPolicy", value=["1", "yes", "true"], section="Link")]),
    Setting(section="DHCPv6", sinceRel="2.43", name="ClientIdentifier", allowedValue=EnumValue(["mac", "duid", "duid-only"]), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv6", sinceRel="2.43", name="DUIDRawData", allowedValue=TextValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="DUIDType", allowedValue=TextValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="ForceDHCPv6PDOtherInformation", allowedValue=BooleanValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="Hostname", allowedValue=TextValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="IAID", allowedValue=NumericValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="KeepConfiguration", allowedValue=TextValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="ListenPort", allowedValue=NumericValue(lower=1, upper=65535)),
    Setting(section="DHCPv6", sinceRel="2.43", name="RapidCommit", allowedValue=BooleanValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="RequestBroadcast", allowedValue=TextValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="RouteMetric", allowedValue=NumericValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="RouteTable", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="DHCPv6", sinceRel="2.43", name="SendHostname", allowedValue=BooleanValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv6", sinceRel="2.43", name="UseDNS", allowedValue=BooleanValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="UseDomains", allowedValue=EitherValue(args=[BooleanValue(), EnumValue(["route"])])),
    Setting(section="DHCPv6", sinceRel="2.43", name="UseHostname", allowedValue=BooleanValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="UseMTU", allowedValue=BooleanValue(), restricted=[Limitation(key="MTUBytes", section="Link"), Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv6", sinceRel="2.43", name="UseNTP", allowedValue=BooleanValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="UserClass", allowedValue=TextValue()),
    Setting(section="DHCPv6", sinceRel="2.43", name="UseRoutes", allowedValue=BooleanValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv6", sinceRel="2.43", name="UseTimezone", allowedValue=BooleanValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv6", sinceRel="2.43", name="VendorClassIdentifier", allowedValue=TextValue(), restricted=[Limitation(key="Anonymize", value=["1", "yes", "true"])]),
    Setting(section="DHCPv6PrefixDelegation", name="Assign", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="DHCPv6PrefixDelegation", name="SubnetId", allowedValue=NumericValue(upper=0x7fffffffffffffff, numberBase=16), sinceRel="2.46"),
    Setting(section="DHCPv6PrefixDelegation", name="Token", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="EnhancedTransmissionSelection", name="Bands", allowedValue=NumericValue(lower=1, upper=16), sinceRel="2.46"),
    Setting(section="EnhancedTransmissionSelection", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="EnhancedTransmissionSelection", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="EnhancedTransmissionSelection", name="PriorityMap", allowedValue=ListOf(NumericValue()), sinceRel="2.46"),
    Setting(section="EnhancedTransmissionSelection", name="QuantumBytes", allowedValue=NumericValue(base=1024, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="EnhancedTransmissionSelection", name="StrictBands", allowedValue=NumericValue(lower=1, upper=16), sinceRel="2.46"),
    Setting(section="FairQueueing", name="Buckets", allowedValue=NumericValue(), sinceRel="2.45"),
    Setting(section="FairQueueing", name="CEThresholdSec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="FairQueueing", name="FlowLimit", allowedValue=NumericValue(), sinceRel="2.45"),
    Setting(section="FairQueueing", name="Handle", allowedValue=EitherValue(args=[HexValue(lower=0, upper=0xfff), EmptyValue()]), sinceRel="2.45"),
    Setting(section="FairQueueing", name="InitialQuantum", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="FairQueueing", name="MaximumRate", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="FairQueueing", name="OrphanMask", allowedValue=NumericValue(), sinceRel="2.45"),
    Setting(section="FairQueueing", name="Pacing", allowedValue=BooleanValue(), sinceRel="2.45"),
    Setting(section="FairQueueing", name="PacketLimit", allowedValue=NumericValue(), sinceRel="2.45"),
    Setting(section="FairQueueing", name="Parent", allowedValue=EnumValue(value=["root", "clsact", "ingress"]), sinceRel="2.45"),
    Setting(section="FairQueueing", name="Quantum", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="CEThresholdSec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="ECN", allowedValue=BooleanValue(), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="Flows", allowedValue=NumericValue(), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="Handle", allowedValue=EitherValue(args=[HexValue(lower=0, upper=0xfff), EmptyValue()]), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="IntervalSec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="MemoryLimit", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="PacketLimit", allowedValue=NumericValue(lower=0, upper=4294967294), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="Parent", allowedValue=EnumValue(value=["root", "clsact", "ingress"]), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="Quantum", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="FairQueueingControlledDelay", name="TargetSec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="FooOverUDP", name="Encapsulation", allowedValue=TextValue()),
    Setting(section="FooOverUDP", name="Local", allowedValue=IPValue(), sinceRel="2.43"),
    Setting(section="FooOverUDP", name="Peer", allowedValue=IPValue(), sinceRel="2.43"),
    Setting(section="FooOverUDP", name="PeerPort", allowedValue=NumericValue(lower=1, upper=65534), sinceRel="2.43"),
    Setting(section="FooOverUDP", name="Port", allowedValue=NumericValue(lower=1, upper=65534)),
    Setting(section="FooOverUDP", name="Protocol", allowedValue=NumericValue(lower=1, upper=255, specials=["gre", "ipip"])),
    Setting(section="GenericRandomEarlyDetection", name="DefaultVirtualQueue", allowedValue=NumericValue(lower=1, upper=16), sinceRel="2.46"),
    Setting(section="GenericRandomEarlyDetection", name="GenericRIO", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="GenericRandomEarlyDetection", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="GenericRandomEarlyDetection", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="GenericRandomEarlyDetection", name="VirtualQueues", allowedValue=NumericValue(lower=1, upper=16), sinceRel="2.46"),
    Setting(section="GENEVE", name="DestinationPort", allowedValue=NumericValue(lower=1, upper=65534)),
    Setting(section="GENEVE", name="FlowLabel", allowedValue=TextValue()),
    Setting(section="GENEVE", name="GenericProtocolExtension", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="GENEVE", name="Id", allowedValue=NumericValue(lower=0, upper=16777215)),
    Setting(section="GENEVE", name="IPDoNotFragment", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="GENEVE", name="Remote", allowedValue=IPValue()),
    Setting(section="GENEVE", name="TOS", allowedValue=NumericValue(lower=1, upper=255)),
    Setting(section="GENEVE", name="TTL", allowedValue=NumericValue(lower=1, upper=255)),
    Setting(section="GENEVE", name="UDP6ZeroChecksumRx", allowedValue=BooleanValue()),
    Setting(section="GENEVE", name="UDP6ZeroChecksumTx", allowedValue=BooleanValue()),
    Setting(section="GENEVE", name="UDPChecksum", allowedValue=BooleanValue()),
    Setting(section="HeavyHitterFilter", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="HeavyHitterFilter", name="PacketLimit", allowedValue=NumericValue(upper=4294967294), sinceRel="2.46"),
    Setting(section="HeavyHitterFilter", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucket", name="DefaultClass", allowedValue=NumericValue(numberBase=16), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucket", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucket", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucket", name="RateToQuantum", allowedValue=NumericValue(), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="BufferBytes", allowedValue=NumericValue(base=1024, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="CeilBufferBytes", allowedValue=NumericValue(base=1024, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="CeilRate", allowedValue=NumericValue(base=1000, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="ClassId", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="MTUBytes", allowedValue=NumericValue(base=1024, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="OverheadBytes", allowedValue=NumericValue(base=1024, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root"])]), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="Priority", allowedValue=NumericValue(), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="QuantumBytes", allowedValue=NumericValue(base=1024, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="HierarchyTokenBucketClass", name="Rate", allowedValue=NumericValue(base=1000, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="Install", name="Alias", allowedValue=TextValue()),
    Setting(section="Install", name="Also", allowedValue=UnitListValue()),
    Setting(section="Install", name="DefaultInstance", allowedValue=TextValue(), sinceRel="2.15"), # TODO Template checks
    Setting(section="Install", name="RequiredBy", allowedValue=UnitListValue()),
    Setting(section="Install", name="WantedBy", allowedValue=UnitListValue()),
    Setting(section="IPv6AcceptRA", name="DenyList", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="IPv6AcceptRA", name="DHCPv6Client", allowedValue=EitherValue([EnumValue(["always"]), BooleanValue()]), sinceRel="2.46"),
    Setting(section="IPv6AcceptRA", name="RouteTable", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="IPv6AcceptRA", name="UseAutonomousPrefix", allowedValue=BooleanValue()),
    Setting(section="IPv6AcceptRA", name="UseDNS", allowedValue=BooleanValue()),
    Setting(section="IPv6AcceptRA", name="UseDomains", allowedValue=BooleanValue()),
    Setting(section="IPv6AcceptRA", name="UseOnLinkPrefix", allowedValue=BooleanValue()),
    Setting(section="IPv6AddressLabel", name="Label", allowedValue=TextValue()),
    Setting(section="IPv6AddressLabel", name="Prefix", allowedValue=TextValue()),
    Setting(section="IPv6Prefix", name="AddressAutoconfiguration", allowedValue=BooleanValue()),
    Setting(section="IPv6Prefix", name="Assign", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="IPv6Prefix", name="OnLink", allowedValue=BooleanValue()),
    Setting(section="IPv6Prefix", name="PreferredLifetimeSec", allowedValue=TimeValue()),
    Setting(section="IPv6Prefix", name="Prefix", allowedValue=TextValue()),
    Setting(section="IPv6Prefix", name="ValidLifetimeSec", allowedValue=TimeValue()),
    Setting(section="IPv6PrefixDelegation", name="DNS", allowedValue=TextValue()),
    Setting(section="IPv6PrefixDelegation", name="DNSLifetimeSec", allowedValue=TimeValue()),
    Setting(section="IPv6PrefixDelegation", name="Domains", allowedValue=TextValue()),
    Setting(section="IPv6PrefixDelegation", name="EmitDNS", allowedValue=BooleanValue()),
    Setting(section="IPv6PrefixDelegation", name="EmitDomains", allowedValue=BooleanValue()),
    Setting(section="IPv6PrefixDelegation", name="Managed", allowedValue=BooleanValue()),
    Setting(section="IPv6PrefixDelegation", name="OtherInformation", allowedValue=BooleanValue()),
    Setting(section="IPv6PrefixDelegation", name="RouterLifetimeSec", allowedValue=TimeValue()),
    Setting(section="IPv6PrefixDelegation", name="RouterPreference", allowedValue=EnumValue(["high", "medium", "low", "normal", "default"])),
    Setting(section="IPv6RoutePrefix", name="Route", allowedValue=TextValue(), sinceRel="2.44"), # TODO: route entry parser
    Setting(section="IPVLAN", name="Flags", allowedValue=EnumValue(["bridge", "private", "vepa"])),
    Setting(section="IPVLAN", name="Mode", allowedValue=EnumValue(["L2", "L3", "L3S"])),
    Setting(section="Journal", name="Compress", allowedValue=BooleanValue()),
    Setting(section="Journal", name="ForwardToConsole", allowedValue=BooleanValue()),
    Setting(section="Journal", name="ForwardToKMsg", allowedValue=BooleanValue()),
    Setting(section="Journal", name="ForwardToSyslog", allowedValue=BooleanValue()),
    Setting(section="Journal", name="ForwardToWall", allowedValue=BooleanValue()),
    Setting(section="Journal", name="LineMax", allowedValue=NumericValue(lower=79, suffixes=["K", "M", "G", "T"])),
    Setting(section="Journal", name="MaxFileSec", allowedValue=NumericValue(suffixes=["year", "month", "week", "day", "h", "m"])),
    Setting(section="Journal", name="MaxLevelConsole", allowedValue=EitherValue([NumericValue(upper=7), EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"])])),
    Setting(section="Journal", name="MaxLevelKMsg", allowedValue=EitherValue([NumericValue(upper=7), EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"])])),
    Setting(section="Journal", name="MaxLevelStore", allowedValue=EitherValue([NumericValue(upper=7), EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"])])),
    Setting(section="Journal", name="MaxLevelSyslog", allowedValue=EitherValue([NumericValue(upper=7), EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"])])),
    Setting(section="Journal", name="MaxLevelWall", allowedValue=EitherValue([NumericValue(upper=7), EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"])])),
    Setting(section="Journal", name="MaxRetentionSec", allowedValue=NumericValue(suffixes=["year", "month", "week", "day", "h", "m"])),
    Setting(section="Journal", name="RateLimitBurst", allowedValue=NumericValue()),
    Setting(section="Journal", name="RateLimitIntervalSec", allowedValue=NumericValue(suffixes=["s", "min", "h", "ms", "us"])),
    Setting(section="Journal", name="ReadKMsg", allowedValue=BooleanValue()),
    Setting(section="Journal", name="RuntimeKeepFree", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "P", "E"])),
    Setting(section="Journal", name="RuntimeMaxFiles", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "P", "E"])),
    Setting(section="Journal", name="RuntimeMaxFileSize", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "P", "E"])),
    Setting(section="Journal", name="RuntimeMaxUse", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "P", "E"])),
    Setting(section="Journal", name="Seal", allowedValue=BooleanValue()),
    Setting(section="Journal", name="SplitMode", allowedValue=EnumValue(["uid", "none"])),
    Setting(section="Journal", name="Storage", allowedValue=EnumValue(["volatile", "persistent", "auto", "none"])),
    Setting(section="Journal", name="SyncIntervalSec", allowedValue=TimeValue()),
    Setting(section="Journal", name="SystemKeepFree", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "P", "E"])),
    Setting(section="Journal", name="SystemMaxFiles", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "P", "E"])),
    Setting(section="Journal", name="SystemMaxFileSize", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "P", "E"])),
    Setting(section="Journal", name="SystemMaxUse", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "P", "E"])),
    Setting(section="Journal", name="TTYPath", allowedValue=DeviceNodeValue()),
    Setting(section="L2TP", name="DestinationPort", allowedValue=NumericValue(lower=1, upper=65534)),
    Setting(section="L2TP", name="EncapsulationType", allowedValue=EnumValue(["ip", "udp"])),
    Setting(section="L2TP", name="Local", allowedValue=EitherValue(args=[IPValue(), EnumValue(["auto", "static", "dynamic"])])),
    Setting(section="L2TP", name="PeerTunnelId", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="L2TP", name="Remote", allowedValue=IPValue()),
    Setting(section="L2TP", name="TunnelId", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="L2TP", name="UDP6ZeroChecksumRx", allowedValue=BooleanValue()),
    Setting(section="L2TP", name="UDP6ZeroChecksumTx", allowedValue=BooleanValue()),
    Setting(section="L2TP", name="UDPChecksum", allowedValue=BooleanValue()),
    Setting(section="L2TP", name="UDPSourcePort", allowedValue=NumericValue(lower=1, upper=65534)),
    Setting(section="L2TPSession", name="Layer2SpecificHeader", allowedValue=EnumValue(["none", "default"])),
    Setting(section="L2TPSession", name="Name", allowedValue=TextValue()),
    Setting(section="L2TPSession", name="PeerSessionId", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="L2TPSession", name="SessionId", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="LifetimeSec", name="Route", allowedValue=NumericValue(lower=0), sinceRel="2.44"),
    Setting(section="Link", name="AllMulticast", allowedValue=BooleanValue(), requires=[Limitation(key="Multicast", value=["0", "true", "yes"])]),
    Setting(section="Link", name="AlternativeName", allowedValue=TextValue(), dropinproc=DropinAdditive(), sinceRel="2.45"),
    Setting(section="Link", name="AlternativeNamesPolicy", allowedValue=EnumValue(["database", "onboard", "slot", "path", "mac"]), sinceRel="2.45"),
    Setting(section="Link", name="ARP", allowedValue=BooleanValue()),
    Setting(section="Link", name="AutoNegotiationFlowControl", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="Link", name="Group", allowedValue=NumericValue(lower=0, upper=4294967294), sinceRel="2.46"),
    Setting(section="Link", name="MACAddress", allowedValue=ListOf(MacAddressValue())),
    Setting(section="Link", name="MACAddressPolicy", allowedValue=TextValue()), # TODO: parser
    Setting(section="Link", name="MTUBytes", allowedValue=NumericValue(suffixes=["K", "M", "G"], base=1024)),
    Setting(section="Link", name="Multicast", allowedValue=BooleanValue()),
    Setting(section="Link", name="OriginalName", allowedValue=ListOf(TextValue()), sinceRel="2.43"),
    Setting(section="Link", name="RequiredForOnline", allowedValue=BooleanValue()),
    Setting(section="Link", name="RxBufferSize", allowedValue=NumericValue(lower=0), sinceRel="2.44"),
    Setting(section="Link", name="RxFlowControl", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="Link", name="TxBufferSize", allowedValue=NumericValue(lower=0), sinceRel="2.44"),
    Setting(section="Link", name="TxFlowControl", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="Link", name="Unmanaged", allowedValue=BooleanValue()),
    Setting(section="LLDP", name="MUDURL", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="Login", name="HandleHibernateKey", allowedValue=EnumValue(["ignore", "poweroff", "reboot", "halt", "kexec", "suspend", "hibernate", "hybrid-sleep", "suspend-then-hibernate", "lock"])),
    Setting(section="Login", name="HandleLidSwitch", allowedValue=EnumValue(["ignore", "poweroff", "reboot", "halt", "kexec", "suspend", "hibernate", "hybrid-sleep", "suspend-then-hibernate", "lock"])),
    Setting(section="Login", name="HandleLidSwitchDocked", allowedValue=EnumValue(["ignore", "poweroff", "reboot", "halt", "kexec", "suspend", "hibernate", "hybrid-sleep", "suspend-then-hibernate", "lock"])),
    Setting(section="Login", name="HandleLidSwitchExternalPower", allowedValue=EnumValue(["ignore", "poweroff", "reboot", "halt", "kexec", "suspend", "hibernate", "hybrid-sleep", "suspend-then-hibernate", "lock"])),
    Setting(section="Login", name="HandlePowerKey", allowedValue=EnumValue(["ignore", "poweroff", "reboot", "halt", "kexec", "suspend", "hibernate", "hybrid-sleep", "suspend-then-hibernate", "lock"])),
    Setting(section="Login", name="HandleSuspendKey", allowedValue=EnumValue(["ignore", "poweroff", "reboot", "halt", "kexec", "suspend", "hibernate", "hybrid-sleep", "suspend-then-hibernate", "lock"])),
    Setting(section="Login", name="HibernateKeyIgnoreInhibited", allowedValue=BooleanValue()),
    Setting(section="Login", name="HoldoffTimeoutSec", allowedValue=TimeValue()),
    Setting(section="Login", name="IdleAction", allowedValue=EnumValue(["ignore", "poweroff", "reboot", "halt", "kexec", "suspend", "hibernate", "hybrid-sleep", "suspend-then-hibernate", "lock"])),
    Setting(section="Login", name="IdleActionSec", allowedValue=TimeValue(), requires=[Limitation(key="IdleAction")]),
    Setting(section="Login", name="InhibitDelayMaxSec", allowedValue=TimeValue()),
    Setting(section="Login", name="InhibitorsMax", allowedValue=NumericValue(suffixes=["K", "G", "M", "T"])),
    Setting(section="Login", name="KillExcludeUsers", allowedValue=TextValue()),
    Setting(section="Login", name="KillOnlyUsers", allowedValue=TextValue()),
    Setting(section="Login", name="KillUserProcesses", allowedValue=BooleanValue()),
    Setting(section="Login", name="LidSwitchIgnoreInhibited", allowedValue=BooleanValue()),
    Setting(section="Login", name="NAutoVTs", allowedValue=NumericValue()),
    Setting(section="Login", name="PowerKeyIgnoreInhibited", allowedValue=BooleanValue()),
    Setting(section="Login", name="RemoveIPC", allowedValue=BooleanValue()),
    Setting(section="Login", name="ReserveVT", allowedValue=NumericValue()),
    Setting(section="Login", name="RuntimeDirectorySize", allowedValue=NumericValue(suffixes=["K", "G", "M", "T"], base=1024)),
    Setting(section="Login", name="SessionsMax", allowedValue=NumericValue(suffixes=["K", "G", "M", "T"])),
    Setting(section="Login", name="SuspendKeyIgnoreInhibited", allowedValue=BooleanValue()),
    Setting(section="Login", name="UserStopDelaySec", allowedValue=TimeValue()),
    Setting(section="MACVLAN", name="Mode", allowedValue=EnumValue(["private", "vepa", "bridge", "passthru", "source"])),
    Setting(section="MACVTAP", name="Mode", allowedValue=EnumValue(["private", "vepa", "bridge", "passthru", "source"])),
    Setting(section="Manager", name="AmbientCapabilities", allowedValue=TextValue()), # TODO capabilities parser
    Setting(section="Manager", name="CapabilityBoundingSet", allowedValue=TextValue()), # TODO capabilities parser
    Setting(section="Manager", name="CPUAffinity", allowedValue=NumericValue()),
    Setting(section="Manager", name="CrashChangeVT", allowedValue=BooleanValue(), sinceRel="2.27"),
    Setting(section="Manager", name="CrashChVT", allowedValue=TextValue(), tillRel="2.27"),
    Setting(section="Manager", name="CrashReboot", allowedValue=BooleanValue()),
    Setting(section="Manager", name="CrashShell", allowedValue=BooleanValue()),
    Setting(section="Manager", name="CtrlAltDelBurstAction", allowedValue=TextValue(), sinceRel="2.32"), # TODO parser
    Setting(section="Manager", name="DefaultBlockIOAccounting", allowedValue=BooleanValue(), sinceRel="2.11"),
    Setting(section="Manager", name="DefaultCPUAccounting", allowedValue=BooleanValue(), sinceRel="2.11"),
    Setting(section="Manager", name="DefaultEnvironment", allowedValue=KeyValuePairListValue()),
    Setting(section="Manager", name="DefaultIOAccounting", allowedValue=BooleanValue()),
    Setting(section="Manager", name="DefaultIPAccounting", allowedValue=BooleanValue()),
    Setting(section="Manager", name="DefaultLimitAS", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitCORE", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitCPU", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitDATA", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitFSIZE", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitLOCKS", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitMEMLOCK", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitMSGQUEUE", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitNICE", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitNOFILE", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitNPROC", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitRSS", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitRTPRIO", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitRTTIME", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitSIGPENDING", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultLimitSTACK", allowedValue=TextValue()), # TODO resource parser
    Setting(section="Manager", name="DefaultMemoryAccounting", allowedValue=BooleanValue(), sinceRel="2.11"),
    Setting(section="Manager", name="DefaultRestartSec", allowedValue=TimeValue()),
    Setting(section="Manager", name="DefaultStandardError", allowedValue=TextValue()), # TODO parser
    Setting(section="Manager", name="DefaultStandardOutput", allowedValue=TextValue()), # TODO parser
    Setting(section="Manager", name="DefaultStartLimitBurst", allowedValue=TimeValue()),
    Setting(section="Manager", name="DefaultStartLimitIntervalSec", allowedValue=TimeValue()),
    Setting(section="Manager", name="DefaultTasksAccounting", allowedValue=BooleanValue(), sinceRel="2.27"),
    Setting(section="Manager", name="DefaultTasksMax", allowedValue=NumericValue(suffixes=["%"]), sinceRel="2.28"),
    Setting(section="Manager", name="DefaultTimeoutStartSec", allowedValue=TimeValue()),
    Setting(section="Manager", name="DefaultTimeoutStopSec", allowedValue=TimeValue()),
    Setting(section="Manager", name="DefaultTimerAccuracySec", allowedValue=TimeValue(), sinceRel="2.12"),
    Setting(section="Manager", name="DumpCore", allowedValue=BooleanValue()),
    Setting(section="Manager", name="KExecWatchdogSec", allowedValue=TimeValue(), sinceRel="2.43"),
    Setting(section="Manager", name="LogColor", allowedValue=BooleanValue()),
    Setting(section="Manager", name="LogLevel", allowedValue=TextValue()), # TODO LogLevel parser
    Setting(section="Manager", name="LogLocation", allowedValue=TextValue()), # TODO parser
    Setting(section="Manager", name="LogTarget", allowedValue=TextValue()), # TODO LogTarget
    Setting(section="Manager", name="NoNewPrivileges", allowedValue=BooleanValue(), sinceRel="2.39"),
    Setting(section="Manager", name="NUMAPolicy", allowedValue=EnumValue(["default", "preferred", "bind", "interleave", "local"]), sinceRel="2.43"),
    Setting(section="Manager", name="RebootWatchdogSec", allowedValue=TimeValue(), sinceRel="2.43"),
    Setting(section="Manager", name="RuntimeWatchdogSec", allowedValue=TimeValue()),
    Setting(section="Manager", name="ShowStatus", allowedValue=BooleanValue()),
    Setting(section="Manager", name="ShutdownWatchdogSec", allowedValue=TimeValue(), tillRel="2.42"),
    Setting(section="Manager", name="SystemCallArchitectures", allowedValue=TimeValue()),
    Setting(section="Manager", name="TimerSlackNSec", allowedValue=TimeValue()),
    Setting(section="Manager", name="WatchdogDevice", allowedValue=DeviceNodeValue()),
    Setting(section="Match", name="Architecture", allowedValue=TextValue(conditional={"!": None})),
    Setting(section="Match", name="Driver", allowedValue=ListOf(TextValue(), conditional={"!": None})),
    Setting(section="Match", name="Host", allowedValue=TextValue(conditional={"!": None})),
    Setting(section="Match", name="KernelCommandLine", allowedValue=TextValue(conditional={"!": None})),
    Setting(section="Match", name="KernelVersion", allowedValue=TextValue(conditional={"!": None})),
    Setting(section="Match", name="MACAddress", allowedValue=MacAddressValue()),
    Setting(section="Match", name="Name", allowedValue=ListOf(TextValue(), conditional={"!": None})),
    Setting(section="Match", name="Path", allowedValue=ListOf(TextValue(), conditional={"!": None})),
    Setting(section="Match", name="PermanentMACAddress", allowedValue=ListOf(MacAddressValue()), sinceRel="2.45"),
    Setting(section="Match", name="Property", allowedValue=TextValue(), sinceRel="2.43"),
    Setting(section="Match", name="Type", allowedValue=ListOf(TextValue(), conditional={"!": None})),
    Setting(section="Match", name="Virtualization", allowedValue=TextValue(conditional={"!": None})),
    Setting(section="Match", name="WLANInterfaceType", allowedValue=EnumValue(value=["ad-hoc", "station", "ap", "ap-vlan", "wds", "monitor", "mesh-point", "p2p-client", "p2p-go", "p2p-device", "ocb", "nan"], conditional={"!": None }), sinceRel="2.44"),
    Setting(section="Mount", name="AmbientCapabilities", allowedValue=TextValue()),
    Setting(section="Mount", name="AppArmorProfile", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"}), sinceRel="2.10"),
    Setting(section="Mount", name="BindPaths", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Mount", name="BindReadOnlyPaths", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Mount", name="BlockIOAccounting", allowedValue=BooleanValue(), tillRel="2.41"),
    Setting(section="Mount", name="BlockIODeviceWeight", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(1, 10000)]), tillRel="2.41"),
    Setting(section="Mount", name="BlockIOReadBandwidthMax", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(suffixes=["K", "M", "G", "T", "B"])]), tillRel="2.41"),
    Setting(section="Mount", name="BlockIOWeight", allowedValue=NumericValue(lower=1, upper=10000), tillRel="2.41"),
    Setting(section="Mount", name="BlockIOWriteBandwidthMax", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(suffixes=["K", "M", "G", "T", "B"])]), tillRel="2.41"),
    Setting(section="Mount", name="BlockStartupIOWeight", allowedValue=NumericValue(lower=1, upper=10000), tillRel="2.41"),
    Setting(section="Mount", name="CacheDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Mount", name="CacheDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Mount", name="Capabilities", allowedValue=TextValue(), tillRel="2.30"),
    Setting(section="Mount", name="CapabilityBoundingSet", allowedValue=TextValue()),
    Setting(section="Mount", name="ConfigurationDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Mount", name="ConfigurationDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Mount", name="ControlGroup", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Mount", name="ControlGroupAttribute", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Mount", name="ControlGroupModify", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Mount", name="ControlGroupPersistent", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Mount", name="CoredumpFilter", allowedValue=EitherValue([NumericValue(upper=16), EnumValue(["private-anonymous", "shared-anonymous", "private-file-backed", "shared-file-backed", "elf-headers", "private-huge", "shared-huge", "private-dax", "shared-dax", "all", "default"])]), sinceRel="2.46"),
    Setting(section="Mount", name="CPUAccounting", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Mount", name="CPUAffinity", allowedValue=EitherValue([TextValue(), EnumValue(["numa"])])),
    Setting(section="Mount", name="CPUQuota", allowedValue=NumericValue(lower=0, suffixes=["%"])),
    Setting(section="Mount", name="CPUQuotaPeriodSec", allowedValue=TimeValue(), sinceRel="2.42"),
    Setting(section="Mount", name="CPUSchedulingPolicy", allowedValue=EnumValue(["other", "batch", "idle", "fifo", "rr"])),
    Setting(section="Mount", name="CPUSchedulingPriority", allowedValue=NumericValue(lower=1, upper=99)),
    Setting(section="Mount", name="CPUSchedulingResetOnFork", allowedValue=BooleanValue()),
    Setting(section="Mount", name="CPUShares", allowedValue=NumericValue(lower=2, upper=262144), tillRel="2.41"),
    Setting(section="Mount", name="CPUWeight", allowedValue=NumericValue(1, 10000), sinceRel="2.32"),
    Setting(section="Mount", name="DefaultMemoryLow", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.43"),
    Setting(section="Mount", name="DefaultMemoryMin", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.43"),
    Setting(section="Mount", name="Delegate", allowedValue=EnumValue(["yes", "cpu", "cpuacct", "io", "blkio", "memory", "devices", "pids"])),
    Setting(section="Mount", name="DeviceAllow", allowedValue=DeviceNodeValue()),
    Setting(section="Mount", name="DevicePolicy", allowedValue=EnumValue(["auto", "closed", "strict"])),
    Setting(section="Mount", name="DirectoryMode", allowedValue=OctalModeValue()),
    Setting(section="Mount", name="DisableControllers", allowedValue=EnumValue(["cpu", "cpuacct", "io", "blkio", "memory", "devices", "pids"])),
    Setting(section="Mount", name="DynamicUser", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Mount", name="Environment", allowedValue=KeyValuePairListValue()),
    Setting(section="Mount", name="EnvironmentFile", allowedValue=AbsolutePathListValue()),
    Setting(section="Mount", name="FinalKillSignal", allowedValue=SignalValue()),
    Setting(section="Mount", name="ForceUnmount", allowedValue=BooleanValue()),
    Setting(section="Mount", name="Group", allowedValue=GroupsValue()),
    Setting(section="Mount", name="IgnoreSIGPIPE", allowedValue=BooleanValue()),
    Setting(section="Mount", name="InaccessableDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Mount", name="InaccessiblePaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Mount", name="IOAccounting", allowedValue=BooleanValue()),
    Setting(section="Mount", name="IODeviceLatencyTargetSec", allowedValue=TextValue()),# TODO parser device + target
    Setting(section="Mount", name="IODeviceWeight", allowedValue=TextValue()), # TODO parser device + weight
    Setting(section="Mount", name="IOReadBandwidthMax", allowedValue=TextValue()), # TODO parser device + bytes
    Setting(section="Mount", name="IOReadIOPSMax", allowedValue=TextValue()),# TODO parser device + IOPS
    Setting(section="Mount", name="IOSchedulingClass", allowedValue=EnumValue(["none", "realtime", "best-effort", "idle"])),
    Setting(section="Mount", name="IOSchedulingPriority", allowedValue=NumericValue(lower=0, upper=7)),
    Setting(section="Mount", name="IOWeight", allowedValue=NumericValue(lower=1, upper=10000)),
    Setting(section="Mount", name="IOWriteBandwidthMax", allowedValue=TextValue()), # TODO parser device + bytes
    Setting(section="Mount", name="IOWriteIOPSMax", allowedValue=TextValue()),# TODO parser device + IOPS
    Setting(section="Mount", name="IPAccounting", allowedValue=BooleanValue(), sinceRel="2.35"),
    Setting(section="Mount", name="IPAddressAllow", allowedValue=IPValue(), sinceRel="2.35"),
    Setting(section="Mount", name="IPAddressDeny", allowedValue=IPValue(), sinceRel="2.35"),
    Setting(section="Mount", name="KeyringMode", allowedValue=EnumValue(["inherit", "private", "shared"]), sinceRel="2.35"),
    Setting(section="Mount", name="KillMode", allowedValue=EnumValue(["control-group", "process", "mixed", "none"])),
    Setting(section="Mount", name="KillSignal", allowedValue=SignalValue()),
    Setting(section="Mount", name="LazyUnmount", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Mount", name="LimitAS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitCORE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitCPU", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitDATA", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitFSIZE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitLOCKS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitMEMLOCK", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitMSGQUEUE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitNICE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitNOFILE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitNPROC", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitRSS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitRTPRIO", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitRTTIME", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitSIGPENDING", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LimitSTACK", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Mount", name="LockPersonality", allowedValue=BooleanValue(), sinceRel="2.35"),
    Setting(section="Mount", name="LogLevelMax", allowedValue=EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"]), sinceRel="2.34"),
    Setting(section="Mount", name="LogRateLimitBurst", allowedValue=TimeValue(), sinceRel="2.40"),
    Setting(section="Mount", name="LogRateLimitIntervalSec", allowedValue=TimeValue(), sinceRel="2.40"),
    Setting(section="Mount", name="LogsDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Mount", name="MemoryAccounting", allowedValue=BooleanValue()),
    Setting(section="Mount", name="MemoryDenyWriteExecute", allowedValue=BooleanValue(), sinceRel="2.31"),
    Setting(section="Mount", name="MemoryHigh", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Mount", name="MemoryLimit", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"], specials=["infinity"]), tillRel="2.41"),
    Setting(section="Mount", name="MemoryLow", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Mount", name="MemoryMax", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Mount", name="MemoryMin", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.40"),
    Setting(section="Mount", name="MemorySwapMax", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Mount", name="MountAPIVFS", allowedValue=BooleanValue()),
    Setting(section="Mount", name="MountFlags", allowedValue=EnumValue(["shared", "slave", "private"])),
    Setting(section="Mount", name="NetworkNamespacePath", allowedValue=AbsolutePathListValue(), sinceRel="2.42"),
    Setting(section="Mount", name="Nice", allowedValue=NumericValue(lower=-20, upper=19)),
    Setting(section="Mount", name="NoNewPrivileges", allowedValue=BooleanValue(), sinceRel="2.39"),
    Setting(section="Mount", name="NUMAPolicy", allowedValue=EnumValue(["default", "preferred", "bind", "interleave", "local"]), sinceRel="2.43"),
    Setting(section="Mount", name="OOMScoreAdjust", allowedValue=NumericValue(lower=-1000, upper=1000)),
    Setting(section="Mount", name="Options", allowedValue=ListOf(TextValue(), delimiter=",")),
    Setting(section="Mount", name="PAMName", allowedValue=TextValue()), # TODO PAM service lookup parser
    Setting(section="Mount", name="PassEnvironment", allowedValue=TextValue(), sinceRel="2.28"),
    Setting(section="Mount", name="Personality", allowedValue=EnumValue(["x86", "x86-64", "ppc", "ppc-le", "ppc64", "ppc64-le", "s390", "s390x"])),
    Setting(section="Mount", name="PrivateDevices", allowedValue=BooleanValue()),
    Setting(section="Mount", name="PrivateMounts", allowedValue=BooleanValue(), sinceRel="2.39"),
    Setting(section="Mount", name="PrivateNetwork", allowedValue=BooleanValue()),
    Setting(section="Mount", name="PrivateTmp", allowedValue=BooleanValue()),
    Setting(section="Mount", name="PrivateUsers", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Mount", name="ProtectClock", allowedValue=BooleanValue(), sinceRel="2.45"),
    Setting(section="Mount", name="ProtectControlGroups", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Mount", name="ProtectHome", allowedValue=EitherValue(args=[EnumValue(["tmpfs", "read-only"]), BooleanValue()]), sinceRel="2.14"),
    Setting(section="Mount", name="ProtectHostname", allowedValue=BooleanValue(), sinceRel="2.42"),
    Setting(section="Mount", name="ProtectKernelLogs", allowedValue=BooleanValue(), sinceRel="2.44"),
    Setting(section="Mount", name="ProtectKernelModules", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Mount", name="ProtectKernelTunables", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Mount", name="ProtectSystem", allowedValue=EitherValue(args=[EnumValue(["full", "strict"]), BooleanValue()]), sinceRel="2.14"),
    Setting(section="Mount", name="ReadOnlyDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Mount", name="ReadOnlyPaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Mount", name="ReadWriteDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Mount", name="ReadWriteOnly", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="Mount", name="ReadWritePaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Mount", name="RemoveIPC", allowedValue=BooleanValue()),
    Setting(section="Mount", name="RestartKillSignal", allowedValue=SignalValue(), sinceRel="2.44"),
    Setting(section="Mount", name="RestrictAddressFamilies", allowedValue=TextValue(), sinceRel="2.11"),
    Setting(section="Mount", name="RestrictNamespaces", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Mount", name="RestrictRealtime", allowedValue=BooleanValue(), sinceRel="2.31"),
    Setting(section="Mount", name="RestrictSUIDSGID", allowedValue=BooleanValue()),
    Setting(section="Mount", name="RootDirectory", allowedValue=PathValue()),
    Setting(section="Mount", name="RootHash", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="Mount", name="RootHashSignature", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="Mount", name="RootImage", allowedValue=PathValue()),
    Setting(section="Mount", name="RuntimeDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Mount", name="RuntimeDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Mount", name="RuntimeDirectoryPreserve", allowedValue=EitherValue(args=[BooleanValue(), EnumValue(["restart"])]), sinceRel="2.35"),
    Setting(section="Mount", name="SecureBits", allowedValue=EnumValue(["keep-caps", "keep-caps-locked", "no-setuid-fixup", "no-setuid-fixup-locked", "noroot", "noroot-locked"])),
    Setting(section="Mount", name="SELinuxContext", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"})),
    Setting(section="Mount", name="SendSIGHUP", allowedValue=BooleanValue()),
    Setting(section="Mount", name="SendSIGKILL", allowedValue=BooleanValue()),
    Setting(section="Mount", name="Slice", allowedValue=UnitListValue(requiredExt=".slice")),
    Setting(section="Mount", name="SloppyOptions", allowedValue=BooleanValue()),
    Setting(section="Mount", name="SmackProcessLabel", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"}), sinceRel="2.18"),
    Setting(section="Mount", name="StandardError", allowedValue=EitherValue(args=[EnumValue(["inherit", "null", "tty", "journal", "kmsg", "journal+console", "kmsg+console", "socket"]), TextValue()])),
    Setting(section="Mount", name="StandardInput", allowedValue=EitherValue(args=[EnumValue(["null", "tty", "tty-force", "tty-fail", "data", "socket"]), TextValue()]), sinceRel="2.34"),
    Setting(section="Mount", name="StandardInputData", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Mount", name="StandardInputText", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Mount", name="StandardOutput", allowedValue=EitherValue(args=[EnumValue(["inherit", "null", "tty", "journal", "kmsg", "journal+console", "kmsg+console", "socket"]), TextValue()])),
    Setting(section="Mount", name="StartupCPUShares", allowedValue=NumericValue(lower=2, upper=262144), sinceRel="2.13", tillRel="2.41"),
    Setting(section="Mount", name="StartupCPUWeight", allowedValue=NumericValue(1, 10000)),
    Setting(section="Mount", name="StartupIOWeight", allowedValue=NumericValue(lower=1, upper=10000)),
    Setting(section="Mount", name="StateDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Mount", name="StateDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Mount", name="SupplementaryGroups", allowedValue=GroupsValue()),
    Setting(section="Mount", name="SyslogFacility", allowedValue=EnumValue(["kern", "user", "mail", "daemon", "auth", "syslog", "lpr", "news", "uucp", "cron", "authpriv", "ftp", "local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7"])),
    Setting(section="Mount", name="SyslogIdentifier", allowedValue=TextValue()),
    Setting(section="Mount", name="SyslogLevel", allowedValue=EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"])),
    Setting(section="Mount", name="SyslogLevelPrefix", allowedValue=BooleanValue()),
    Setting(section="Mount", name="SystemCallArchitectures", allowedValue=TextValue()),
    Setting(section="Mount", name="SystemCallErrorNumber", allowedValue=EitherValue([ErrorTypeValue(), NumericValue(lower=1, upper=4095)])),
    Setting(section="Mount", name="SystemCallFilter", allowedValue=TextValue()),
    Setting(section="Mount", name="TasksAccounting", allowedValue=BooleanValue(), sinceRel="2.27"),
    Setting(section="Mount", name="TasksMax", allowedValue=NumericValue(lower=1, specials=["infinity"]), sinceRel="2.27"),
    Setting(section="Mount", name="TemporaryFileSystem", allowedValue=TextValue(), sinceRel="2.38"),
    Setting(section="Mount", name="TimeoutSec", allowedValue=TimeValue()),
    Setting(section="Mount", name="TimerSlackNSec", allowedValue=TimeValue()),
    Setting(section="Mount", name="TTYPath", allowedValue=DeviceNodeValue()),
    Setting(section="Mount", name="TTYReset", allowedValue=BooleanValue()),
    Setting(section="Mount", name="TTYVHangup", allowedValue=BooleanValue()),
    Setting(section="Mount", name="TTYVTDisallocate", allowedValue=BooleanValue()),
    Setting(section="Mount", name="Type", allowedValue=TextValue()),
    Setting(section="Mount", name="UMask", allowedValue=NumericValue()),
    Setting(section="Mount", name="UnsetEnvironment", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Mount", name="User", allowedValue=UsersValue()),
    Setting(section="Mount", name="UtmpIdentifier", allowedValue=TextValue()),
    Setting(section="Mount", name="UtmpMode", allowedValue=EnumValue(["init", "login", "user"]), sinceRel="2.25"),
    Setting(section="Mount", name="WatchdogSignal", allowedValue=SignalValue()),
    Setting(section="Mount", name="What", allowedValue=TextValue()),
    Setting(section="Mount", name="Where", allowedValue=MountPathValue()),
    Setting(section="Mount", name="WorkingDirectory", allowedValue=PathValue(conditional={"~": None})),
    Setting(section="Neighbor", name="Address", allowedValue=IPValue()),
    Setting(section="Neighbor", name="LinkLayerAddress", allowedValue=ListOf(MacAddressValue()), sinceRel="2.43"),
    Setting(section="Neighbor", name="MACAddress", allowedValue=ListOf(MacAddressValue()), tillRel="2.42"),
    Setting(section="NetDev", name="Description", allowedValue=TextValue()),
    Setting(section="NetDev", name="Kind", allowedValue=EnumValue(["bond", "bridge", "dummy", "gre", "gretap", "erspan", "ip6gre", "ip6tnl", "ip6gretap", "ipip", "ipvlan", "macvlan", "macvtap", "sit", "tap", "tun", "veth", "vlan", "vti", "vti6", "vxlan", "geneve", "l2tp", "vrf", "vcan", "vxcan", "wireguard", "netdevsim", "fou", "bridge", "dummy", "gre", "gretap", "erspan", "ip6gre", "ip6tnl", "ip6gretap", "ipip", "ipvlan", "macvlan", "macvtap", "sit", "tap", "tun", "veth", "vlan", "vti", "vti6", "vxlan", "geneve", "l2tp", "vrf", "vcan", "vxcan", "wireguard", "netdevsim", "fou"])),
    Setting(section="NetDev", name="MACAddress", allowedValue=MacAddressValue()),
    Setting(section="NetDev", name="MTUBytes", allowedValue=NumericValue(suffixes=["K", "M", "G"], base=1024)),
    Setting(section="NetDev", name="Name", allowedValue=TextValue()),
    Setting(section="Network", name="ActiveSlave", allowedValue=BooleanValue(), restricted=[Limitation(key="Mode", value=["active-backup", "balance-alb", "balance-tlb"], section="Bond", file="ignore")]),
    Setting(section="Network", name="Address", allowedValue=IPValue()),
    Setting(section="Network", name="BindCarrier", allowedValue=TextValue()),
    Setting(section="Network", name="Bond", allowedValue=TextValue()),
    Setting(section="Network", name="Bridge", allowedValue=TextValue()),
    Setting(section="Network", name="ConfigureWithoutCarrier", allowedValue=BooleanValue()),
    Setting(section="Network", name="DefaultRouteOnDevice", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="Network", name="DHCP", allowedValue=EnumValue(["yes", "no", "ipv4", "ipv6"])),
    Setting(section="Network", name="DHCPServer", allowedValue=BooleanValue()),
    Setting(section="Network", name="DNS", allowedValue=IPValue()),
    Setting(section="Network", name="DNSDefaultRoute", allowedValue=BooleanValue()),
    Setting(section="Network", name="DNSOverTLS", allowedValue=EnumValue(["false", "opportunistic"])),
    Setting(section="Network", name="DNSSEC", allowedValue=EnumValue(["yes", "no", "true", "false", "0", "1", "allow-downgrade"])),
    Setting(section="Network", name="DNSSECNegativeTrustAnchors", allowedValue=TextValue()),
    Setting(section="Network", name="Domains", allowedValue=TextValue()),
    Setting(section="Network", name="EmitLLDP", allowedValue=EnumValue(["yes", "no", "true", "false", "0", "1", "nearest-bridge", "non-tpmr-bridge", "customer-bridge"])),
    Setting(section="Network", name="Gateway", allowedValue=IPValue()),
    Setting(section="Network", name="IgnoreCarrierLoss", allowedValue=BooleanValue()),
    Setting(section="Network", name="IPMasquerade", allowedValue=BooleanValue(), requires=[Limitation(key="IPForward", value="ipv4")]),
    Setting(section="Network", name="IPv4AcceptLocal", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="Network", name="IPv4LLRoute", allowedValue=BooleanValue()),
    Setting(section="Network", name="IPv4ProxyARP", allowedValue=BooleanValue()),
    Setting(section="Network", name="IPv6AcceptRA", allowedValue=BooleanValue()),
    Setting(section="Network", name="IPv6DuplicateAddressDetection", allowedValue=NumericValue()),
    Setting(section="Network", name="IPv6HopLimit", allowedValue=NumericValue()),
    Setting(section="Network", name="IPv6LinkLocalAddressGenerationMode", allowedValue=EnumValue(["eui64", "none", "stable-privacy", "random"]), sinceRel="2.46"),
    Setting(section="Network", name="IPv6MTUBytes", allowedValue=NumericValue()),
    Setting(section="Network", name="IPv6PrefixDelegation", allowedValue=EnumValue(["static", "dhcpv6", "yes", "false"])),
    Setting(section="Network", name="IPv6PrivacyExtensions", allowedValue=EnumValue(["yes", "no", "true", "false", "0", "1", "prefer-public", "kernel"])),
    Setting(section="Network", name="IPv6ProxyNDP", allowedValue=BooleanValue()),
    Setting(section="Network", name="IPv6ProxyNDPAddress", allowedValue=IPValue(), requires=[Limitation(key="IPv6ProxyNDP", value=["yes", "1", "true"])]),
    Setting(section="Network", name="IPv6Token", allowedValue=IPValue()),
    Setting(section="Network", name="IPVLAN", allowedValue=TextValue()),
    Setting(section="Network", name="LinkLocalAddressing", allowedValue=EnumValue(["yes", "no", "ipv4", "ipv6"])),
    Setting(section="Network", name="LLDP", allowedValue=EnumValue(["yes", "no", "true", "false", "0", "1", "routers-only"])),
    Setting(section="Network", name="LLMNR", allowedValue=EnumValue(["yes", "no", "true", "false", "0", "1", "resolve"])),
    Setting(section="Network", name="MACVLAN", allowedValue=TextValue()),
    Setting(section="Network", name="MulticastDNS", allowedValue=EnumValue(["yes", "no", "true", "false", "0", "1", "resolve"])),
    Setting(section="Network", name="NTP", allowedValue=IPorUrlValue()),
    Setting(section="Network", name="PrimarySlave", allowedValue=BooleanValue(), restricted=[Limitation(key="Mode", value=["active-backup", "balance-alb", "balance-tlb"], section="Bond", file="ignore")]),
    Setting(section="Network", name="Tunnel", allowedValue=TextValue()),
    Setting(section="Network", name="VLAN", allowedValue=TextValue()),
    Setting(section="Network", name="VRF", allowedValue=TextValue()),
    Setting(section="Network", name="VXLAN", allowedValue=TextValue()),
    Setting(section="NetworkEmulator", name="DelayJitterSec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="NetworkEmulator", name="DelaySec", allowedValue=NumericValue(), sinceRel="2.45"),
    Setting(section="NetworkEmulator", name="DuplicateRate", allowedValue=NumericValue(lower=0, upper=100, suffixes=["%"]), sinceRel="2.45"),
    Setting(section="NetworkEmulator", name="Handle", allowedValue=EitherValue(args=[HexValue(lower=0, upper=0xfff), EmptyValue()]), sinceRel="2.45"),
    Setting(section="NetworkEmulator", name="LossRate", allowedValue=NumericValue(lower=0, upper=100, suffixes=["%"]), sinceRel="2.45"),
    Setting(section="NetworkEmulator", name="PacketLimit", allowedValue=NumericValue(lower=0, upper=4294967294), sinceRel="2.45"),
    Setting(section="NetworkEmulator", name="Parent", allowedValue=EnumValue(value=["root", "clsact", "ingress"]), sinceRel="2.45"),
    Setting(section="NextHop", name="Gateway", allowedValue=IPValue(), sinceRel="2.44"),
    Setting(section="NextHop", name="Id", allowedValue=NumericValue(lower=0), sinceRel="2.44"),
    Setting(section="Path", name="DirectoryMode", allowedValue=OctalModeValue()),
    Setting(section="Path", name="DirectoryNotEmpty", allowedValue=AbsolutePathListValue()),
    Setting(section="Path", name="MakeDirectory", allowedValue=BooleanValue(), restricted=[Limitation(key="PathExists")]),
    Setting(section="Path", name="PathChanged", allowedValue=AbsolutePathListValue()),
    Setting(section="Path", name="PathExists", allowedValue=AbsolutePathListValue()),
    Setting(section="Path", name="PathExistsGlob", allowedValue=TextValue()), # TODO parser
    Setting(section="Path", name="PathModified", allowedValue=AbsolutePathListValue()),
    Setting(section="Path", name="Unit", allowedValue=UnitListValue()),
    Setting(section="Peer", name="MACAddress", allowedValue=MacAddressValue()),
    Setting(section="Peer", name="Name", allowedValue=TextValue()),
    Setting(section="PFIFO", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="PFIFO", name="PacketLimit", allowedValue=NumericValue(upper=4294967294), sinceRel="2.46"),
    Setting(section="PFIFO", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="PFIFOFast", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="PFIFOFast", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="PFIFOHeadDrop", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="PFIFOHeadDrop", name="PacketLimit", allowedValue=NumericValue(upper=4294967294), sinceRel="2.46"),
    Setting(section="PFIFOHeadDrop", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="PIE", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="PIE", name="PacketLimit", allowedValue=NumericValue(upper=4294967294), sinceRel="2.46"),
    Setting(section="PIE", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="QDics", name="Handle", allowedValue=EitherValue(args=[HexValue(lower=0, upper=0xfff), EmptyValue()]), sinceRel="2.45"),
    Setting(section="QDics", name="Parent", allowedValue=EnumValue(value=["clsact", "ingress"]), sinceRel="2.45"),
    Setting(section="QuickFairQueueing", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="QuickFairQueueing", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="QuickFairQueueingClass", name="ClassId", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="QuickFairQueueingClass", name="MaxPacketBytes", allowedValue=NumericValue(base=1024, suffixes=["K", "M", "G"]), sinceRel="2.46"),
    Setting(section="QuickFairQueueingClass", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root"])]), sinceRel="2.46"),
    Setting(section="QuickFairQueueingClass", name="Weight", allowedValue=NumericValue(lower=1, upper=1023), sinceRel="2.46"),
    Setting(section="Route", name="Destination", allowedValue=TextValue()),
    Setting(section="Route", name="FastOpenNoCookie", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="Route", name="Gateway", allowedValue=EitherValue(args=[IPValue(), EnumValue(["_dhcp"])])),
    Setting(section="Route", name="GatewayOnLink", allowedValue=BooleanValue()),
    Setting(section="Route", name="InitialAdvertisedReceiveWindow", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="Route", name="InitialCongestionWindow", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="Route", name="IPServiceType", allowedValue=EnumValue(value=["CS4", "CS6"]), sinceRel="2.44"),
    Setting(section="Route", name="IPv6Preference", allowedValue=EnumValue(["low", "medium", "high"])),
    Setting(section="Route", name="Metric", allowedValue=NumericValue()),
    Setting(section="Route", name="MTUBytes", allowedValue=NumericValue(suffixes=["K", "M", "G"], base=1024)),
    Setting(section="Route", name="PreferredSource", allowedValue=TextValue()),
    Setting(section="Route", name="Protocol", allowedValue=EitherValue(args=[EnumValue(["kernel", "boot", "static"]), NumericValue(lower=0, upper=255)])),
    Setting(section="Route", name="QuickAck", allowedValue=BooleanValue()),
    Setting(section="Route", name="Scope", allowedValue=EnumValue(["global", "link", "host"])),
    Setting(section="Route", name="Source", allowedValue=TextValue()),
    Setting(section="Route", name="Table", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="Route", name="TTLPropagate", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="Route", name="Type", allowedValue=EnumValue(["unicast", "local", "broadcast", "anycast", "multicast", "blackhole", "unreachable", "prohibit", "throw", "nat", "xresolve"])),
    Setting(section="RoutingPolicyRule", name="DestinationPort", allowedValue=CombinedValue(args=[NumericValue(), NumericValue()])),
    Setting(section="RoutingPolicyRule", name="FirewallMark", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="RoutingPolicyRule", name="From", allowedValue=IPValue()),
    Setting(section="RoutingPolicyRule", name="IncomingInterface", allowedValue=TextValue()),
    Setting(section="RoutingPolicyRule", name="InvertRule", allowedValue=BooleanValue()),
    Setting(section="RoutingPolicyRule", name="IPProtocol", allowedValue=EnumValue(["tcp", "udp", "sctp", "6", "17"])),
    Setting(section="RoutingPolicyRule", name="OutgoingInterface", allowedValue=TextValue()),
    Setting(section="RoutingPolicyRule", name="Priority", allowedValue=NumericValue()),
    Setting(section="RoutingPolicyRule", name="SourcePort", allowedValue=CombinedValue(args=[NumericValue(), NumericValue()])),
    Setting(section="RoutingPolicyRule", name="SuppressPrefixLength", allowedValue=NumericValue(lower=0, upper=128), sinceRel="2.45"),
    Setting(section="RoutingPolicyRule", name="Table", allowedValue=NumericValue(lower=1, upper=4294967295)),
    Setting(section="RoutingPolicyRule", name="To", allowedValue=IPValue()),
    Setting(section="RoutingPolicyRule", name="TypeOfService", allowedValue=NumericValue(lower=0, upper=255)),
    Setting(section="RoutingPolicyRule", name="User", allowedValue=TextValue(), sinceRel="2.45"),
    Setting(section="Scope", name="RuntimeMaxSec", allowedValue=TimeValue(), sinceRel="2.44"),
    Setting(section="Service", name="AmbientCapabilities", allowedValue=TextValue()),
    Setting(section="Service", name="AppArmorProfile", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"}), sinceRel="2.10"),
    Setting(section="Service", name="BindPaths", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Service", name="BindReadOnlyPaths", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Service", name="BlockIOAccounting", allowedValue=BooleanValue(), tillRel="2.41"),
    Setting(section="Service", name="BlockIODeviceWeight", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(1, 10000)]), tillRel="2.41"),
    Setting(section="Service", name="BlockIOReadBandwidthMax", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(suffixes=["K", "M", "G", "T", "B"])]), tillRel="2.41"),
    Setting(section="Service", name="BlockIOWeight", allowedValue=NumericValue(lower=1, upper=10000), tillRel="2.41"),
    Setting(section="Service", name="BlockIOWriteBandwidthMax", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(suffixes=["K", "M", "G", "T", "B"])]), tillRel="2.41"),
    Setting(section="Service", name="BlockStartupIOWeight", allowedValue=NumericValue(lower=1, upper=10000), tillRel="2.41"),
    Setting(section="Service", name="BusName", allowedValue=TextValue(), requires=[Limitation(key="Type", value="dbus")]),
    Setting(section="Service", name="CacheDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Service", name="CacheDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Service", name="Capabilities", allowedValue=TextValue(), tillRel="2.30"),
    Setting(section="Service", name="CapabilityBoundingSet", allowedValue=TextValue()),
    Setting(section="Service", name="ConfigurationDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Service", name="ConfigurationDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Service", name="ControlGroup", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Service", name="ControlGroupAttribute", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Service", name="ControlGroupModify", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Service", name="ControlGroupPersistent", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Service", name="CoredumpFilter", allowedValue=EitherValue([NumericValue(upper=16), EnumValue(["private-anonymous", "shared-anonymous", "private-file-backed", "shared-file-backed", "elf-headers", "private-huge", "shared-huge", "private-dax", "shared-dax", "all", "default"])]), sinceRel="2.46"),
    Setting(section="Service", name="CPUAccounting", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Service", name="CPUAffinity", allowedValue=EitherValue(args=[TextValue(), EnumValue(["numa"])])),
    Setting(section="Service", name="CPUQuota", allowedValue=NumericValue(lower=0, suffixes=["%"])),
    Setting(section="Service", name="CPUQuotaPeriodSec", allowedValue=TimeValue(), sinceRel="2.42"),
    Setting(section="Service", name="CPUSchedulingPolicy", allowedValue=EnumValue(["other", "batch", "idle", "fifo", "rr"])),
    Setting(section="Service", name="CPUSchedulingPriority", allowedValue=NumericValue(lower=1, upper=99)),
    Setting(section="Service", name="CPUSchedulingResetOnFork", allowedValue=BooleanValue()),
    Setting(section="Service", name="CPUShares", allowedValue=NumericValue(lower=2, upper=262144), tillRel="2.41"),
    Setting(section="Service", name="CPUWeight", allowedValue=NumericValue(1, 10000), sinceRel="2.32"),
    Setting(section="Service", name="DefaultMemoryLow", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.43"),
    Setting(section="Service", name="DefaultMemoryMin", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.43"),
    Setting(section="Service", name="Delegate", allowedValue=EnumValue(["yes", "cpu", "cpuacct", "io", "blkio", "memory", "devices", "pids"])),
    Setting(section="Service", name="DeviceAllow", allowedValue=DeviceNodeValue()),
    Setting(section="Service", name="DevicePolicy", allowedValue=EnumValue(["auto", "closed", "strict"])),
    Setting(section="Service", name="DisableControllers", allowedValue=EnumValue(["cpu", "cpuacct", "io", "blkio", "memory", "devices", "pids"])),
    Setting(section="Service", name="DynamicUser", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Service", name="Environment", allowedValue=KeyValuePairListValue()),
    Setting(section="Service", name="EnvironmentFile", allowedValue=AbsolutePathListValue(conditional={"-": None})),
    Setting(section="Service", name="ExecCondition", allowedValue=TextValue(), sinceRel="2.43"),
    Setting(section="Service", name="ExecReload", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, })),
    Setting(section="Service", name="ExecStart", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, }), dropinproc=DropinAdditive()),
    Setting(section="Service", name="ExecStartPost", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, }), dropinproc=DropinAdditive()),
    Setting(section="Service", name="ExecStartPre", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, }), dropinproc=DropinAdditive()),
    Setting(section="Service", name="ExecStop", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, }), dropinproc=DropinAdditive()),
    Setting(section="Service", name="ExecStopPost", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, }), dropinproc=DropinAdditive()),
    Setting(section="Service", name="FileDescriptorStoreMax", allowedValue=NumericValue()),
    Setting(section="Service", name="FinalKillSignal", allowedValue=SignalValue()),
    Setting(section="Service", name="Group", allowedValue=GroupsValue()),
    Setting(section="Service", name="GuessMainPID", allowedValue=BooleanValue(), requires=[Limitation(key="Type", value="forking")]),
    Setting(section="Service", name="IgnoreSIGPIPE", allowedValue=BooleanValue()),
    Setting(section="Service", name="InaccessableDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Service", name="InaccessiblePaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Service", name="IOAccounting", allowedValue=BooleanValue()),
    Setting(section="Service", name="IODeviceLatencyTargetSec", allowedValue=TextValue()),# TODO parser device + target
    Setting(section="Service", name="IODeviceWeight", allowedValue=TextValue()), # TODO parser device + weight
    Setting(section="Service", name="IOReadBandwidthMax", allowedValue=TextValue()), # TODO parser device + bytes
    Setting(section="Service", name="IOReadIOPSMax", allowedValue=TextValue()),# TODO parser device + IOPS
    Setting(section="Service", name="IOSchedulingClass", allowedValue=EnumValue(["none", "realtime", "best-effort", "idle"])),
    Setting(section="Service", name="IOSchedulingPriority", allowedValue=NumericValue(lower=0, upper=7)),
    Setting(section="Service", name="IOWeight", allowedValue=NumericValue(lower=1, upper=10000)),
    Setting(section="Service", name="IOWriteBandwidthMax", allowedValue=TextValue()), # TODO parser device + bytes
    Setting(section="Service", name="IOWriteIOPSMax", allowedValue=TextValue()),# TODO parser device + IOPS
    Setting(section="Service", name="IPAccounting", allowedValue=BooleanValue(), sinceRel="2.35"),
    Setting(section="Service", name="IPAddressAllow", allowedValue=IPValue(), sinceRel="2.35"),
    Setting(section="Service", name="IPAddressDeny", allowedValue=IPValue(), sinceRel="2.35"),
    Setting(section="Service", name="KeyringMode", allowedValue=EnumValue(["inherit", "private", "shared"]), sinceRel="2.35"),
    Setting(section="Service", name="KillMode", allowedValue=EnumValue(["control-group", "process", "mixed", "none"])),
    Setting(section="Service", name="KillSignal", allowedValue=SignalValue()),
    Setting(section="Service", name="LimitAS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitCORE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitCPU", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitDATA", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitFSIZE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitLOCKS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitMEMLOCK", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitMSGQUEUE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitNICE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitNOFILE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitNPROC", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitRSS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitRTPRIO", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitRTTIME", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitSIGPENDING", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LimitSTACK", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Service", name="LockPersonality", allowedValue=BooleanValue(), sinceRel="2.35"),
    Setting(section="Service", name="LogLevelMax", allowedValue=EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"]), sinceRel="2.34"),
    Setting(section="Service", name="LogRateLimitBurst", allowedValue=TimeValue(), sinceRel="2.40"),
    Setting(section="Service", name="LogRateLimitIntervalSec", allowedValue=TimeValue(), sinceRel="2.40"),
    Setting(section="Service", name="LogsDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Service", name="MemoryAccounting", allowedValue=BooleanValue()),
    Setting(section="Service", name="MemoryDenyWriteExecute", allowedValue=BooleanValue(), sinceRel="2.31"),
    Setting(section="Service", name="MemoryHigh", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Service", name="MemoryLimit", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"], specials=["infinity"]), tillRel="2.41"),
    Setting(section="Service", name="MemoryLow", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Service", name="MemoryMax", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Service", name="MemoryMin", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.40"),
    Setting(section="Service", name="MemorySwapMax", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Service", name="MountAPIVFS", allowedValue=BooleanValue()),
    Setting(section="Service", name="MountFlags", allowedValue=EnumValue(["shared", "slave", "private"])),
    Setting(section="Service", name="NetworkNamespacePath", allowedValue=AbsolutePathListValue(), sinceRel="2.42"),
    Setting(section="Service", name="Nice", allowedValue=NumericValue(lower=-20, upper=19)),
    Setting(section="Service", name="NonBlocking", allowedValue=BooleanValue()),
    Setting(section="Service", name="NoNewPrivileges", allowedValue=BooleanValue(), sinceRel="2.39"),
    Setting(section="Service", name="NotifyAccess", allowedValue=EnumValue(["main", "exec", "all", "none"])),
    Setting(section="Service", name="NUMAPolicy", allowedValue=EnumValue(["default", "preferred", "bind", "interleave", "local"]), sinceRel="2.43"),
    Setting(section="Service", name="OOMScoreAdjust", allowedValue=NumericValue(lower=-1000, upper=1000)),
    Setting(section="Service", name="PAMName", allowedValue=TextValue()), # TODO PAM service lookup parser
    Setting(section="Service", name="PassEnvironment", allowedValue=TextValue(), sinceRel="2.28"),
    Setting(section="Service", name="Personality", allowedValue=EnumValue(["x86", "x86-64", "ppc", "ppc-le", "ppc64", "ppc64-le", "s390", "s390x"])),
    Setting(section="Service", name="PIDFile", allowedValue=PathValue()),
    Setting(section="Service", name="PrivateDevices", allowedValue=BooleanValue()),
    Setting(section="Service", name="PrivateMounts", allowedValue=BooleanValue(), sinceRel="2.39"),
    Setting(section="Service", name="PrivateNetwork", allowedValue=BooleanValue()),
    Setting(section="Service", name="PrivateTmp", allowedValue=BooleanValue()),
    Setting(section="Service", name="PrivateUsers", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Service", name="ProtectClock", allowedValue=BooleanValue(), sinceRel="2.45"),
    Setting(section="Service", name="ProtectControlGroups", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Service", name="ProtectHome", allowedValue=EitherValue(args=[EnumValue(["tmpfs", "read-only"]), BooleanValue()]), sinceRel="2.14"),
    Setting(section="Service", name="ProtectHostname", allowedValue=BooleanValue(), sinceRel="2.42"),
    Setting(section="Service", name="ProtectKernelLogs", allowedValue=BooleanValue(), sinceRel="2.44"),
    Setting(section="Service", name="ProtectKernelModules", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Service", name="ProtectKernelTunables", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Service", name="ProtectSystem", allowedValue=EitherValue(args=[EnumValue(["full", "strict"]), BooleanValue()]), sinceRel="2.14"),
    Setting(section="Service", name="ReadOnlyDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Service", name="ReadOnlyPaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Service", name="ReadWriteDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Service", name="ReadWritePaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Service", name="RemainAfterExit", allowedValue=BooleanValue()),
    Setting(section="Service", name="RemoveIPC", allowedValue=BooleanValue()),
    Setting(section="Service", name="Restart", allowedValue=EnumValue(["no", "on-success", "on-failure", "on-abnormal", "on-watchdog", "on-abort", "always"]), restricted=[Limitation(key="Type", value="oneshot")]),
    Setting(section="Service", name="RestartForceExitStatus", allowedValue=SignalValue(), sinceRel="2.15"),
    Setting(section="Service", name="RestartKillSignal", allowedValue=SignalValue(), sinceRel="2.44"),
    Setting(section="Service", name="RestartPreventExitStatus", allowedValue=SignalValue(), requires=[Limitation(key="ExecStart")]),
    Setting(section="Service", name="RestartSec", allowedValue=TimeValue()),
    Setting(section="Service", name="RestrictAddressFamilies", allowedValue=TextValue(), sinceRel="2.11"),
    Setting(section="Service", name="RestrictNamespaces", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Service", name="RestrictRealtime", allowedValue=BooleanValue(), sinceRel="2.31"),
    Setting(section="Service", name="RestrictSUIDSGID", allowedValue=BooleanValue()),
    Setting(section="Service", name="RootDirectory", allowedValue=PathValue()),
    Setting(section="Service", name="RootDirectoryStartOnly", allowedValue=BooleanValue(), requires=[Limitation(key="ExecStart")]),
    Setting(section="Service", name="RootHash", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="Service", name="RootHashSignature", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="Service", name="RootImage", allowedValue=PathValue()),
    Setting(section="Service", name="RuntimeDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Service", name="RuntimeDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Service", name="RuntimeDirectoryPreserve", allowedValue=EitherValue(args=[BooleanValue(), EnumValue(["restart"])]), sinceRel="2.35"),
    Setting(section="Service", name="RuntimeMaxSec", allowedValue=TimeValue(), sinceRel="2.29"),
    Setting(section="Service", name="SecureBits", allowedValue=EnumValue(["keep-caps", "keep-caps-locked", "no-setuid-fixup", "no-setuid-fixup-locked", "noroot", "noroot-locked"])),
    Setting(section="Service", name="SELinuxContext", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"})),
    Setting(section="Service", name="SendSIGHUP", allowedValue=BooleanValue()),
    Setting(section="Service", name="SendSIGKILL", allowedValue=BooleanValue()),
    Setting(section="Service", name="Slice", allowedValue=UnitListValue(requiredExt=".slice")),
    Setting(section="Service", name="SmackProcessLabel", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"}), sinceRel="2.18"),
    Setting(section="Service", name="Sockets", allowedValue=UnitListValue(requiredExt=".socket")),
    Setting(section="Service", name="StandardError", allowedValue=EitherValue(args=[EnumValue(["inherit", "null", "tty", "journal", "kmsg", "journal+console", "kmsg+console", "socket"]), TextValue()])),
    Setting(section="Service", name="StandardInput", allowedValue=EitherValue(args=[EnumValue(["null", "tty", "tty-force", "tty-fail", "data", "socket"]), TextValue()]), sinceRel="2.34"),
    Setting(section="Service", name="StandardInputData", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Service", name="StandardInputText", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Service", name="StandardOutput", allowedValue=EitherValue(args=[EnumValue(["inherit", "null", "tty", "journal", "kmsg", "journal+console", "kmsg+console", "socket"]), TextValue()])),
    Setting(section="Service", name="StartLimitBurst", allowedValue=NumericValue()),
    Setting(section="Service", name="StartLimitInterval", allowedValue=TimeValue()),
    Setting(section="Service", name="StartLimitIntervalSec", allowedValue=TimeValue()),
    Setting(section="Service", name="StartupCPUShares", allowedValue=NumericValue(lower=2, upper=262144), tillRel="2.41"),
    Setting(section="Service", name="StartupCPUWeight", allowedValue=NumericValue(1, 10000)),
    Setting(section="Service", name="StartupIOWeight", allowedValue=NumericValue(lower=1, upper=10000)),
    Setting(section="Service", name="StateDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Service", name="StateDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Service", name="SuccessExitStatus", allowedValue=SignalValue()),
    Setting(section="Service", name="SupplementaryGroups", allowedValue=GroupsValue()),
    Setting(section="Service", name="SyslogFacility", allowedValue=EnumValue(["kern", "user", "mail", "daemon", "auth", "syslog", "lpr", "news", "uucp", "cron", "authpriv", "ftp", "local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7"])),
    Setting(section="Service", name="SyslogIdentifier", allowedValue=TextValue()),
    Setting(section="Service", name="SyslogLevel", allowedValue=EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"])),
    Setting(section="Service", name="SyslogLevelPrefix", allowedValue=BooleanValue()),
    Setting(section="Service", name="SystemCallArchitectures", allowedValue=TextValue()),
    Setting(section="Service", name="SystemCallErrorNumber", allowedValue=EitherValue([ErrorTypeValue(), NumericValue(lower=1, upper=4095)])),
    Setting(section="Service", name="SystemCallFilter", allowedValue=TextValue()),
    Setting(section="Service", name="TasksAccounting", allowedValue=BooleanValue(), sinceRel="2.27"),
    Setting(section="Service", name="TasksMax", allowedValue=NumericValue(lower=1, specials=["infinity"]), sinceRel="2.27"),
    Setting(section="Service", name="TemporaryFileSystem", allowedValue=TextValue(), sinceRel="2.38"),
    Setting(section="Service", name="TimeoutAbortSec", allowedValue=TimeValue(), sinceRel="2.43"),
    Setting(section="Service", name="TimeoutSec", allowedValue=TimeValue()),
    Setting(section="Service", name="TimeoutStartFailureMode", allowedValue=EnumValue(["terminate", "abort", "kill"]), sinceRel="2.46"),
    Setting(section="Service", name="TimeoutStartSec", allowedValue=TimeValue()),
    Setting(section="Service", name="TimeoutStopFailureMode", allowedValue=EnumValue(["terminate", "abort", "kill"]), sinceRel="2.46"),
    Setting(section="Service", name="TimeoutStopSec", allowedValue=TimeValue()),
    Setting(section="Service", name="TimerAccuracySec", allowedValue=TimeValue()),
    Setting(section="Service", name="TimerSlackNSec", allowedValue=TimeValue()),
    Setting(section="Service", name="TTYPath", allowedValue=DeviceNodeValue()),
    Setting(section="Service", name="TTYReset", allowedValue=BooleanValue()),
    Setting(section="Service", name="TTYVHangup", allowedValue=BooleanValue()),
    Setting(section="Service", name="TTYVTDisallocate", allowedValue=BooleanValue()),
    Setting(section="Service", name="Type", allowedValue=EnumValue(["simple", "exec", "forking", "oneshot", "dbus", "notify", "idle"])),
    Setting(section="Service", name="UMask", allowedValue=NumericValue()),
    Setting(section="Service", name="UnsetEnvironment", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Service", name="USBFunctionDescriptors", allowedValue=TextValue()), # TODO parser
    Setting(section="Service", name="USBFunctionStrings", allowedValue=TextValue()), # TODO parser
    Setting(section="Service", name="User", allowedValue=UsersValue()),
    Setting(section="Service", name="UtmpIdentifier", allowedValue=TextValue()),
    Setting(section="Service", name="UtmpMode", allowedValue=EnumValue(["init", "login", "user"]), sinceRel="2.25"),
    Setting(section="Service", name="WatchdogSec", allowedValue=TimeValue()),
    Setting(section="Service", name="WatchdogSignal", allowedValue=SignalValue()),
    Setting(section="Service", name="WorkingDirectory", allowedValue=PathValue(conditional={"~": None})),
    Setting(section="Socket", name="Accept", allowedValue=BooleanValue()),
    Setting(section="Socket", name="AmbientCapabilities", allowedValue=TextValue()),
    Setting(section="Socket", name="AppArmorProfile", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"}), sinceRel="2.10"),
    Setting(section="Socket", name="Backlog", allowedValue=NumericValue()),
    Setting(section="Socket", name="BindIPv6Only", allowedValue=EnumValue(["default", "both", "ipv6-only"])),
    Setting(section="Socket", name="BindPaths", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Socket", name="BindReadOnlyPaths", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Socket", name="BindToDevice", allowedValue=DeviceNodeValue()),
    Setting(section="Socket", name="BlockIOAccounting", allowedValue=BooleanValue(), tillRel="2.41"),
    Setting(section="Socket", name="BlockIODeviceWeight", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(1, 10000)]), tillRel="2.41"),
    Setting(section="Socket", name="BlockIOReadBandwidthMax", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(suffixes=["K", "M", "G", "T", "B"])]), tillRel="2.41"),
    Setting(section="Socket", name="BlockIOWeight", allowedValue=NumericValue(lower=1, upper=10000), tillRel="2.41"),
    Setting(section="Socket", name="BlockIOWriteBandwidthMax", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(suffixes=["K", "M", "G", "T", "B"])]), tillRel="2.41"),
    Setting(section="Socket", name="BlockStartupIOWeight", allowedValue=NumericValue(lower=1, upper=10000), tillRel="2.41"),
    Setting(section="Socket", name="Broadcast", allowedValue=BooleanValue()),
    Setting(section="Socket", name="CacheDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Socket", name="CacheDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Socket", name="Capabilities", allowedValue=TextValue(), tillRel="2.30"),
    Setting(section="Socket", name="CapabilityBoundingSet", allowedValue=TextValue()),
    Setting(section="Socket", name="ConfigurationDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Socket", name="ConfigurationDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Socket", name="ControlGroup", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Socket", name="ControlGroupAttribute", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Socket", name="ControlGroupModify", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Socket", name="ControlGroupPersistent", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Socket", name="CoredumpFilter", allowedValue=EitherValue([NumericValue(upper=16), EnumValue(["private-anonymous", "shared-anonymous", "private-file-backed", "shared-file-backed", "elf-headers", "private-huge", "shared-huge", "private-dax", "shared-dax", "all", "default"])]), sinceRel="2.46"),
    Setting(section="Socket", name="CPUAccounting", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Socket", name="CPUAffinity", allowedValue=EitherValue([TextValue(), EnumValue(["numa"])])),
    Setting(section="Socket", name="CPUQuota", allowedValue=NumericValue(lower=0, suffixes=["%"])),
    Setting(section="Socket", name="CPUQuotaPeriodSec", allowedValue=TimeValue(), sinceRel="2.42"),
    Setting(section="Socket", name="CPUSchedulingPolicy", allowedValue=EnumValue(["other", "batch", "idle", "fifo", "rr"])),
    Setting(section="Socket", name="CPUSchedulingPriority", allowedValue=NumericValue(lower=1, upper=99)),
    Setting(section="Socket", name="CPUSchedulingResetOnFork", allowedValue=BooleanValue()),
    Setting(section="Socket", name="CPUShares", allowedValue=NumericValue(lower=2, upper=262144), tillRel="2.41"),
    Setting(section="Socket", name="CPUWeight", allowedValue=NumericValue(1, 10000), sinceRel="2.32"),
    Setting(section="Socket", name="DefaultMemoryLow", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.43"),
    Setting(section="Socket", name="DefaultMemoryMin", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.43"),
    Setting(section="Socket", name="DeferAcceptSec", allowedValue=NumericValue(), sinceRel="2.16"),
    Setting(section="Socket", name="Delegate", allowedValue=EnumValue(["cpu", "cpuacct", "io", "blkio", "memory", "devices", "pids"])),
    Setting(section="Socket", name="DeviceAllow", allowedValue=DeviceNodeValue()),
    Setting(section="Socket", name="DevicePolicy", allowedValue=EnumValue(["auto", "closed", "strict"])),
    Setting(section="Socket", name="DirectoryMode", allowedValue=OctalModeValue()),
    Setting(section="Socket", name="DisableControllers", allowedValue=EnumValue(["yes", "cpu", "cpuacct", "io", "blkio", "memory", "devices", "pids"])),
    Setting(section="Socket", name="DynamicUser", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Socket", name="Environment", allowedValue=KeyValuePairListValue()),
    Setting(section="Socket", name="EnvironmentFile", allowedValue=AbsolutePathListValue()),
    Setting(section="Socket", name="ExecStartPost", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, })),
    Setting(section="Socket", name="ExecStartPre", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, })),
    Setting(section="Socket", name="ExecStopPost", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, })),
    Setting(section="Socket", name="ExecStopPre", allowedValue=ExecValue(conditional={"-": "ErrorCommandCouldFail", "@": None, ":": None, "+": "ErrorCommandFullPrivileges", "!": None, "!!": None, })),
    Setting(section="Socket", name="FileDescriptorName", allowedValue=TextValue()),
    Setting(section="Socket", name="FinalKillSignal", allowedValue=SignalValue()),
    Setting(section="Socket", name="FreeBind", allowedValue=BooleanValue()),
    Setting(section="Socket", name="Group", allowedValue=GroupsValue()),
    Setting(section="Socket", name="IgnoreSIGPIPE", allowedValue=BooleanValue()),
    Setting(section="Socket", name="InaccessableDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Socket", name="InaccessiblePaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Socket", name="IOAccounting", allowedValue=BooleanValue()),
    Setting(section="Socket", name="IODeviceLatencyTargetSec", allowedValue=TextValue()),# TODO parser device + target
    Setting(section="Socket", name="IODeviceWeight", allowedValue=TextValue()), # TODO parser device + weight
    Setting(section="Socket", name="IOReadBandwidthMax", allowedValue=TextValue()), # TODO parser device + bytes
    Setting(section="Socket", name="IOReadIOPSMax", allowedValue=TextValue()),# TODO parser device + IOPS
    Setting(section="Socket", name="IOSchedulingClass", allowedValue=EnumValue(["none", "realtime", "best-effort", "idle"])),
    Setting(section="Socket", name="IOSchedulingPriority", allowedValue=NumericValue(lower=0, upper=7)),
    Setting(section="Socket", name="IOWeight", allowedValue=NumericValue(lower=1, upper=10000)),
    Setting(section="Socket", name="IOWriteBandwidthMax", allowedValue=TextValue()), # TODO parser device + bytes
    Setting(section="Socket", name="IOWriteIOPSMax", allowedValue=TextValue()),# TODO parser device + IOPS
    Setting(section="Socket", name="IPAccounting", allowedValue=BooleanValue(), sinceRel="2.35"),
    Setting(section="Socket", name="IPAddressAllow", allowedValue=IPValue(), sinceRel="2.35"),
    Setting(section="Socket", name="IPAddressDeny", allowedValue=IPValue(), sinceRel="2.35"),
    Setting(section="Socket", name="IPTOS", allowedValue=NumericValue(specials=["low-delay", "throughput", "reliability", "low-cost"])),
    Setting(section="Socket", name="IPTTL", allowedValue=NumericValue()),
    Setting(section="Socket", name="KeepAlive", allowedValue=BooleanValue()),
    Setting(section="Socket", name="KeepAliveIntervalSec", allowedValue=NumericValue(), sinceRel="2.16"),
    Setting(section="Socket", name="KeepAliveProbes", allowedValue=NumericValue(), sinceRel="2.16"),
    Setting(section="Socket", name="KeepAliveTimeSec", allowedValue=NumericValue(), sinceRel="2.16"),
    Setting(section="Socket", name="KeyringMode", allowedValue=EnumValue(["inherit", "private", "shared"]), sinceRel="2.35"),
    Setting(section="Socket", name="KillMode", allowedValue=EnumValue(["control-group", "process", "mixed", "none"])),
    Setting(section="Socket", name="KillSignal", allowedValue=SignalValue()),
    Setting(section="Socket", name="LimitAS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitCORE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitCPU", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitDATA", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitFSIZE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitLOCKS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitMEMLOCK", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitMSGQUEUE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitNICE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitNOFILE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitNPROC", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitRSS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitRTPRIO", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitRTTIME", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitSIGPENDING", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="LimitSTACK", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Socket", name="ListenDatagram", allowedValue=TextValue()), # TODO parser
    Setting(section="Socket", name="ListenFIFO", allowedValue=AbsolutePathListValue()),
    Setting(section="Socket", name="ListenMessageQueue", allowedValue=TextValue()), # TODO parser
    Setting(section="Socket", name="ListenNetlink", allowedValue=TextValue()), # TODO parser
    Setting(section="Socket", name="ListenSequentialPacket", allowedValue=TextValue()), # TODO parser
    Setting(section="Socket", name="ListenSpecial", allowedValue=AbsolutePathListValue()),
    Setting(section="Socket", name="ListenStream", allowedValue=TextValue()), # TODO parser
    Setting(section="Socket", name="ListenUSBFunction", allowedValue=TextValue(), requires=[Limitation(key="USBFunctionDescriptors"), Limitation(key="USBFunctionStrings")]), # TODO parser
    Setting(section="Socket", name="LockPersonality", allowedValue=BooleanValue(), sinceRel="2.35"),
    Setting(section="Socket", name="LogLevelMax", allowedValue=EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"]), sinceRel="2.34"),
    Setting(section="Socket", name="LogRateLimitBurst", allowedValue=TimeValue(), sinceRel="2.40"),
    Setting(section="Socket", name="LogRateLimitIntervalSec", allowedValue=TimeValue(), sinceRel="2.40"),
    Setting(section="Socket", name="LogsDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Socket", name="Mark", allowedValue=NumericValue()),
    Setting(section="Socket", name="MaxConnections", allowedValue=NumericValue(), sinceRel="2.32"),
    Setting(section="Socket", name="MaxConnectionsPerSource", allowedValue=NumericValue(), sinceRel="2.32"),
    Setting(section="Socket", name="MemoryAccounting", allowedValue=BooleanValue()),
    Setting(section="Socket", name="MemoryDenyWriteExecute", allowedValue=BooleanValue(), sinceRel="2.31"),
    Setting(section="Socket", name="MemoryHigh", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Socket", name="MemoryLimit", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"], specials=["infinity"]), tillRel="2.41"),
    Setting(section="Socket", name="MemoryLow", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Socket", name="MemoryMax", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Socket", name="MemoryMin", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.40"),
    Setting(section="Socket", name="MemorySwapMax", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.32"),
    Setting(section="Socket", name="MessageQueueMaxMessages", allowedValue=NumericValue()),
    Setting(section="Socket", name="MessageQueueMessageSize", allowedValue=NumericValue()),
    Setting(section="Socket", name="MountAPIVFS", allowedValue=BooleanValue()),
    Setting(section="Socket", name="MountFlags", allowedValue=EnumValue(["shared", "slave", "private"])),
    Setting(section="Socket", name="NetworkNamespacePath", allowedValue=AbsolutePathListValue(), sinceRel="2.42"),
    Setting(section="Socket", name="Nice", allowedValue=NumericValue(lower=-20, upper=19)),
    Setting(section="Socket", name="NoDelay", allowedValue=BooleanValue(), sinceRel="2.16"),
    Setting(section="Socket", name="NoNewPrivileges", allowedValue=BooleanValue(), sinceRel="2.39"),
    Setting(section="Socket", name="NUMAPolicy", allowedValue=EnumValue(["default", "preferred", "bind", "interleave", "local"]), sinceRel="2.43"),
    Setting(section="Socket", name="OOMScoreAdjust", allowedValue=NumericValue(lower=-1000, upper=1000)),
    Setting(section="Socket", name="PAMName", allowedValue=TextValue()), # TODO PAM service lookup parser
    Setting(section="Socket", name="PassCredentials", allowedValue=BooleanValue()),
    Setting(section="Socket", name="PassEnvironment", allowedValue=TextValue(), sinceRel="2.28"),
    Setting(section="Socket", name="PassPacketInfo", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="Socket", name="PassSecurity", allowedValue=BooleanValue()),
    Setting(section="Socket", name="Personality", allowedValue=EnumValue(["x86", "x86-64", "ppc", "ppc-le", "ppc64", "ppc64-le", "s390", "s390x"])),
    Setting(section="Socket", name="PipeSize", allowedValue=NumericValue()),
    Setting(section="Socket", name="Priority", allowedValue=NumericValue()),
    Setting(section="Socket", name="PrivateDevices", allowedValue=BooleanValue()),
    Setting(section="Socket", name="PrivateMounts", allowedValue=BooleanValue(), sinceRel="2.39"),
    Setting(section="Socket", name="PrivateNetwork", allowedValue=BooleanValue()),
    Setting(section="Socket", name="PrivateTmp", allowedValue=BooleanValue()),
    Setting(section="Socket", name="PrivateUsers", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Socket", name="ProtectClock", allowedValue=BooleanValue(), sinceRel="2.45"),
    Setting(section="Socket", name="ProtectControlGroups", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Socket", name="ProtectHome", allowedValue=EitherValue(args=[EnumValue(["tmpfs", "read-only"]), BooleanValue()]), sinceRel="2.14"),
    Setting(section="Socket", name="ProtectHostname", allowedValue=BooleanValue(), sinceRel="2.42"),
    Setting(section="Socket", name="ProtectKernelLogs", allowedValue=BooleanValue(), sinceRel="2.44"),
    Setting(section="Socket", name="ProtectKernelModules", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Socket", name="ProtectKernelTunables", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Socket", name="ProtectSystem", allowedValue=EitherValue(args=[EnumValue(["full", "strict"]), BooleanValue()]), sinceRel="2.14"),
    Setting(section="Socket", name="ReadOnlyDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Socket", name="ReadOnlyPaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Socket", name="ReadWriteDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Socket", name="ReadWritePaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Socket", name="ReceiveBuffer", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Socket", name="RemoveIPC", allowedValue=BooleanValue()),
    Setting(section="Socket", name="RemoveOnStop", allowedValue=BooleanValue(), sinceRel="2.14"),
    Setting(section="Socket", name="RestartKillSignal", allowedValue=SignalValue(), sinceRel="2.44"),
    Setting(section="Socket", name="RestrictAddressFamilies", allowedValue=TextValue(), sinceRel="2.11"),
    Setting(section="Socket", name="RestrictNamespaces", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Socket", name="RestrictRealtime", allowedValue=BooleanValue(), sinceRel="2.31"),
    Setting(section="Socket", name="RestrictSUIDSGID", allowedValue=BooleanValue()),
    Setting(section="Socket", name="ReusePort", allowedValue=BooleanValue()),
    Setting(section="Socket", name="RootDirectory", allowedValue=PathValue()),
    Setting(section="Socket", name="RootHash", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="Socket", name="RootHashSignature", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="Socket", name="RootImage", allowedValue=PathValue()),
    Setting(section="Socket", name="RuntimeDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Socket", name="RuntimeDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Socket", name="RuntimeDirectoryPreserve", allowedValue=EitherValue(args=[BooleanValue(), EnumValue(["restart"])]), sinceRel="2.35"),
    Setting(section="Socket", name="SecureBits", allowedValue=EnumValue(["keep-caps", "keep-caps-locked", "no-setuid-fixup", "no-setuid-fixup-locked", "noroot", "noroot-locked"])),
    Setting(section="Socket", name="SELinuxContext", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"}), requires=[Limitation(key="Accept", value=["true", "0", "yes"])]),
    Setting(section="Socket", name="SELinuxContextFromNet", allowedValue=BooleanValue()),
    Setting(section="Socket", name="SendBuffer", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Socket", name="SendSIGHUP", allowedValue=BooleanValue()),
    Setting(section="Socket", name="SendSIGKILL", allowedValue=BooleanValue()),
    Setting(section="Socket", name="Service", allowedValue=UnitListValue(), requires=[Limitation(key="Accept", value=["no"])]),
    Setting(section="Socket", name="Slice", allowedValue=UnitListValue(requiredExt=".slice")),
    Setting(section="Socket", name="SmackLabel", allowedValue=TextValue()),
    Setting(section="Socket", name="SmackLabelIPIn", allowedValue=TextValue()),
    Setting(section="Socket", name="SmackLabelIPOut", allowedValue=TextValue()),
    Setting(section="Socket", name="SmackProcessLabel", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"}), sinceRel="2.18"),
    Setting(section="Socket", name="SocketGroup", allowedValue=GroupsValue(), sinceRel="2.14"),
    Setting(section="Socket", name="SocketMode", allowedValue=OctalModeValue()),
    Setting(section="Socket", name="SocketProtocol", allowedValue=EnumValue(["udplite", "sctp"])),
    Setting(section="Socket", name="SocketUser", allowedValue=UsersValue(), sinceRel="2.14"),
    Setting(section="Socket", name="StandardError", allowedValue=EitherValue(args=[EnumValue(["inherit", "null", "tty", "journal", "kmsg", "journal+console", "kmsg+console", "socket"]), TextValue()])),
    Setting(section="Socket", name="StandardInput", allowedValue=EitherValue(args=[EnumValue(["null", "tty", "tty-force", "tty-fail", "data", "socket"]), TextValue()]), sinceRel="2.34"),
    Setting(section="Socket", name="StandardInputData", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Socket", name="StandardInputText", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Socket", name="StandardOutput", allowedValue=EitherValue(args=[EnumValue(["inherit", "null", "tty", "journal", "kmsg", "journal+console", "kmsg+console", "socket"]), TextValue()])),
    Setting(section="Socket", name="StartupCPUShares", allowedValue=NumericValue(lower=2, upper=262144), tillRel="2.41"),
    Setting(section="Socket", name="StartupCPUWeight", allowedValue=NumericValue(1, 10000)),
    Setting(section="Socket", name="StartupIOWeight", allowedValue=NumericValue(lower=1, upper=10000)),
    Setting(section="Socket", name="StateDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Socket", name="StateDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Socket", name="SupplementaryGroups", allowedValue=GroupsValue()),
    Setting(section="Socket", name="Symlinks", allowedValue=AbsolutePathListValue(), sinceRel="2.14"),
    Setting(section="Socket", name="SyslogFacility", allowedValue=EnumValue(["kern", "user", "mail", "daemon", "auth", "syslog", "lpr", "news", "uucp", "cron", "authpriv", "ftp", "local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7"])),
    Setting(section="Socket", name="SyslogIdentifier", allowedValue=TextValue()),
    Setting(section="Socket", name="SyslogLevel", allowedValue=EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"])),
    Setting(section="Socket", name="SyslogLevelPrefix", allowedValue=BooleanValue()),
    Setting(section="Socket", name="SystemCallArchitectures", allowedValue=TextValue()),
    Setting(section="Socket", name="SystemCallErrorNumber", allowedValue=EitherValue([ErrorTypeValue(), NumericValue(lower=1, upper=4095)])),
    Setting(section="Socket", name="SystemCallFilter", allowedValue=TextValue()),
    Setting(section="Socket", name="TasksAccounting", allowedValue=BooleanValue(), sinceRel="2.27"),
    Setting(section="Socket", name="TasksMax", allowedValue=NumericValue(lower=1, specials=["infinity"]), sinceRel="2.27"),
    Setting(section="Socket", name="TCPCongestion", allowedValue=TextValue()),
    Setting(section="Socket", name="TemporaryFileSystem", allowedValue=TextValue(), sinceRel="2.38"),
    Setting(section="Socket", name="TimeoutSec", allowedValue=TimeValue()),
    Setting(section="Socket", name="TimerSlackNSec", allowedValue=NumericValue()),
    Setting(section="Socket", name="Transparent", allowedValue=BooleanValue()),
    Setting(section="Socket", name="TriggerLimitBurst", allowedValue=TimeValue(), sinceRel="2.30"),
    Setting(section="Socket", name="TriggerLimitIntervalSec", allowedValue=TimeValue(), sinceRel="2.30"),
    Setting(section="Socket", name="TTYPath", allowedValue=DeviceNodeValue()),
    Setting(section="Socket", name="TTYReset", allowedValue=BooleanValue()),
    Setting(section="Socket", name="TTYVHangup", allowedValue=BooleanValue()),
    Setting(section="Socket", name="TTYVTDisallocate", allowedValue=BooleanValue()),
    Setting(section="Socket", name="UMask", allowedValue=NumericValue()),
    Setting(section="Socket", name="UnsetEnvironment", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Socket", name="User", allowedValue=UsersValue()),
    Setting(section="Socket", name="UtmpIdentifier", allowedValue=TextValue()),
    Setting(section="Socket", name="UtmpMode", allowedValue=EnumValue(["init", "login", "user"]), sinceRel="2.25"),
    Setting(section="Socket", name="WatchdogSignal", allowedValue=SignalValue()),
    Setting(section="Socket", name="WorkingDirectory", allowedValue=PathValue(conditional={"~": None})),
    Setting(section="Socket", name="Writable", allowedValue=BooleanValue(), sinceRel="2.27"),
    Setting(section="SR-IOV", name="LinkState", allowedValue=EitherValue([BooleanValue(), EnumValue(["auto"])]), sinceRel="2.46"),
    Setting(section="SR-IOV", name="MACAddress", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="SR-IOV", name="MACSpoofCheck", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="SR-IOV", name="QualityOfService", allowedValue=NumericValue(lower=1, upper=4294967294), sinceRel="2.46"),
    Setting(section="SR-IOV", name="QueryReceiveSideScaling", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="SR-IOV", name="Trust", allowedValue=BooleanValue(), sinceRel="2.46"),
    Setting(section="SR-IOV", name="VirtualFunction", allowedValue=NumericValue(upper=2147483646), sinceRel="2.46"),
    Setting(section="SR-IOV", name="VLANId", allowedValue=NumericValue(lower=1, upper=4096), sinceRel="2.46"),
    Setting(section="SR-IOV", name="VLANProtocol", allowedValue=EnumValue(["802.1Q", "802.1ad"]), sinceRel="2.46"),
    Setting(section="StochasticFairBlue", name="Handle", allowedValue=NumericValue(lower=1, upper=0xffff, numberBase=16), sinceRel="2.46"),
    Setting(section="StochasticFairBlue", name="PacketLimit", allowedValue=NumericValue(upper=4294967294), sinceRel="2.46"),
    Setting(section="StochasticFairBlue", name="Parent", allowedValue=EitherValue([TextValue(), EnumValue(["root", "clsact", "ingress"])]), sinceRel="2.46"),
    Setting(section="StochasticFairnessQueueing", name="Handle", allowedValue=EitherValue(args=[HexValue(lower=0, upper=0xfff), EmptyValue()]), sinceRel="2.45"),
    Setting(section="StochasticFairnessQueueing", name="Parent", allowedValue=EnumValue(value=["root", "clsact", "ingress"]), sinceRel="2.45"),
    Setting(section="StochasticFairnessQueueing", name="PerturbPeriodSec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="Swap", name="AmbientCapabilities", allowedValue=TextValue()),
    Setting(section="Swap", name="AppArmorProfile", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"}), sinceRel="2.10"),
    Setting(section="Swap", name="BindPaths", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Swap", name="BindReadOnlyPaths", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Swap", name="BlockIOAccounting", allowedValue=BooleanValue(), tillRel="2.41"),
    Setting(section="Swap", name="BlockIODeviceWeight", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(1, 10000)]), tillRel="2.41"),
    Setting(section="Swap", name="BlockIOReadBandwidthMax", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(suffixes=["K", "M", "G", "T", "B"])]), tillRel="2.41"),
    Setting(section="Swap", name="BlockIOWeight", allowedValue=NumericValue(lower=1, upper=10000), tillRel="2.41"),
    Setting(section="Swap", name="BlockIOWriteBandwidthMax", allowedValue=CombinedValue(args=[DeviceNodeValue(), NumericValue(suffixes=["K", "M", "G", "T", "B"])]), tillRel="2.41"),
    Setting(section="Swap", name="BlockStartupIOWeight", allowedValue=NumericValue(lower=1, upper=10000), tillRel="2.41"),
    Setting(section="Swap", name="CacheDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Swap", name="CacheDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Swap", name="Capabilities", allowedValue=TextValue(), tillRel="2.30"),
    Setting(section="Swap", name="CapabilityBoundingSet", allowedValue=TextValue()),
    Setting(section="Swap", name="ConfigurationDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Swap", name="ConfigurationDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Swap", name="ControlGroup", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Swap", name="ControlGroupAttribute", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Swap", name="ControlGroupModify", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Swap", name="ControlGroupPersistent", allowedValue=TextValue(), tillRel="2.12"),
    Setting(section="Swap", name="CoredumpFilter", allowedValue=EitherValue([NumericValue(upper=16), EnumValue(["private-anonymous", "shared-anonymous", "private-file-backed", "shared-file-backed", "elf-headers", "private-huge", "shared-huge", "private-dax", "shared-dax", "all", "default"])]), sinceRel="2.46"),
    Setting(section="Swap", name="CPUAccounting", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Swap", name="CPUAffinity", allowedValue=EitherValue([TextValue(), EnumValue(["numa"])])),
    Setting(section="Swap", name="CPUQuota", allowedValue=NumericValue(lower=0, suffixes=["%"])),
    Setting(section="Swap", name="CPUQuotaPeriodSec", allowedValue=TimeValue(), sinceRel="2.42"),
    Setting(section="Swap", name="CPUSchedulingPolicy", allowedValue=EnumValue(["other", "batch", "idle", "fifo", "rr"])),
    Setting(section="Swap", name="CPUSchedulingPriority", allowedValue=NumericValue(lower=1, upper=99)),
    Setting(section="Swap", name="CPUSchedulingResetOnFork", allowedValue=BooleanValue()),
    Setting(section="Swap", name="CPUShares", allowedValue=NumericValue(lower=2, upper=262144), tillRel="2.41"),
    Setting(section="Swap", name="CPUWeight", allowedValue=NumericValue(1, 10000), sinceRel="2.32"),
    Setting(section="Swap", name="DefaultMemoryLow", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.43"),
    Setting(section="Swap", name="DefaultMemoryMin", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.43"),
    Setting(section="Swap", name="Delegate", allowedValue=EnumValue(["yes", "cpu", "cpuacct", "io", "blkio", "memory", "devices", "pids"])),
    Setting(section="Swap", name="DeviceAllow", allowedValue=DeviceNodeValue()),
    Setting(section="Swap", name="DevicePolicy", allowedValue=EnumValue(["auto", "closed", "strict"])),
    Setting(section="Swap", name="DisableControllers", allowedValue=EnumValue(["cpu", "cpuacct", "io", "blkio", "memory", "devices", "pids"])),
    Setting(section="Swap", name="DynamicUser", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Swap", name="Environment", allowedValue=KeyValuePairListValue()),
    Setting(section="Swap", name="EnvironmentFile", allowedValue=AbsolutePathListValue()),
    Setting(section="Swap", name="FinalKillSignal", allowedValue=SignalValue()),
    Setting(section="Swap", name="Group", allowedValue=GroupsValue()),
    Setting(section="Swap", name="IgnoreSIGPIPE", allowedValue=BooleanValue()),
    Setting(section="Swap", name="InaccessableDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Swap", name="InaccessiblePaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Swap", name="IOAccounting", allowedValue=BooleanValue()),
    Setting(section="Swap", name="IODeviceLatencyTargetSec", allowedValue=TextValue()),# TODO parser device + target
    Setting(section="Swap", name="IODeviceWeight", allowedValue=TextValue()), # TODO parser device + weight
    Setting(section="Swap", name="IOReadBandwidthMax", allowedValue=TextValue()), # TODO parser device + bytes
    Setting(section="Swap", name="IOReadIOPSMax", allowedValue=TextValue()),# TODO parser device + IOPS
    Setting(section="Swap", name="IOSchedulingClass", allowedValue=EnumValue(["none", "realtime", "best-effort", "idle"])),
    Setting(section="Swap", name="IOSchedulingPriority", allowedValue=NumericValue(lower=0, upper=7)),
    Setting(section="Swap", name="IOWeight", allowedValue=NumericValue(lower=1, upper=10000)),
    Setting(section="Swap", name="IOWriteBandwidthMax", allowedValue=TextValue()), # TODO parser device + bytes
    Setting(section="Swap", name="IOWriteIOPSMax", allowedValue=TextValue()),# TODO parser device + IOPS
    Setting(section="Swap", name="IPAccounting", allowedValue=BooleanValue(), sinceRel="2.35"),
    Setting(section="Swap", name="IPAddressAllow", allowedValue=IPValue(), sinceRel="2.35"),
    Setting(section="Swap", name="IPAddressDeny", allowedValue=IPValue(), sinceRel="2.35"),
    Setting(section="Swap", name="KeyringMode", allowedValue=EnumValue(["inherit", "private", "shared"]), sinceRel="2.35"),
    Setting(section="Swap", name="KillMode", allowedValue=EnumValue(["control-group", "process", "mixed", "none"])),
    Setting(section="Swap", name="KillSignal", allowedValue=SignalValue()),
    Setting(section="Swap", name="LimitAS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitCORE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitCPU", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitDATA", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitFSIZE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitLOCKS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitMEMLOCK", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitMSGQUEUE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitNICE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitNOFILE", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitNPROC", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitRSS", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitRTPRIO", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitRTTIME", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitSIGPENDING", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LimitSTACK", allowedValue=NumericValue(specials=["infinity"])),
    Setting(section="Swap", name="LockPersonality", allowedValue=BooleanValue(), sinceRel="2.35"),
    Setting(section="Swap", name="LogLevelMax", allowedValue=EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"]), sinceRel="2.34"),
    Setting(section="Swap", name="LogRateLimitBurst", allowedValue=TimeValue(), sinceRel="2.40"),
    Setting(section="Swap", name="LogRateLimitIntervalSec", allowedValue=TimeValue(), sinceRel="2.40"),
    Setting(section="Swap", name="LogsDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Swap", name="MemoryAccounting", allowedValue=BooleanValue()),
    Setting(section="Swap", name="MemoryDenyWriteExecute", allowedValue=BooleanValue(), sinceRel="2.31"),
    Setting(section="Swap", name="MemoryHigh", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Swap", name="MemoryLimit", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"], specials=["infinity"]), tillRel="2.41"),
    Setting(section="Swap", name="MemoryLow", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Swap", name="MemoryMax", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Swap", name="MemoryMin", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"]), sinceRel="2.40"),
    Setting(section="Swap", name="MemorySwapMax", allowedValue=NumericValue(suffixes=["K", "M", "G", "T", "B"])),
    Setting(section="Swap", name="MountAPIVFS", allowedValue=BooleanValue()),
    Setting(section="Swap", name="MountFlags", allowedValue=EnumValue(["shared", "slave", "private"])),
    Setting(section="Swap", name="NetworkNamespacePath", allowedValue=AbsolutePathListValue(), sinceRel="2.42"),
    Setting(section="Swap", name="Nice", allowedValue=NumericValue(lower=-20, upper=19)),
    Setting(section="Swap", name="NoNewPrivileges", allowedValue=BooleanValue(), sinceRel="2.39"),
    Setting(section="Swap", name="NUMAPolicy", allowedValue=EnumValue(["default", "preferred", "bind", "interleave", "local"]), sinceRel="2.43"),
    Setting(section="Swap", name="OOMScoreAdjust", allowedValue=NumericValue(lower=-1000, upper=1000)),
    Setting(section="Swap", name="Options", allowedValue=TextValue()),
    Setting(section="Swap", name="PAMName", allowedValue=TextValue()), # TODO PAM service lookup parser
    Setting(section="Swap", name="PassEnvironment", allowedValue=TextValue(), sinceRel="2.28"),
    Setting(section="Swap", name="Personality", allowedValue=EnumValue(["x86", "x86-64", "ppc", "ppc-le", "ppc64", "ppc64-le", "s390", "s390x"])),
    Setting(section="Swap", name="Priority", allowedValue=NumericValue()),
    Setting(section="Swap", name="PrivateDevices", allowedValue=BooleanValue()),
    Setting(section="Swap", name="PrivateMounts", allowedValue=BooleanValue(), sinceRel="2.39"),
    Setting(section="Swap", name="PrivateNetwork", allowedValue=BooleanValue()),
    Setting(section="Swap", name="PrivateTmp", allowedValue=BooleanValue()),
    Setting(section="Swap", name="PrivateUsers", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Swap", name="ProtectClock", allowedValue=BooleanValue(), sinceRel="2.45"),
    Setting(section="Swap", name="ProtectControlGroups", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Swap", name="ProtectHome", allowedValue=EitherValue(args=[EnumValue(["tmpfs", "read-only"]), BooleanValue()]), sinceRel="2.14"),
    Setting(section="Swap", name="ProtectHostname", allowedValue=BooleanValue(), sinceRel="2.42"),
    Setting(section="Swap", name="ProtectKernelLogs", allowedValue=BooleanValue(), sinceRel="2.44"),
    Setting(section="Swap", name="ProtectKernelModules", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Swap", name="ProtectKernelTunables", allowedValue=BooleanValue(), sinceRel="2.32"),
    Setting(section="Swap", name="ProtectSystem", allowedValue=EitherValue(args=[EnumValue(["full", "strict"]), BooleanValue()]), sinceRel="2.14"),
    Setting(section="Swap", name="ReadOnlyDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Swap", name="ReadOnlyPaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Swap", name="ReadWriteDirectories", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Swap", name="ReadWritePaths", allowedValue=TextValue(), sinceRel="2.31"),
    Setting(section="Swap", name="RemoveIPC", allowedValue=BooleanValue()),
    Setting(section="Swap", name="RestartKillSignal", allowedValue=SignalValue(), sinceRel="2.44"),
    Setting(section="Swap", name="RestrictAddressFamilies", allowedValue=TextValue(), sinceRel="2.11"),
    Setting(section="Swap", name="RestrictNamespaces", allowedValue=TextValue(), sinceRel="2.33"),
    Setting(section="Swap", name="RestrictRealtime", allowedValue=BooleanValue(), sinceRel="2.31"),
    Setting(section="Swap", name="RestrictSUIDSGID", allowedValue=BooleanValue()),
    Setting(section="Swap", name="RootDirectory", allowedValue=PathValue()),
    Setting(section="Swap", name="RootHash", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="Swap", name="RootHashSignature", allowedValue=TextValue(), sinceRel="2.46"),
    Setting(section="Swap", name="RootImage", allowedValue=PathValue()),
    Setting(section="Swap", name="RuntimeDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Swap", name="RuntimeDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Swap", name="RuntimeDirectoryPreserve", allowedValue=EitherValue(args=[BooleanValue(), EnumValue(["restart"])]), sinceRel="2.35"),
    Setting(section="Swap", name="SecureBits", allowedValue=EnumValue(["keep-caps", "keep-caps-locked", "no-setuid-fixup", "no-setuid-fixup-locked", "noroot", "noroot-locked"])),
    Setting(section="Swap", name="SELinuxContext", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"})),
    Setting(section="Swap", name="SendSIGHUP", allowedValue=BooleanValue()),
    Setting(section="Swap", name="SendSIGKILL", allowedValue=BooleanValue()),
    Setting(section="Swap", name="Slice", allowedValue=UnitListValue(requiredExt=".slice")),
    Setting(section="Swap", name="SmackProcessLabel", allowedValue=TextValue(conditional={"-": "ErrorCommandCouldFail"}), sinceRel="2.18"),
    Setting(section="Swap", name="StandardError", allowedValue=EitherValue(args=[EnumValue(["inherit", "null", "tty", "journal", "kmsg", "journal+console", "kmsg+console", "socket"]), TextValue()])),
    Setting(section="Swap", name="StandardInput", allowedValue=EitherValue(args=[EnumValue(["null", "tty", "tty-force", "tty-fail", "data", "socket"]), TextValue()]), sinceRel="2.34"),
    Setting(section="Swap", name="StandardInputData", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Swap", name="StandardInputText", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Swap", name="StandardOutput", allowedValue=EitherValue(args=[EnumValue(["inherit", "null", "tty", "journal", "kmsg", "journal+console", "kmsg+console", "socket"]), TextValue()])),
    Setting(section="Swap", name="StartupCPUShares", allowedValue=NumericValue(lower=2, upper=262144), tillRel="2.41"),
    Setting(section="Swap", name="StartupCPUWeight", allowedValue=NumericValue(1, 10000)),
    Setting(section="Swap", name="StartupIOWeight", allowedValue=NumericValue(lower=1, upper=10000)),
    Setting(section="Swap", name="StateDirectory", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Swap", name="StateDirectoryMode", allowedValue=NumericValue(), sinceRel="2.35"),
    Setting(section="Swap", name="SupplementaryGroups", allowedValue=GroupsValue()),
    Setting(section="Swap", name="SyslogFacility", allowedValue=EnumValue(["kern", "user", "mail", "daemon", "auth", "syslog", "lpr", "news", "uucp", "cron", "authpriv", "ftp", "local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7"])),
    Setting(section="Swap", name="SyslogIdentifier", allowedValue=TextValue()),
    Setting(section="Swap", name="SyslogLevel", allowedValue=EnumValue(["emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"])),
    Setting(section="Swap", name="SyslogLevelPrefix", allowedValue=BooleanValue()),
    Setting(section="Swap", name="SystemCallArchitectures", allowedValue=TextValue()),
    Setting(section="Swap", name="SystemCallErrorNumber", allowedValue=EitherValue([ErrorTypeValue(), NumericValue(lower=1, upper=4095)])),
    Setting(section="Swap", name="SystemCallFilter", allowedValue=TextValue()),
    Setting(section="Swap", name="TasksAccounting", allowedValue=BooleanValue(), sinceRel="2.27"),
    Setting(section="Swap", name="TasksMax", allowedValue=NumericValue(lower=1, specials=["infinity"]), sinceRel="2.27"),
    Setting(section="Swap", name="TemporaryFileSystem", allowedValue=TextValue(), sinceRel="2.38"),
    Setting(section="Swap", name="TimeoutSec", allowedValue=TimeValue()),
    Setting(section="Swap", name="TimerSlackNSec", allowedValue=NumericValue()),
    Setting(section="Swap", name="TTYPath", allowedValue=DeviceNodeValue()),
    Setting(section="Swap", name="TTYReset", allowedValue=BooleanValue()),
    Setting(section="Swap", name="TTYVHangup", allowedValue=BooleanValue()),
    Setting(section="Swap", name="TTYVTDisallocate", allowedValue=BooleanValue()),
    Setting(section="Swap", name="UMask", allowedValue=NumericValue()),
    Setting(section="Swap", name="UnsetEnvironment", allowedValue=TextValue(), sinceRel="2.35"),
    Setting(section="Swap", name="User", allowedValue=UsersValue()),
    Setting(section="Swap", name="UtmpIdentifier", allowedValue=TextValue()),
    Setting(section="Swap", name="UtmpMode", allowedValue=EnumValue(["init", "login", "user"]), sinceRel="2.25"),
    Setting(section="Swap", name="WatchdogSignal", allowedValue=SignalValue()),
    Setting(section="Swap", name="What", allowedValue=TextValue()),
    Setting(section="Swap", name="WorkingDirectory", allowedValue=PathValue(conditional={"~": None})),
    Setting(section="Tap", name="Group", allowedValue=GroupsValue()),
    Setting(section="Tap", name="MultiQueue", allowedValue=BooleanValue()),
    Setting(section="Tap", name="OneQueue", allowedValue=BooleanValue()),
    Setting(section="Tap", name="PacketInfo", allowedValue=BooleanValue()),
    Setting(section="Tap", name="User", allowedValue=UsersValue()),
    Setting(section="Tap", name="VNetHeader", allowedValue=BooleanValue()),
    Setting(section="Time", name="FallbackNTP", allowedValue=TextValue()),
    Setting(section="Time", name="NTP", allowedValue=TextValue()),
    Setting(section="Time", name="PollIntervalMaxSec", allowedValue=NumericValue(lower=17)),
    Setting(section="Time", name="PollIntervalMinSec", allowedValue=NumericValue(lower=16)),
    Setting(section="Time", name="RootDistanceMaxSec", allowedValue=NumericValue()),
    Setting(section="Timer", name="AccuracySec", allowedValue=TimeValue()),
    Setting(section="Timer", name="OnActiveSec", allowedValue=TimeValue()),
    Setting(section="Timer", name="OnBootSec", allowedValue=TimeValue()),
    Setting(section="Timer", name="OnCalendar", allowedValue=TextValue()), # TODO calender parser
    Setting(section="Timer", name="OnClockChange", allowedValue=BooleanValue()),
    Setting(section="Timer", name="OnStartupSec", allowedValue=TimeValue()),
    Setting(section="Timer", name="OnTimezoneChange", allowedValue=BooleanValue()),
    Setting(section="Timer", name="OnUnitActiveSec", allowedValue=TimeValue()),
    Setting(section="Timer", name="OnUnitInactiveSec", allowedValue=TimeValue()),
    Setting(section="Timer", name="Persistent", allowedValue=BooleanValue(), sinceRel="2.12"),
    Setting(section="Timer", name="RandomizedDelaySec", allowedValue=TimeValue(), sinceRel="2.29"),
    Setting(section="Timer", name="RemainAfterElapse", allowedValue=BooleanValue()),
    Setting(section="Timer", name="Unit", allowedValue=UnitListValue(requiredExt=".timer", inverseMode=True)),
    Setting(section="Timer", name="WakeSystem", allowedValue=BooleanValue(), sinceRel="2.12"),
    Setting(section="TokenBucketFilter", name="Burst", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="TokenBucketFilter", name="Handle", allowedValue=EitherValue(args=[HexValue(lower=0, upper=0xfff), EmptyValue()]), sinceRel="2.45"),
    Setting(section="TokenBucketFilter", name="LatencySec", allowedValue=TimeValue(), sinceRel="2.45"),
    Setting(section="TokenBucketFilter", name="LimitSize", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="TokenBucketFilter", name="MPUBytes", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="TokenBucketFilter", name="MTUBytes", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="TokenBucketFilter", name="Parent", allowedValue=EnumValue(value=["root", "clsact", "ingress"]), sinceRel="2.45"),
    Setting(section="TokenBucketFilter", name="PeakRate", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="TokenBucketFilter", name="Rate", allowedValue=NumericValue(suffixes=["K", "M", "G"]), sinceRel="2.45"),
    Setting(section="TrafficControlQueueingDiscipline", name="NetworkEmulatorDelayJitterSec", allowedValue=NumericValue(lower=0), sinceRel="2.44", tillRel="2.45"),
    Setting(section="TrafficControlQueueingDiscipline", name="NetworkEmulatorDelaySec", allowedValue=NumericValue(lower=0), sinceRel="2.44", tillRel="2.45"),
    Setting(section="TrafficControlQueueingDiscipline", name="NetworkEmulatorDuplicateRate", allowedValue=NumericValue(lower=0, upper=100, suffixes=["%"]), sinceRel="2.44", tillRel="2.45"),
    Setting(section="TrafficControlQueueingDiscipline", name="NetworkEmulatorLossRate", allowedValue=NumericValue(lower=0, upper=100, suffixes=["%"]), sinceRel="2.44", tillRel="2.45"),
    Setting(section="TrafficControlQueueingDiscipline", name="NetworkEmulatorPacketLimit", allowedValue=NumericValue(lower=0, upper=4294967294), sinceRel="2.44", tillRel="2.45"),
    Setting(section="TrafficControlQueueingDiscipline", name="Parent", allowedValue=EnumValue(value=["root", "clsact"]), sinceRel="2.44", tillRel="2.45"),
    Setting(section="TrivialLinkEqualizer", name="Handle", allowedValue=EitherValue(args=[HexValue(lower=0, upper=0xfff), EmptyValue()]), sinceRel="2.45"),
    Setting(section="TrivialLinkEqualizer", name="Id", allowedValue=NumericValue(), sinceRel="2.45"),
    Setting(section="TrivialLinkEqualizer", name="Parent", allowedValue=EnumValue(value=["root", "clsact", "ingress"]), sinceRel="2.45"),
    Setting(section="Tun", name="Group", allowedValue=GroupsValue()),
    Setting(section="Tun", name="MultiQueue", allowedValue=BooleanValue()),
    Setting(section="Tun", name="OneQueue", allowedValue=BooleanValue()),
    Setting(section="Tun", name="PacketInfo", allowedValue=BooleanValue()),
    Setting(section="Tun", name="User", allowedValue=UsersValue()),
    Setting(section="Tun", name="VNetHeader", allowedValue=BooleanValue()),
    Setting(section="Tunnel", name="AllowLocalRemote", allowedValue=BooleanValue()),
    Setting(section="Tunnel", name="AssignToLoopback", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="Tunnel", name="CopyDSCP", allowedValue=BooleanValue()),
    Setting(section="Tunnel", name="DiscoverPathMTU", allowedValue=BooleanValue()),
    Setting(section="Tunnel", name="Encapsulation", allowedValue=TextValue()),
    Setting(section="Tunnel", name="EncapsulationLimit", allowedValue=NumericValue(lower=0, upper=255, specials=["none"])),
    Setting(section="Tunnel", name="ERSPANIndex", allowedValue=NumericValue(lower=1, upper=1048575)),
    Setting(section="Tunnel", name="FooOverUDP", allowedValue=BooleanValue()),
    Setting(section="Tunnel", name="FOUDestinationPort", allowedValue=NumericValue(lower=1, upper=65534), requires=[Limitation(key="FooOverUDP", value="yes")]),
    Setting(section="Tunnel", name="FOUSourcePort", allowedValue=NumericValue(lower=1, upper=65534)),
    Setting(section="Tunnel", name="Independent", allowedValue=BooleanValue()),
    Setting(section="Tunnel", name="InputKey", allowedValue=TextValue()),
    Setting(section="Tunnel", name="IPv6FlowLabel", allowedValue=TextValue()),
    Setting(section="Tunnel", name="IPv6RapidDeploymentPrefix", allowedValue=TextValue()),
    Setting(section="Tunnel", name="ISATAP", allowedValue=BooleanValue()),
    Setting(section="Tunnel", name="Key", allowedValue=TextValue()),
    Setting(section="Tunnel", name="Local", allowedValue=EitherValue(args=[IPValue(), EnumValue(["any"])])),
    Setting(section="Tunnel", name="Mode", allowedValue=EnumValue(["ip6ip6", "ipip6", "any"])),
    Setting(section="Tunnel", name="OutputKey", allowedValue=TextValue()),
    Setting(section="Tunnel", name="Remote", allowedValue=EitherValue(args=[IPValue(), EnumValue(["any"])])),
    Setting(section="Tunnel", name="SerializeTunneledPackets", allowedValue=BooleanValue()),
    Setting(section="Tunnel", name="TOS", allowedValue=TextValue()),
    Setting(section="Tunnel", name="TTL", allowedValue=NumericValue(lower=1, upper=255)),
    Setting(section="Unit", name="After", allowedValue=UnitListValue(), dropinproc=DropinAdditive()),
    Setting(section="Unit", name="Alias", allowedValue=TextValue()),
    Setting(section="Unit", name="AllowIsolate", allowedValue=BooleanValue()),
    Setting(section="Unit", name="Also", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertACPower", allowedValue=BooleanValue()),
    Setting(section="Unit", name="AssertArchitecture", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertCapability", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertControlGroupController", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertCPUs", allowedValue=NumericValue()),
    Setting(section="Unit", name="AssertDirectoryNotEmpty", allowedValue=AbsolutePathListValue()),
    Setting(section="Unit", name="AssertFileIsExecutable", allowedValue=AbsolutePathListValue()),
    Setting(section="Unit", name="AssertFileNotEmpty", allowedValue=AbsolutePathListValue()),
    Setting(section="Unit", name="AssertFirstBoot", allowedValue=BooleanValue()),
    Setting(section="Unit", name="AssertGroup", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertHost", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertKernelCommandLine", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertKernelVersion", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertMemory", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertNeedsUpdate", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertPathExists", allowedValue=AbsolutePathListValue()),
    Setting(section="Unit", name="AssertPathExistsGlob", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertPathIsDirectory", allowedValue=AbsolutePathListValue()),
    Setting(section="Unit", name="AssertPathIsEncrypted", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None}), sinceRel="2.46"),
    Setting(section="Unit", name="AssertEnvironment", allowedValue=KeyValuePairListValue(), sinceRel="2.46"),
    Setting(section="Unit", name="AssertPathIsMountPoint", allowedValue=AbsolutePathListValue()),
    Setting(section="Unit", name="AssertPathIsReadWrite", allowedValue=AbsolutePathListValue()),
    Setting(section="Unit", name="AssertPathIsSymbolicLink", allowedValue=AbsolutePathListValue()),
    Setting(section="Unit", name="AssertSecurity", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertUser", allowedValue=TextValue()),
    Setting(section="Unit", name="AssertVirtualization", allowedValue=BooleanValue()),
    Setting(section="Unit", name="Before", allowedValue=UnitListValue(), dropinproc=DropinAdditive()),
    Setting(section="Unit", name="BindsTo", allowedValue=UnitListValue()),
    Setting(section="Unit", name="CollectMode", allowedValue=EnumValue(["inactive", "inactive-or-failed"]), sinceRel="2.34"),
    Setting(section="Unit", name="ConditionACPower", allowedValue=BooleanValue()),
    Setting(section="Unit", name="ConditionArchitecture", allowedValue=TextValue(), sinceRel="2.10"),
    Setting(section="Unit", name="ConditionCapability", allowedValue=TextValue()),
    Setting(section="Unit", name="ConditionControlGroupController", allowedValue=TextValue(), sinceRel="2.38"),
    Setting(section="Unit", name="ConditionCPUs", allowedValue=NumericValue(), sinceRel="2.42"),
    Setting(section="Unit", name="ConditionDirectoryNotEmpty", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None})),
    Setting(section="Unit", name="ConditionEnvironment", allowedValue=KeyValuePairListValue(), sinceRel="2.46"),
    Setting(section="Unit", name="ConditionFileIsExecutable", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None})),
    Setting(section="Unit", name="ConditionFileNotEmpty", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None})),
    Setting(section="Unit", name="ConditionFirstBoot", allowedValue=BooleanValue()),
    Setting(section="Unit", name="ConditionGroup", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Unit", name="ConditionHost", allowedValue=TextValue()),
    Setting(section="Unit", name="ConditionKernelCommandLine", allowedValue=TextValue()),
    Setting(section="Unit", name="ConditionKernelVersion", allowedValue=TextValue(), sinceRel="2.38"),
    Setting(section="Unit", name="ConditionMemory", allowedValue=TextValue(), sinceRel="2.42"),
    Setting(section="Unit", name="ConditionNeedsUpdate", allowedValue=TextValue(), sinceRel="2.15"),
    Setting(section="Unit", name="ConditionPathExists", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None})),
    Setting(section="Unit", name="ConditionPathExistsGlob", allowedValue=TextValue()),
    Setting(section="Unit", name="ConditionPathIsDirectory", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None})),
    Setting(section="Unit", name="ConditionPathIsEncrypted", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None}), sinceRel="2.46"),
    Setting(section="Unit", name="ConditionPathIsMountPoint", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None})),
    Setting(section="Unit", name="ConditionPathIsReadWrite", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None})),
    Setting(section="Unit", name="ConditionPathIsSymbolicLink", allowedValue=AbsolutePathListValue(conditional={"!": None, "|": None})),
    Setting(section="Unit", name="ConditionSecurity", allowedValue=TextValue(), sinceRel="2.12"),
    Setting(section="Unit", name="ConditionUser", allowedValue=TextValue(), sinceRel="2.34"),
    Setting(section="Unit", name="ConditionVirtualization", allowedValue=BooleanValue(["vm", "container"], conditional={"!": None, "|": None})),
    Setting(section="Unit", name="Conflicts", allowedValue=UnitListValue(), dropinproc=DropinAdditive()),
    Setting(section="Unit", name="DefaultDependencies", allowedValue=BooleanValue()),
    Setting(section="Unit", name="Description", allowedValue=TextValue()),
    Setting(section="Unit", name="Documentation", allowedValue=TextValue()),
    Setting(section="Unit", name="FailureAction", allowedValue=EnumValue(["none", "reboot", "reboot-force", "reboot-immediate", "poweroff", "poweroff-force", "poweroff-immediate", "exit", "exit-force"]), sinceRel="2.13"),
    Setting(section="Unit", name="FailureActionExitStatus", allowedValue=NumericValue(0, 255), sinceRel="2.40"),
    Setting(section="Unit", name="IgnoreOnIsolate", allowedValue=BooleanValue()),
    Setting(section="Unit", name="IPEgressFilterPath", allowedValue=TextValue(), sinceRel="2.43"),
    Setting(section="Unit", name="IPIngressFilterPath", allowedValue=TextValue(), sinceRel="2.43"),
    Setting(section="Unit", name="JobRunningTimeoutSec", allowedValue=TimeValue()),
    Setting(section="Unit", name="JobTimeoutAction", allowedValue=EnumValue(["none", "reboot", "reboot-force", "reboot-immediate", "poweroff", "poweroff-force", "poweroff-immediate", "exit", "exit-force"])),
    Setting(section="Unit", name="JobTimeoutRebootArgument", allowedValue=EnumValue(["none", "reboot", "reboot-force", "reboot-immediate", "poweroff", "poweroff-force", "poweroff-immediate", "exit", "exit-force"])),
    Setting(section="Unit", name="JobTimeoutSec", allowedValue=TimeValue()),
    Setting(section="Unit", name="JoinsNamespaceOf", allowedValue=TextValue()), # TODO
    Setting(section="Unit", name="LogNamespace", allowedValue=TextValue(), tillRel="2.45"),
    Setting(section="Unit", name="OnFailure", allowedValue=UnitListValue()),
    Setting(section="Unit", name="OnFailureJobMode", allowedValue=EnumValue(["fail", "replace", "replace-irreversibly", "isolate", "flush", "ignore-dependencies", "ignore-requirements"])),
    Setting(section="Unit", name="PartOf", allowedValue=UnitListValue()),
    Setting(section="Unit", name="PropagatesReloadFrom", allowedValue=UnitListValue()),
    Setting(section="Unit", name="PropagatesReloadTo", allowedValue=UnitListValue()),
    Setting(section="Unit", name="RebootArgument", allowedValue=TextValue(), sinceRel="2.13"),
    Setting(section="Unit", name="RefuseManualStart", allowedValue=BooleanValue()),
    Setting(section="Unit", name="RefuseManualStop", allowedValue=BooleanValue()),
    Setting(section="Unit", name="Requires", allowedValue=UnitListValue(), dropinproc=DropinAdditive()),
    Setting(section="Unit", name="RequiresMountsFor", allowedValue=AbsolutePathListValue()),
    Setting(section="Unit", name="RequiresOverridable", allowedValue=TextValue(), tillRel="2.28"),
    Setting(section="Unit", name="Requisite", allowedValue=UnitListValue(), dropinproc=DropinAdditive()),
    Setting(section="Unit", name="SourcePath", allowedValue=TextValue()),
    Setting(section="Unit", name="StartLimitAction", allowedValue=EnumValue(["none", "reboot", "reboot-force", "reboot-immediate", "poweroff", "poweroff-force", "poweroff-immediate", "exit", "exit-force"])),
    Setting(section="Unit", name="StartLimitBurst", allowedValue=NumericValue()),
    Setting(section="Unit", name="StartLimitIntervalSec", allowedValue=NumericValue()),
    Setting(section="Unit", name="StopWhenUnneeded", allowedValue=BooleanValue()),
    Setting(section="Unit", name="SuccessAction", allowedValue=EnumValue(["none", "reboot", "reboot-force", "reboot-immediate", "poweroff", "poweroff-force", "poweroff-immediate", "exit", "exit-force"]), sinceRel="2.34"),
    Setting(section="Unit", name="SuccessActionExitStatus", allowedValue=NumericValue(0, 255), sinceRel="2.40"),
    Setting(section="Unit", name="Wants", allowedValue=UnitListValue(), dropinproc=DropinAdditive()),
    Setting(section="User", name="CrashChVT", allowedValue=TextValue(), tillRel="2.27"),
    Setting(section="VLAN", name="GVRP", allowedValue=BooleanValue()),
    Setting(section="VLAN", name="Id", allowedValue=NumericValue(lower=0, upper=4094)),
    Setting(section="VLAN", name="LooseBinding", allowedValue=BooleanValue()),
    Setting(section="VLAN", name="MVRP", allowedValue=BooleanValue()),
    Setting(section="VLAN", name="ReorderHeader", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="DestinationPort", allowedValue=NumericValue(lower=1, upper=65534)),
    Setting(section="VXLAN", name="FDBAgeingSec", allowedValue=NumericValue()),
    Setting(section="VXLAN", name="FlowLabel", allowedValue=NumericValue(lower=0, upper=1048575)),
    Setting(section="VXLAN", name="GenericProtocolExtension", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="VXLAN", name="GroupPolicyExtension", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="Id", allowedValue=TextValue()),
    Setting(section="VXLAN", name="IPDoNotFragment", allowedValue=BooleanValue(), sinceRel="2.43"),
    Setting(section="VXLAN", name="L2MissNotification", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="L3MissNotification", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="Local", allowedValue=IPValue()),
    Setting(section="VXLAN", name="MacLearning", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="MaximumFDBEntries", allowedValue=NumericValue()),
    Setting(section="VXLAN", name="PortRange", allowedValue=TextValue()),
    Setting(section="VXLAN", name="ReduceARPProxy", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="Remote", allowedValue=IPValue()),
    Setting(section="VXLAN", name="RemoteChecksumRx", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="RemoteChecksumTx", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="RouteShortCircuit", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="TOS", allowedValue=TextValue()),
    Setting(section="VXLAN", name="TTL", allowedValue=NumericValue(lower=0, upper=255)),
    Setting(section="VXLAN", name="UDP6ZeroChecksumRx", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="UDP6ZeroChecksumTx", allowedValue=BooleanValue()),
    Setting(section="VXLAN", name="UDPChecksum", allowedValue=BooleanValue()),
    Setting(section="WireGuard", name="FwMark", allowedValue=TextValue()),
    Setting(section="WireGuard", name="ListenPort", allowedValue=NumericValue(lower=1, upper=65534)),
    Setting(section="WireGuard", name="PrivateKey", allowedValue=TextValue()),
    Setting(section="WireGuard", name="PrivateKeyFile", allowedValue=AbsolutePathListValue()),
    Setting(section="WireGuardPeer", name="AllowedIPs", allowedValue=TextValue()),
    Setting(section="WireGuardPeer", name="Endpoint", allowedValue=TextValue()),
    Setting(section="WireGuardPeer", name="FwMark", allowedValue=TextValue()),
    Setting(section="WireGuardPeer", name="PersistentKeepalive", allowedValue=NumericValue(lower=1, upper=65535)),
    Setting(section="WireGuardPeer", name="PresharedKey", allowedValue=TextValue()),
    Setting(section="WireGuardPeer", name="PresharedKeyFile", allowedValue=AbsolutePathListValue()),
    Setting(section="WireGuardPeer", name="PublicKey", allowedValue=TextValue()),
]
