"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbIngressController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * Generate alb-ingress-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-alb-ingress-controller/blob/master/docs/examples
 *
 * @stability stable
 */
class AlbIngressController extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, options) {
        var _b, _c, _d, _e;
        super(scope, id);
        this.serviceAccountName = (_b = options.serviceAccountName) !== null && _b !== void 0 ? _b : 'alb-ingress-controller';
        this.deploymentName = 'alb-ingress-controller';
        this.clusterName = options.clusterName;
        this.namespace = (_c = options.namespace) !== null && _c !== void 0 ? _c : 'kube-system';
        new k8s.ClusterRole(this, 'alb-ingress-controller-clusterole', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': 'alb-ingress-controller',
                    ...options.labels,
                },
                name: 'alb-ingress-controller',
            },
            rules: [
                {
                    apiGroups: ['', 'extensions'],
                    resources: ['configmaps', 'endpoints', 'events', 'ingresses', 'ingresses/status', 'services', 'pods/status'],
                    verbs: ['create', 'get', 'list', 'update', 'watch', 'patch'],
                },
                {
                    apiGroups: ['', 'extensions'],
                    resources: ['nodes', 'pods', 'secrets', 'services', 'namespaces'],
                    verbs: ['get', 'list', 'watch'],
                },
            ],
        });
        new k8s.ClusterRoleBinding(this, 'alb-ingress-controller-clusterole-binding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': 'alb-ingress-controller',
                    ...options.labels,
                },
                name: 'alb-ingress-controller',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: 'alb-ingress-controller',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    namespace: this.namespace,
                    name: this.serviceAccountName,
                },
            ],
        });
        new k8s.ServiceAccount(this, 'alb-ingress-controller-sa', {
            metadata: {
                name: this.serviceAccountName,
                namespace: this.namespace,
            },
        });
        new k8s.Deployment(this, 'alb-ingress-controller-deployment', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': 'alb-ingress-controller',
                    ...options.labels,
                },
                namespace: this.namespace,
                name: this.deploymentName,
            },
            spec: {
                replicas: (_d = options === null || options === void 0 ? void 0 : options.replicas) !== null && _d !== void 0 ? _d : 1,
                selector: {
                    matchLabels: {
                        'app.kubernetes.io/name': 'alb-ingress-controller',
                        ...options.labels,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            'app.kubernetes.io/name': 'alb-ingress-controller',
                            ...options.labels,
                        },
                    },
                    spec: {
                        containers: [{
                                name: 'alb-ingress-controller',
                                image: (_e = options === null || options === void 0 ? void 0 : options.image) !== null && _e !== void 0 ? _e : 'docker.io/amazon/aws-alb-ingress-controller:v1.1.9',
                                args: this.argsFunc(options.args),
                                env: this.envFunc(options.env),
                            }],
                        serviceAccountName: `${this.serviceAccountName}`,
                    },
                },
            },
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--ingress-class=alb', `--cluster-name=${this.clusterName}`];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
    envFunc(envSet) {
        return envSet;
    }
}
exports.AlbIngressController = AlbIngressController;
_a = JSII_RTTI_SYMBOL_1;
AlbIngressController[_a] = { fqn: "cdk8s-aws-load-balancer-controller.AlbIngressController", version: "2.3.3" };
//# sourceMappingURL=data:application/json;base64,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